/*-----------------------------------------------------------------------------------*/
/*  TypeWriter
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var typeWriterWidget = {
        typeWriter: function () {
            var self = this;

            if ( ! $('.kt-typewriter').length ) { 
                return;
            }

            $('.kt-typewriter:not(.initiated)').each(function () {
                var $wrapper = $(this).parents('.kt-typewriter-wrapper');
                var strings = $(this).data('texts').split("||"),
                    loop = $wrapper.data('loop') ? $wrapper.data('loop') : false,
                    smartBackspace = $wrapper.data('smart-backspace') ? $wrapper.data('smart-backspace') : true,
                    startDelay = $wrapper.data('start-delay') ? $wrapper.data('start-delay') : 0,
                    showCursor = $wrapper.data('show-cursor') ? $wrapper.data('show-cursor') : true,
                    cursorChar = $wrapper.data('cursor-char') ? $wrapper.data('cursor-char') : '|',
                    typeSpeed = $wrapper.data('type-speed') ? $wrapper.data('type-speed') : 0,
                    backDelay = $wrapper.data('back-delay') ? $wrapper.data('back-delay') : 700,
                    backSpeed = $wrapper.data('back-speed') ? $wrapper.data('back-speed') : 0,
                    fadeOut = $wrapper.data('fade-out') ? $wrapper.data('fade-out') : false,
                    fadeOutDelay = $wrapper.data('fade-out-delay') ? $wrapper.data('fade-out-delay') : 500;

                $(this).addClass('initiated');
                var typed = new Typed( '.kt-typewriter', {
                    strings: strings,
                    typeSpeed: parseInt( typeSpeed ),
                    backSpeed: parseInt( backSpeed ),
                    backDelay: parseInt( backDelay ),
                    loop: loop,
                    smartBackspace: smartBackspace,
                    startDelay: parseInt( startDelay ),
                    showCursor: showCursor,
                    cursorChar: cursorChar,
                    fadeOut: fadeOut,
                    fadeOutDelay: parseInt( fadeOutDelay ),
                });
            });
        },

    };

    kiteTheme = Object.assign( kiteTheme, typeWriterWidget);

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( window.kiteTheme ) {
        kiteTheme.typeWriter();
    }

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-type-writer.default', function ($scope) {
            kiteTheme.typeWriter();
        });
    });
})(jQuery, window.kiteTheme);
//