/*-----------------------------------------------------------------------------------*/
/*  video
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var video = {

        initVideo: function () {
            this.fitVideo();
            this.initVideoBackground();
            this.embedVideoLightGallery();
            this.videoBackgroundSize();
        },

        /*-----------------------------------------------------------------------------------*/
        /*  fitvid 
        /*-----------------------------------------------------------------------------------*/

        fitVideo: function () {
            $(".container").fitVids();
        },

        /*----------------------------------------------------------------------------------*/
        /*  mediaelementplayer ( Html Video )
        /*-----------------------------------------------------------------------------------*/

        initVideoBackground: function () {

            var self = this;
            if ( ! $('.video').length ) {
                return;
            }

            if (typeof $.fn.mediaelementplayer == 'function') {
                $('.video').each(function (index, el) {
                    var autoplay = false;
                    var autoplayCheck = $(this).attr('autoplay');
                    if (typeof autoplayCheck !== typeof undefined && autoplayCheck !== false) {
                        autoplay = true;
                    }
                    $(this).mediaelementplayer({
                        enableKeyboard: false,
                        iPadUseNativeControls: false,
                        pauseOtherPlayers: false,
                        iPhoneUseNativeControls: false,
                        AndroidUseNativeControls: false,
                        autoplay: autoplay,
                        features: ['playpause', 'progress', 'current', 'duration', 'tracks', 'volume', 'fullscreen'],
                        success: function (mediaElement, domObject) {
                            // fade in play buttons and poster image In Video Html 5 inline
                            $('.mejs-poster').addClass('fadein');

                            if (mediaElement.paused && autoplay) {
                                mediaElement.play();
                            }

                        },
                    });
                });

                //mobile check
                if (navigator.userAgent.match(/(Android|iPod|iPhone|iPad|IEMobile|Opera Mini)/)) {
                    self.videoBackgroundSize();
                    $('.videohomepreload').show();
                    $('.videowrap').remove();
                }

                $('.inline_video').each(function (i) {
                    var $this = $(this);
                    if ($this.hasClass('hide-control')) {
                        var $hideControl = $this.find('.mejs-controls');
                        $hideControl.remove();
                        $this.find('.mejs-layers').remove();
                    }
                });

                // append play button In poster image wrap ( for inline Video ) - we need set this div In this Position For hidding Play buttons when click On video
                var $playButton = $('.inline_video.video_embed_container .play-button');
                $('.inline_video.video_embed_container .play-button').remove();

                var $mejsPoster = $('.mejs-poster');
                $playButton.appendTo($mejsPoster);
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*  light galley for video
        /*-----------------------------------------------------------------------------------*/

        embedVideoLightGallery: function () {

            if ( ! $('.video_embed_container').length ) {
                return;
            }

            $('.video_embed_container').each(function (i) {

                var $this = $(this);

                var videoEmbedID = $this.attr('id');
                if (typeof $.fn.lightGallery == 'function') {
                    $this.not('.inline_video').lightGallery({
                        counter: false,
                        addClass: 'videopopup',
                        galleryId: videoEmbedID,
                    });
                }
            });

        },

        /*----------------------------------------------------------------------------------*/
        /*  Video background size
        /*-----------------------------------------------------------------------------------*/

        videoBackgroundSize: function () {
            if ( ! $('.videowrap').length ) {
                return;
            }

            $('.videowrap').each(function (i) {

                var $sectionWidth = $(this).closest('.videohome ').outerWidth();
                var $vcVideoWrap = $(this).parents('.vc_videowrap');

                if ($vcVideoWrap.length) {

                    var $sectionHeight = $vcVideoWrap.find('.vc_videocontent').outerHeight();

                    $(this).width($sectionWidth);
                    $vcVideoWrap.height($sectionHeight);

                } else {

                    var $sectionHeight = $(this).closest('.videohome').outerHeight();
                    $(this).width($sectionWidth);
                    $(this).height($sectionHeight);

                }

                // calculate scale ratio
                var videoWidthOriginal = 1280,  // original video dimensions
                    videoHeightOriginal = 720,
                    vidRatio = 1280 / 720,
                    scale_h = $sectionWidth / videoWidthOriginal,
                    scale_v = ($sectionHeight) / videoHeightOriginal,
                    scale = scale_h > scale_v ? scale_h : scale_v;

                // limit minimum width
                var minVideoWidth = vidRatio * ($sectionHeight + 20);

                if (scale * videoWidthOriginal < minVideoWidth) { scale = minVideoWidth / videoWidthOriginal; }

                $(this).find('video').width(Math.ceil(scale * videoWidthOriginal + 2));
                $(this).find('video').height(Math.ceil(scale * videoHeightOriginal + 2));

                $(this).scrollLeft(($(this).find('video').width() - $sectionWidth) / 2);
                $(this).find('.mejs-overlay, .mejs-poster').scrollTop(($(this).find('video').height() - ($sectionHeight)) / 2);
                $(this).scrollTop(($(this).find('video').height() - ($sectionHeight)) / 2);

            });

        },
    };

    kiteTheme = Object.assign( kiteTheme, video );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($, kiteTheme){
    if ( kiteTheme ) {
        kiteTheme.initVideo();

        $(window).on( 'resize', function(){
            kiteTheme.videoBackgroundSize();
        });
    }
})(jQuery, window.kiteTheme);