/**
 * Kitestudio Main Js File
 */

window.kiteTheme = {};

// Configuration
( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    $.extend( kiteTheme, {

        // rtl: js_porto_vars.rtl == '1' ? true : false,
        // rtl_browser: $( 'html' ).hasClass( 'browser-rtl' ),

        ajax_url: kite_theme_vars.ajax_url,

        $window: $(window),
        $document: $(document),
        $body: $('body'),
        windowHeight: $(window).height(),
        windowWidth: $(window).width(),
        msie: window.navigator.userAgent.indexOf("self.msie "),
        msie11: navigator.userAgent.match(/Trident.*rv\:11\./),
        is_device_mobile: /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test( navigator.userAgent || navigator.vendor || window.opera ) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test( ( navigator.userAgent || navigator.vendor || window.opera ).substr( 0, 4 ) ),
        isTouchDevice: (Modernizr.touchevents) ? true : false,

        isTablet: function () {
            if ( window.innerWidth < 1024 )
                return true;
            return false;
        },

        isMobile: function () {
            if ( window.innerWidth <= 767 )
                return true;
            return false;
        },

        // Blog page number
        blogPageNum: 0,
        //Header
        $ktHeader: $("#kt-header"),

        scrolingToSection: false,
        externalClicked: false,
        $scrolId: '', // this value Save Value of specific id From top
        enableScrollId: '',
        //menu
        menuArray: [],

        $scrollpals: $("html, body"),
        wcNoticeTimer: '',
        resizeId: '',

        init: function() {
            this.updateDocHeight();
            this.updateWinDimension();
            this.pageTopSpace();
            this.minPageHeightSet();
            this.showMoreTag();
            this.initSelectElements();
            this.nav();
            this.allCats();
            this.UpdateCurrentMenuAncestorClass();
            this.homeHeight();
            this.mobileNavigation();
            this.toggleSidebar();
            this.kiteScrollBar();
            this.coveringLevelVerticalMenu();
            this.interactiveBackgroundImg();
            this.parallaxImg();
            this.scrollTo();

            if ($('#main-content').length) {
                this.lazyLoadOnLoad('#main-content, .togglesidebar');   
            } else {
                this.lazyLoadOnLoad('body > .wrap, .togglesidebar');
            }

            this.lazyLoadOnHover();
            this.abortImageLoading();
            this.wpmlMenu();
            this.vcGridReInit();
            this.fixIOSDoubleTapIssue();
            this.ajaxifySearch();
            this.updateToolbarEditLink();
            this.preloaderHide();
            this.topBar();
            this.topBarLang();
            this.additionalScript();
            this.scrolling();
            this.initialMenuArray();
            this.updateMenuOnActiveSection();
            this.searchForm();
            this.sliderParallax();
            this.headerTransformation();
            this.scrollToTopButton();
            this.galleryStart();
            this.getScrollBarWidth();
            this.ajaxSearchForm();
            this.checkHeader();
            this.tabClick();
            this.humburgerMenuToggle();
            this.humburgerMenuUpdate();
            this.humburgerMenuNavigation();
            this.bottomNavbarHandler();
            this.selectElement();
            this.shortcodeAnimation();
            this.faq();
            this.socialLink();
            this.socailshare();
            this.trapNavigationInModal();
        },

        onReady: function() {
            this.popupNewsletter();
            this.headerPromoBar();
            this.cookiesBar();
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Update document height, window height & width
        /*-----------------------------------------------------------------------------------*/

        updateDocHeight: function () {
            this.documentHeight = Math.max(
                this.$document.height(),
                this.windowHeight,
                document.documentElement.clientHeight /* For opera: */
            );

            this.$window.trigger('document-height-changed');
        },

        updateWinDimension: function () {
            this.windowHeight = this.$window.height();
            this.windowWidth = this.$window.width();
        },

        /*----------------------------------------------------------------------------------*/
        /*   top space for blog in main page
        /*-----------------------------------------------------------------------------------*/

        // page Top Space depends On menu Height
        pageTopSpace: function () {
            var topSpace = 0,
                topbarHeight = 0;

            if ($('#topbar').length) {
                topbarHeight = 33;
            }

            if ($('header').hasClass('type2_3')) {

                topSpace = 125 + topbarHeight;

            } else if ($('header').hasClass('type4_5_6')) {

                topSpace = 85 + topbarHeight;

            } else {

                topSpace = 58 + topbarHeight;

            }

            return topSpace;
        },

        /*----------------------------------------------------------------------------------*/
        /*  set min-height For Blog and blog Detail 
        /*-----------------------------------------------------------------------------------*/

        minPageHeightSet: function () {
            var self = this;

            if (self.windowWidth > 1140) {

                var $pageFooterHeight = $('.footer-bottom').height(),
                    topbarHeight = $('#topbar').height();

                // Add Footer Widget section height too Footer height
                if ($('.footer-widgetized').length) {
                    $pageFooterHeight = $pageFooterHeight + $('.footer-widgetized').height();
                }

                var $pageMainHeight,
                    $wholePageHeight,
                    $pageMainHeight2;

                if ( $('.layout').height() < self.windowHeight ) {
                    var pageHeightExcludedMainContent = $('.layout').height() - $('#main-content').height();
                    $('#main-content').css( 'min-height', 'calc(100vh - ' + pageHeightExcludedMainContent + 'px)');
                }

                //check if page is without slider, set a min-height for page
                if ($('#fullscreenslider').length <= 0 && $('#blogsingle').length <= 0) {
                    $pageMainHeight = $('#main').height();
                    $wholePageHeight = $pageMainHeight + $pageFooterHeight;
                    $pageMainHeight2 = self.windowHeight - $pageFooterHeight - topbarHeight;

                    $('#main').css({
                        'min-height': $pageMainHeight2 + "px",
                    });

                } else if ($('#blogsingle').length) {

                    $pageMainHeight = $('#blogsingle').height();
                    $wholePageHeight = $pageMainHeight + $pageFooterHeight;
                    $pageMainHeight2 = self.windowHeight - $pageFooterHeight - topbarHeight;

                    $('#blogsingle').css({
                        'min-height': $pageMainHeight2 + "px"
                    });

                } else {
                    $('#main').css({ 'min-height': "0px" });
                }
            }
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Show More tag
        /*-----------------------------------------------------------------------------------*/

        showMoreTag: function () {

            if ( !$('body').hasClass('show-more-in-wc-widgets') ) {
                return;
            }

            if ( $('.widget_product_tag_cloud .tagcloud').length != 0 ) {
                var productTagHeight = $('.widget_product_tag_cloud .tagcloud').height();
                if ( productTagHeight > 100 ) {
                    $('.widget_product_tag_cloud').addClass("collapse");
                    if ( !$('.widget_product_tag_cloud .tagcloud').find('.show_more_items').length ) {
                        $('.widget_product_tag_cloud .tagcloud').after("<span class='show_more_tags'>" + kite_theme_vars.show_more + "</span>");
                    }
                }

                $('.widget_product_tag_cloud .show_more_tags').on('click', function (e) {
                    e.preventDefault();
                    $('.widget_product_tag_cloud').removeClass("collapse");
                });
            }


            if ( $('.widget_layered_nav.widget > ul').length != 0 ) {
                $('.widget_layered_nav.widget').each(function (index, el) {

                    if ( $(this).find('> ul').height() > 162) {
                        $(this).addClass('collapse');
                        if ( !$(this).find('.show_more_items').length ) {
                            $(this).append("<span class='show_more_items'>" + kite_theme_vars.show_more + "</span>");
                        }
                    }

                    $('.widget_layered_nav.widget .show_more_items').on('click', function (event) {
                        event.preventDefault();
                        $(this).parents('.widget_layered_nav.widget').removeClass('collapse');
                    });
                });
            }

            if ( $('.widget_product_categories.widget > ul').length != 0 ) {
                var productCategoriesHeight = $('.widget_product_categories.widget:not(.inFilterbar) > ul').height();
                if ( productCategoriesHeight > 160 && $("body").hasClass("show-more-categories") ) {
                    $('.widget_product_categories.widget:not(.inFilterbar)').addClass('collapse');
                    if (!$('.widget_product_categories.widget:not(.inFilterbar)').find('.show_more_items').length) {
                        $('.widget_product_categories.widget:not(.inFilterbar)').append("<span class='show_more_items'>" + kite_theme_vars.show_more + "</span>");
                    }
                }

                $('.widget_product_categories.widget .show_more_items,.widget_product_categories .cats-toggle').on('click', function (event) {
                    event.preventDefault();
                    $('.widget_product_categories.widget').removeClass('collapse');
                });
            }

        },

        /*-----------------------------------------------------------------------------------*/
        /*  niceSelect For Restyle SELECT OPTION 
        /*-----------------------------------------------------------------------------------*/

        initSelectElements: function (Action) {
            if ( $('.woocommerce').length != 0 ) {
                $('.woocommerce-ordering .orderby').niceSelect(Action);
                $('form.cart table.variations select').not('.hide-attr-select').niceSelect(Action);
            }

            // Calculate shipping section in cart page
            // archive of post
            // widget select categories
            // woocommerce drop down widgets - layerd Nav
            $('section.shipping-calculator-form select, .widget_archive select, .widget_categories select.postform, .widget_product_categories select.dropdown_product_cat,.widget_layered_nav select,.widget select').niceSelect(Action);

            // this Code added : For bug Fix call select in Ajax Request in Filter drop down
            $('.widget_product_categories select.dropdown_product_cat,select.dropdown_layered_nav').niceSelect();

        },

        /*-----------------------------------------------------------------------------------*/
        /*  Navigation
        /*-----------------------------------------------------------------------------------*/

        nav: function () {

            var self = this;

            if (self.windowWidth <= 1140) {
                return;
			}

            var $menuItem = $('.navigation > ul li.menu-item-has-children');

            $menuItem.each(function () {

                var $menuWrapper = $(this).find('.menu-item-wrapper'),
                    $secondlevelItems = $menuWrapper.find('> ul > li'),
                    $leftOffset = 0,
                    $rightOffset = 0;//store the offset of megamenu from right side of screen

                if ( $(this).hasClass('mega-menu-parent') ) {
                    $menuWrapper.find('.special-last-child').closest('.menu-item-wrapper').addClass('has-special-last-child');
                    if ($menuWrapper.find('.special-last-child > ul > li:last-child').hasClass('boxed-item')) {
                        if (!$menuWrapper.find('.special-last-child').hasClass('has-boxed-item-as-special') ) {
                            $menuWrapper.find('.special-last-child').addClass('has-boxed-item-as-special');
                        }
                    }

                    $menuWrapper.css('margin-left', '');//Reset margin-left to calculate correct position
                    $menuWrapper.css('margin-right', '');//Reset margin-right to calculate correct position

                    if ($(this).hasClass('fullwidth-mega-menu')) {
                        $menuWrapper.width(self.windowWidth);
                        $menuWrapper.css('margin-left', -$(this).offset().left);
                    } else {
                        $menuWrapper.width($secondlevelItems.length * $secondlevelItems.eq(0).outerWidth());
                        $menuWrapper.height($menuWrapper.find('> ul').height());
                        if ($('body').hasClass('rtl')) {
                            var $leftOffset = $menuWrapper.offset().left;
                            if ($leftOffset < 0) {
                                $menuWrapper.css('margin-right', $leftOffset); // cause mega menu be in window
                            }
                        } else {
                            var $rightOffset = self.windowWidth - ($menuWrapper.offset().left + $menuWrapper.outerWidth());
                            if ($rightOffset < 0) {
                                $menuWrapper.css('margin-left', $rightOffset); // cause mega menu be in window
                            }
                        }
                    }

                    if ( $menuWrapper.parents('.catmenu').length != 0 ) {
                        if ( $menuWrapper.find('> ul').height() < $('nav.catmenu').height() ) {
                            $menuWrapper.height($('.category-menu-container > nav').height());
                        }
                    }
                } else {
                    var $subMenuWidth = $(this).find('> ul').eq(0).outerWidth();
                    var $rightOffset = self.windowWidth - ($(this).offset().left + $subMenuWidth);
                    if ($rightOffset < $subMenuWidth) {
                        $(this).addClass('left-submenus');
                    }
                }
                if ( $(this).parents('.catmenu').length != 0 ) {
                    var menuWidth = $(this).parents('.catmenu').siblings('.allcats').outerWidth();
                    if (self.windowWidth > 1140) {
                        var $left = parseInt(menuWidth) + parseInt($(this).parents('.catmenu').siblings('.allcats').css('marginLeft').replace('px', ''));
                        if ( $('body').hasClass('rtl') ) {
                            $menuWrapper.css('right', $left);
                        } else {
                            $menuWrapper.css('left', $left);
                        }
                        if ( !$(this).hasClass('mega-menu-parent') && $(this).parents('.mega-menu-parent').length == 0 ) {
                            if ( $('body').hasClass('rtl') ) {
                                $(this).find('> ul.sub-menu').css('right', $left);
                            } else {
                                $(this).find('> ul.sub-menu').css('left', $left);
                            }
						}
                    }
                }
            });

            //Mega menu
            $menuItem.mouseover(function () {
                if ( !$(this).hasClass('hover') ) {
					$(this).addClass("hover");
				}

            }).mouseout(function () {
                $(this).removeClass("hover");
            });

            $menuItem.focusin(function(){
                if ( !$(this).hasClass('hover') ) {
					$(this).addClass("hover");
				}
            });

            $menuItem.focusout(function(){
                $(this).removeClass("hover");
            });

        },
        allCats: function () {
            var self = this;
            $('.allcats:not(.always-open)').on('click', function () {
                $('.catmenu').toggleClass('close');
                self.nav();
            });
        },
        UpdateCurrentMenuAncestorClass: function () {
            var self = this;
            if ( self.windowWidth <= 1140 ) {
				return;
			}

            $('header .navigation > ul > li').removeClass('current-menu-ancestor');
            $('header .navigation > ul > li').removeClass('current-menu-item');
            $('header .navigation li li ul li.active').parents('.navigation > ul > li.menu-item-has-children').addClass('current-menu-ancestor');
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Home Height 
        /*-----------------------------------------------------------------------------------*/

        homeHeight: function (callback) {

            var self = this;

            var $wpAdminBarHeight = $('#wpadminbar').height();

            //Wordpress Admin Bar Height
            var checkWpBar = function () {
                var $HSlMHeight = self.windowHeight;
                if ( !isNaN($wpAdminBarHeight) ) {
                    $HSlMHeight = $HSlMHeight - $wpAdminBarHeight;
                }
                return $HSlMHeight;
            }

            var $HSlMVal = checkWpBar();

            // Image Fullscreen
            if ( $('.fulscreenimage').length !== 0 ) {
                $("#fulscreenimage").css({ height: $HSlMVal + 'px' });
            }

            if ( self.windowWidth > 1140 ) {
                // Revolution Slider
                if ( $('#homeHeight').height() > 0 ) {

                    var $LHeight = $('#homeHeight').height();
                    $LHeight = $LHeight - 6;

                    if ( !isNaN($wpAdminBarHeight) ) {
                        $LHeight = $LHeight - $wpAdminBarHeight;
                    }
                    $LHeight = 0;
                } else {//Reset the top margin for pages without intro
                    $("#main").css({ marginTop: 0 + 'px' });
                }

            } else {
                $('#main').css({ marginTop: 0 });
            }

            return true;

        },

        /*------------------------------------------------------------------------------*/
        /*  phone Navigation
        /*------------------------------------------------------------------------------*/

        mobileNavigation: function () {
            var self = this;
            $('.mobile-navigation li.cat-item:has(ul.children)').addClass('menu-item-has-children');
            $('.mobile-navigation li.cat-item ul.children').addClass('sub-menu');
            $('.mobile-navigation ul.sub-menu').slideUp('300', 'easeInOutCirc');
            $('.mobile-navigation li.menu-item-has-children a').off('click');
            $('.mobile-navigation li.menu-item-has-children a').on('click', function (event) {
                var $li = $(this).parent('li');
                if ($li.hasClass('menu-item-has-children')) {
                    event.preventDefault();
                }
                if ($li.hasClass('mega-menu-parent')) {
                    if ($(this).hasClass('active')) {
                        $li.find('> div.menu-item-wrapper > ul.sub-menu').slideUp('300', function(){
                            setTimeout( self.trapNavigationInModal(false), 300 );
                        } );
                        $(this).removeClass('active');
                        $li.removeClass('active expanded');
                    } else {
                        $li.find('> div.menu-item-wrapper > ul.sub-menu').slideDown('300', 'easeInOutCirc');
                        $(this).addClass('active');
                        $li.addClass('active expanded');
                    }
                } else {
                    if ($(this).hasClass('active')) {
                        $li.find('> ul.sub-menu').slideUp('300', function(){
                            setTimeout( self.trapNavigationInModal(false), 300 );
                        });
                        $(this).removeClass('active');
                        $li.removeClass('active expanded');
                    } else {
                        $li.find('> ul.sub-menu').slideDown('300', 'easeInOutCirc');
                        $(this).addClass('active');
                        $li.addClass('active expanded');
                    }
                }
                $(document).trigger( 'menu-parent-item-toggle-expand');
            });

            $('.mobile-navigation li.menu-item-has-children a .menu_title span').on('click',function(){
                window.open( $(this).parents('a').attr('href'), '_self' );
            });
        },

        /*------------------------------------------------------------------------------*/
        /*  Toggle Sidebar container  + cart container
        /*------------------------------------------------------------------------------*/

        toggleSidebar: function () {

            var self = this;

            var $toggleSidebarContainer = $('.toggle-sidebar-container:not(.filtersidebar)'),
                $toggleSidebarMobileMenu = $('.toggle-sidebar-mobile-menu:not(.categories-offcanvas)'),
                $toggleSidebarCategoryMenu = $('.toggle-sidebar-mobile-menu.categories-offcanvas'),
                $toggleSidebarProductCategoryMenu = $('.toggle-sidebar-product-category-menu'),
                $cartSidebarContainer = $('.cart-sidebar-container'),
                $fixedAddToCartContainer = $('.fixed-add-to-cart-container .fixed-add-to-cart'),
                $filtersidebarContainer = $('.toggle-sidebar-container.filtersidebar'),
                $widgetSidebarAreaContainer = $(".main-sidebar-container, #woocommerce-product-sidebar"),
                $scrollToTop = $('.scrolltotop'),
                //Buttons
                $mobileNavButton = $('.mobilenavbutton'),
                $catNavButton = $('.cat-nav-button'),
                $productNavButton = $('.productnavbutton'),
                $cartToggleButton = $('.cart-sidebarbtn,.kt-header-button.kt-cart'),
                $mobileSidebarOverlay = $('.mobile-sidebar-overlay');

            var closeSidebar = function () {
                if ($toggleSidebarContainer.hasClass('sidebar-toggle-open') || $filtersidebarContainer.hasClass('sidebar-toggle-open') || $('header.kt-elementor-template .responsive-whole-search-container').hasClass('open') ) {
                    self.$ktHeader.removeClass('sidebar-toggle-open');
                    $toggleSidebarContainer.removeClass('sidebar-toggle-open');
                    $toggleSidebarMobileMenu.removeClass('sidebar-toggle-open');
                    $toggleSidebarCategoryMenu.removeClass('sidebar-toggle-open');
                    $toggleSidebarProductCategoryMenu.removeClass('sidebar-toggle-open');
                    $cartSidebarContainer.removeClass('sidebar-toggle-open');
                    $widgetSidebarAreaContainer.removeClass('open');
                    $('header.kt-elementor-template .responsive-whole-search-container').removeClass('open');
                    $('.kt-header-builder-overlay').removeClass('show');

                    $fixedAddToCartContainer.removeClass('toggleOpen');
                    $scrollToTop.removeClass('toggleOpen');

                    $mobileSidebarOverlay.removeClass('open');

                    if ($('.shop-filter .shop-filter-toggle').hasClass('open'))
                        $('.shop-filter .shop-filter-toggle').removeClass('open');

                    if ($('.shop-filter').hasClass('open'))
                        $('.shop-filter').removeClass('open');

                    $filtersidebarContainer.removeClass('sidebar-toggle-open');
                    //Allow snap-to-scroll + scrolling
                    self.$body.removeClass('disable-snap-to-scroll');
                }
            }

            var openSidebar = function (type) {
                self.$ktHeader.addClass('sidebar-toggle-open');
                $toggleSidebarContainer.addClass('sidebar-toggle-open');
                $fixedAddToCartContainer.addClass('toggleOpen');
                $scrollToTop.addClass('toggleOpen');
                $('.kt-header-builder-overlay').addClass('show');

                //Disallow snap-to-scroll + disable scroll
                self.$body.addClass('disable-snap-to-scroll');

                if (type == 'cart') {
                    $cartSidebarContainer.addClass('sidebar-toggle-open');
                    $cartSidebarContainer.focus();
                } else if (type == 'catSidebar') {
                    $mobileSidebarOverlay.addClass('open');
                    $toggleSidebarCategoryMenu.addClass('sidebar-toggle-open');
                    self.trapNavigationInModal();
                } else if (type == 'filtersidebar') {
                    $filtersidebarContainer.addClass('sidebar-toggle-open');
                    $filtersidebarContainer.find('.togglefilterscontainer:not(.no-widgets)').css('display', 'block');
                    $filtersidebarContainer.focus();
                } else if (type == 'productcatsidebar') {
                    $mobileSidebarOverlay.addClass('open');
                    $toggleSidebarProductCategoryMenu.addClass('sidebar-toggle-open');
                    $toggleSidebarProductCategoryMenu.focus();
                    self.trapNavigationInModal();
                    console.error('test');
                } else if ( type == "widgetAreaSidebar" ) {
                    $widgetSidebarAreaContainer.addClass('open');
                } else {
                    $mobileSidebarOverlay.addClass('open');
                    $toggleSidebarMobileMenu.addClass('sidebar-toggle-open');
                    self.trapNavigationInModal();
                }
            }

            self.$document.on('click', '#sidebar-open-overlay, .kt-header-builder-overlay, .cart-sidebar-container .cart-close-btn,.togglesidebarWidgetbar #toggle-sidebar-close-btn,.mobile-sidebar-overlay,.mobile-menu-close-button span,.closesidebar, .kt-sidebar-title', function () {
                closeSidebar();
            });

            self.$document.on('keydown', '.cart-sidebar-container .cart-close-btn,.togglesidebarWidgetbar #toggle-sidebar-close-btn,.mobile-menu-close-button span,.closesidebar, .mobile-menu-close-button a', function (e) {
                if ( e.keyCode == 13 ) {
                    closeSidebar();
                }
            });

            var overlays = document.querySelectorAll('#sidebar-open-overlay, .kt-header-builder-overlay, .mobile-sidebar-overlay');
            for (var i = 0 ; i < overlays.length; i++) {
                overlays[i].addEventListener('touchstart' , function(e){
                    e.preventDefault();
                    closeSidebar();
                }) ;
            }

            self.$document.on( 'keydown', function(e){
                if( e.key === "Escape" ) {
                    closeSidebar();
                }
            });

            $cartToggleButton.on('click', function (e) {
                if ((self.$body.hasClass('vertical_menu_enabled') && self.windowWidth > 1140) || self.$body.hasClass('woocommerce-cart') || ( $(this).find('.widget_shopping_cart_content').length && self.$window.width() > 1025 ) )
                    return;

                e.preventDefault();
                openSidebar('cart');
            });

            $mobileNavButton.on('click', function () {
                openSidebar('mobileSidebar');
            });
            $catNavButton.on('click', function () {
                openSidebar('catSidebar');
            });
			$productNavButton.on('click', function () {
                openSidebar('productcatsidebar');
            });
            $('.shop-filter .shop-filter-toggle').on('click', function () {
                closeSidebar();
                if ( !$(this).siblings('.filtersidebar').hasClass('hidden-desktop') ) {
                    openSidebar('filtersidebar');
                }
            });
            $('#mobilenavbar .navicons.filters').on('click', function () {
                openSidebar('filtersidebar');
            });
            $('#mobilenavbar .navicons.kt-sidebar').on('click', function () {
                openSidebar('widgetAreaSidebar');
            });
            //close sidebar when click on links inside cart/sidebar
            self.$window.on('djaxLoading', function () {
                closeSidebar();
            })

        },

        /*------------------------------------------------------------------------------*/
        /*  Scrollbar
        /*------------------------------------------------------------------------------*/
        kiteScrollBar: function (element) {
            var $element = $(element);

            if (!$element) {
                return;
            }

            $element.each(function () {
                var $this = $(this),
                    $scrollContainer = $this.find('.swiper');

                if ($scrollContainer.length > 0) {
                    if ( $scrollContainer[0].swiper != undefined ) {
                        // $scrollContainer[0].swiper.updateSlidesSize();
                        return;
                    }
                }

                $this.wrapInner('<div class="swiper sw-scrollbar"><div class="swiper-wrapper"><div class="swiper-slide"></div></div><div class="swiper-scrollbar"></div></div>');
                $scrollContainer = $this.find('.swiper');

                var swiper = new Swiper($scrollContainer[0], {
                    scrollbar: {
                        el: '.swiper-scrollbar',
                        draggable: true,
                    },
                    direction: 'vertical',
                    slidesPerView: 'auto',
                    mousewheelControl: true,
                    freeMode: true,
                    touchReleaseOnEdges: true,
                    mousewheelReleaseOnEdges: true,
                    mousewheelSensitivity: .6,
                    watchSlidesProgress: true,
                });
            })

        },

        /*------------------------------------------------------------------------------*/
        /*  vertical sidebar
        /*------------------------------------------------------------------------------*/

        coveringLevelVerticalMenu: function () {

            var $verticalMenuItem = $(".vertical_menu_enabled .vertical_menu_navigation li.menu-item-has-children > a:not('.mp-back')");
            $verticalMenuItem.addClass('no_djax');

            $verticalMenuItem.on('click', function (e) {

                var $this = $(this);
                e.preventDefault();

                // Hide Li element
                $this.parent().siblings().addClass('hide-for-submenu');

                $this.addClass('hide-for-submenu');

                $this.parent().addClass('remove-activehover');

                var $subMenu = $this.siblings('.mp-level');

                if ( $subMenu.length ) {
                    $this.siblings('.mp-level').addClass('mp-level-open');
                }

            });

            $(".vertical_menu_enabled .vertical_menu_navigation li a.mp-back").on('click', function (e) {

                e.preventDefault();

                var $this = $(this);

                $this.parent().removeClass('mp-level-open');

                //show parent li element
                $this.parent().parent().find('a').removeClass('hide-for-submenu');

                $this.parent().parent().removeClass('remove-activehover');

                $this.parent().parent().siblings().removeClass('hide-for-submenu')

            });

        },

        /*----------------------------------------------------------------------------------*/
        /* Interactive background
        /*-----------------------------------------------------------------------------------*/
        interactiveBackgroundImg: function () {
            var self = this;
            if ( $('.interactive-background').length <= 0 ) {
                return;
            }

            self.interactiveBackground($('.interactive-background .section-container'), { sensitivity: 100, duration: 10000, zoom: false, initialZoom: true });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  parallax
        /*-----------------------------------------------------------------------------------*/

        parallaxImg: function () {

            var self = this;

            if ( self.$body.hasClass('snap-to-scroll') || $('.parallax').length <= 0 || self.msie > 0 || !!self.msie11 ) {
                return;
            }


            if ( self.windowWidth > 1140 && !self.isTouchDevice ) {
                var $parallaxContainers = $('.parallax'),
                    scrollPosition = 0;

                var parallaxHandler = function () {
                    $parallaxContainers.each(function () {
                        var $el = $(this),
                            speed = parseFloat($el.attr('data-speed')),
                            elementHeight = $el.data('height'),
                            elementTop = $el.data('offsetTop'),
                            elementBottom = elementTop + elementHeight,
                            factorMult = 0;

                        //When element is out of viewport
                        if ( elementTop > (scrollPosition + self.windowHeight) || elementBottom < scrollPosition ) {
                            return;
                        }

                        var parallax = (scrollPosition - elementTop) / self.windowHeight;
                        factorMult = Math.round((parallax) * speed * 100) / 100;
                        $el.find(".parallax-img").css({
                            'transform': 'translate3d(0,' + factorMult + '%,0)'
                        });
                    });
                }

                var parallaxInit = function () {
                    self.windowHeight = self.$window.height();
                    $parallaxContainers.each(function () {
                        var $el = $(this);
                        $el.data('offsetTop', $el.offset().top);
                        $el.data('height', $el.outerHeight(true));
                    });
                }

                var doScroll = function () {
                    $parallaxContainers.each(function () {
                        var $el = $(this);
                        $el.data('offsetTop', $el.offset().top);
                    });
                    scrollPosition = self.$window.scrollTop();
                    window.requestAnimationFrame(parallaxHandler);
                }

                parallaxInit();
                parallaxHandler();


                self.$window.on('scroll', doScroll).on('resize', parallaxInit);
                self.$window.one('djaxClick', function () {
                    self.$window.unbind('scroll', doScroll).unbind('resize', parallaxInit);
                });

            }
        },

        //Parallax by mouse position
        //Parallax by mouse position
        interactiveBackground: function ($elements, options) {
            var self = this;

            if (self.windowWidth <= 1140 || self.isTouchDevice) {
                return;
            }

            var transform = function ($target, x, y, scaleRatio) {
                $target.css('transform', 'matrix(1, 0, 0,1,' + x + ',' + y + ') scale(' + scaleRatio + ',' + scaleRatio + ')');
            }

            var transformLeave = function ($target, x, y, scaleRatio) {
                $target.css('transform', 'matrix(1, 0, 0,1,' + x + ',' + y + ') scale(' + scaleRatio + ',' + scaleRatio + ')');
            }

            return $elements.each(function () {

                var settings = $.extend({
                    target: '> .interactive-background-image img',
                    sensitivity: 20,
                    duration: 1400,//ms
                    zoom: true,
                    initialZoom: false,
                }, options);

                var el = $(this);
                //Prevent from multiple running
                if ( el.find(settings.target).length === 0 || el.hasClass('interactive-background-active') ) {
                    return true;
                }

                var target = el.find(settings.target),
                    h, w, cx, x, y, scaleRatio = 1;

                //set different transition duration for element
                if ( settings.duration != 1400 ) {
                    target.css('transition-duration', settings.duration + 'ms');
                }

                el.addClass('interactive-background-active');
                el.on('mouseenter interactive_bg_init', function (e) {
                    if (w !== el.width()) {
                        w = el.width();
                        h = el.height();
                        cx = settings.sensitivity / w;

                        if (settings.zoom || settings.initialZoom) {
                            scaleRatio = (w + settings.sensitivity) / w;
                        }

                        //set initial scale
                        if (settings.initialZoom) {
                            target.css('transform', 'scale(' + scaleRatio + ',' + scaleRatio + ')');
                        }
                    }
                }).on('mousemove', function (e) {
                    x = (-cx * (e.pageX - (target.offset().left + w / 2)));
                    y = (-cx * (e.pageY - (target.offset().top + h / 2)));
                    transform(target, x, y, scaleRatio);
                }).on('mouseleave', function (e) {
                    if (settings.initialZoom) {
                        transformLeave(target, 0, 0, scaleRatio);
                    }
                    else {
                        transformLeave(target, 0, 0, 1);
                    }

                });

                if (settings.initialZoom) {
                    el.trigger('interactive_bg_init');
                }
            });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Scrolling function 
        /*-----------------------------------------------------------------------------------*/

        scrollTo: function (location, introCheck, time) {

            var self = this;

            if ( location !== "#" ) {

                var scrollto;

                // introCheck 3 is for go to top Page ( top Button )
                // introCheck 2 is for logo
                //introcheck 5 is for next button in showcase
                if ( introCheck == 1 || introCheck == 2 || introCheck == 4 || introCheck == 5 ) {

                    if ( introCheck !== 4 && introCheck !== 5 ) { // this code run when link from external to internal
                        // get internal id ( hash ) From Query string
                        var sPageURL = window.location.search.substring(1);
                        var sURLVariables = sPageURL.split('&');
                        for (var i = 0; i < sURLVariables.length; i++) {
                            var sParameterName = sURLVariables[i].split('=');
                            if (sParameterName[0] == 'sectionid') {
                                location = '#'.concat(sParameterName[1]);
                            }
                        }
                    }

                    var $location = $(location);

                    if ( $location.length ) {
                        var offsetTop = $location.offset().top,
                            done = $location.closest('.layout').offset().top,
                            menuHeight = $('#headerfirststate').outerHeight(),
                            topBar = 0;

                        if ( $('#headersecondstate').length > 0 ) {
                            menuHeight = $('#headersecondstate').outerHeight();
                        }


                        offsetTop = offsetTop - done;

                        if ( self.$body.hasClass('has-topbar') ) { // Top bar height
                            topBar = 33;
                        }

                        if ( $('.vertical_menu_area').length || introCheck == 5 ) { // If vertical menu Or next button On showcase
                            scrollto = offsetTop - topBar;

                        } else {
                            scrollto = offsetTop - menuHeight + topBar;
                        }

                        if ( self.windowWidth <= 1140 ) {
                            scrollto = offsetTop - 70;//70px is responsive menu height
                        }

                    }
                }

                if ( introCheck === 1 || introCheck === 4 || introCheck === 5 ) {
                    var scrollTime = time ? time : parseInt(kite_theme_vars.scrolling_speed);
                    //scroll to inside id
                    self.$scrollpals.animate(
                        { scrollTop: scrollto },
                        {
                            duration: scrollTime,
                            easing: kite_theme_vars.scrolling_easing,
                            complete: function () {
                                self.scrolingToSection = false;
                                self.externalClicked = false;
                            },
                            queue: false
                        }
                    );

                } else if (introCheck === 2 || introCheck === 3) {
                    var scrollTime = time ? time : 1500;
                    //scroll to top of page
                    self.$scrollpals.animate(
                        { scrollTop: 0 },
                        {
                            duration: scrollTime,
                            easing: kite_theme_vars.scrolling_easing,
                            queue: false
                        }
                    );
                }
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*  animation 
        /*-----------------------------------------------------------------------------------*/

        animationDelay: function (counter, $selector) {
            var baseDelay = 0.2;
            return baseDelay * counter;
        },

        setAnimationForItems: function ($container, $items, $item, $delay) {
            //Select one of available animations
            if ($container.hasClass('fadeinfrombottom') || $container.hasClass('fadein') || $container.hasClass('fadeinfromtop') || $container.hasClass('fadeinfromright') || $container.hasClass('fadeinfromleft')) {
                $container.find('ul li, .instagramfeed .instagram-img').addClass('isEaseInAnimated');
                $item.addClass('isanimated');
                $item.css({ 'transition-delay': $delay + 's' });
            } else if ($container.hasClass('zoomin')) {
                $container.find('.postphoto').addClass('isZoomInAnimated');
                $item.addClass('isanimated');
                $item.css({ 'transition-delay': $delay + 's' });
            } else if ($container.hasClass('default')) {
                $container.find('.postphoto').addClass('isDefault');
                $item.addClass('isanimated');
            }
        },

        // animation / cart blog
        isotopeAnimation: function ($container) {
            var self = this,
                $this = $container,
                counter = 0,
                $selector;

            if ((self.isMobile() || self.isTablet()) && $container.hasClass('no-responsive-animation')) {
                return;
            }

            $container.find('.isotope-item').not('.isotope-hidden').find('.postphoto,.blog_item').not('.isanimated').waypoint({
                handler: function () {
                    var $this = $(this.element);
                    $this.each(function () {
                        var $item = $(this);
                        setTimeout(function () {
                            //Ask self.animationDelay() for the amount of delay per each item
                            var delay = self.animationDelay(counter, $item);

                            // Select all items
                            var $allItems = $container.find('.postphoto');

                            //Select one of available animations
                            self.setAnimationForItems($container, $allItems, $item, delay);

                            //Reset counter per each iteration.
                            counter = counter + 1;

                        }, 50);
                        counter = 0;
                    });
                    this.destroy();
                },
                offset: '95%'
            });
        },

        //  products and Carousel ( image carousel , Instagram carousel , Products carousel )
        showAnimation: function ($container, $carousel) {

            var self = this,
                counter = 0,
                $carouselItem,
                $duplicateSlider;

            var showAnimationBase = function (that) {
                $(that).each(function () {
                    var $delay;
                    setTimeout(function () {
                        //Ask self.animationDelay() for the amount of delay per each item
                        //Select one of available animations
                        if ($container.hasClass('fadeinfrombottom') || $container.hasClass('fadeinfromtop') || $container.hasClass('fadeinfromright') || $container.hasClass('fadeinfromleft')) {

                            $container.find('.productwrap , .swiper-slide,.product_category_container').addClass('isEaseInAnimated'); // Find .productWrap For Shop widge , Use Swiper-slide for image carousel
                            $(that).addClass('isanimated');

                            $delay = 0.15 * counter;
                            $(that).css({ 'transition-delay': $delay + 's' });

                        } else if ($container.hasClass('zoomin')) {
                            $container.find('.productwrap , .swiper-slide,.product_category_container').addClass('isZoomInAnimated');
                            $(that).addClass('isanimated');

                            $delay = 0.1 * counter;
                            $(that).css({ 'transition-delay': $delay + 's' });

                        } else {
                            $container.find('.productwrap , .swiper-slide,.product_category_container').addClass('fadein');
                            $(that).addClass('isanimated');

                            $delay = 0.01 * counter;
                            $(that).css({ 'transition-delay': $delay + 's' });

                        }

                        //Reset counter per each iteration.
                        counter = counter + 1;

                    }, 0);

                    counter = 0;

                });
            }

            //Set animation for duplicate slides seperatly to do not consider in animation delays
            var setAnimationBaseForDuplicatSlides = function ($that) {
                $that.css({ 'transition-delay': '0s' });
                $that.addClass('isanimated');

                if ($container.hasClass('fadeinfrombottom') || $container.hasClass('fadeinfromtop') || $container.hasClass('fadeinfromright') || $container.hasClass('fadeinfromleft')) {
                    $container.find('.productwrap , .swiper-slide,.product_category_container').addClass('isEaseInAnimated'); // Find .productWrap For Shop widge , Use Swiper-slide for image carousel
                } else if ($container.hasClass('zoomin')) {
                    $container.find('.productwrap , .swiper-slide,.product_category_container').addClass('isZoomInAnimated');
                } else {
                    $container.find('.productwrap , .swiper-slide,.product_category_container').addClass('fadein');
                }
            }

            if ((self.isMobile() || self.isTablet()) && $container.hasClass('no-responsive-animation')) {
                return true;
            }

            if ($carousel == 1) { //this code For carousel

                $carouselItem = $container.find('div.product');

                if ( !$carouselItem.hasClass('swiper-slide-visible') ) {
                    return 0;
                }

                $container.find('.swiper-slide-visible .productwrap:not(.isanimated), .swiper-slide-visible .product_category_container:not(.isanimated)').waypoint({
                    handler: function () {
                        var $item = $(this.element);


                        $duplicateSlider = $item.closest('div.product').siblings('div.product[data-swiper-slide-index="' + $item.closest('div.product').data("swiper-slide-index") + '"]').find('.productwrap, .product_category_container')
                        $container = $item.parents('.woocommerce.wc-shortcode');

                        //load animation on slide and its duplicate slide
                        showAnimationBase($item);
                        setAnimationBaseForDuplicatSlides($duplicateSlider);
                        this.destroy();
                    },
                    offset: '95%'
                });



            } else if ($carousel == 2) { // For Image Carousel

                $carouselItem = $container.find('div.swiper-slide');

                if (!$carouselItem.hasClass('swiper-slide-visible')) {
                    return 0;
                }

                if ($container.hasClass('has-animation')) {

                    $container.find('.swiper-slide-visible:not(.isanimated)').waypoint({
                        handler: function () {
                            var $item = $(this.element);

                            $duplicateSlider = $item.siblings('div[data-swiper-slide-index="' + $item.data("swiper-slide-index") + '"]')

                            $container = $item.parents('.carousel');

                            //load animation on slide and its duplicate slide
                            showAnimationBase($item);
                            setAnimationBaseForDuplicatSlides($duplicateSlider);
                            this.destroy();
                        },
                        offset: '95%'
                    });

                }

            } else if ($carousel == 3) { // For Instagram Carousel

                $carouselItem = $container.find('div.insta-media');

                if ( !$carouselItem.hasClass('swiper-slide-visible') ) {
                    return 0;
                }

                if ($container.hasClass('has-animation')) {
                    var $notAnimatedSlide = $container.find('.swiper-slide-visible:not(.isanimated)');

                    $notAnimatedSlide.waypoint({
                        handler: function () {
                            var $item = $(this.element);

                            $duplicateSlider = $item.siblings('div[data-swiper-slide-index="' + $item.data("swiper-slide-index") + '"]');
                            $container = $item.parents('.carousel');
                            //load animation on slide and its duplicate slide
                            showAnimationBase($item);
                            setAnimationBaseForDuplicatSlides($duplicateSlider);
                            this.destroy();
                        },
                        offset: '95%'
                    });

                }

            } else { //this code For gird ( no Carousel)
                if ( !$container.hasClass('main-shop-loop') ) {
                    $container = $container.closest('.woocommerce.wc-shortcode');
                }

                if ( !$container.hasClass('default') ) { // default = No animation for Product Grid
                    $container.find('.productwrap:not(.isanimated),.product_category_container:not(.isanimated)').waypoint({
                        handler: function () {
                            var $item = $(this.element);
                            showAnimationBase($item);
                            this.destroy();
                        },
                        offset: '95%'
                    });

                }

            }
        },

        /*----------------------------------------------------------------------------------*/
        /*  Lazy loading images 
        /*-----------------------------------------------------------------------------------*/

        lazyLoadOnLoad: function (that) {
            let $thatContainers = typeof that == 'string' ? document.querySelectorAll(that) : that.get();

            var lazy_load_callback = (entries) => {
                entries.forEach( entry => {
                    if ( entry.isIntersecting ) {
                        let $this = entry.target;
                        if (!$this.classList.contains('lazy-loaded') && !$this.classList.contains('is-loading')) {
                            $this.classList.add('is-loading');
                            var $img, src;

                            if ($this.classList.contains('bg-lazy-load')) {
                                src = $this.dataset.src;

                            } else if ( $this.matches('img') ) {
                                $img = $this;
                                src = $img.dataset.src;
                            } else {
                                $img = $this.querySelector('img');
                                src = $img.dataset.src;
                            }

                            var img = new Image();

                            img.onload = function () {
                                if ($this.classList.contains('bg-lazy-load')) {
                                    $this.style.backgroundImage = 'url(' + src + ')';
                                    $this.removeAttribute('data-src');
                                } else {
                                    $img.src = src;
                                    $img.removeAttribute('data-src');
                                }

                                setTimeout(function () {
                                    $this.classList.add('lazy-loaded');
                                }, 100);
                            }
                            img.src = src;
                        }
                    }
                })
            }

            let options = {
                root: null,
                rootMargin: '0px',
                threshold: 0
            }

            $thatContainers.forEach( $container => {
                let $lazyLoadCntainers = $container.querySelectorAll('.lazy-load-on-load');
                if ($lazyLoadCntainers.length > 0) {

                    let observer = new IntersectionObserver( lazy_load_callback, options);
                    $lazyLoadCntainers.forEach( $lazyLoadElement => {
                        observer.observe( $lazyLoadElement );
                    })
                }
            })
        },

        lazyLoadOnHover: function ( $scope = '') {
            var self = this;

            if (self.isTouchDevice)
                return;
            if ( $scope == '' ) {
                var $items = $('.lazy-load-hover-container');
            } else {
                var $items = $scope.find('.lazy-load-hover-container');
            }

            $items.on('mouseenter', function () {
                var $this = $(this).find('.lazy-load-hover');
                if ($this.length > 0) {
                    if (!$this.hasClass('lazy-loaded') && !$this.hasClass('is-loading')) {
                        $this.addClass('is-loading');
                        $this.closest('.lazy-load-hover-container').addClass('is-loading');

                        var $img, src;

                        if ($this.hasClass('bg-lazy-load')) {
                            src = $this.data('src');
                        }
                        else {
                            $img = $this.find('img');
                            src = $img.data('src');
                        }

                        var img = new Image();

                        img.onload = function () {
                            if ($this.hasClass('bg-lazy-load'))
                                $this.css('background', 'url(' + src + ')').removeAttr('data-src', '');
                            else
                                $img.attr('src', src).removeAttr('data-src', '');

                            $this.closest('.lazy-load-hover-container').removeClass('is-loading');

                            setTimeout(function () {
                                $this.addClass('lazy-loaded');
                            }, 100);
                        }

                        img.src = src;
                    }
                }
            })
        },

        abortImageLoading: function () {
            $('.lazy-load.is-loading:not(.lazy-loaded) img').attr('src', '');
        },

        /*----------------------------------------------------------------------------------*/
        /*  WPML
        /*-----------------------------------------------------------------------------------*/

        wpmlMenu: function () {

            if ($('.headerwrap .menu-item-language').length) {
                $('.headerwrap .menu-item-language').append($("<span class='spanhover'></span>"));
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*   reInitialise the VC post grid
        /*-----------------------------------------------------------------------------------*/

        vcGridReInit: function () {
            if ($.fn.vcGrid) {
                $.fn.vcGrid.call($('[data-vc-grid-settings]'));
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*   Workaround for double tap issue on IOS
        /*-----------------------------------------------------------------------------------*/
        fixIOSDoubleTapIssue: function () {
            if (!navigator.platform.match(/(iPhone|iPod|iPad)/i)) {
                return;
            }

            var $elements = $('.buttons, .carousel .arrows-button-prev, .carousel .arrows-button-next,#blogsingle .arrows-button-next,#blogsingle .arrows-button-prev, .swiper-button-prev, .swiper-button-next,.woocommerce.infoonhover div.product, .woocommerce.infoonhover div.product .hover-image,.woocommerce.infoonhover div.product a.product-link');
            $elements = $elements.add('#mobile-menu-button,.cart-sidebarbtn,.cart-close-btn,#sidebar-open-overlay,.kt-header-builder-overlay,.responsive-wishlist a, .popup_interaction .soundcloud-format .play-button-wrap, .blog-masonry-container .play-button,#kt-modal,#kt-modal.quickview-modal #modal-close, #kt-modal a[rel="next"], #kt-modal a[rel="prev"]');
            $elements = $elements.add('.banner a,.gallery .postphoto, .galleryitem a, .readmore .loadmore, .woocommerce div.products div.product .product-buttons > span a, .pdwrap .pdnavigation a,.mobile-sidebar-overlay,.mobile-menu-close-button span,.navicons a,.scrolltotop a');
            $elements.on('touchstart mouseenter focus', function (e) {
                if (e.type == 'touchstart') {
                    e.stopImmediatePropagation();
                }
            });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Ajaxify Search
        /*-----------------------------------------------------------------------------------*/
        ajaxifySearch: function () {
            var self = this;

            //Woocommerce search
            self.$document.find("div.search-form form").submit(function (e) {
                var $this = $(this);

                var keyword = $this.find('input[name="s"]').val();
                if (keyword != '') {
                    var url = $this.attr('action');
                    $(this).siblings('a').attr('href', url + '?s=' + keyword).trigger('click');
                }
            });
        },

        /*----------------------------------------------------------------------------------*/
        /*   Wordpress toolbar edit link update
        /*-----------------------------------------------------------------------------------*/
        updateToolbarEditLink: function (content) {
            var self = this;

            if ( $("#wp-admin-bar-edit").length > 0 ) {
                // set up edit link when wp toolbar is enabled
                var page_id = self.$body.data('pageid');
                var oldLink = $('#wp-admin-bar-edit a').attr("href");
                var newLink = oldLink.replace(/(post=).*?(&)/, '$1' + page_id + '$2');
                $('#wp-admin-bar-edit a').attr("href", newLink);
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*   preloader
        /*-----------------------------------------------------------------------------------*/

        preloaderHide: function () {
            var self = this;

            //no-page-transition class prevent from running animation of page transition at first time
            self.$body.removeClass('no-page-transition');
            $('.main-content').addClass('show');
            // fixing issue : fade up animation in monitor with high height cause
            $('body.no-preloader.fade-up .footer-bottom').addClass('fadeissuefixed');
            $("#preloader").addClass('hide-preloader');
            setTimeout(function () {
                $("#preloader").css({ 'display': 'none' });
            }, 510);

        },


        /*----------------------------------------------------------------------------------*/
        /*   wpadminbar And Topbar
        /*-----------------------------------------------------------------------------------*/


        topBar: function () {
            var self = this;

            if ( $("#wpadminbar").length != 0 && self.windowWidth > 320 ) {

                if ( $("#topbar").length != 0 ) {

                    if (!(self.$ktHeader.hasClass('closedtopbar'))) {
                        // topbar Enable With wpadminbar
                        self.$ktHeader.add(".navigation-mobile").add("#homeHeight").addClass('menuspacewpnoti');
                        $("#topbar").addClass('topbarspacewp');
                    }
                    if ($('#topbar').hasClass('fixed-menu') || $('#topbar').hasClass('type10')) {

                        $('#topbar').css({ 'top': "32px", });
                    }

                } else {

                    // topbar disable With wpadminbar
                    self.$ktHeader.add("#homeHeight").addClass('menuspacewp');

                }
                $('.no-widgets > .sidebar.widget-area').addClass('has_adminbar');
            } else if ($("#topbar").length != 0 && !$("#topbar").hasClass('closed-topbar')) {
                // topbar Enable
                self.$ktHeader.add("#homeHeight").addClass('menu-space-noti');
            }

            if ( $("#wpadminbar").length != 0 && $(".vertical_menu_enabled").length != 0 ) {

                $('#home .homewrap .fulscreenimage').css({
                    'margin-top': "32px",
                });

            }

        },


        /*----------------------------------------------------------------------------------*/
        /*   Topbar language
        /*-----------------------------------------------------------------------------------*/

        topBarLang: function () {
            var href = window.location.href;
            var elements = $('.lang_link > li > a[href="' + href + '"]');
            var $langActive = elements.parent("li").addClass('active');
            if ($langActive.length) {
                var $selectedLang = $('.lang_link li.active').html();
                var $showLang = $("#language1,#mobile-language1").html()

                $('#language1,#mobile-language1').html($selectedLang);
                $('.lang_link li.active').html($showLang);
                $langActive.removeClass('active');
                $('#language1 > a,#mobile-language1 > a').attr('href', '#');
            }

            // Close the drop down language select in mobile menu
            $('.mobile-topbar .lang-sel > span:first-child a').on('click', function (event) {
                event.preventDefault();
                $('.mobile-topbar .lang-sel ul.lang_link').slideToggle('fast');
                $('.mobile-topbar .lang-sel ul.lang_link').toggleClass('show');
            });
            $('.dd-selected').on('click', function (event) {
                if ($('.mobile-topbar .lang-sel ul.lang_link').hasClass('show')) {
                    $('.mobile-topbar .lang-sel ul.lang_link').slideToggle('fast');
                    $('.mobile-topbar .lang-sel ul.lang_link').removeClass('show');
                }
            });
            $(document).on('click', function (event) {
                if ($(event.target).parents('.lang-sel').length == 0) {
                    if ($('.mobile-topbar .lang-sel ul.lang_link').hasClass('show')) {
                        $('.mobile-topbar .lang-sel ul.lang_link').slideToggle('fast');
                        $('.mobile-topbar .lang-sel ul.lang_link').removeClass('show');
                    }
                }

            });
            // End of Close dropdown language menu select in mobile menu
            $('.dd-select').off('click');
            $('.dd-select').on('click', function () {
                var $display = $('.dd-select').siblings('ul.dd-options').css('display');

                if ($display == 'none') {
                    $('.dd-select').siblings('ul.dd-options').slideDown();
                } else {
                    $('.dd-select').siblings('ul.dd-options').slideUp();
                }
            });
        },

        /*----------------------------------------------------------------------------------*/
        /*   User additional script
        /*-----------------------------------------------------------------------------------*/

        additionalScript: function () {
            //Run extra scripts here
            if ( '' != kite_theme_vars.additionaljs ) {
                eval(kite_theme_vars.additionaljs);
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*   Scrolling
        /*-----------------------------------------------------------------------------------*/

        scrolling: function () {
            var self = this;
            $(".navigation li a , .mobile-navigation li a , .vertical_menu_navigation li a").click(function (e) {
                var $this = $(this),
                    hashAttr = $this.attr('data-hash');

                $(".navigation li , .mobile-navigation li, .vertical_menu_navigation li").removeClass('active current_page_item');


                if (typeof hashAttr === typeof undefined || hashAttr === false) {

                    //add active class for first and secoud menu
                    var href = $this.attr('href');
                    var elements = $('a[href="' + href + '"]');

                    elements.parent().addClass('active');

                } else {
                    $('.navigation li a[data-hash="' + hashAttr + '"]').add('.mobile-navigation li a[data-hash="' + hashAttr + '"]').add('.vertical_menu_navigation li a[data-hash="' + hashAttr + '"]').parent().addClass('active');//Active item in all menus(Specially for kite-menu)
                }


                if (!$this.hasClass('locallink')) {
                    self.externalClicked = true;
                }

                if ($this.hasClass('externallink')) {

                    self.$scrolId = '#' + hashAttr; // section id that scroll into From External Page in internal page

                } else if ($this.hasClass('locallink')) {

                    e.preventDefault();
                    self.scrolingToSection = true;
                    self.scrollTo('#' + hashAttr, 4); //scroll to inside id  in Front Page
                }

                if ($this.hasClass('externallink')) {
                    self.enableScrollId = true;
                } else {
                    self.enableScrollId = false;
                }

            });

            $("header a.locallink.logo , header.type2_3 .locallink.logo a  ,aside .locallink.logo,header .locallink.home , aside .locallink.home").click(function (e) {
                var $this = $(this),
                    scroll = $this.attr('href');

                e.preventDefault();
                scroll = scroll.substring(scroll.indexOf("#"), scroll.length);
                self.scrollTo(scroll, 2);  //scroll to top of page
            });

            var pathname = window.location.href;

            if ( !window.location.origin ) { // Internet Explorer Origion
                window.location.origin = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port : '');
            }

            var $originpathname = window.location.origin + window.location.pathname;

            if ( pathname.search("#") > 0 ) {
                pathname = pathname.substring(pathname.indexOf("#"), pathname.length);
                if ( $originpathname !== pathname && pathname !== '#home' ) {
                    if ($(".page-template-main-page-php").length) {
                        self.scrollTo(pathname, 1);
                    }
                }
            }
        },

        //Initial list of menu items
        initialMenuArray: function () {
            var self = this;

            var aChildren = self.$ktHeader.find(".navigation li a").add(".vertical_menu_area .vertical_menu_navigation ul a"); // find the a children of the list items

            for (var i = 0; i < aChildren.length; i++) {

                var aChild = aChildren[i];
                if ($(aChild).hasClass('locallink')) {

                    var ahref = $(aChild).attr("data-hash");
                    if ( self.menuArray.indexOf(ahref) == -1 ) {
                        self.menuArray.push(ahref);
                    }
                }
            } // above loop fills the menuArray with attribute href values
        },

        /* add active class for menu when page Scrolling */
        updateMenuOnActiveSection: function () {
            var self = this;

            //Exit if this page is not main page
            if ( !self.$body.hasClass('home') || !self.$body.hasClass('page-template-main-page-php') ) {
                return;
            }

            //check navigating flag to know it is on scrolling to a section or not ( by click from user)
            if ( self.scrolingToSection == false && self.externalClicked == false ) {

                var windowY = self.$window.scrollTop(); // get the offset of the window from the top of page
                for (var i = 0; i < self.menuArray.length; i++) {
                    var theID = "#" + self.menuArray[i];
                    var theHash = self.menuArray[i];

                    if ( $(theID).length ) {

                        var divPos = $(theID).offset().top; // get the offset of the div from the top of page
                        var divHeight = $(theID).height(); // get the height of the div in question
                        var menuSize = 87;

                        if ($(".vertical_menu_area").length)
                            menuSize = 0;

                        if ( $("#wpadminbar").length != 0 ) { // wpadminbar
                            menuSize = menuSize + 36;
                        }

                        //Set divPos to 0 becouse #home section is parallax and doesn not exist from page normally
                        if ( theID == '#home' ) {
                            divPos = 0;
                        }

                        if ( self.$body.hasClass('home') ) {
                            self.$ktHeader.find(".navigation li.current_page_item").removeClass("current_page_item");
                            $("aside.vertical_menu_area .vertical_menu_navigation ul li.current_page_item").removeClass("current_page_item");
                        }

                        if ( windowY >= (divPos - menuSize) && windowY < (divPos + divHeight - menuSize) ) {
                            self.$ktHeader.find(".navigation a[data-hash='" + theHash + "']").parent().addClass("active");
                            $("aside.vertical_menu_area nav.vertical_menu_navigation li a[data-hash='" + theHash + "']").parent().addClass("active");
                        } else {
                            self.$ktHeader.find(".navigation a[data-hash='" + theHash + "']").parent().removeClass("active");
                            $("aside.vertical_menu_area nav.vertical_menu_navigation li a[data-hash='" + theHash + "']").parent().removeClass("active");
                        }
                    }
                }
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*   Search form
        /*-----------------------------------------------------------------------------------*/

        searchForm: function () {
            var self = this,
                $searchButton = $('.search-button , .search-button .icon, .search-icon-link');

            if ( $searchButton.length <= 0 ) {
                return;
            }
            var $searchForm = $('form.searchform.popup');
            var $searchInput = $searchForm.find('input[type="text"]');
            var $catBox = $searchForm.find('div.nice-select');
            var $searchResults = $searchForm.find('.searchresults');
            var $showAllResults = $searchForm.find('.show_all_results');
            self.$document.on('click', function (e) {
                if ( !$(e.target).is($searchForm) && $searchForm.has(e.target).length == 0 ) {
                    if ( $(e.target).is($searchButton) ) {
                        e.preventDefault();
                        $('.search-form-cls').toggleClass('showing');
                        if (!$searchResults.hasClass('close')) {
                            $searchResults.css('display', 'block');
                            $showAllResults.css('display', 'block');
                        }
                        setTimeout(function () {
                            $searchInput.focus();
                            var tmpStr = $searchInput.val();
                            $searchInput.val('');
                            $searchInput.val(tmpStr);
                        }, 100);
                    } else {
                        $('.search-form-cls').removeClass('showing');
                        if ( !$searchResults.hasClass('close') ) {
                            $searchResults.css('display', 'none');
                            $showAllResults.css('display', 'none');
                        }
                    }
                } else {
                    if ( $(e.target).is($catBox) || $catBox.has(e.target).length != 0 ) {
                        if ( !$searchResults.hasClass('close') ) {
                            $searchResults.toggleClass('close');
                        }
                        if ( !$showAllResults.hasClass('close') ) {
                            $showAllResults.toggleClass('close');
                        }
                    }
                }
            });
            self.$document.on( 'keydown', function(e){
                if(e.key === "Escape") {

                    $('.search-form-cls').removeClass('showing');
                    if ( !$('.mobilesearchcats').hasClass('open') ) {
                        $('.responsive-whole-search-container').removeClass('open');
                    }
                    if ( !$searchResults.hasClass('close') ) {
                        $searchResults.css('display', 'none');
                        $showAllResults.css('display', 'none');
                    }
                }
            });
        },

        /*----------------------------------------------------------------------------------*/
        /*  Home parallax
        /*-----------------------------------------------------------------------------------*/

        sliderParallax: function () {

            var self = this;

            if ( $('.sliderParallax').length <= 0 || self.msie > 0 || !!self.msie11 ) {
                return;
            }

            if ( self.windowWidth > 1140 && !self.isTouchDevice && $("#home").length > 0 ) {

                self.windowHeight = self.$window.height();
                var $slider = $('#home .slider-wrap'),
                    $start = $slider.find('#caption-start'),
                    latestKnownScrollPosition = 0,
                    tick = false;

                var updateSliderPosition = function () {

                    //When element is out of viewport
                    if ( self.windowHeight < latestKnownScrollPosition ) {
                        tick = false;
                        return;
                    }

                    $slider.css({
                        'transform': 'matrix(1, 0, 0, 1, 0, ' + latestKnownScrollPosition * 0.6 + ')'
                    });

                    tick = false;
                }
                updateSliderPosition();
                var requestTick = function () {
                    if (tick == false) {
                        window.requestAnimationFrame(updateSliderPosition);
                    }
                    tick = true;
                }

                var onScroll = function () {
                    latestKnownScrollPosition = window.pageYOffset;
                    requestTick();
                }

                self.$window.on('scroll', onScroll);

                self.$window.one('djaxClick', function () {
                    self.$window.unbind('scroll', onScroll);
                });
            }

        },


        /*----------------------------------------------------------------------------------*/
        /*  Header transform
        /*-----------------------------------------------------------------------------------*/

        headerTransformation: function () {

            var self = this;

            var isFixedMenu = self.$ktHeader.data("fixed") === 'fixed-menu';

            if ((self.windowWidth > 1140 && isFixedMenu) || self.$body.hasClass('vertical_menu_enabled')) {
                return;
            }

            var latestKnownScrollPosition = 0,
                headerHeight = self.$ktHeader.find('#headerfirststate').outerHeight();

            var updateMenuState = function () {
                latestKnownScrollPosition = window.pageYOffset;
                // checking the state of mobile Header
                if ($('#mobile-header_secondstate').length != 0) {
                    if (130 > latestKnownScrollPosition) {
                        $('#mobile-header').removeClass('state2');
                        $('#mobile-header_secondstate').removeClass('state2');
                    } else {
                        $('#mobile-header').addClass('state2');
                        $('#mobile-header_secondstate').addClass('state2');
                    }
                }


                if ( headerHeight > latestKnownScrollPosition ) {
                    self.$ktHeader.removeClass('state2');
                    // If Search Resutl is open => close it
                    if ( $('#kt-header #headersecondstate .searchresults').length > 0 ) {
                        $('#kt-header #headersecondstate .searchresults').css('visibility', 'hidden');
                        $('#kt-header #headersecondstate .show_all_results').css('visibility', 'hidden');
                        $('#kt-header #headersecondstate .searchelements').removeClass('focus');
                        $('#headersecondstate .searchelements input').blur();
                    }
                    // If Category dropdown is open => close it
                    if ( $('#headersecondstate div.nice-select').hasClass('open') ) {
                        $('#headersecondstate div.nice-select').removeClass('open');
                    }
                } else {
                    self.$ktHeader.addClass('state2');
                    // If Search Resutl of first header sate is open => close it
                    if ( !$('#headerfirststate .searchresults').hasClass('close') ) {
                        $('#headerfirststate .searchresults').addClass('close');
                        $('#headerfirststate .show_all_results').addClass('close');
                        $('#headerfirststate .searchelements').removeClass('focus');
                        $('#headerfirststate .searchelements input').blur();
                    }
                    // If Category dropdown is open => close it
                    if ( $('#headerfirststate div.nice-select').hasClass('open') ) {
                        $('#headerfirststate div.nice-select').removeClass('open');
                    }
                    // If Search Resutl of second header state is open => close it
                    if ( $('#kt-header #headersecondstate .searchresults').length > 0 ) {
                        if ( !$('#kt-header #headersecondstate .searchresults').hasClass('close') ) {
                            $('#kt-header #headersecondstate .searchresults').css('visibility', 'visible');
                            $('#kt-header #headersecondstate .show_all_results').css('visibility', 'visible');
                        } else {
                            $('#kt-header #headersecondstate .show_all_results').addClass('close');
                            $('#kt-header #headersecondstate .searchresults').attr('style', '');
                            $('#kt-header #headersecondstate .show_all_results').attr('style', '');
                        }
                    }
                }

            }

            self.$window.on('scroll', updateMenuState);
            updateMenuState();

        },

        /*----------------------------------------------------------------------------------*/
        /*  top Button
        /*-----------------------------------------------------------------------------------*/

        scrollToTopButton: function () {
            var self = this;

            var $scrollToTop = $(".scrolltotop");

            if ( $scrollToTop.length <= 0 ) {
                return;
            }

            var latestKnownScrollPosition = 0,
                tick = false,
                visibilityThreshold = self.windowHeight * 1.7;

            //use unbind to prevent from multiple times clikc event
            $scrollToTop.find("a.scrolltop").unbind().click(function (e) {
                e.preventDefault();
                self.scrollTo("top", 3);  //scroll to top of page
            });

            var updateButtonVisibility = function () {

                if ( visibilityThreshold > latestKnownScrollPosition ) {
                    $scrollToTop.removeClass('visiblescrolltop');
                } else {
                    $scrollToTop.addClass('visiblescrolltop');
                }

                tick = false;
            }

            updateButtonVisibility();

            var requestTick = function () {
                if (tick == false) {
                    window.requestAnimationFrame(updateButtonVisibility);
                }
                tick = true;
            }

            var onScroll = function () {
                latestKnownScrollPosition = window.pageYOffset;
                requestTick();
            }

            self.$window.on('scroll', onScroll);
            self.$window.one('djaxClick', function () {
                self.$window.unbind('scroll', onScroll);
            });
        },

        /*----------------------------------------------------------------------------------*/
        /*  Gallery
        /*-----------------------------------------------------------------------------------*/

        galleryStart: function () {
            var self = this;

            if (typeof $.fn.lightGallery != 'function' || ! $('.kt_lightgallery').length ) {
                return;
            }

            $('.kt_lightgallery').each(function () {

                var $this = $(this);

                //Let the animation be set by the user
                var slideAnimation = $this.parent('.isotope').data('animation-type'),
                    galleryID = $this.attr('id'),
                    galleryThumbnail = $this.parent('.isotope').data('gallery-thumbnail');

                $this.lightGallery({
                    selector: '.galleryitem',
                    counter: true,
                    mode: slideAnimation,
                    speed: 400,
                    thumbnail: galleryThumbnail,
                    currentPagerPosition: 'middle',
                    galleryId: galleryID,
                    iframeMaxWidth: '80%'
                });

                $this.on('onBeforeOpen.lg', function (event) {
                    //detect if the gallery is of type light style
                    $(".isotope.lightPopUp").click(function () {
                        $('.lg').addClass('lightstyle');//when LightStyle is selected
                        $('.lg-backdrop.in').addClass('galleryback');
                    });
                });

                $this.on('onAfterOpen.lg', function (event) {
                    $(".isotope .isotope-item").click(function () {

                        // Add Class Active Gallery
                        $('.kt_lightgallery').removeClass('activeGallery');
                        $(this).parents('.kt_lightgallery').addClass('activeGallery');

                        //Calculating Social share information
                        var json = $.parseJSON($(this).find('.postphoto .galleryitem a.portfolioLink').data('social-share'));

                        //Adding socailshare to the image wrap
                        $(".lg-outer .bd_socail_share").remove();
                        $(".lg-outer .lg-toolbar.group .lg-autoplay-button").after(json);
                        $('.social_share_toggle').hover(function () {//social button animation
                            $('.social_share_toggle .social_links_list').toggleClass('opentoggle');
                        });

                        self.socialSharePopup();
                        self.$body.addClass('gl-open');

                    });

                });


                $this.on('onAfterAppendSubHtml.lg', function (event) {

                    // Update socailshare
                    var $index = $('.lg-inner .lg-item.lg-current').index();
                    //Calculating Social share information
                    var json = $.parseJSON($('.kt_lightgallery.activeGallery').find('.postphoto .galleryitem a.portfolioLink').eq($index).data('social-share'));
                    //Adding socailshare to the image wrap
                    $(".lg-outer .bd_socail_share").remove();
                    $(".lg-outer .lg-toolbar.group .lg-autoplay-button").after(json);
                    $('.social_share_toggle').hover(function () {//social button animation
                        $('.social_share_toggle .social_links_list').toggleClass('opentoggle');
                    });

                    self.socialSharePopup();

                    $('.lg-sub-html').children().show('opacity', 1);

                });

                $this.on('onBeforeClose.lg', function (event) {
                    self.$body.removeClass('gl-open');
                });

            });

        },

        getScrollBarWidth: function () {
            var self = this;

            var inner = document.createElement('p');
            inner.style.cssText = 'width: 100%; height: 200px;';

            var outer = document.createElement('div');
            outer.style.cssText = 'width: 200px; height: 150px; position:absolute; visibility:hidden; left:0px; top:0px; overflow:hidden;';
            outer.appendChild(inner);

            document.body.appendChild(outer);
            var w1 = inner.offsetWidth;
            outer.style.overflow = 'scroll';
            var w2 = inner.offsetWidth;
            if ( w1 == w2 ) {
                w2 = outer.clientWidth;
            }

            document.body.removeChild(outer);

            if ( (w1 - w2) > 0 ) { // Detect scrollbar width
                if (self.$body.height() > self.windowHeight) { // Detect if a page has a vertical scrollbar?
                    self.$body.addClass('has-scrollbar');

                    if ((w1 - w2) == 15) { // ios device
                        self.$body.addClass('scrollbarSize15');
                    } else if ((w1 - w2) == 17) { // chorme and firefox in windows
                        self.$body.addClass('scrollbarSize17');
                    } else if ((w1 - w2) == 12) { // edge in windows
                        self.$body.addClass('scrollbarSize12');
                    }
                }
            }
        },

        // cookies bar
        cookiesBar: function () {
            if (typeof Cookies === 'undefined') { // this is temperpry solution
                return false;
            }
            if ( $(window).width() > 1280 ) {
                $('.kt-cookies-bar').addClass('container');
            }

            if (Cookies.get('kt_cookies') == 'accepted') {
                return;
            }
            var $cookiesBar = $('.kt-cookies-bar');
            setTimeout(function () {
                $cookiesBar.addClass('bar-display');
                $cookiesBar.on('click', '.cookies-accept-btn', function (e) {
                    e.preventDefault();
                    acceptCookies();
                })
            }, 2500);

            var acceptCookies = function () {
                $cookiesBar.removeClass('bar-display').addClass('bar-hide');
                Cookies.set('kt_cookies', 'accepted', { expires: 60, path: '/' });

            };
        },

        mobileHeaderSearchButtonClick: function () {
            var self = this;
            if ( $(window).width() >= 1140 ) {
                return;
            }

            $('.kt-header-button.kt-search').each(function (index, el) {
                $(this).on('click', function () {
                    var $this = $(this);
                    $this.siblings('.responsive-whole-search-container').toggleClass('open');
                    $('.kt-header-builder-overlay').addClass('show');
                });
            });

            $(document).on('click', function (event) {
                if ( !$(event.target).parents('.responsive-whole-search-container').length && !$(event.target).parents('.search_icon, .kt-header-button.kt-search').length && $('.responsive-whole-search-container').hasClass('open') ) {
                    $('.responsive-whole-search-container').removeClass('open');
                    $('.kt-header-builder-overlay').removeClass('show');
                }
            });

            // Not run in marketplace header
            if ( !$('#mobile-header.style2').length ) {
                return;
            }

            $('.search_icon, .kt-header-button.kt-search').each(function (index, el) {
                var $this = $(this);
                $this.on('click', function () {
                    $this.parent('.mobile-header-buttons').siblings('.responsive-whole-search-container').toggleClass('open');
                    setTimeout( function(){
                        $this.parent('.mobile-header-buttons').siblings('.responsive-whole-search-container').find('.searchinput').focus();
                        // $this.parent('.mobile-header-buttons').siblings('.responsive-whole-search-container').find('.searchinput').click();
                    }, 500 );
                });

                $this.on('keyup', function (e) {
                    if ( e.keyCode === 13 ) {
                        $this.parent('.mobile-header-buttons').siblings('.responsive-whole-search-container').addClass('open');
                        setTimeout( function(){
                            $this.parent('.mobile-header-buttons').siblings('.responsive-whole-search-container').find('.searchinput').focus();
                            // $this.parent('.mobile-header-buttons').siblings('.responsive-whole-search-container').find('.searchinput').click();
                            self.trapNavigationInModal( false );
                        }, 500 );
                    }
                });
            });
        },
        sanitize: function(string) {
            const map = {
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#x27;',
                "/": '&#x2F;',
            };
            const reg = /[&<>"'/]/ig;
            return string.replace(reg, (match)=>(map[match]));
        },
        ajaxSearchFormSync: function ($element, $value) {
            if ( $element.parent().hasClass('firstStateSearchForm') ) {
                $('.secondstatesearchform .searchinput').val($value);
            } else if ( $element.parent().hasClass('secondstatesearchform') ) {
                $('.firstStateSearchForm .searchinput').val($value);
            }
        },
        ajaxSearchForm: function () {

            var self = this;
            var xhr = null;
            var $selectedCat = 'all';
            var $Cats;
            var $input = $('.searchinput');
            var $searchForm = $('.search-form-cls');
            var $searchInputWrapper = $('.search-inputwrapper');
            var $searchIcon = $('.search-container .searchicon, .widget-has-catlist .searchicon, .search-icon-link');
            self.mobileHeaderSearchButtonClick();

            $searchIcon.on('click', function (event) {
                $(this).parents('form').submit();
            });
            $searchIcon.on('keydown', function(event){
                if ( event.keyCode == 13 ) {
                    $(this).parents('form').submit();
                }
            });
            $('.searchresults, .searchcats,.searchcats span').on('click', function (e) {
                var $searchElements = $(this).closest('.search-container').find('.searchelements');
                if ( !$searchElements.hasClass('focus') ) {
                    $searchElements.addClass('focus');
                    $('.search-inputwrapper form').addClass('focus');
                }
            });
            $('.mobilesearchcats li.option').on('click', function (event) {
                event.preventDefault();
                $(this).parents('.search-container').find('.searchinput').attr('placeholder', 'Search in "' + $(this).text() + '"');
            });
            $('.mobilesearchcats').on('click', function () {
                if ( !$(this).parents('.search-inputwrapper').find('.searchresults').hasClass('close') ) {
                    $('.searchresults').addClass('close');
                    $('.show_all_results').addClass('close');
                }
            });
            $('.searchinput').on('click', function () {
                if (!$(this).parent('.searchelements').hasClass('focus')) {
                    $(this).parent('.searchelements').addClass('focus');
                    $(this).parents('form').addClass('focus');
                }
                if (!$('.mobile-sidebar-overlay').hasClass('open')) {
                    $('header#kt-header').addClass('z-index');
                    $('.mobile-sidebar-overlay').addClass('open');
                    $('body').addClass('kt-fix-responsive');
                }
                var $searchResults = $(this).closest('.search-container').find('.searchresults');
                var $showAllResults = $(this).closest('.search-container').find('.show_all_results');
                if ( $searchResults.find('.searchitem').length > 0 ) {
                    if ( $searchResults.hasClass('close') ) {
                        $searchResults.toggleClass('close');
                        $showAllResults.toggleClass('close');
                    }
                } else {
                    var histories = self.getSearchHistory( '', false ),
                        historyLength = ( typeof histories == 'undefined' ) ? 0 : ( histories.length >= 4 ? 4 : histories.length ),
                        $activeSearchResults = $(this).closest('.search-container').find('.searchresults');

                    if ( historyLength != 0 ) {
                        var historiesLink = '',
                            hostname = kite_theme_vars.url,
                            postType = $(this).parents('form').find("input[name='post_type']").val();

                        for ( var i=0; i < historyLength; ++i ) {
                            var url = self.updateQueryStringParameter( hostname, 's', histories[i] );
                            url = self.updateQueryStringParameter( url, 'post_type', postType);
                            historiesLink += '<div class="row"><span class="icon icon-history"></span><a href="' + url +'">' + histories[i] + '</a></div>';
                        }

                        if ( ! $activeSearchResults.find( '.searchitem' ).length ) {
                            $activeSearchResults.find('.kt-history').html( historiesLink );
                        }

                        $activeSearchResults.removeClass('close');
                    }
                }

            });

            $('body').click(function (e) {
                if (!$(e.target).is('.searchcats,.searchinput, .searchcats span, .searchresults, .show_all_results,.search-button')) {
                    $('.searchelements').removeClass('focus');
                    $('.mobile-sidebar-overlay').removeClass('open');
                    $('body').removeClass('kt-fix-responsive');
                    $('header#kt-header').removeClass('z-index');
                    $('.search-inputwrapper form').removeClass('focus');
                    if ($(this).closest('.search-container').find('.searchresults').hasClass('close')) {
                        $(this).closest('.search-container').find('.show_all_results').addClass('close');
                    }

                }
            });

            $('.show_all_results').on('click', function () {
                $(this).closest('.search-container').find('form').submit();
            });
            $('.search-inputwrapper .searchicon').on('click', function () {
                $(this).closest('.search-container').find('form').submit();
            });
            $input.on('keyup', function (e) {
                if ( e.keyCode == 27 ) {
                    return;
                } else if ( xhr ) {
                    xhr.abort();
                }
                var value = $(this).val();
                if ( value.indexOf('<script') == 0 || value.indexOf('<script') > 0 ) {
                    value = self.sanitize(value);
                }
                self.ajaxSearchFormSync($(this), value);
                var $searchResults = $('.searchresults');
                var $showAllResults = $('.show_all_results');
                var $search_container = $(this).closest('.search-container');
                var $activeSearchResults = $search_container.find('.searchresults');
                var $activeShowAllResults = $search_container.find('.show_all_results');

                var resultColumns = '';
                if ( $(this).closest('.search-container.search-element.columns-1, .search-container.search-element.columns-2, .search-container.search-element.columns-3').length ) {
                    if ( $search_container.hasClass('columns-1') ) {
                        resultColumns = 1;
                    } else if ( $search_container.hasClass('columns-2') ) {
                        resultColumns = 2;
                    } else {
                        resultColumns = 3;
                    }
                }

                $searchResults.each(function (index, el) {
                    if ($(this).find('.searchitem').length > 0) {
                        if ($(this).hasClass('close')) {
                            $(this).toggleClass('close');
                            $(this).closest('.search-container').find('.show_all_results').toggleClass('close');
                        }
                    }
                });
                $Cats = $(this).parents('.search-container').find('li.option');
                if ( $Cats.length > 0 ) {
                    $.each($Cats, function (index, val) {
                        if ($(this).hasClass('selected')) {
                            $selectedCat = $(this).attr('data-value');
                        }
                    });
                }
                var data = {
                    action: 'kite_ajax_search_action',
                    s: value,
                    cat: $selectedCat,
                    result_columns : resultColumns
                }
                if (value.length < 2) {
                    $(this).parent().find('.typing-indicator span').css('visibility', 'hidden');
                    $searchInputWrapper.find('.searchicon span.icon,.searchicon,form .searchicon span').removeClass('loading');

                    $searchResults.each(function (index, el) {
                        if ( !$(this).hasClass('close') ) {
                            $(this).addClass('close');
                            $(this).closest('.search-container').find('.show_all_results').addClass('close');
                        }
                        if ($(this).find('.searchitem').length > 0) {
                            $(this).find('.kt-result').html('');
                            $(this).find('.kt-result').removeClass('has-result');
                        }
                        // Removeing The Style that Created with jquery when toggling search Form overlay
                        // Refer to search_form Function
                        $(this).removeAttr('style');
                        $(this).closest('.search-container').find('.show_all_results').removeAttr('style');
                    });
                    $showAllResults.each(function (index, el) {
                        if ( !$(this).hasClass('close') ) {
                            $(this).addClass('close');
                        }
                    });
                } else {
                    // show search histories
                    var histories = self.getSearchHistory( value, false ),
                        historyLength = ( typeof histories == 'undefined' ) ? 0 : ( histories.length >= 4 ? 4 : histories.length );
                    if ( historyLength != 0 ) {
                        var historiesLink = '',
                            hostname = $('<a>').prop('href', url).prop('hostname'),
                            postType = $(this).parents('form').find("input[name='post_type']").val();

                        for ( var i=0; i < historyLength; ++i ) {
                            var url = self.updateQueryStringParameter( hostname, 's', histories[i] );
                            url = self.updateQueryStringParameter( url, 'post_type', postType);
                            historiesLink += '<div class="row"><span class="icon icon-history"></span><a href="' + url +'">' + histories[i] + '</a></div>';
                        }

                        if ( ! $activeSearchResults.find( '.searchitem' ).length ) {
                            $activeSearchResults.find('.kt-history').html( historiesLink );
                        }

                        $activeSearchResults.removeClass('close');
                    }

                    $(this).parent().find('.typing-indicator span').css('visibility', 'visible');
                    $searchInputWrapper.find('form .searchicon span.icon, form .searchicon, form .searchicon span').addClass('loading');
                    $showAllResults.each(function (index, el) {
                        if ($(this).hasClass('close')) {
                            $(this).removeClass('close');
                        }
                        $(this).html( kite_theme_vars.see_all_results + " <a href='#' class='productsearchlink'>" + value + "</a>")
                    });
                    xhr = $.ajax({
                        url: kite_theme_vars.ajax_url,
                        type: 'GET',
                        dataType: 'html',
                        data: data,
                    }).done(function (response) {
                        if ($(response).find('.searchitem').length > 0) {
                            self.addSearchHistory(value);
                            // Search Results Sync Between two state header
                            $searchResults.each(function (index, el) {
                                if ($(this).find('.searchitem').length > 0) {
                                    $(this).find('.kt-result').html('');
                                    $(this).find('.kt-result').removeClass('has-result');
                                }
                                $(this).find('.kt-history').html('');
                                $(this).find('.kt-result').html(response);
                                $(this).find('.kt-result').addClass('has-result');
                                self.lazyLoadOnLoad($(this));
                            });
                            // Toggling Search Result show for just the activated Input
                            if ($activeSearchResults.hasClass('close')) {
                                $activeSearchResults.removeClass('close');
                                $activeShowAllResults.removeClass('close');
                            }
                            self.trapNavigationInModal( false );
                        } else {
                            $searchResults.each(function (index, el) {
                                if (!$(this).hasClass('close')) {
                                    $(this).addClass('close');
                                }
                                if ($(this).find('.searchitem').length > 0) {
                                    $(this).find('.kt-result').html('');
                                }
                                // Removeing The Style that Created with jquery when toggling search Form overlay
                                // Refer to search_form Function
                                $(this).removeAttr('style');
                                $(this).closest('.search-container').find('.show_all_results').removeAttr('style');
                            });
                            $showAllResults.each(function (index, el) {
                                if ($(this).hasClass('close')) {
                                    $(this).removeClass('close');
                                }
                                $(this).html(response + "<a href='#' class='productsearchlink'> " + value + "</a>")
                            });
                            self.trapNavigationInModal( false );
                        }
                        $('.typing-indicator span').css('visibility', 'hidden');
                        $searchInputWrapper.find('.searchicon span.icon,.searchicon, form .searchicon span').removeClass('loading');

                    }).fail(function (response) {

                    }).always(function () {

                    });
                }
            });

            if ($('.search-container').find('li.option').length > 0) {
                $('.search-container').on('click', 'li.option', function (event) {
                    if (xhr) {
                        xhr.abort();
                    }
                    var $clickedCat = $(this);
                    var value = $clickedCat.closest('.search-container').find('input.searchinput').val();
                    if ( value.indexOf('<script') == 0 || value.indexOf('<script') > 0 ) {
                        value = self.sanitize(value);
                    }
                    var $activeSearchResults = $clickedCat.closest('.search-container').find('.searchresults');
                    var $activeShowAllResults = $clickedCat.closest('.search-container').find('.show_all_results');
                    var $searchResults = $('.searchresults');
                    var $showAllResults = $('.show_all_results');
                    var $selectedCat = $clickedCat.attr('data-value');
                    var $catsNiceSelect = $('.search-inputwrapper .nice-select');

                    // change category for non ajax search action
                    $clickedCat.closest('.search-container').find('input[name="cat"]').val( $selectedCat );

                    // Categories Sync between two state
                    if ( $catsNiceSelect.length > 0 ) {
                        $catsNiceSelect.each(function (index, el) {
                            if (!$(this).parents('.search-container').is($clickedCat.parents('.search-container'))) {

                                var $otherStateCats = $(this).find('li.option');
                                $otherStateCats.each(function (index, el) {
                                    if ($(this).hasClass('selected')) {
                                        $(this).removeClass('selected focus');
                                    }
                                    if ($(this).attr('data-value') == $selectedCat) {
                                        $(this).addClass('selected focus');
                                        $(this).closest('.nice-select').find('.current').text($(this).text());
                                    }
                                });
                            }
                        });
                    }
                    var data = {
                        action: 'kite_ajax_search_action',
                        s: value,
                        cat: $selectedCat,
                    }
                    if (value.length < 2) {
                        if ($(this).parents('form').hasClass('popup')) {
                            $searchForm.find('.typing-indicator span').css('visibility', 'hidden');
                        } else {
                            $searchInputWrapper.find('.searchicon span.icon,.searchicon, form .searchicon span').removeClass('loading');
                        }
                        $searchResults.each(function (index, el) {
                            if ( !$(this).hasClass('close') ) {
                                $(this).addClass('close');
                                $(this).closest('.search-container').find('.show_all_results').addClass('close');
                            }
                            if ( $(this).find('.searchitem').length > 0 ) {
                                $(this).find('.kt-result').html('');
                            }
                            // Removeing The Style that Created with jquery when toggling search Form overlay
                            // Refer to search_form Function
                            $(this).removeAttr('style');
                            $(this).closest('.search-container').find('.show_all_results').removeAttr('style');
                        });
                    } else {
                        $searchForm.find('.typing-indicator span').css('visibility', 'visible');
                        $searchInputWrapper.find('.searchicon span.icon,.searchicon, form .searchicon span').addClass('loading');
                        if (xhr) {
                            xhr.abort();
                        }
                        xhr = $.ajax({
                            url: kite_theme_vars.ajax_url,
                            type: 'GET',
                            dataType: 'html',
                            data: data,
                        }).done(function (response) {
                            if ($(response).find('.searchitem').length > 0) {
                                // Search Results Sync Between two state header
                                $searchResults.each(function (index, el) {
                                    if ($(this).find('.searchitem').length > 0) {
                                        $(this).find('.searchitem').remove();
                                    }
                                    $(this).find('.kt-history').html('');
                                    $(this).find('.kt-result').html(response);
                                    $(this).find('.kt-result').addClass('has-result');
                                    self.lazyLoadOnLoad($(this));
                                });
                                // Toggling Search Result show for just the activated Input
                                if ($activeSearchResults.hasClass('close')) {
                                    $activeSearchResults.removeClass('close');
                                    $activeShowAllResults.removeClass('close');
                                }
                            } else {
                                $searchResults.each(function (index, el) {
                                    if (!$(this).hasClass('close')) {
                                        $(this).addClass('close');
                                    }
                                    if ($(this).find('.searchitem').length > 0) {
                                        $(this).find('.kt-result').html('');
                                    }
                                    // Removeing The Style that Created with jquery when toggling search Form overlay
                                    // Refer to search_form Function
                                    $(this).removeAttr('style');
                                    $(this).closest('.search-container').find('.show_all_results').removeAttr('style');
                                });
                                $showAllResults.each(function (index, el) {
                                    if ($(this).hasClass('close')) {
                                        $(this).removeClass('close');
                                    }
                                    $(this).html(response + "<a href='#' class='productsearchlink'> " + value + "</a>")
                                });
                            }
                            $('.typing-indicator span').css('visibility', 'hidden');
                            $searchInputWrapper.find('.searchicon span.icon,.searchicon, form .searchicon span').removeClass('loading');
                        }).fail(function () {

                        });
                    }
                });
                self.$document.on('click', function (event) {

                    var $searchInputWrapper = $("#headerfirststate .search-inputwrapper,#mobile-header .search-inputwrapper, #kt-header.kt-elementor-template .search-inputwrapper");
                    if ( $searchInputWrapper.length > 0 ) {
                        if ($searchInputWrapper.has(event.target).length == 0 && !$searchInputWrapper.is(event.target)) {
                            $searchInputWrapper.each(function (index, el) {
                                if (!$(this).find('.searchresults').hasClass('close')) {
                                    $(this).find('.searchresults').addClass('close');
                                    $(this).find('.show_all_results').addClass('close');
                                }
                            });
                        } else {
                            if ($searchInputWrapper.find('.searchcats').is(event.target) || $searchInputWrapper.find('.searchcats').has(event.target).length > 0) {
                                $searchInputWrapper.each(function (index, el) {
                                    if (!$(this).find('.searchresults').hasClass('close')) {
                                        $(this).find('.searchresults').addClass('close');
                                        $(this).find('.show_all_results').addClass('close');
                                    }
                                });
                            }
                        }
                    }
                    var $searchInputWrapperSecondState = $("#headersecondstate .search-inputwrapper,#mobile-header_secondstate .search-inputwrapper");
                    if ( $searchInputWrapperSecondState.length > 0 ) {
                        if ($searchInputWrapperSecondState.has(event.target).length == 0 && !$searchInputWrapperSecondState.is(event.target)) {
                            $searchInputWrapperSecondState.each(function (index, el) {
                                if (!$(this).find('.searchresults').hasClass('close')) {
                                    $(this).find('.searchresults').addClass('close');
                                    $(this).find('.show_all_results').addClass('close');
                                }
                            });
                        } else {
                            if ($searchInputWrapperSecondState.find('.searchcats').is(event.target) || $searchInputWrapperSecondState.find('.searchcats').has(event.target).length > 0) {
                                $searchInputWrapperSecondState.each(function (index, el) {
                                    if (!$(this).find('.searchresults').hasClass('close')) {
                                        $(this).find('.searchresults').addClass('close');
                                        $(this).find('.show_all_results').addClass('close');
                                    }
                                });
                            }
                        }
                    }
                });
            }
        },
        addSearchHistory: function( search ) {
            if ( ! $('body').hasClass('kt-search-history') || search == 'undefined' ) {
                return;
            }
            var self = this;
            var history = Cookies.get('kt-search-history');
            if ( history != '' ) {
                if ( ! self.getSearchHistory( search, true ) ) {
                    history = history + '|' + search;
                }
            } else {
                history = search;
            }
            Cookies.set( 'kt-search-history', history, { expires: 30 } );
        },
        getSearchHistory: function ( search, same = false ) {
            if ( ! $('body').hasClass('kt-search-history') ) {
                return;
            }
            var history = Cookies.get('kt-search-history');
                var result = [];
                if( history == '' || typeof history == 'undefined' ) {
                    return;
                }

                var histories = history.split('|');
                // if search is empty return latest 4 history
                if ( search == '' ) {
                    var loopNum = histories.length >= 4 ? ( histories.length - 4 ) : 0;
                    for ( var i = histories.length - 1; i >= loopNum; --i ) {
                        if ( histories[i] != 'undefined' ) {
                            result.push( histories[i] );
                        }
                    }
                } else {
                    if ( same == true ) {
                        for(var i = 0; i < histories.length; ++i){
                            if ( histories[i] == search ) {
                                return true;
                            }
                        }
                        return false;
                    }
                    for(var i = 0; i < histories.length; i++){
                        if ( histories[i].includes(search) ) {
                            if ( histories[i] != 'undefined' ) {
                                result.push(histories[i]);
                            }
                        }
                    }
                }

                return result;
        },

        // popup newsletter
        popupNewsletter: function () {

            var $newsletterModal = $("#kt-popup-newsletter");
            var $newsletterClose = $(".kt-popup-newsletter-close");
            var $newsletterInner = $(".kt-popup-newsletter-inner");
			var $topbarNewsletter = $(".topbar_newsletter, .kt-header-button.kt-newsletter");
			var $delay = $newsletterInner.data('delay');
            if ( $delay == '' || !$.isNumeric($delay) ) {
                $delay = 1000;
            }

            if ($(window).width() < 1140 ) {
                $delay = 0;
            }

			var topbarNewsletter = function(){
                setTimeout(function(){
                    $newsletterModal.css({
						'height': '100%',
						'opacity':'1'});
					$newsletterInner.addClass('show_popup');
                },$delay);


				// When the user clicks anywhere outside of the modal or on the X button, close it
				$newsletterModal.click(function (event) {
					var target = $(event.target);
					if (target.is($newsletterModal) || target.is($newsletterClose)) {
						$newsletterInner.removeClass('show_popup');
						$newsletterModal.css({
							'height': '0',
							'opacity':'0'});
						Cookies.set('kt_popup_newsletter', 'dismiss', { expires: 60, path: '/'});
					}
				});
			}

			// When topbarNewsletter is clicked, open the newsletter modal
			$topbarNewsletter.click(function () {
				$delay = 100;
				topbarNewsletter(setTimeout(function(){
                    $newsletterModal.css({
						'height': '100%',
						'opacity':'1'});
					$newsletterInner.addClass('show_popup');
                },$delay - 50)
				);

			});

            if ( $newsletterModal ) {
                if ($newsletterModal.hasClass('hidden-phone') && self.windowWidth <= 768) {
                    return;
                } else {

                    if (Cookies.set('kt_popup_newsletter') == 'dismiss') {
                       $newsletterModal.css({
							'height': '0',
							'opacity':'0'});
                        return;
                    } else {
                        topbarNewsletter();
                    }
                }
                if ($('.kt-popup-newsletter-shortcode .kt-newsletter').length != 0 && $('.kt-popup-newsletter-shortcode .kt-newsletter').hasClass('fullwidth')) {
                    $('.kt-popup-newsletter-shortcode').addClass('fullwidth');
                }
            }

        },

        headerPromoBar: function () {
            var self = this;
            var $responsiveHeader = $(".header-banner");
            var $headerBannerClose = $(".close-header-banner");
            $responsiveHeader.css('display', 'none');
            if ( $responsiveHeader ) {

                if ( self.windowWidth <= 1024 ) {
                    var $responsiveHeader_height = $responsiveHeader.data("responsive-height");
                    $responsiveHeader.css('height', $responsiveHeader_height);
                }


                if ( Cookies.set('header-banner') == 'dismiss' ) {
                    $responsiveHeader.remove();
                    return;
                } else {

                    if ($('#wpadminbar').length) {
                        var wpAdminBarHeight = $('#wpadminbar').height();
                    } else {
                        var wpAdminBarHeight = 0;
                    }
                    $(window).on('load', function () {
                        $responsiveHeader.css('display', 'block');
                        var headerHeight = $responsiveHeader.height() + wpAdminBarHeight;
                        var headerTopbarHeight = $('#topbar').height() + headerHeight;
                        if ( $responsiveHeader.hasClass('fixed-menu') ) {
                            $('#topbar.fixed-menu').css('top', headerHeight);
                            $('#kt-header.fixed-menu , #kt-header.fixed-menu #headerfirststate').css('top', headerTopbarHeight);
                        }
                    });

                    // When the user clicks anywhere outside of the modal or on the X button, close it
                    $headerBannerClose.click(function (event) {
                        $responsiveHeader.css('display', 'none');
                        var topbarHeight = $('#topbar').height() + wpAdminBarHeight;
                        $('#topbar.fixed-menu').css('top', wpAdminBarHeight);
                        $('#kt-header.fixed-menu, #kt-header.fixed-menu #headerfirststate').css('top', topbarHeight);
                        $('#kt-header.kite-menu #headersecondstate').css({ 'top': wpAdminBarHeight, 'transition': 'top .3s ease' });
                        Cookies.set('header-banner', 'dismiss', { expires: 60, path: '/' });
                    });
                }
            }
        },

        /*Wordpress Admin bar position in screen smaller size than 600px is not fixed
        and we need to fix over header in in fixed mode state to the top of screen while
        user scrolling the page down*/
        checkHeader: function () {
            var self = this;
            if ($('#wpadminbar').length > 0) {
                var $wpAdminBarHeight = $('#wpadminbar').height();
                // Check Window Width for the first time or when window resized
                if ( self.windowWidth > 600 ) {
                    $('#kt-header.fixed-menu').attr("style", "");
                    $('#mobile-header_secondstate').css('top', $wpAdminBarHeight);
                }
            }
        },

        tabClick: function () {
            var self = this;
            $('.vc_tta-tabs-container ul li a').on('click', function () {
                if ($('div.infoonclick').length) {
                    $('div.infoonclick div').find('span.show-hover').off('click');
                    self.productsInfoOnClick();
                }
            });
        },

        //humburger menu
        humburgerMenuToggle: function () {
            var $humburgerMenu = $('aside.humburger_menu_area'),
                $header = $('#kt-header.fixed-menu.type10');

            $('.menu-toggle').on('click', function () {
                var $this = $(this);
                $this.toggleClass('open').removeClass('closed');
                $humburgerMenu.toggleClass('show');
                $header.toggleClass('open');
            });
        },

        humburgerMenuUpdate: function () {
            var $widget = $('.vertical_menu_navigation'),
                $list = $widget.find('ul.humburger_menu');
            if ( ! $widget.length ) {
                return;
            }
            $list.find('li.menu-item-has-children').each(function () {
                var $this = $(this);
                if ( $this.find('ul').length <= 0 ) {
                    return true;
                }

                if ( $this.hasClass('current-menu-ancestor') ) {
                    $this.append('<div class="cats-toggle toggle-active"></div>');
                } else {
                    $this.append('<div class="cats-toggle"></div>');
                }
            });

            if ( $list.find('li.current-menu-item').length > 0 ) {
                $list.find('li.current-menu-item').parents('ul').css("display", "block");
                $list.find('li.current-menu-item ul.sub-menu').css("display", "block");
                $list.find('.current-menu-item.current-menu-ancestor .cats-toggle').addClass('toggle-active');
            }
        },
        humburgerMenuNavigation: function () {
            var $widget = $('.vertical_menu_navigation'),
                $list = $widget.find('ul.humburger_menu'),
                time = 300;
            $list.on('click', '.cats-toggle', function () {
                var $btn = $(this),
                $li = $btn.parent('li');
                if ($li.hasClass('mega-menu-parent')) {
                    var $subList =  $li.find('> div.menu-item-wrapper > ul.sub-menu');
                } else {
                    var $subList =  $li.find('> ul.sub-menu');
                }

                if ($subList.hasClass('list-shown')) {
                    $btn.removeClass('toggle-active');
                    $subList.stop().slideUp(time, 'easeInOutCirc').removeClass('list-shown');
                } else {
                    $subList.parent().parent().find('> li > .list-shown').slideUp().removeClass('list-shown');
                    $subList.parent().parent().find('> li > .toggle-active').removeClass('toggle-active');
                    $btn.addClass('toggle-active');
                    $subList.stop().slideDown(time, 'easeInOutCirc').addClass('list-shown');
                }
            });
        },

        bottomNavbarHandler: function() {
            $(document).on( 'click', function(e){
                if ( ! $(e.target).parents('.navicons').length && ! $(e.target).is('.navicons') ) {
                    return;
                }

                var $navIcons = $(e.target).is('.navicons') ? $(e.target) : $(e.target).parents('.navicons');

                if ( $navIcons.hasClass('cart') && ! $(e.target).is('.cart-sidebarbtn') && ! $(e.target).is('.kt-header-button.kt-cart') ) {
                    $('.cart-sidebarbtn').click();
                }

                if ( $navIcons.hasClass('userAccount') && ! $(e.target).is('.login-link-popup') ) {
                    $('.login-link-popup').click();
                }
            });
        },

        selectElement: function() {
            $('.kt-select-element').each(function(){
                if ( $(this).data('action') == 'hover' ) {
                    $(this).hover(function () {
                            // over
                            $(this).addClass('open');
                        }, function () {
                            // out
                            $(this).removeClass('open');
                        }
                    );
                }
            });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Animation For Image & Text Shortcode
        /*-----------------------------------------------------------------------------------*/

        shortcodeAnimation: function () {
            var self = this,
                $shortcodes;

            var animateShortcodes = function (item) {
                var $this = item,
                    $delay = $this.attr('data-delay');

                if ( $this.attr('data-animation') != 'none' ) {

                    $this.css('transition-delay', $delay + 'ms');

                    $this.addClass('do_animate');

                    if ( $this.hasClass("counterbox") || $this.hasClass("piechartbox") || $this.hasClass("progress_bar") ) {

                        //Run Counter Box Animation along left animations
                        if ( $this.hasClass("counterbox") ) {
                            self.counterBoxAnimate($this);
                        }

                        //Run Pie Chart  Animation along left animations
                        if ( $this.hasClass("piechartbox") ) {
                            self.pieChartAnimate($this);
                        }

                        //Run Progress bar  Animation along left animations
                        if ( $this.hasClass("progress_bar") ) {
                            self.progressBarAnimate($this);
                        }
                    }

                }

            }

            var aniamteShortcodesInSnapToScroll = function () {
                var $activeSlide = $('div.kt-section.visible'),
                    $inactiveSlide = $('div.kt-section').not('.visible');

                if (self.isMobile() || self.isTablet()) {
                    $shortcodes = $activeSlide.find('.shortcodeAnimation:not(.no-responsive-animation)');
				} else {
                    $shortcodes = $activeSlide.find('.shortcodeAnimation');
				}

                $shortcodes.each(function () {
                    var $shortcode = $(this);
                    animateShortcodes($shortcode);
                });

                $inactiveSlide.find('.shortcodeAnimation').removeClass("do_animate");
            }


            if ( !self.$body.hasClass('snap-to-scroll') || (self.$body.hasClass('snap-to-scroll') && self.windowWidth <= 1140 ) ) {

                if (self.isMobile() || self.isTablet()) {
                    $shortcodes = $('.shortcodeAnimation:not(.no-responsive-animation)');
				} else {
                    $shortcodes = $('.shortcodeAnimation');
				}

                $shortcodes.waypoint({
                    handler: function () {
                        var $item = $(this.element);
                        animateShortcodes($item);
                        this.destroy();
                    },
                    offset: '90%'
                });

            } else {
                self.$document.on('snap_to_scroll_slide_end', function () {
                    aniamteShortcodesInSnapToScroll();
                });
                aniamteShortcodesInSnapToScroll();
            }
        },

        /*-----------------------------------------------------------------------------------*/
        /*  toggle - FAQ
        /*-----------------------------------------------------------------------------------*/

        faq: function () {

            var $faqContainers = $('.toggle_wrap');

            if ( !$faqContainers.length ) { 
				return; 
			}

            $faqContainers.each(function () {
                var $container = $(this),
                    $titles = $container.find('.wpb_toggle'),
                    $contents = $container.find('.toggle_content_wrap');

                if ( $container.hasClass('wpb_toggle_open') ) {
                    $contents.slideDown();
                } else {
                    $contents.slideUp();
                }

                $titles.off("click").on('click', function (e) {
                    var $this = $(this);

                    $this.toggleClass('wpb_toggle_title_active');
                    var $parent = $this.parent()

                    $parent.toggleClass('wpb_toggle_open');

                    if ($parent.hasClass('wpb_toggle_open')) {
                        $parent.find('.toggle_content_wrap').slideDown();
                    } else {
                        $parent.find('.toggle_content_wrap').slideUp();

                    }
                });
            });
        },

        // Social links 
        socialLink: function () {
            if ($('.woocommercepage').length == 0 && $('.social_share_toggle').parents('div.product').length == 0) {
                $('.social_share_toggle').find('.social_links_list').addClass('opentoggle');
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*  socail share icon
        /*-----------------------------------------------------------------------------------*/

        socailshare: function () {
            // Google Plus like button
            var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
            po.src = 'https://apis.google.com/js/plusone.js';
            var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
        },

        /*-----------------------------------------------------------------------------------*/
        /*  social share's pop up 
        /*-----------------------------------------------------------------------------------*/

        socialSharePopup: function () {

            $(".social_links a, .socialshare-container a").click(function (e) {
                e.preventDefault();

                var $url = $(this).attr('href'),
                    $title = $(this).attr('title'),
                    newWindow = window.open($url, $title, 'height=300,width=600');

                if (window.focus) { 
                    newWindow.focus() 
                }
                return false;
            });
        },

        trapNavigationInModal: function( firstElementFocus = true ) {
            // add all the elements inside modal which you want to make focusable
            var  focusableElements =
            'button, [href], input:not([type="hidden"]), select, textarea, [tabindex]:not([tabindex="-1"])';
            var $modal = $('.search-form-cls, .responsive-whole-search-container, .togglesidebar.sidebar-menu'); // select the modal by it's id

            if ( !$modal.length ) {
                return;
            }

            var checkFocusedElement = function( e, $firstFocusableElement, $lastFocusableElement ) {
                var isTabPressed = e.key === 'Tab' || e.keyCode === 9;

                if (!isTabPressed) {
                    return;
                }

                if (e.shiftKey) { // if shift key pressed for shift + tab combination
                    if (document.activeElement === $firstFocusableElement) {
                        $lastFocusableElement.focus(); // add focus for the last focusable element
                        e.preventDefault();
                    }
                } else { // if tab key is pressed
                    if (document.activeElement === $lastFocusableElement ) { // if focused has reached to last focusable element then focus first focusable element after pressing tab
                        $firstFocusableElement.focus(); // add focus for the first focusable element
                        e.preventDefault();
                    }

                    if ( $(document.activeElement).parents('.searchcats').length ) {
                        $('.search-form-cls .searchcats li').removeClass('selected').removeClass('focus');
                        $(document.activeElement).parent('li').addClass('selected focus');
                    }
                }
            }

            $modal.each( function() {
                var $eachModal = $(this);
                var $focusableContent = $eachModal.find(focusableElements).filter(':visible');
                var $firstFocusableElement = $focusableContent.first()[0]; // get first element to be focused inside modal
                var $lastFocusableElement = $focusableContent.last()[0]; // get last element to be focused inside modal

                $eachModal.off( 'keydown' );
                $eachModal.keydown( function(e) {
                    checkFocusedElement( e, $firstFocusableElement, $lastFocusableElement )
                });
                if ( firstElementFocus && typeof $firstFocusableElement !== 'undefined' ) {
                    $firstFocusableElement.focus();
                }
            });
        },

    } );

} ).apply( this, [ window.kiteTheme, jQuery ] );


(function($){
    kiteTheme.documentHeight = kiteTheme.$document.height();
    kiteTheme.init();

    $(document).on( 'ready', function(){
        kiteTheme.onReady();
    });

    $(window).on( 'resize', function() {
        kiteTheme.updateDocHeight();
        kiteTheme.updateWinDimension();
        kiteTheme.minPageHeightSet();
        kiteTheme.nav();
        kiteTheme.checkHeader();
        kiteTheme.initSelectElements();
    })

    $(window).on('elementor/frontend/init', function () {

        // if (!elementorFrontend.isEditMode()) {
        //     return;
        // }


        $(window).on('load', function(){
            $(this).trigger('resize');
        });

        // elementorFrontend.hooks.addAction('frontend/element_ready/global', function ($scope) {
        //     if ($scope.find('.masonry-blog.isotope').length) {
        //         $(window).on('resize',function(){
        //             kiteTheme.kite_blogMasonry($scope);
        //         });
        //     }
        // });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-piechart.default', function ($scope) {
            kiteTheme.shortcodeAnimation( $scope );
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-image-carousel.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-products.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
            kiteTheme.lazyLoadOnHover($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-products-by-attribute.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
            kiteTheme.lazyLoadOnHover($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-hand-picked-products.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
            kiteTheme.lazyLoadOnHover($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-ajax-woocommerce-products.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
            kiteTheme.lazyLoadOnHover($scope);
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-product-categories.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
            kiteTheme.isotopeAnimation($scope);
            kiteTheme.shortcodeAnimation();
        });
        elementorFrontend.hooks.addAction('frontend/element_ready/kite-single-product.default', function ($scope) {
            kiteTheme.lazyLoadOnLoad($scope);
        });
    });
})( jQuery );