/*-----------------------------------------------------------------------------------*/
/*  productCards
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var productCards = {

        initProductCards: function () { 
            this.mobileHoverState();
            this.productQuickView();
            this.productHover();
            this.productsInfoOnClick();
            this.woocommerceVariationItemSelect();
            this.woocommerceButtonsOnHoverCartClick();
            this.buttonsAppearUnderHover();
            this.modernButtonsOnHoverQuantityHandler();
        },

        initProductCardsOnReady: function () {
            this.compare();
        },

        productCardsResizeEvent: function() {
            this.mobileHoverState();
        },

        mobileHoverState: function () {

            if ( this.windowWidth >= 768 ) {
                return;
            }

            if ( $('body').hasClass('responsive-hover-state-off') ) {
                $('div.products.infoonclick .product, div.products.infoonhover .product').on( 'click', function(e){
                    e.preventDefault();
                    var url = $(this).find( 'a > h3, a > h2').parent('a').attr('href');
                    if ( url != '' ) {
                        window.location.href = url;
                    }
                });
                return;
            }

            if (navigator.platform.match(/(iPhone|iPod|iPad)/i)) {
                var $eventListener = 'click mouseover';
            } else {
                var $eventListener = 'click';
            }

            $('.woocommerce div.products div.product * ').on($eventListener, function (event) {
                var $self = $(this);
                if (!$self.parents('div.product:not(.parent_div_product)').hasClass('hover-state')) {
                    event.preventDefault();
                    $('.woocommerce div.products div.product').each(function (index, el) {
                        if ($(this).hasClass('hover-state'))
                            $(this).removeClass('hover-state');
                    });
                    $self.parents('div.product:not(.parent_div_product)').addClass('hover-state');
                }
            });

            $(document).on('click touchstart', function (event) {
                if ($(event.target).closest('.hover-state').length == 0) {
                    $('.hover-state').removeClass('hover-state');
                }
            });

            // fix 2column show bug in you may also like carousel
            if ($('.related.carousel div.products').hasClass('column_res')) {
                $('.related.carousel div.products').removeClass('column_res');
            }
        },

        /*-----------------------------------------------------------------------------------*/
        /*  product  Quick view
        /*-----------------------------------------------------------------------------------*/

        productQuickView: function () {
            var self = this;

            var $quickViewModal = self.$document.find('#kt-modal'),
                $quickviewWrapper = $quickViewModal.find('.modal-content-wrapper'),
                $quickviewContent = $quickViewModal.find('#modal-content'),
                $quickviewNext = $quickViewModal.find('a[rel="next"]'),
                $quickviewPrev = $quickViewModal.find('a[rel="prev"]'),
                $items = $('div.products div.product');

            if ( $quickViewModal.length <= 0 || ! $('.quick-view-button').length ) {
                return;
            }

            $('.quick-view-button').on('click', function (e) {
                e.preventDefault();

                var $this = $(this),
                    $productID = $this.data('product_id');

                $this.closest('div.product:not(.parent_div_product)').addClass('qv-active');

                //put a delay to load images after css transitions
                setTimeout(function () {

                    // next and Prev Buttons - in Quick view
                    var $nextItem = $items.filter('.qv-active').next('div.product:not(.parent_div_product)'),
                        $prevItem = $items.filter('.qv-active').prev('div.product:not(.parent_div_product)');

                    if ( $nextItem.length <= 0 ) {
                        $nextItem = $items.eq(0);
                    }

                    if ( $prevItem.length <= 0 ) {
                        $prevItem = $items.eq($items.length - 1);
                    }

                    if ($this.closest('.products').find('div.product').length <= 1) {
                        $quickViewModal.addClass('hidden-nav');
                    }
                    else {
                        if ( self.windowWidth > 767 ) {
                            $quickviewNext.find('img').remove();
                            $quickviewPrev.find('img').remove();

                            var $nextImg = $nextItem.find('img').eq(0).clone(),
                                $prevImg = $prevItem.find('img').eq(0).clone();
                            $nextImg.insertAfter($quickviewNext.find('span'));
                            $prevImg.insertAfter($quickviewPrev.find('span'));
                        }
                    }

                }, 400);

                self.$body.addClass('modal-open'); // disable scrollbar
                $quickViewModal.addClass('quickview-modal');

                if ( !$quickViewModal.removeClass('closed').hasClass('open') ) {
                    $quickViewModal.removeClass('loading').addClass('open');
                }

                var ajaxUrl,
                    data = {
                        product_id: $productID
                    };
                // Use new WooCommerce endpoint URL if available
                if (typeof wc_add_to_cart_params !== 'undefined') {
                    ajaxUrl = wc_add_to_cart_params.wc_ajax_url.toString().replace('%%endpoint%%', 'load_quick_view'); // WooCommerce Ajax endpoint URL (available since 2.4)
                } else {
                    ajaxUrl = kite_theme_vars.ajax_url;
                    data['action'] = 'load_quick_view';
                }

                $.ajax({
                    url: ajaxUrl,
                    type: 'POST',
                    data: data,
                    dataType: 'html',
                    cache: false,
                    headers: { 'cache-control': 'no-cache' },
                    success: function (data) {
                        $quickviewContent.html(data);
                        $quickViewModal.addClass('shown'); // content is ready, so show it
                        $quickviewContent.find($('form.cart .yith-wcwl-add-to-wishlist')).remove();
                        setTimeout(function () {
                            self.productThumbnails($quickviewContent, true); // enable gallery slider of product
                        }, 200);

                        self.initSelectElements();
                        self.countdown();
                        self.productProgressBar();
                        self.productVariation();
                        self.woocommerceVariationAttributes(); // enable variation attributes
                        self.woocommerceVariationAttributesSelection();
                        self.woocommerceVariationAttributesTrigger(); // update image attributes
                        self.woocommerceVariationItemSelect(); // update image attributes
                        self.reInitVariation($quickviewContent); // Variation Form
                        self.addToCart(); // add to cart - open side bar add to cart
                        $quickviewContent.find($('a.compare')).on('click', function (e) {
                            setTimeout(function () {
                                $quickviewContent.html('');
                                $quickViewModal.removeClass('shown').removeClass('quickview-modal');
                            }, 0);
                            setTimeout(function () {
                                $quickViewModal.addClass('compare-modal');
                            }, 300);
                            self.compare();

                        });
                    }
                });
            });


            // Close quickview by click outside of content
            $quickViewModal.on('click', function (e) {
                if (!$quickviewWrapper.is(e.target) && $quickviewWrapper.has(e.target).length === 0 && !$quickviewNext.is(e.target) && $quickviewNext.has(e.target).length === 0 && !$quickviewPrev.is(e.target) && $quickviewPrev.has(e.target).length === 0) {
                    self.closeQuickView();
                }
            });

            // Close quickview by click close button
            self.$document.on('click', '#kt-modal.quickview-modal #modal-close', function (e) {
                e.preventDefault();
                self.closeQuickView();
            });

            // Close box with esc key
            self.$document.keyup(function (e) {
                if (e.keyCode === 27) {
                    self.closeQuickView();
                }
            });

            $quickviewNext.on('click', function (e) {
                e.preventDefault();
                var $nextItem = $items.filter('.qv-active').next('div.product:not(.parent_div_product)');
                if ($nextItem.length <= 0) {
                    $nextItem = $items.eq(0);
                }

                $quickViewModal.removeClass('shown');
                $items.filter('.qv-active').removeClass('qv-active');
                $nextItem.find('a.quick-view-button').trigger('click');
            });

            $quickviewPrev.on('click', function (e) {
                e.preventDefault();
                var $prevItem = $items.filter('.qv-active').prev('div.product:not(.parent_div_product)');
                if ($prevItem.length <= 0) {
                    $prevItem = $items.eq($items.length - 1);
                }

                $quickViewModal.removeClass('shown');
                $items.filter('.qv-active').removeClass('qv-active')
                $prevItem.find('a.quick-view-button').trigger('click');
            });
        },

        closeQuickView: function () {
            var self = this;

            var $quickViewModal = self.$document.find('#kt-modal.quickview-modal'),
                $quickviewContent = $quickViewModal.find('#modal-content');

            $quickViewModal.removeClass('shown loading open').addClass('closed');
            $('div.product.qv-active:not(.parent_div_product)').removeClass('qv-active');

            setTimeout(function () {
                self.$body.removeClass('modal-open');
                $quickViewModal.removeClass('quickview-modal');
            }, 300)

            setTimeout(function () {
                $quickviewContent.html('');
            }, 800);
        },

        /*-----------------------------------------------------------------------------------*/
        /*  product hover
        /*-----------------------------------------------------------------------------------*/

        productHover: function () {

            var $productAddToCart = $('div.products.grid_view div.product span.product-button');
            //check existance of woocommerce class (shop page or a normal page with shortcode)
            if ($('.woocommerce').length <= 0  || ! $productAddToCart.length ) {
                return;
            }

            $productAddToCart.each(function () {
                var $product = $(this).closest('div.product:not(.parent_div_product)');

                if ( !$product.hasClass('single-product-shortcode') ) {

                    //Hover effect
                    $(this).mouseenter(function () {
                        $product.addClass('add-to-cart-hovered');
                    });

                    //Exit hover state of the cart button when mouse leaves the buttons container
                    $(this).mouseleave(function () {
                        $product.removeClass('add-to-cart-hovered');
                    });

                }

            });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  product - Info on click style
        /*-----------------------------------------------------------------------------------*/

        productsInfoOnClick: function ( $infiniteScroll = false ) {
            var self = this;

            if ( !$('div.infoonclick').length ) {
                return;
            }

            var $container = !$infiniteScroll ? $('div.infoonclick div') : $infiniteScroll;

            // off the previous click events
            $container.find('span.show-hover').off('click');
            $container.find('a.product_variation_item').off('click');

            $container.find('span.show-hover').on('click', function () {
                var $productID = $(this).parents('div.product:not(.parent_div_product)').attr('data-productid'); //data product ID
                $productID = $('div.product:not(.parent_div_product)[data-productid =' + $productID + ']');
                $(this).parents('div.products').find($productID).find('span.show-hover').toggleClass('show').closest('div.product').toggleClass('show-hover-content');
            });
            $container.find('a.product_variation_item').on('click', function () {
                $container.find('.selectlabel,.colorlabel').removeClass('selected');
                $(this).closest('.selectlabel,.colorlabel').addClass('selected');

            });

        },

        /*----------------------------------------------------------------------------------*/
        /*  compare
        /*----------------------------------------------------------------------------------*/

        compare: function () {
            var self = this;

            var $compareModal = self.$document.find('#kt-modal'),
                $compareContent = $compareModal.find('#modal-content'),
                $compareWrapper = $compareModal.find('.modal-content-wrapper');

            $('.compare').on('click', function () {
                $compareModal.addClass('compare-modal open').removeClass('closed'); // content is ready, so show it
            });
            $(document).on('click', '.comparewrapper a.compareLink, .kt-compare .hd-btn-link', function (ev) {
                ev.preventDefault();
                $compareModal.addClass('compare-modal open').removeClass('closed'); // content is ready, so show it
                var tableUrl = this.href;

                if ( typeof tableUrl == 'undefined' ) {
                    return;
                } 
                $('body').trigger('yith_woocompare_open_popup', { response: tableUrl, button: $(this) });
            });

            // Close quickview by click outside of content
            $compareModal.on('click', function (e) {
                if ( !$compareModal.hasClass('compare-modal') ) {
                    return;
                }

                if ( !$compareWrapper.is(e.target) && $compareWrapper.has(e.target).length === 0 ) {
                    closeCompareModal();
                }
            });

            self.$document.on('click', '#kt-modal.compare-modal #modal-close', function (e) {
                e.preventDefault();
                closeCompareModal();
            });

            var closeCompareModal = function () {
                $compareModal.removeClass('shown loading open').addClass('closed');
                setTimeout(function () {
                    self.$body.removeClass('modal-open');
                    $compareModal.removeClass('compare-modal');
                }, 300)

                setTimeout(function () {
                    $compareContent.html('');
                }, 800);

                var $widgetList = $('.yith-woocompare-widget div.products-list'),
                    data = {
                        action: yith_woocompare.actionview,
                        context: 'frontend'
                    };

                if (typeof $.fn.block != 'undefined') {
                    $widgetList.block({ message: null, overlayCSS: { background: '#fff url(' + yith_woocompare.loader + ') no-repeat center', backgroundSize: '16px 16px', opacity: 0.6 } });
                }

                $.ajax({
                    type: 'post',
                    url: yith_woocompare.ajaxurl.toString().replace('%%endpoint%%', yith_woocompare.actionview),
                    data: data,
                    success: function (response) {
                        // add the product in the widget
                        if (typeof $.fn.block != 'undefined') {
                            $widgetList.unblock().html(response);
                        }
                        $widgetList.html(response);
                    }
                });
            }

            // open popup & Run yith_woocompare_open_popup handler
            self.$body.off('yith_woocompare_open_popup');
            self.$body.on('yith_woocompare_open_popup', function (e, data) {
                var url = data.response;

                self.$body.addClass('modal-open'); // Disable scrollbar

                $.post({
                    url: url + ' .compare-list',
                    cache: false,
                    headers: { 'cache-control': 'no-cache' },
                    success: function (response) {
                        $compareContent.html(response);
                        $compareModal.addClass('shown');
                        self.kiteScrollBar('table.compare-list tr.description td p:first-child ');
                    }
                });

            });

            self.$document.find('kt-modal.compare-modal tr.remove a').off('click');

            // remove from table
            self.$document.on('click', '#kt-modal.compare-modal tr.remove a', function (e) {
                e.preventDefault();

                $(this).addClass('norotate');

                var button = $(this),
                    data = {
                        action: yith_woocompare.actionremove,
                        id: button.data('product_id'),
                        context: 'frontend'
                    },
                    product_cell = $('td.product_' + data.id + ', th.product_' + data.id);

                // add ajax loader
                if (typeof $.fn.block != 'undefined') {
                    button.block({
                        message: null,
                        overlayCSS: {
                            background: '#fff url(' + yith_woocompare.loader + ') no-repeat center',
                            backgroundSize: '16px 16px',
                            opacity: 0.6
                        }
                    });
                }

                $.ajax({
                    type: 'post',
                    url: yith_woocompare.ajaxurl.toString().replace('%%endpoint%%', yith_woocompare.actionremove),
                    data: data,
                    dataType: 'html',
                    success: function (response) {

                        // in compare table
                        var table = $(response).filter('table.compare-list');
                        $('body  table.compare-list').replaceWith(table);

                        $('.compare[data-product_id="' + button.data('product_id') + '"]', window.parent.document).removeClass('added').html(yith_woocompare.button_text);

                        // removed trigger
                        self.$window.trigger('yith_woocompare_product_removed');
                    }
                });
            });


        },

        woocommerceVariationItemSelect: function () {

            var currencySymbol = $('.woocommerce-Price-currencySymbol:first').text();
            var simpleAddToCart = function ($productItem, buttonClass = false ) {
                var $cartButton = $productItem.find('div.addtocartbutton .addcartbutton,.product-buttons .product-button a, .modern-buttons-on-hover-cart-btn,.mobileAddToCart');
                if ( !$productItem.find('.simpleAddToCart').length ) {
                    $cartButton.after('<a href="" rel="nofollow" data-quantity="1" class="add_to_cart_button product_type_simple simpleAddToCart button" style="display:none"><span class="icon icon-cart"></span><span class="txt" data-hover="'+kite_theme_vars.add_to_cart+'">'+kite_theme_vars.add_to_cart+'</span></a>');
                    if ( ! buttonClass ) {
                        $('.simpleAddToCart').removeClass('button');
                    }
                    $('.simpleAddToCart').on('click', function () {
                        $(this).closest('div.product:not(.parent_div_product)').addClass('cartButtonClicked');
                    });
                }
            };
            $('.product_variation_item.info').on('click', function () {
                var $this = $(this),
                    $origImage = $(this).closest('div.product:not(.parent_div_product) ').find('div.imageswrap img'),
                    $hoverImage = $(this).closest('div.product:not(.parent_div_product) ').find('div.hover-image'),
                    buttonClass = $this.parents('.products').is('.modern-buttons-on-hover');

                simpleAddToCart($this.closest('div.product:not(.parent_div_product)'), buttonClass );
                $this.closest( 'div.product:not(.parent_div_product)').find('.product-quantity').removeClass('disable');

                $this.closest('div.product:not(.parent_div_product)').find('.add_to_cart_btn_wrap').addClass('is-loading');

                var $salePrice = $this.attr('data-sale-price');
                var $regPrice = $this.attr('data-regular-price');
                var dataImage = $this.attr('data-image');
                var dataSrcset = $this.attr('data-srcset');

                $('<img/>').attr('src', dataImage).on('load', function () {
                    $(this).remove(); // prevent memory leaks as @benweet suggested
                    $hoverImage.css('background', 'url(' + dataImage + ')');
                    $origImage.attr('src', dataImage);
                    $origImage.attr('srcset', dataSrcset);
                    $this.closest('div.product').find('.add_to_cart_btn_wrap').removeClass('is-loading');
                });

                if ($this.closest('div.product').find('.simpleprice').length == 0) {
                    $this.closest('div.product').find('.price').after('<span class="price simpleprice" style="display:none;"></span>');
                }
                if ($regPrice != '' && $salePrice != '') {
                    $this.closest('div.product:not(.parent_div_product) ').find('.simpleprice').html('<span class="woocs_price_code"><del><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">' + currencySymbol + '</span>' + $regPrice + '</span></del> <ins><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">' + currencySymbol + '</span>' + $salePrice + '</span></ins></span>');
                } else if ($regPrice != '') {
                    $this.closest('div.product:not(.parent_div_product) ').find('.simpleprice').html('<span class="woocs_price_code"><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">' + currencySymbol + '</span>' + $regPrice + '</span></span>');
                } else if ($salePrice != '') {
                    $this.closest('div.product:not(.parent_div_product) ').find('.simpleprice').html('<span class="woocs_price_code"><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">' + currencySymbol + '</span>' + $salePrice + '</span></span>');
                }

                $this.closest('div.product:not(.parent_div_product)').find('.price:not(.simpleprice)').attr('style', 'display: none !important');
                $this.closest('div.product:not(.parent_div_product)').find('.simpleprice').removeAttr('style');
                $this.closest('div.product:not(.parent_div_product)').find('.simpleAddToCart').removeAttr('style');
                $this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.addcartbutton:not(.simpleAddToCart), .product-button > a:not(.simpleAddToCart)').css('display', 'none');

                $this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.simpleAddToCart, .product-button > a.simpleAddToCart').removeData('product_id');
                $this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.simpleAddToCart, .product-button > a.simpleAddToCart').removeData('product_sku');
                $this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.simpleAddToCart, .product-button > a.simpleAddToCart').data('product_id', $(this).data('product_id'));
                $this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.simpleAddToCart, .product-button > a.simpleAddToCart').attr('data-product_id', $(this).data('product_id'));
                $this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.simpleAddToCart, .product-button > a.simpleAddToCart').data('product_sku', $(this).data('product_sku'));
                $this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.simpleAddToCart, .product-button > a.simpleAddToCart').attr('data-product_sku', $(this).data('product_sku'));
                $this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.simpleAddToCart, .product-button > a.simpleAddToCart').attr('href', $(this).data('cart-url'));

                if ($this.closest('div.product:not(.parent_div_product)').find('div.addtocartbutton a.addcartbutton, .variations').hasClass('ajax_enabled')) {
                    $this.closest('div.product:not(.parent_div_product)').find('.simpleAddToCart').addClass('ajax_add_to_cart');
                }
            });
            $('.variable_item,.variations .nice-select li').on('click', function () {
                $('form.variations_form').addClass('variation_clicked');

            });

        },
        infoonhoverAndClickAddedToCart: function ($variationItem) {
            if ($(window).width() < 768)
                return;
            if ($('.woocommerce .products.infoonhover').length || $('.woocommerce .products.infoonclick').length) {
                var $price = $variationItem.closest('div.product:not(.parent_div_product)').find('.price:not(.simpleprice)');
                var $onSale = $variationItem.closest('div.product:not(.parent_div_product)').find('.onsale');
                var $label = $variationItem.closest('div.product:not(.parent_div_product)').find('.custom_product_label');
                if ($variationItem.closest('div.products').hasClass('infoonhover') || $variationItem.closest('div.products').hasClass('infoonclick')) {
                    $variationItem.closest('div.product:not(.parent_div_product)').hover(function () {
                        $price.removeAttr('style');
                    }, function () {
                        $price.addClass('add-cart');
                    });
                }
                if ($variationItem.closest('div.products').hasClass('infoonclick')) {
                    $variationItem.closest('div.product:not(.parent_div_product)').toggleClass('show-hover-content');
                    $variationItem.closest('div.product:not(.parent_div_product)').find('.show-hover').toggleClass('show');
                }
                if ($onSale.length) {
                    $onSale.css('top', ($price.outerHeight() + 10) + 'px');
                    if ($label.length) {
                        $label.css('top', ($onSale.outerHeight() + $price.outerHeight() + 15) + 'px');
                    }
                }
                else if ($label.length) {
                    $label.css('top', ($price.outerHeight() + 10) + 'px');
                }

                if ($variationItem.closest('div.product:not(.parent_div_product)').hasClass('product-type-variable')) {
                    $variationItem.closest('div.product:not(.parent_div_product)').find('input[type="radio"]').prop('checked', false);
                }
            }
        },
        woocommerceButtonsOnHoverCartClick: function () {
            var $addToCartButton = $('.woocommerce div.products.buttonsonhover div.product .product-buttons .product-button a, .woocommerce div.products.instantshop div.product .instant_shop_button div.addtocartbutton a.addcartbutton');
            $addToCartButton.off('click');
            $addToCartButton.on('click', function (event) {
                if ($(this).closest('div.product:not(.parent_div_product)').find('.product-button, div.addtocartbutton,div.addtocartbutton a').hasClass('product_type_variable')) {
                    if ($(this).closest('div.product:not(.parent_div_product)').find('.simpleAddToCart').length == 0) {
                        $(this).after('<a href="" rel="nofollow" data-quantity="1" class="add_to_cart_button product_type_simple simpleAddToCart" style="display:none"><span class="icon"></span><span class="txt" data-hover="'+kite_theme_vars.add_to_cart+'">'+kite_theme_vars.add_to_cart+'</span></a>');
                    }
                    if ($(this).parents('div.products').hasClass('buttonsonhover')) {
                        $(this).closest('div.product:not(.parent_div_product)').find('.simpleAddToCart').addClass('button');
                    } else {
                        $(this).closest('div.product:not(.parent_div_product)').find('.simpleAddToCart').addClass('addcartbutton');
                    }
                }
            });
        },
        buttonsAppearUnderHover: function () {
            if ($('div.products.buttonsappearunder').parents('.woocommerce.carousel.wc-shortcode, .woocommerce .related.grid').length) {
                var heightOfCarousel = $('div.products.buttonsappearunder').parents('.woocommerce.carousel.wc-shortcode ').height();
                var heightOfGrid = $('div.products.buttonsappearunder').parents('.woocommerce .related.grid ').height();
                $('div.products.buttonsappearunder').parents('.woocommerce.carousel.wc-shortcode').css('height', heightOfCarousel);
                $('div.products.buttonsappearunder').css('height', heightOfCarousel);
                $('div.products.buttonsappearunder').parents('.woocommerce .related.grid').css('height', heightOfGrid + 20 + 'px');
            }
        },

        modernButtonsOnHoverQuantityHandler: function () {
            $(document).on('click', '.modern-buttons-on-hover .product-quantity > span:not(.product-button)', function(){
                var $this = $(this);
                var min = $this.siblings('.product-button').find('a').data('min-quantity'),
                    max = $this.siblings('.product-button').find('a').data('max-quantity');

                var currnetQuantity = parseInt( $this.siblings('input').val() );
                var newQuantity = 0;
                max = ( max == -1 || typeof max == 'undefined' ) ? Infinity : max;

                if ( $this.hasClass('plus') && currnetQuantity < max ) {
                    newQuantity = ++currnetQuantity;
                    $this.siblings('input').val( newQuantity );
                    $this.siblings('span.product-button').find('a').data( 'quantity', newQuantity );
                    $this.siblings('span.product-button').find('a').attr( 'data-quantity', newQuantity );
                }

                if ( $this.hasClass('minus') && currnetQuantity > min ) {
                    newQuantity = --currnetQuantity;
                    $this.siblings('input').val( newQuantity );
                    $this.siblings('span.product-button').find('a').data( 'quantity', newQuantity );
                    $this.siblings('span.product-button').find('a').attr( 'data-quantity', newQuantity );
                }
            });
        },

    };

    kiteTheme = Object.assign( kiteTheme, productCards );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($){
    kiteTheme.initProductCards();
    $(window).on( 'resize', function(){
        kiteTheme.productCardsResizeEvent();
    });
    $(document).ready(function () { 
        kiteTheme.initProductCardsOnReady();
    });
})( jQuery );