/*-----------------------------------------------------------------------------------*/
/*  shop
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var shop = {

        initShop: function() {
            this.layerNavAjaxDropDown();
            this.disablePriceSliderKeydownEvent();
            this.priceSliderFilter();
            this.woocommerceFilter();
            this.woocommerceActiveTag();
            this.woocommerceAjaxWrapper();
            this.searchBoxToggle();
            this.productsPagination();
            this.switchView();
            this.shopHeadCatResponsive();
            this.shopHeadCatDisplay();

            if ($('#main-content').length) {
                this.lazyLoadShopSkeletonStyle('#main-content, .togglesidebar');
            } else {
                this.lazyLoadShopSkeletonStyle('body > .wrap, .togglesidebar');
            }
        },

        /*-----------------------------------------------------------------------------------*/
        /* Filter drop down ( select ) functionality after ajax request
        /*-----------------------------------------------------------------------------------*/

        layerNavAjaxDropDown: function () {

            $('.dropdown_layered_nav').change(function () {

                var slug = $(this).val(),
                    filtername = $(this).closest('select').attr('data-filtername');

                var url = window.location.href; // get current url
                slug = '?filter_' + filtername + '=' + slug;
                url += slug;
                location.href = url;

            });

        },

        /*-----------------------------------------------------------------------------------*/
        /* price slider filter - woocommerce code without any changes this code use for Djax
        /*-----------------------------------------------------------------------------------*/
        disablePriceSliderKeydownEvent: function () {
            $(".widget_price_filter").on('click', function () {
                $(this).find('.ui-slider-handle').unbind('keydown');
            });

            $(document).on('price_slider_slide', function(){
                $('.price_slider_amount button').addClass('active');
            });

            $(document).on('woocommerce-content-updated', function(){
                $('.price_slider_amount button').removeClass('active');
            });
        },

        priceSliderFilter: function () {
            if ( !$('.woocommerce-page').length ) {
                return 0;
            }

            var priceSlider = function () {
                // Get markup ready for slider
                $('input#min_price, input#max_price').hide();
                $('.price_slider, .price_label').show();

                // Price slider uses jquery ui
                var min_price = $('.price_slider_amount #min_price').data('min'),
                    max_price = $('.price_slider_amount #max_price').data('max'),
                    current_min_price = parseInt(min_price, 10),
                    current_max_price = parseInt(max_price, 10);

                //this section modified by kiteSt
                if ( $('.price_slider_amount #min_price').val() ) {
                    current_min_price = parseInt($('.price_slider_amount #min_price').val(), 10);
                }
                if ( $('.price_slider_amount #max_price').val() ) {
                    current_max_price = parseInt($('.price_slider_amount #max_price').val(), 10);
                }
                //end section

                $(document.body).bind('price_slider_create price_slider_slide', function (event, min, max) {
                    if ( woocommerce_price_slider_params.currency_pos === 'left' ) {

                        $('.price_slider_amount span.from').html(woocommerce_price_slider_params.currency_symbol + min);
                        $('.price_slider_amount span.to').html(woocommerce_price_slider_params.currency_symbol + max);

                    } else if ( woocommerce_price_slider_params.currency_pos === 'left_space' ) {

                        $('.price_slider_amount span.from').html(woocommerce_price_slider_params.currency_symbol + ' ' + min);
                        $('.price_slider_amount span.to').html(woocommerce_price_slider_params.currency_symbol + ' ' + max);

                    } else if ( woocommerce_price_slider_params.currency_pos === 'right' ) {

                        $('.price_slider_amount span.from').html(min + woocommerce_price_slider_params.currency_symbol);
                        $('.price_slider_amount span.to').html(max + woocommerce_price_slider_params.currency_symbol);

                    } else if ( woocommerce_price_slider_params.currency_pos === 'right_space' ) {

                        $('.price_slider_amount span.from').html(min + ' ' + woocommerce_price_slider_params.currency_symbol);
                        $('.price_slider_amount span.to').html(max + ' ' + woocommerce_price_slider_params.currency_symbol);

                    }

                    $(document.body).trigger('price_slider_updated', [min, max]);
                });

                $('.price_slider').slider({
                    range: true,
                    animate: true,
                    min: min_price,
                    max: max_price,
                    values: [current_min_price, current_max_price],
                    create: function () {

                        $('.price_slider_amount #min_price').val(current_min_price);
                        $('.price_slider_amount #max_price').val(current_max_price);

                        $(document.body).trigger('price_slider_create', [current_min_price, current_max_price]);
                    },
                    slide: function (event, ui) {

                        $('input#min_price').val(ui.values[0]);
                        $('input#max_price').val(ui.values[1]);

                        $(document.body).trigger('price_slider_slide', [ui.values[0], ui.values[1]]);
                    },
                    change: function (event, ui) {

                        $(document.body).trigger('price_slider_change', [ui.values[0], ui.values[1]]);
                    }
                });
            }

            // woocommerce_price_slider_params is required to continue, ensure the object exists
            if (typeof woocommerce_price_slider_params === 'undefined') {
                return false;
            }

            if (typeof $.fn.slider != 'undefined') {
                priceSlider();
            } else {
                //Wait a bit to add scripts compelety to DOM and then run function
                setTimeout(function () {
                    if (typeof $.fn.slider != 'undefined') {
                        priceSlider();
                    }
                }, 1000)
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*  Update woocommerce content by ajax
        /*-----------------------------------------------------------------------------------*/

        woocommerceFilter: function () {
            var self = this;

            $('.shop-filter-toggle').on('click', function () {
                var $this = $(this),
                    $searchKeyword = $(".shop-filter .search-keyword");

                $this.toggleClass('open').removeClass('closed');
                $this.parents('.shop-filter').toggleClass('open');
                if ($this.parents('.shop-filter').find('.togglefilterscontainer').length == 0) {
                    $('.togglesidebar.filtersidebar').toggleClass('open');
                } else if ( $this.hasClass('open') ) {
                    $this.parents('.shop-filter').find('.togglefilterscontainer').slideDown();
                } else {
                    $this.parents('.shop-filter').find('.togglefilterscontainer').slideUp();
                }
                if ($this.parents('#mobile-header_secondstate').length) {
                    $('.shop-filter').toggleClass('open');
                    $('body').toggleClass('filtersOpened');
                }

                if ( self.windowWidth < 1025 ) {
                    if ($this.hasClass('open')) {
                        $('.shopFilterCategoriesBtn').addClass('closed')
                    } else {
                        $('.shopFilterCategoriesBtn').removeClass('closed')
                    }
                }

                // Search keyword
                if ( $this.hasClass('open') ) {
                    $searchKeyword.addClass('hide');
                    if ($this.parents('.shop-filter').find(".special-filter.cat").hasClass("opencat")) {
                        $this.parents('.shop-filter').find(".special-filter.cat").removeClass('opencat');
                        $this.siblings('.shopFilterCategoriesBtn').removeClass('opencat');
                    }
                } else {
                    $searchKeyword.removeClass('hide');
                }
            });

            $('#sidebar-open-overlay').on('click', function () {
                $('.shop-filter').removeClass('open');
            });

            if ( $('body:not(.always-open-expandable-filters) .shop-filter').length ) {
                $('.shop-filter').find('.togglefilterscontainer').css('display', 'none');
            }

            if ( self.windowWidth < 1025 ) {

                $('.shopFilterCategoriesBtn').on('click', function () {
                    var $this = $(this),
                        $searchKeyword = $(".shop-filter .search-keyword");

                    $this.toggleClass('opencat').removeClass('closed');
                    $this.parents('.shop-filter').find(".special-filter.cat").toggleClass('opencat');

                    if ($this.hasClass('opencat')) {
                        $('.shop-filter-toggle').addClass('closed')
                    } else {
                        $('.shop-filter-toggle').removeClass('closed')
                    }

                    // Search keyword
                    if ($this.hasClass('opencat')) {
                        $searchKeyword.addClass('hide');
                        if ($this.parents('.shop-filter').hasClass("open")) {
                            $this.parents('.shop-filter').removeClass('open');
                            $this.siblings('.shop-filter-toggle').removeClass('open');
                        }
                    } else {
                        $searchKeyword.removeClass('hide');
                    }
                });

                var closeFilterAndCat = function () {
                    $('.shop-filter').removeClass('open');
                    $('.shop-filter-toggle').removeClass('open closed');
                    $(".shop-filter .search-keyword").addClass('hide');
                    $('.shop-filter').find(".special-filter.cat").removeClass('opencat');
                    $('.shopFilterCategoriesBtn').removeClass('opencat closed');
                }

                self.$body.on('wc-content-updating', closeFilterAndCat);
                self.$document.on('click', '.woocommerce .shop-filter .special-filter.cat', closeFilterAndCat);


                if ( !$('.woocommerce .shop-filter .sidebar').length ) {
                    var wcCloseSidebar = function () {
                        $('.woocommerce .wc-sidebar-btn').removeClass('active').siblings('.sidebar').removeClass('show');
                    }

                    self.$body.on('wc-content-updating', wcCloseSidebar);

                    self.$document.on('click', '.woocommerce .wc-sidebar-btn', function () {
                        var $this = $(this);

                        if (!$this.hasClass('active')) {
                            $this.siblings('.sidebar').addClass('show');
                        } else {
                            $this.siblings('.sidebar').removeClass('show');
                        }

                        $this.toggleClass('active');
                    });
                }


                self.woocommerceFilterResponsive();
            }

            $(document).on('click', '.search-inputwrapper .searchinput,#mobile-header_secondstate .allcats', function () {
                if ($('.shop-filter-toggle.mobile-filter').hasClass('open')) {
                    $('.shop-filter-toggle.mobile-filter').toggleClass('open');
                    $('.shop-filter-toggle:not(.mobile-filter)').siblings('.shop-filter').toggleClass('open');
                }

            });

        },

        woocommerceFilterResponsive: function () {
            var self = this,
                $shopFilterSidebar = $('.woocommerce .shop-filter .sidebar'),
                $shopSidebar = $('#woocommerce-sidebar .sidebar');

            if ( self.windowWidth > 1140 || ( ! $shopFilterSidebar.length && ! $shopSidebar.length ) ) {
                return;
            }

            $shopSidebar = $('#woocommerce-sidebar .sidebar').html();
            if ( $shopFilterSidebar.length && $('.navicons.filters').length ) {
                $shopFilterSidebar.append($shopSidebar);
                $shopFilterSidebar.parent('.togglefilterscontainer').removeClass('no-widgets');
                $shopFilterSidebar.prepend($('.woocommerce .shop-filter .special-filter .widget.widget_on_sale_filter'));
                $shopFilterSidebar.prepend($('.woocommerce .shop-filter .special-filter .widget.widget_in_stock_filter'));
                self.showMoreTag();
            }
        },


        goToTopShop: function () {
            var self = this;
            setTimeout(function () {
                self.scrollTo('.woocommercepage.kt_shop_page .row', 1, 400);
            }, 500)

        },

        /*----------------------------------------------------------------------------------*/
        /*  Update woocommerce content by ajax
        /*-----------------------------------------------------------------------------------*/


        //Activate tag on page refresh
        woocommerceActiveTag: function () {
            var url = window.location.href;
            $('.widget.woocommerce.widget_product_tag_cloud a[href="' + url + '"]').addClass('current-cat');

        },

        woocommerceAjaxWrapper: function () {
            var self = this;

            if ( !self.$body.hasClass('woocommerce') || self.$body.hasClass('single-product') ) {
                return;
            }

            var isActiveAjaxRequest = function () {
                if ( xhr && xhr.readyState != 4 ) {
                    return true;
                }

                return false;
            }

            var hideWrapperLoading = function () {
                $('.wc-ajax-content').css('opacity', 1);
                $('.wc-ajax-wrapper > .wc-loading').addClass('hide');
            }

            var showWrapperLoading = function () {
                $('.wc-ajax-content').css('opacity', 0);
                $('.wc-ajax-wrapper > .wc-loading').removeClass('hide');
            }

            var displayBottomFilters = function (opacity) {
                var $currentActiveFilters = $('.widget.widget_layered_nav_filters'),
                    $resultCount = $('.woocommerce-result-count');

                $currentActiveFilters.add($resultCount).css('opacity', opacity);
            }

            var updateWidgets = function ($response) {
                //Update search form
                var form = $response.find('form.woocommerce-product-search');
                $('form.woocommerce-product-search').attr('data-type', form.attr('data-type')).attr('action', form.attr('action'));


                //Update search keyword
                var $searchKeyword = $response.find('.search-keyword a');
                if ( $searchKeyword.length > 0 ) {
                    $('.search-keyword').html($searchKeyword).removeClass('hide').addClass('show');
                } else {
                    $('.search-keyword').removeClass('show');
                }

                var $shopFilter = $response.find('.shop-filter'),
                    $resultCount = $response.find('p.woocommerce-result-count'),
                    $resOrdering = $response.find('.woocommerce-ordering select'),
                    $resShopFilters = $response.find('.shop-filter .widget-area'),
                    $resSidebarFilters = $response.find('.toggle-sidebar-container.filtersidebar'),
                    $resShopCats = $response.find('#shop-filter-cat'),
                    $resShopSidebar = $response.find('#woocommerce-sidebar'),
                    $resShopFilterBarSort = $response.find('.shop-filter .special-filter.sort'),
                    $resShopBottomFilters = $response.find('.shop-filter .bottompartfilter'),
                    $mobileActiveFilters = $response.find('.mobileactivefilters');

                //Wait .2s to complete animations
                setTimeout(function () {
                    if ( $shopFilter.length <= 0 ) {
                        $('.shop-filter, .shop-filter-toggle').addClass('hidden');
                    } else {
                        $('.shop-filter, .shop-filter-toggle').removeClass('hidden');
                    }

                    if ( $resShopCats.length > 0 ) {
                        $('#shop-filter-cat').html($resShopCats.html());
                    }


                    $('.shop-filter .widget-area').html($resShopFilters.html());
                    $('.toggle-sidebar-container.filtersidebar').html($resSidebarFilters.html());
                    $('.shop-filter .special-filter.sort').html($resShopFilterBarSort.html());

                    // Update filters in shop with filter
                    if ( self.windowWidth < 1025 ) {
                        $('.woocommerce-sidebar .sidebar.widget-area').html($resShopSidebar.html()); // In Responsive devices
                        $('.woocommerce .shop-filter .sidebar').append($resShopSidebar.html());
                    } else {
                        $('#woocommerce-sidebar').html($resShopSidebar.html());
                    }

                    $('.woocommerce-result-count').html($resultCount.html());
                    $('.woocommerce-ordering select').html($resOrdering.html());
                    $('.shop-filter .bottompartfilter').html($resShopBottomFilters.html());
                    $('.mobileactivefilters').html($mobileActiveFilters.html());
                    self.catWidgetUpdate();
                    self.showMoreTag();

                    setTimeout(function () {
                        self.disablePriceSliderKeydownEvent();
                        self.priceSliderFilter();
                        displayBottomFilters(1);
                        // self.woocommerceFilterResponsive();
                        self.shopHeadCatDisplay();
                        self.initSelectElements('update');
                        self.layerNavAjaxDropDown();
                        self.catWidget();
                    }, 100);
                }, 200);

            }

            var updateContent = function ($response, categoryChanged) {
                var $newBlock = $response.find('.wc-ajax-content'),
                    $newCategoryHeader = $response.find('#header'),
                    $newCategoryHeaderStyle = $newCategoryHeader.prev('style'),
                    $currentCategoryHeader = $('#header'),
                    $currentCategoryHeaderStyle = $currentCategoryHeader.prev('style'),
                    $newTopSpaceClasses = $response.find('#main-content').attr("class"); // get new top space classes

                if ( $newBlock.length > 0 ) {
                    $('.wc-ajax-content').html($newBlock.html());
                } else {
                    $newBlock = $response.find('.woocommerce-info').addClass('no-match');
                    $('.wc-ajax-content').html($newBlock);
                }

                //update category header and top space classes
                if ( categoryChanged ) {
                    if ( $newCategoryHeader.length > 0 ) {
                        if ($currentCategoryHeader.length > 0) {

                            $currentCategoryHeaderStyle.replaceWith($newCategoryHeaderStyle);
                            $currentCategoryHeader.after($newCategoryHeader.addClass('hide'));
                            //wait a bit to add content to DOM completely
                            setTimeout(function () {
                                $newCategoryHeader.removeClass('hide');
                            }, 100);
                            //wait a bit to animate completely
                            setTimeout(function () {
                                $currentCategoryHeader.remove();
                            }, 400);

                        } else {
                            $('#pageheight').before($newCategoryHeaderStyle);
                            $('#pageheight').before($newCategoryHeader.addClass('hidecompletly'));
                            //wait a bit to add content to DOM completely
                            setTimeout(function () {
                                $newCategoryHeader.removeClass('hidecompletly');
                            }, 200);
                        }

                    } else {
                        $currentCategoryHeader.addClass('hidecompletly');
                        setTimeout(function () {
                            $currentCategoryHeader.remove();
                            $currentCategoryHeaderStyle.remove();
                        }, 300);
                    }

                    // Replace New top Space classes
                    if ($newTopSpaceClasses.length > 0) {
                        $('#main-content').addClass($newTopSpaceClasses);
                    }
                }

                //wait a bit to add content to DOM completely
                setTimeout(function () {
                    self.runIsotopeInProducts();
                    self.productsInfoOnClick();
                    self.lazyLoadOnLoad('#main-content');
                    self.lazyLoadOnHover();
                    self.productHover();
                    self.productQuickView();
                    self.productsPagination();

                }, 50);

            }

            //Helper function to get content by url
            //is_search is a flag to show search results
            var getWoocommerceContent = function (pageUrl, categoryChanged) {

                //Prevent from multiple ajax requests
                if (isActiveAjaxRequest()) {
                    xhr.abort();
                }

                self.abortImageLoading();

                if ( pageUrl ) {

                    self.$body.trigger('wc-content-updating');

                    if ( self.windowWidth <= 1140 ) {
                        self.goToTopShop();
                    }

                    showWrapperLoading();

                    displayBottomFilters(0);

                    if ( $('.product_per_page_filter').length ) {
                        $('.product_per_page_filter .num').each(function (index, el) {
                            if ($(this).hasClass('selected')) {
                                pageUrl = self.updateQueryStringParameter(pageUrl, 'per-page', $(this).data('num'));
                            }
                        });
                    }

                    // Make sure the URL has a trailing-slash before query args (fix 301 redirect)
                    pageUrl = pageUrl.replace(/\/?(\?|#|$)/, '/$1');

                    //Update history of browser ( for browser next/prev button)
                    window.history.pushState({ 'url': pageUrl, 'title': '' }, '', pageUrl);

                    xhr = $.ajax({
                        url: pageUrl,
                        dataType: 'html',
                        data: { ajax_shop_req: true },
                        cache: false,
                        headers: { 'cache-control': 'no-cache' },
                        method: 'POST',
                    }).done(function (response) {
                        // Update shop content
                        var $response = $(response);
                        updateContent($response, categoryChanged);
                        updateWidgets($response);

                        hideWrapperLoading();
                        self.runIsotopeInProducts();
                        self.lazyLoadOnLoad('.woocommerce .products');
                        self.lazyLoadOnHover($(response));
                        self.compare();
                        self.woocommerceVariationItemSelect();
                        self.woocommerceButtonsOnHoverCartClick();
                        self.mobileHoverState();
                        $('body').trigger( 'woocommerce-content-updated' );
                    });
                }
            };

            self.woocommerceActiveTag();

            var xhr;//xmlHttpRequest

            //Woocommerce pagination + woocommerce back-to-shop link
            self.$document.on('click', '.wc-ajax-content:not(.disable_pagination) nav.woocommerce-pagination li a, .back-to-shop', function (e) {
                // This will prevent event triggering more then once
                if ( e.handled !== true ) {
                    e.handled = true;
                    e.preventDefault();
                    self.goToTopShop();

                    $('.shop-filter .search-box').removeClass('open');
                    $('.shop-filter .search-box').siblings('.filter-search-form-container').removeClass('open');
                    $('.shop-filter .search-box').siblings('.special-filter.cat').removeClass('hide');
                    $('.shop-filter .search-box').siblings('.special-filter.sort').removeClass('hide');

                    if ( !$('.shop-filter .search-box').hasClass('open') ) {
                        $(".shop-filter .search-hint").addClass('hide');
                    }
                    $('.filter-search-form-container form').removeClass('start_search');
                    $('.filter-search-form-container form input').val('');

                    getWoocommerceContent($(this).attr('href'), false);
                }
            });

            //Woocommerce Layered nav + Layered nav filter (filter by and active filters widgets) + on sale filter + in stock filter + sorting filter
            self.$document.on('click', '.special-filter.sort li a,.widget_layered_nav li a, .widget_layered_nav_filters li a,.on-sale-filter a,.in-stock-filter a,.clearfilters a', function (e) {
                // This will prevent event triggering more then once
                if ( e.handled !== true ) {
                    e.handled = true;
                    e.preventDefault();

                    if ( !isActiveAjaxRequest() ) {
                        $(this).closest('li').addClass('pending');
                    } else {
                        $(this).closest('ul').find('.pending').removeClass('pending').toggleClass('chosen');
                    }

                    $(this).closest('li').toggleClass('chosen');
                    getWoocommerceContent($(this).attr('href'));
                }
            });
            self.$document.on('click', '#kt-modal.sort-modal ul.list li a', function (event) {
                event.preventDefault();
                getWoocommerceContent($(this).attr('href'));
                self.closeSortPopup();
            });
            //Woocommerce rating filter
            self.$document.on('click', '.widget_rating_filter li a', function (e) {
                // This will prevent event triggering more then once
                if (e.handled !== true) {

                    e.handled = true;
                    e.preventDefault();
                    if ($(this).closest('ul').find('li.chosen').is($(this).closest('li'))) {
                        $(this).closest('li').toggleClass('chosen');
                    } else {
                        $(this).closest('li').toggleClass('chosen');
                    }

                    getWoocommerceContent($(this).attr('href'));
                }

            });

            //Woocommerce ranged price filter, sorting widget
            self.$document.on('click', '.widget_ranged_price_filter li a,.widget_order_by_filter li a', function (e) {
                // This will prevent event triggering more then once
                if (e.handled !== true) {

                    e.handled = true;
                    e.preventDefault();
                    $(this).closest('ul').find('li.current').removeClass('current');
                    $(this).closest('li').toggleClass('current');
                    getWoocommerceContent($(this).attr('href'));
                }

            });

            //Woocommerce tag cloud widget
            self.$document.on('click', '.widget.woocommerce.widget_product_tag_cloud a', function (e) {
                // This will prevent event triggering more then once
                if (e.handled !== true) {

                    e.handled = true;
                    e.preventDefault();
                    $(this).closest('.tagcloud').find('.current-tag').removeClass('current-tag');
                    $(this).addClass('current-tag');
                    getWoocommerceContent($(this).attr('href'));
                }

            });

            //Woocommerce categories
            self.$document.on('click', '.widget_product_categories li a', function (e) {

                // When shop page is set to show just categories or subcategories - filter ajax not work
                if ($(this).parents('.shop_is_categories_style').length) {
                    return;
                }

                // This will prevent event triggering more then once
                if (e.handled !== true) {

                    e.handled = true;
                    e.preventDefault();
                    $(this).closest('.widget_product_categories').find('.current-cat').removeClass('current-cat');
                    $(this).closest('li').addClass('current-cat');
                    getWoocommerceContent($(this).attr('href'), true);
                    $('body').on( 'woocommerce-content-updated', function() {
                        if ( ! $('body').hasClass('categories-scroll-animation') ) {
                            return;
                        }
                        var topOffset = $('.wc-ajax-content').length ? $('.wc-ajax-content').offset().top : $('#main-content').offset().top ;
                        $('html, body').animate(
                            {
                              scrollTop: topOffset - 80,
                            },
                            'slow',
                            'linear'
                        );
                    });
                }

            });

            //Woocommerce categories
            self.$document.on('select2-open', '.widget_product_categories .dropdown_product_cat:not(.change_event_removed)', function (e) {
                $(this).addClass('change_event_removed');
                $('.dropdown_product_cat').unbind('change');
            });
            self.$document.on('change', '.widget_product_categories select', function (e) {
                // This will prevent event triggering more then once
                if (e.handled !== true) {

                    e.handled = true;
                    var selected = $(this).find('option:selected').val(),
                        url,
                        homeUrl = kite_theme_vars.home_url;

                    if ( homeUrl.indexOf('?') > 0 ) {
                        url = homeUrl + '&product_cat=' + selected;
                    } else {
                        url = homeUrl + '?product_cat=' + selected;
                    }

                    getWoocommerceContent(url, true);
                }

            });

            //Woocommerce price filter
            self.$document.on('click', '.widget_price_filter button.button', function (e) {
                // This will prevent event triggering more then once
                if (e.handled !== true) {

                    e.handled = true;
                    e.preventDefault();

                    var url = window.location.href,
                        minPrice = $(this).siblings('#min_price').val(),
                        maxPrice = $(this).siblings('#max_price').val();

                    //Update/add min_price and max_price
                    url = self.updateQueryStringParameter(url, 'min_price', minPrice);
                    url = self.updateQueryStringParameter(url, 'max_price', maxPrice);

                    getWoocommerceContent(url);
                }

            });
            //switch view
            if ( $('.products.woocommerce').hasClass('list_view') ) {
                $('.views_button.list').addClass('active');
            } else {
                $('.views_button.grid').addClass('active');
            }
            var $viewsButton = $(".views_button");

            $viewsButton.click(function (e) {
                e.preventDefault();
                let $thisItem = $(this),
                    url = window.location.href,
                    $shopContainer = $(".products.woocommerce");

                $viewsButton.removeClass("active");
                $thisItem.addClass("active");

                if ($thisItem.hasClass('grid') && $shopContainer.hasClass('list_view')) {

                    url = self.updateQueryStringParameter(url, 'view', 'grid');
                    getWoocommerceContent(url);
                } else if ( $thisItem.hasClass('list') && $shopContainer.hasClass('grid_view') ) {
                    url = self.updateQueryStringParameter(url, 'view', 'list');
                    getWoocommerceContent(url);
                }

            });

            //Woocommerce per page filter
            self.$document.on('click', '.product_per_page_filter .num', function (e) {
                // This will prevent event triggering more then once
                if ( e.handled !== true ) {
                    e.handled = true;
                    e.preventDefault();
                    if ( $(this).hasClass('selected') ) {
                        return;
                    }
                    var url = window.location.href,
                        perPage = $(this).data('num'),
                        $this = $(this);

                    $('.product_per_page_filter .num').each(function (index, el) {
                        if ( $(this).is($this) ) {
                            $(this).addClass('selected');
                        } else {
                            $(this).removeClass('selected');
                        }
                    });
                    //Update/add min_price and max_price
                    url = self.updateQueryStringParameter(url, 'per-page', perPage);

                    getWoocommerceContent(url);
                }

            });

            //Woocommerce sort
            //Unbind previous function and bind new function to orderby select
            $('.woocommerce-ordering').off('change', 'select.orderby');
            $('.woocommerce-ordering').on('change', 'select.orderby', function () {

                var selected = $(this).find('option:selected').val();
                var url = window.location.href;

                //Update/add orderby
                url = self.updateQueryStringParameter(url, 'orderby', selected);

                getWoocommerceContent(url);

            });

            //Woocommerce search
            self.$document.find("form.woocommerce-product-search").each(function () {
                var $this = $(this);
                $this.submit(function (e) {
                    e.preventDefault();
                    $this.addClass('start_search');
                    var keyword = $this.find('input.search-field').val();
                    if ( keyword != '' ) {
                        //Hide virtual keyboard in mobiles
                        $this.find('input.search-field').blur();

                        var url = $this.attr('action');
                        //Update/add orderby
                        url = self.updateQueryStringParameter(url, 's', keyword);
                        //Do not add post_type to URL if this form is in category page
                        if ($this.attr('data-type') != 'category') {
                            url = self.updateQueryStringParameter(url, 'post_type', 'product');
                        }
                        getWoocommerceContent(url);
                    }
                });
            });
            self.$document.find('form.woocommerce-product-search .cross_close_link').on('click', function (event) {
                event.preventDefault();
                var $url = $(this).attr('href');
                $(this).parents('form.woocommerce-product-search').removeClass('start_search');

                $('.shop-filter .search-box').removeClass('open');
                $('.shop-filter .search-box').siblings('.filter-search-form-container').removeClass('open');
                $('.shop-filter .search-box').siblings('.special-filter.cat').removeClass('hide');
                $('.shop-filter .search-box').siblings('.special-filter.sort').removeClass('hide');
                $('.shop-filter .search-box').siblings('#switch_view_buttons').removeClass('hide');
                $('.shop-filter .search-box').siblings('.product_per_page_filter').removeClass('hide');

                if (!$('.shop-filter .search-box').hasClass('open')) {
                    $(".shop-filter .search-hint").addClass('hide');
                }

                $(this).siblings('input').val('');
                getWoocommerceContent($url);
            });

            // remove search keyword and Update Product
            self.$document.on("click", ".shop-filter .search-keyword a", function (e) {
                // This will prevent event triggering more then once
                if (e.handled !== true) {

                    e.handled = true;
                    e.preventDefault();
                    $(this).closest('.search-keyword').toggleClass('show');
                    $('.special_layered_nav_filters').find('.search-keyword-active').removeClass('chosen');
                    getWoocommerceContent($(this).attr('href'));
                }
            });

            // Search Hint [ Press "Enter" to search ]
            self.$document.on("keyup", ".shop-filter .filter-search-form-container input[type='search']", function (e) {
                var len = $(this).val().length,
                    $searchHint = $(".shop-filter .search-hint");
                if ( len >= 2 ) {
                    $searchHint.removeClass('hide')
                } else {
                    $searchHint.addClass('hide')
                }
            }).on("keydown", ".shop-filter .filter-search-form-container input[type='search']", function (e) {
                if ( e.which === 13 && $(this).val() != '' ) {
                    setTimeout(function () {
                        $(".shop-filter .search-hint").addClass('hide');
                        $(".shop-filter .search-keyword").removeClass('show');
                    }, 300)
                }
            });
        },

        searchBoxToggle: function () {
            var self = this;

            $(".shop-filter .search-box").on("click", function (e) {
                $(this).toggleClass('open');
                $(this).siblings('.filter-search-form-container').toggleClass('open');
                $(this).siblings('.special-filter.cat').toggleClass('hide');
                $(this).siblings('.special-filter.sort').toggleClass('hide');
                $(this).siblings('#switch_view_buttons').toggleClass('hide');
                $(this).siblings('.product_per_page_filter').toggleClass('hide');

                //only run on tablet and mobiles
                if (self.windowWidth < 1025 && $('.shop-filter-toggle').hasClass('open')) {
                    $(this).parent('.shop-filter').toggleClass('open');
                }

                if (!$('.shop-filter .search-box').hasClass('open')) {
                    $(".shop-filter .search-hint").addClass('hide');
                }
                $('.filter-search-form-container #woocommerce-product-search-field').focus();

            });
        },

        // shop pagination
        productsPagination: function () {
            var self = this,
                $shopContainer = $(".woocommercepage"),
                $productsContainer = $(".woocommercepage .woocommerce.products"),
                $productsPagination = $('.woocommerce-pagination li a.next'),
                $mainContainer = self.$body,
                loadMoreText = $productsContainer.data('lm-text'),
                layoutMode = $productsContainer.data('layoutmode');

                if ( ! $productsContainer.length ) {
                    return;
                }
                $productsContainer.each(function(){
                    if ( ! $(this).find('div.product').hasClass('product-category') ) {

                        if ($productsPagination.length > 0) {
                            $(this).after("<div class='page-load-status'></div>");
                            var $loadStatus = $(".page-load-status");
                        }

                        if ($shopContainer.hasClass('infinite_scroll')) {
                            var $paginationMethod = "infinite_scroll";
                        } else if ($shopContainer.hasClass('load_more')) {
                            if ( $loadStatus ) {
                                $loadStatus.append("<button class='view-more-button'>" + loadMoreText + "</button>");
                            }
                            var $paginationMethod = "load_more";
                        } else {
                            var $paginationMethod = "pagination";
                        }

                        if ( $paginationMethod != 'pagination' && $productsPagination.length > 0 ) {

                            var $container = $(this).infiniteScroll({
                                path: '.woocommerce-pagination li a.next',
                                append: '.main-shop-loop .product',
                                checkLastPage: true,
                                status: '.page-load-status',
                                hideNav: '.woocommerce-pagination',
                                button: '.view-more-button',
                                history: 'replace',
                                debug: false,
                            });

                            if ($paginationMethod == 'load_more') {
                                $container.infiniteScroll('option', {
                                    scrollThreshold: false,
                                    loadOnScroll: false,
                                });
                            }

                            var $grid = $container.imagesLoaded(function () {
                                $grid.isotope({
                                    itemSelector: '.product',
                                    layoutMode: layoutMode,
                                    originLeft: ( ! $('body').hasClass('rtl') )
                                });
                            });

                            $grid.on('request.infiniteScroll', function (event, path) {

                                if ($paginationMethod == 'infinite_scroll') {
                                    $loadStatus.addClass('loading-next-page');
                                }

                                if ($paginationMethod == "load_more") {
                                    $loadStatus.addClass('teta-loading-next-page');
                                }

                            });
                            $grid.on('append.infiniteScroll', function (event, response, path, items) {

                                $grid.find('.product').addClass('isotope-item');
                                self.runIsotopeInProducts($mainContainer);

                                for (var index =0; index < items.length; index++) {
                                    items[index].classList.add('appended-item');
                                }

                                var $items = $('.appended-item');
                                $grid.append($items).isotope('appended', $items);

                                self.lazyLoadOnLoad($items);
                                self.lazyLoadOnHover();
                                self.buttonsAppearUnderHover($items);
                                self.productsInfoOnClick($items);
                                self.woocommerceVariationItemSelect($items);
                                
                                for (var index = 0; index < items.length; index++) {
                                    items[index].classList.remove('appended-item');
                                }

                                $loadStatus.removeClass('loading-next-page');
                                $loadStatus.removeClass('teta-loading-next-page');

                                if ($paginationMethod == 'load_more') {
                                    $loadStatus.css('display', 'block');
                                    $loadStatus.find('.view-more-button').css('visibility', 'visible');
                                }
                                self.productQuickView();
                                self.compare();
                                self.woocommerceButtonsOnHoverCartClick();
                                self.woocommerceVariationItemSelect();

                            });

                            $grid.on('last.infiniteScroll', function (event, response, path) {
                                $loadStatus.remove();
                            });
                        }
                    }
                });
        },

        //switch view
        switchView: function () {
            var self = this;
            var $shopFilter = $('.woocommercepage .shop-filter');

            self.kiteScrollBar('div.products.list_view .wrap_after_thumbnail .product__decription');

            if ( $shopFilter.hasClass('no-categories-filter') ) {
                $('.woocommerce .shop-filter .filter-search-form-container').css('border-radius', '50px');
                $('.search-box').click(function () {
                    if ( $(this).hasClass('open') ) {
                        $('.woocommerce .shop-filter .filter-search-form-container.open').css('width', 'calc(100% - 310px)');
                    } else {
                        $('.woocommerce .shop-filter .filter-search-form-container').css('width', '0');
                    }
                });

            }
        },

        shopHeadCatResponsive: function () {
            $('.responsive_cat_icon').on('click', function () {
                $(this).parents('.header_cats').toggleClass('show');
            });
        },
        shopHeadCatDisplay: function () {
            var $headerContent = $('#header.shoppage #header-content');
            if ( $(window).width() <= 1140 ) {
                $headerContent.parents('#header').css({
                    'background-image': 'none',
                    'transition': 'none',
                });
            }

        },

        lazyLoadShopSkeletonStyle: function (that) {
            var self = this,
                xhr = null;
            let $thatContainers = typeof that == 'string' ? document.querySelectorAll(that) : that.get();

            var lazy_load_callback = (entries) => {
                entries.forEach( entry => {
                    if ( entry.isIntersecting ) {
                        let $this = entry.target;

                        if ($this.classList.contains('skeleton') && !$this.classList.contains('request-sent') && $this.classList.contains('main-shop-loop')) {
                            $this.classList.add('request-sent');
                            var data = {
                                ajax_shop_req: true,
                                context: 'frontend'
                            };
                            xhr = $.ajax({
                                url: window.location.href,
                                type: 'POST',
                                dataType: 'html',
                                data: data,
                            }).done(function (response) {
                                var $newBlock = $(response).find('.wc-ajax-content');

                                if ( $newBlock.length > 0 ) {
                                    $('.wc-ajax-content').html($newBlock.html());
                                } else {
                                    $newBlock = $response.find('.woocommerce-info').addClass('no-match');
                                    $('.wc-ajax-content').html($newBlock);
                                }

                                self.productsPagination();
                                self.runIsotopeInProducts();
                                self.lazyLoadOnLoad('.woocommerce .products')
                                self.lazyLoadOnHover($(response));
                                self.compare();
                                self.woocommerceVariationItemSelect();
                                self.woocommerceButtonsOnHoverCartClick();
                                self.mobileHoverState();
                                self.productsInfoOnClick();
                                self.productQuickView();
                                $('body').trigger('woocommerce-content-updated');
                                $(document).trigger('kite_ajax_products_loaded');
                                
                            }).fail(function (response) {
                                $this.classList.remove('request-sent');
                            }).always(function () {

                            });
                        }
                    }
                })
            }

            let options = {
                root: null,
                rootMargin: '0px',
                threshold: 0
            }

            $thatContainers.forEach( $container => {
                let $lazyLoadCntainers = $container.querySelectorAll('.products.skeleton');
                if ($lazyLoadCntainers.length > 0) {

                    let observer = new IntersectionObserver( lazy_load_callback, options);
                    $lazyLoadCntainers.forEach( $lazyLoadElement => {
                        observer.observe( $lazyLoadElement );
                    })
                }
            })
        }
    };

    kiteTheme = Object.assign( kiteTheme, shop );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($){
    kiteTheme.initShop();
})(jQuery);