/*-----------------------------------------------------------------------------------*/
/*  Single Product
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var singleProductCommonFunctions = {

        initCommonSingleProduct: function() {
            this.productThumbnails();
            this.productVariation();
            this.woocommerceVariationAttributesTrigger();
            this.woocommerceVariationAttributes();
            this.woocommerceVariationAttributesUpdate();
            this.woocommerceVariationAttributesSelection();
        },

        /*-----------------------------------------------------------------------------------*/
        /*  product  detail - gallery 
        /*-----------------------------------------------------------------------------------*/

        productThumbnails: function ($target, isQuickview) {
            var self = this;

            if ($target === undefined)
                $target = self.$body;

            var $thumbnails = $target.find("#product-thumbs");
            var $thumbnailsItem = $target.find("#product-thumbs .swiper-slide");

            var fixedStyle = $('.parent_div_product.product').hasClass('pd_fixed_summary');

            var pdGallery = $('.parent_div_product.product').hasClass('pd_col_gallery');

            var pdFullwidthTop = $('.parent_div_product.product').hasClass('pd_fullwidth_top');

            var pdSticky = $('.parent_div_product.product').hasClass('pd_sticky');

            if ( $thumbnailsItem.length <= 1 && !fixedStyle ) {
                //popup gallery in simple products when just have a gallery image without featured image.
                var $thumbnailslider = $target.find("#product-fullview-thumbs");
                $thumbnailslider.find('.enable-popup').addClass('swiper-slide');

            }
            if ( $thumbnailsItem.length == 1 &&( !fixedStyle || !pdGallery) ) {

               $("#product-thumbs").remove();

            }
            if ( $thumbnailsItem.length > 1 && (pdFullwidthTop || pdGallery ) ) {

               $("#product-thumbs").remove();
            }

            if ( ($thumbnailsItem.length > 1 || fixedStyle) ) {
                $thumbnails.waitForImages(function(){
                    var $fullView = $target.find("#product-fullview-thumbs"),
                        $productimageContainer = $fullView.find('.swiper'),
                        visibleNum = 4,
                        direction = 'vertical',
                        slidesPerView = 4,
                        productDetail = 'classic';

                    if ( isQuickview ) {
                        var $thumbnailSlides = $thumbnails.find('.swiper-slide'),
                            slidesNum = $thumbnailSlides.length,
                            $productThumbContainer = $thumbnails.find(".swiper"),
                            $productThumbWraper = $thumbnails.find(".swiper-wrapper");
                    } else if ( !fixedStyle ) {
                        var $thumbnailSlides = $thumbnails.find('.swiper-slide'),
                            slidesNum = $thumbnailSlides.length,
                            $productThumbContainer = $thumbnails.find(".swiper"),
                            $productThumbWraper = $thumbnails.find(".swiper-wrapper");
                    }



                    if ( !isQuickview ) {
                        if ( $('#main div.pd_top').length ) {
                            productDetail = 'top';
                        } else if ( $('#main div.pd_classic_sidebar').length ) {
                            productDetail = 'classic_sidebar';
                        } else if ( $('#main div.pd_kt_classic').length ) {
                            productDetail = 'kt_classic';
                        } else if ( $('#main div.pd_classic').length ) {
                            productDetail = 'classic';
                        } else if ( $('#main div.pd_background').length ) {
                            productDetail = 'background';
                        } else if ( $('#main div.pd_fixed_summary').length ) {
                            productDetail = 'pd_fixed_summary';
                        } else if ( $('#main div.pd_sticky').length ) {
                            productDetail = 'pd_sticky';
                        } else if ( $('#main div.pd_col_gallery').length ) {
                            productDetail = 'pd_col_gallery';
                        } else if ( $('#main div.pd_fullwidth_top').length ) {
                            productDetail = 'pd_fullwidth_top';
                        }
                    }

                    if ( self.windowWidth > 979 || (!fixedStyle &&  !pdFullwidthTop &&  !pdGallery)  || isQuickview ) {
                        if ( isQuickview || productDetail == 'top' || productDetail == 'classic_sidebar') {
                            direction = 'horizontal';
                            if (slidesNum <= 2) {
                                $productThumbContainer.css({ "width": ($thumbnailSlides.outerWidth() + 10) * slidesNum, "margin": "0 auto" }); // 10px  margin bottom For Each items
                            }
                            $productThumbWraper.css("width", ($thumbnailSlides.outerWidth() + 10) * slidesNum); // 10px  margin bottom For Each items

                        }
                        if (productDetail == 'classic_sidebar' || productDetail == 'top' || productDetail == 'classic') {
                            slidesPerView = 5;
                            visibleNum = 4;
                        }
                        if (productDetail == 'kt_classic' || productDetail == 'background')
                            slidesPerView = 5;

                        if (productDetail == 'kt_classic')
                            visibleNum = 4; // 4 gallery item in classic styles

                        if ($productimageContainer.parents('.container').width() > 1220 && (productDetail == 'classic' || productDetail == 'kt_classic' || productDetail == 'background')) {
                            slidesPerView = 6;
                            visibleNum = 5;
                        }
                        if ($productimageContainer.parents('.container').width() > 1220 && (productDetail == 'pd_sticky') ){
                            slidesPerView = slidesNum;
                            visibleNum = 4;
                        }

                        if (isQuickview) {
                            visibleNum = 3;
                        }

                        var centeredSlides = true;
                        if ($(productDetail == 'kt_classic' || productDetail == 'classic' || productDetail == 'background' || productDetail == 'pd_sticky').length > 0) {
                            var productImageHeight = $('div.product.parent_div_product .swiper .swiper-wrapper > .swiper-slide > img').height();
                            if (( $('#product-thumbs').length > 0 ) && !pdSticky ) {
                                $('#product-thumbs,#product-thumbs .swiper-wrapper').height((productImageHeight));
                            }

                            if ($('div.product.parent_div_product .swiper .swiper-wrapper > .swiper-slide > img').height() < 400) {
                                visibleNum = 2;
                                centeredSlides = false;
                            }

                            var mainImageHeight = $( '#product-fullview-thumbs .swiper-wrapper > .swiper-slide img').height(),
                                mainImageWidth = $( '#product-fullview-thumbs .swiper-wrapper > .swiper-slide img').width(),
                                thumbWidth = $( '#product-thumbs' ).width();
                            var aspect_ratio = mainImageWidth / mainImageHeight;

                            var thumbHeight = thumbWidth / aspect_ratio ;
                            var thumbHeightSwiper = $( '#product-thumbs .swiper-wrapper > div.swiper-slide' ).height( thumbHeight+'px');
                            $( '#product-thumbs img' ).height( thumbHeight+'px' );

                            slidesPerView = Math.floor( mainImageHeight / thumbHeight );
                            var spaceBetween =  ( mainImageHeight - ( thumbHeight * slidesPerView ) ) / slidesPerView;
                            if ( pdSticky ){
                                if ($('#product-thumbs').length > 0) {
                                    slidesPerView = slidesNum;
                                    visibleNum = 4;
                                    spaceBetween = 12;
                                    $('#product-thumbs,#product-thumbs .swiper-wrapper ').height(thumbHeight * slidesNum);
                                }
                            }
                            if (productDetail == 'background'){
                                if ($('#product-thumbs').length > 0) {
                                    spaceBetween = 8;
                                }
                            } 
                            if (productDetail == 'kt_classic'){
                                if ($('#product-thumbs').length > 0) {
                                    spaceBetween = 13;
                                }
                            }
                            if (productDetail == 'classic'){
                                if ($('#product-thumbs').length > 0) {
                                    spaceBetween = 3;
                                }
                            }
                        } else {
                            var spaceBetween =  5;
                        }

                        var $productFullviewSwiper = $productimageContainer[0].swiper,
                            $productThumbsSwiper = new Swiper($productThumbContainer[0], {
                                speed: 700,
                                longSwipesMs: 800,
                                touchAngle: 90,
                                grabCursor: true,
                                touchRatio: 3,
                                slidesPerView: slidesPerView,
                                preventClicks: false,
                                slideToClickedSlide: true,
                                spaceBetween: spaceBetween,
                                height:thumbHeightSwiper,
                                direction: direction,
                                centeredSlides: true,
                                preloadImages: false,
                                watchSlidesProgress: true,
                                pagination: {
                                    el: '.swiper-pagination',
                                    clickable: true,
                                },
                                lazyLoading: true,
                                on: {
                                    init: function () {
                                        if (slidesNum > visibleNum) {
                                            $thumbnails.addClass('initial-slides-position');
                                        }
                                    },
                                    setTranslate: function () {
                                        if (this.clickedIndex < visibleNum - 1 || this.activeIndex < visibleNum - 1) { //keep items visible until click on last visible item
                                            $productThumbWraper.css("transform", "translate3d(0px, 0px, 0px)");
                                            $productThumbWraper.css("-webkit-transform", "translate3d(0px, 0px, 0px)");
                                        }
                                    },
                                    transitionEnd: function () {
                                        if (this.clickedIndex < visibleNum - 1 || this.activeIndex < visibleNum - 1) { //keep items visible until click on last visible item
                                            $productThumbWraper.css("transform", "translate3d(0px, 0px, 0px)");
                                            $productThumbWraper.css("-webkit-transform", "translate3d(0px, 0px, 0px)");
                                        }
                                    },
                                    slideChangeTransitionStart: function () {
                                        if (($productFullviewSwiper !== "undefined") && !pdFullwidthTop) {
                                            $productFullviewSwiper.slideTo(this.activeIndex);
                                        }
                                    },
                                },
                            });

                    }

                    var isLoop = false,
                        slider_speed = 600,
                        $nextBtn = $target.find('.swiper-button-next'),
                        $prevBtn = $target.find('.swiper-button-prev');

                    if ( self.windowWidth < 979 ) {
                        isLoop = true;
                        $nextBtn = $productimageContainer.find('.swiper-button-next'),
                        $prevBtn = $productimageContainer.find('.swiper-button-prev');
                    }

                    if ( productDetail == 'top' ) {
                        slider_speed = 800;
                    }


                    var autoplayDuration = $('#product-thumbs .auto-play').length ? 6500 : 0;

                    if ( autoplayDuration == 0) {
                        var $autoplay = false;
                    } else {
                        var $autoplay = { delay: autoplayDuration };
                    }

                    if ( pdSticky && !isQuickview &&  $(window).width() > 979 ){
                        var $swiper = new Swiper($productimageContainer[0], {
                            autoplay: false,
                            autoplayDisableOnInteraction: false,
                            speed: slider_speed,
                            longSwipesMs: 700,
                            touchAngle: 30,
                            loop: isLoop,
                            followFinger: true,
                            direction:'vertical',
                            spaceBetween: 12,
                            height:mainImageHeight,
                            grabCursor: true,
                            keyboardControl: true,
                            slidesPerView:1,
                            allowTouchMove:true,
                            simulateTouch: false,
                            mousewheelControl: true,
                            touchReleaseOnEdges: true,
                            mousewheelReleaseOnEdges: true,
                            mousewheelSensitivity: .6,
                            keyboard: true,
                            watchSlidesProgress: true,
                            watchSlidesProgress: true,
                        });
                        $productFullviewSwiper = $swiper;
                    } else if ( pdFullwidthTop && !isQuickview &&  $(window).width() > 979 ) {
                        var $productThumbsFullviewSwiper = new Swiper($productimageContainer[0], {
                            slidesPerView: 3,
                            spaceBetween: 0,
                            centeredSlides:true,
                            loop:true,
                            slideToClickedSlide: true,
                            loopedSlides: 50,
                            navigation: {
                                nextEl: '.swiper-button-next',
                                prevEl: '.swiper-button-prev',
                            },
                            pagination: {
                                el: '.swiper-pagination',
                                clickable: true,
                            },
                            mousewheel: false,
                            mousewheelControl: false,
                            touchReleaseOnEdges: false,
                            mousewheelReleaseOnEdges: false,
                            keyboard: true,
                            autoplay: $autoplay,
                            on: {
                                slideChangeTransitionStart: function () {
                                    if (self.windowWidth > 979 && isQuickview) {
                                        if (!this.isBeginning) {
                                            $productThumbsSwiper.slideTo(this.activeIndex);
                                        }
                                    } else if (self.windowWidth > 979 && !self.isTouchDevice) {
                                        if (!this.isBeginning) {
                                            $productThumbsSwiper.slideTo(this.activeIndex);
                                        }
                                    }
                                },
                                reachBeginning: function () {
                                    if (self.windowWidth > 979 && isQuickview) {
                                        $productThumbsSwiper.slideTo(0);
                                    } else if (self.windowWidth > 979 && !self.isTouchDevice) {
                                        $productThumbsSwiper.slideTo(0);
                                    }
                                },
                            },
                        });
                        $productFullviewSwiper = $productThumbsFullviewSwiper;
                    } else if ( !fixedStyle ||  $(window).width() < 979 ) {
                        if ( $(window).width() < 979 ) {
                            $autoplay = false;
                        }
                        var $productThumbsFullviewSwiper = new Swiper($productimageContainer[0], {
                            autoplay: $autoplay,
                            autoplayDisableOnInteraction: false,
                            speed: slider_speed,
                            longSwipesMs: 700,
                            touchAngle: 30,
                            loop: isLoop,
                            spaceBetween: 0,
                            followFinger: true,
                            watchSlidesProgress: true,
                            navigation: {
                                nextEl: $nextBtn[0],
                                prevEl: $prevBtn[0],
                            },
                            pagination: {
                                el: '.swiper-pagination',
                                clickable: true,
                            },
                            on: {
                                slideChangeTransitionStart: function () {
                                    if (self.windowWidth > 979 && isQuickview) {
                                        if (!this.isBeginning) {
                                            $productThumbsSwiper.slideTo(this.activeIndex);
                                        }
                                    } else if ( self.windowWidth > 979 && !self.isTouchDevice && !fixedStyle && !pdGallery ) {
                                        if (!this.isBeginning) {
                                            $productThumbsSwiper.slideTo(this.activeIndex);
                                        }
                                    }
                                },
                                reachBeginning: function () {
                                    if (self.windowWidth > 979 && isQuickview) {
                                        $productThumbsSwiper.slideTo(0);
                                    } else if ( self.windowWidth > 979 && !self.isTouchDevice && !fixedStyle && !pdGallery ) {
                                        $productThumbsSwiper.slideTo(0);
                                    }
                                },
                            },
                        });

                        $productFullviewSwiper = $productThumbsFullviewSwiper;
                        $('.pd_col_gallery #product-fullview-thumbs .swiper-slide').hover(
                            function() {
                                $('.pd_col_gallery #product-fullview-thumbs .swiper-slide').removeClass('col-gallery-hover');
                                $(this).addClass('col-gallery-hover');
                            },
                            function() {
                                $(this).toggleClass('col-gallery-hover');
                                $('.pd_col_gallery #product-fullview-thumbs .swiper-slide').addClass('col-gallery-hover');
                            }
                        )
                        $('.pd_col_gallery .attr-container label').on('click', function () {
                            $('.pd_col_gallery #product-fullview-thumbs .swiper-slide').removeClass('col-gallery-hover');
                        });
                    }

                });
            } else {
                $('div.pd_background #product-fullview-thumbs .swiper-slide').addClass('kt-one-slide');
            }

        },

        /*-----------------------------------------------------------------------------------*/
        /*  ReInit variation functionality by recalling woocommerce wc_variation_form function
        /*-----------------------------------------------------------------------------------*/

        reInitVariation: function ($container) {
            var $formVariation = $container.find('.variations_form');

            if ( $formVariation.length > 0 ) {
                $formVariation.wc_variation_form().find('.variations select:eq(0)').change();
                $formVariation.trigger('check_variations');
            }

        },

        /*-----------------------------------------------------------------------------------*/
        /*  product variation
        /*-----------------------------------------------------------------------------------*/

        productVariation: function () {
            var self = this;
            if ($("form.variations_form").length <= 0 || $('#product-fullview-thumbs .swiper').length <= 0) {
                return;
            }

            //Use passed parameter for getting variation images
            //variation.image_link : original image size
            //variation.image_src : smaller image ( shop_single size )
            $.fn.wc_variations_image_update = function (variation) {


                //check existnace of image for this variation
                if (variation && variation.image.url && variation.image.url.length > 1) {
                    if ($('.product').hasClass('pd_fixed_summary , pd_sticky') && self.windowWidth > 979) {
                        var $varImg = $('.swiper-slide[data-variableimageurl^="' + variation.image.url + '"]');
                        if (!$varImg.length)
                            return;
                        var $ImgOffset = $varImg.offset().top;
                        $('html,body').animate({ scrollTop: $ImgOffset }, "slow");
                        return;
                    }

                    //Find the index of variation slide and slide to it
                    var index = $("#product-fullview-thumbs").find('.swiper-slide[data-variableimageurl^="' + variation.image.url + '"]').data('slide'),
                        $image_slider = $('#product-fullview-thumbs .swiper')[0].swiper;

                    if (index == undefined)
                        return;

                    if ($image_slider == undefined)
                        return;

                    if (self.windowWidth < 768) {
                        index = index + 1; // increment to point to correct slide in loop mode slider
                    }

                    $image_slider.slideTo(index);
                    $('#product-thumbs').add($('#product-fullview-thumbs')).addClass('stop-by-variations');//Stop slider when select an varaition that has image
                    $image_slider.autoplay.stop();

                }
            };
            if ( $('.variations_form.cart').length && self.windowWidth > 979 && $('.pd_fixed_summary , .pd_sticky').length > 0 ) {
                $('.variable_item').on('click', function (event) {
                    var $varImg = $('.swiper-slide[data-var_id='+$(this).data('var_id')+']');
                    if (!$varImg.length)
                        return;
                    var $ImgOffset = $varImg.offset().top;
                    $('html,body').animate({ scrollTop: $ImgOffset }, "slow");
                });
            }
        },

        /*-----------------------------------------------------------------------------------*/
        /* woocommerce variation select
        /*-----------------------------------------------------------------------------------*/
        woocommerceVariationAttributesTrigger: function () {
            var self = this;

            if ( $('form.cart .variations select').length <= 0 ) {
                return;
            }

            self.$body.trigger('update_variation_values');

        },

        woocommerceVariationAttributes: function () {
            var self = this,
                $quickViewModal = self.$document.find('#kt-modal');


            if ( $('form.cart .variations select').length <= 0 ) {
                return;
            }

            if ( ( $('form.variations_form').length) && ($quickViewModal.length <= 0 || ! $('.quick-view-button').length ) ) {
                if ($('form.variations_form').siblings('.yith-wcwl-add-to-wishlist').length) {
                    $('.single_variation_wrap a.single_add_to_cart_button').after($('.yith-wcwl-add-to-wishlist').eq(0));
                }

                $('.yith-wcwl-add-to-wishlist').css('visibility', 'visible');

            }

            // On clicking the reset variation button
            $(document.body).on('click', '.reset_variations', function (event) {

                $('.nice-select').each(function () {

                    var $this = $(this);

                    var $dropdownLi = $this.find('.list li');

                    //reset DropDown
                    $dropdownLi.removeClass('selected');
                    var $chooseAnoptionText = $this.find('.list li:first-child').text();

                    var $currentText = $this.find('.current');
                    $currentText.html($chooseAnoptionText);

                });

            })

        },

        woocommerceVariationAttributesUpdate: function () {
            setTimeout(function () {

                $('form.cart').find('.variations select').each(function (index, el) {

                    var $select = $(this),
                        $colorAttr = $select.siblings('.select-attr'),
                        attr_values = new Array();

                    $select.find('option').each(function () {
                        attr_values.push($(this).val());
                    });

                    $colorAttr.find('span.select_item').removeClass('active');

                    if ( $colorAttr.length ) {
                        $.each(attr_values, function () {
                            if ( this != '' ) {
                                $colorAttr.find('span[data-value="' + this + '"]').addClass('active');
                            }
                        })
                    }

                    $colorAttr.find('.select_item:not(.active)').addClass('deactive');

                    // Update nice select
                    $('form.cart .variations select').not('.hide-attr-select').niceSelect('update');


                });
            }, 200)
        },


        woocommerceVariationAttributesSelection: function () {
            var self = this,
                $quickViewModal = self.$document.find('#kt-modal');

            if ($('form.cart .variations select').length <= 0) {
                return;
            }

            self.$body.unbind('update_variation_values', self.woocommerceVariationAttributesUpdate);
            self.$body.on('update_variation_values', self.woocommerceVariationAttributesUpdate);

            var $attrContainer = $('.woocommerce form.cart .variations .attr-container'),
                $selectableItems = $attrContainer.find('.select_item'),
                $attr_slides = $attrContainer.find('.swiper-slide');

            $selectableItems.on('click', function () {
                if ( !$(this).hasClass('active') ) {
                    $(this).siblings('input:radio').prop('disabled', 'disabled');
                    return;
                } else {
                    $(this).siblings('input:radio').removeProp('disabled');
                }

                if ( $(this).hasClass('active') ) {
                    //active clicked item
                    $selectableItems.removeClass('selected');
                    $(this).addClass('selected');
                }

                var $term = $(this).data('value');

                //change select element to trigger events
                $attrContainer.siblings('select').find('option[value="' + $term + '"]').prop('selected', true);
                $attrContainer.siblings('select').trigger('change');

            });

            if ( ($('form.variations_form').length)  && ($quickViewModal.length <= 0 || ! $('.quick-view-button').length ) ) {
                if ($('form.variations_form').siblings('.yith-wcwl-add-to-wishlist').length) {
                    $('.single_variation_wrap a.single_add_to_cart_button').after($('.yith-wcwl-add-to-wishlist').eq(0));
                }

                $('.yith-wcwl-add-to-wishlist').css('visibility', 'visible');

            }

            // On clicking the reset variation button
            $(document.body).on('click', '.reset_variations', function (event) {
                // For Color Selection Reset
                $('label.selectlabel input:radio,label.colorlabel input:radio,label.imagelabel input:radio').prop('checked', false);
                // For Image Selection Reset
                $('.variations_form.cart.variation_clicked').removeClass('variation_clicked');
                $attr_slides.removeClass('selected deactive');

                var imageSlider = $('#product-fullview-thumbs .swiper')[0].swiper;
                imageSlider.slideTo(0);


                $('.nice-select').each(function () {

                    var $this = $(this);

                    var $dropdownLi = $this.find('.list li');

                    //reset DropDown
                    $dropdownLi.removeClass('selected');
                    var $chooseAnoptionText = $this.find('.list li:first-child').text();

                    var $currentText = $this.find('.current');
                    $currentText.html($chooseAnoptionText);

                });

            })

        },

    };

    kiteTheme = Object.assign( kiteTheme, singleProductCommonFunctions );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($,kiteTheme){
    kiteTheme.initCommonSingleProduct();
    $(document).ready(function(){
        kiteTheme.productVariation();
    });
})(jQuery, window.kiteTheme);