/*-----------------------------------------------------------------------------------*/
/*  Single Product
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var singleProduct = {

        initSingleProduct: function() {
            this.productDetailHeight();
            this.productSizeGuide();
            this.productSizeGuidePopup();
            this.productDeliveryReturnPopup();
            this.productFaqPopup();
            this.productAccordionStyle();
            this.productTabs();
            this.stickyProductThumbnails();
            this.productGalleryPopupLightGallery();
            this.reviewForm();
            this.productNextPrevButton();
            this.fixedAddToCartFunctionality();
            this.syncFixedAddToCart();
            this.fixedAddToCartVisibility();
            this.fixedProductStyle();
            this.product360View();
            this.tabsTourAccordion();
            this.tabsTourAccordionHeight();
            this.tabScrollbar();
            this.boughtTogetherProduct();
            this.buyNow();
        },

        singleProductResizeEvent: function() {
            this.productDetailHeight();
        }, 

        /*-----------------------------------------------------------------------------------*/
        /*  Set product detail appropriate height
        /*-----------------------------------------------------------------------------------*/
        productDetailHeight: function () {
            var self = this;

            var topSpace = self.pageTopSpace();

            if ( ( $('div.product.pd_top').length <= 0 ) || ( $('div.product.pd_fullwidth_top').length <= 0 ) ) {
                return;
            }


            // max-height - top product detail
            topSpace = topSpace + 60; // 60 is breadcrumb height+ paddings

            if ($('#product-thumbs').length > 0) {
                topSpace = topSpace + 100; // 100 is height of product thumbs
            }
            $('.woocommerce div.product.pd_top div.images img').css("max-height", self.windowHeight - topSpace);

        },

        /*-----------------------------------------------------------------------------------*/
        /*  Product detail size guide
        /*-----------------------------------------------------------------------------------*/

        productSizeGuide: function () {
            var self = this;
            var $sizeGuide = $('#ct_size_guide,.ct-size-guide');

            if ( !self.$body.hasClass('single-product') ) {
                return;
            }

            var $sizeGuideModal = self.$document.find('#kt-modal'),
                $sizeGuideContent = $sizeGuideModal.find('#modal-content');

            if ( $sizeGuideModal.length <= 0 || $sizeGuide.length <= 0 || $sizeGuide.hasClass('ct_sg_tabbed') ) {
                return;
            }

            $('.button_sg').on('click', function (e) {
                e.preventDefault();

                $sizeGuideModal.addClass('hidden-nav');

                self.$body.addClass('modal-open'); // disable scrollbar
                $sizeGuideModal.addClass('size-guide-modal');

                if (!$sizeGuideModal.removeClass('closed').hasClass('open')) {
                    $sizeGuideModal.removeClass('loading').addClass('open');
                }

                var $data = $sizeGuide.removeClass('mfp-hide');

                $sizeGuideContent.html($data);
                $sizeGuideModal.addClass('shown').prepend('<div class="mfp-bg"></div>'); // content is ready, so show it
            });


            // Close quickview by click outside of content
            $sizeGuideModal.on('click', function (e) {
                if ( !$sizeGuideContent.is(e.target) && $sizeGuideContent.has(e.target).length === 0 ) {
                    self.closeSizeGuide();
                }
            });

            // Close quickview by click close button
            self.$document.on('click', '#kt-modal.size-guide-modal #modal-close', function (e) {
                e.preventDefault();
                self.closeSizeGuide();
            });

            // Close box with esc key
            self.$document.keyup(function (e) {
                if (e.keyCode === 27) {
                    self.closeSizeGuide();
                }
            });
        },

        closeSizeGuide: function () {
            var self = this;

            var $sizeGuideModal = self.$document.find('#kt-modal.size-guide-modal'),
                $sizeGuideContent = $sizeGuideModal.find('#modal-content');

            $sizeGuideModal.removeClass('shown loading open').addClass('closed');

            setTimeout(function () {
                self.$body.removeClass('modal-open');
                $sizeGuideModal.removeClass('size-guide-modal');
            }, 300)

            setTimeout(function () {
                var $data = $sizeGuideContent.html();
                $('#main').append($data);
                $('#ct_size_guide,.ct-size-guide').addClass('mfp-hide')
                $sizeGuideContent.html('');
                $sizeGuideModal.find('.mfp-bg').remove();
            }, 800);
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Product detail size guide popup
        /*-----------------------------------------------------------------------------------*/

        productSizeGuidePopup: function () {
            var self = this;
            var $sizeGuide = $('.product-popup-content-sizeguid');

            if ( !self.$body.hasClass('single-product') ) {
                return;
            }

            var $sizeGuideModal = self.$document.find('#kt-modal'),
                $sizeGuideContent = $sizeGuideModal.find('#modal-content');

            if ( $sizeGuideModal.length <= 0 || $sizeGuide.length <= 0 ) {
                return;
            }

            $('.product-popup.size-guide').on('click', function (e) {
                e.preventDefault();

                self.$body.addClass('modal-open'); // disable scrollbar
                $sizeGuideModal.addClass('size-guide-popup-modal');

                if ( !$sizeGuideModal.removeClass('closed').hasClass('open') ) {
                    $sizeGuideModal.removeClass('loading').addClass('open');
                }

                var $data = $sizeGuide.removeClass('hidden');

                $sizeGuideContent.html($data);
                $sizeGuideModal.addClass('shown');
            });


            // Close quickview by click outside of content
            $sizeGuideModal.on('click', function (e) {
                if ( !$sizeGuideContent.is(e.target) && $sizeGuideContent.has(e.target).length === 0 ) {
                    self.closeSizeGuidePopup();
                }
            });

            // Close quickview by click close button
            self.$document.on('click', '#kt-modal.size-guide-popup-modal #modal-close', function (e) {
                e.preventDefault();
                self.closeSizeGuidePopup();
            });

            // Close box with esc key
            self.$document.keyup(function (e) {
                if (e.keyCode === 27) {
                    self.closeSizeGuidePopup();
                }
            });
        },

        closeSizeGuidePopup: function () {
            var self = this;

            var $sizeGuideModal = self.$document.find('#kt-modal.size-guide-popup-modal'),
                $sizeGuideContent = $sizeGuideModal.find('#modal-content');

            $sizeGuideModal.removeClass('shown open').addClass('closed');

            setTimeout(function () {
                self.$body.removeClass('modal-open');
                $sizeGuideModal.removeClass('size-guide-popup-modal');
            }, 0);

            setTimeout(function () {
                var $data = $sizeGuideContent.html();
                $('#main').append($data);
                $('.product-popup-content-sizeguid').addClass('hidden')
                $sizeGuideContent.html('');
            }, 1);
        },

		/*-----------------------------------------------------------------------------------*/
        /*  Product detail delivery return popup
        /*-----------------------------------------------------------------------------------*/
        productDeliveryReturnPopup: function () {
            var self = this;
            var $deliveryReturn = $('.product-popup-content-delivery');

            if ( !self.$body.hasClass('single-product') ) {
                return;
            }

            var $deliveryReturnModal = self.$document.find('#kt-modal'),
                $deliveryReturnContent = $deliveryReturnModal.find('#modal-content');

            if ($deliveryReturnModal.length <= 0 || $deliveryReturn.length <= 0 ) {
                return;
            }

            $('.product-popup.delivery-return').on('click', function (e) {
                e.preventDefault();

                self.$body.addClass('modal-open'); // disable scrollbar
                $deliveryReturnModal.addClass('delivery-return-modal');

                if (!$deliveryReturnModal.removeClass('closed').hasClass('open')) {
                    $deliveryReturnModal.removeClass('loading').addClass('open');
                }

                var $data = $deliveryReturn.removeClass('hidden');

                $deliveryReturnContent.html($data);
                $deliveryReturnModal.addClass('shown');
            });


            $deliveryReturnModal.on('click', function (e) {
                if (!$deliveryReturnContent.is(e.target) && $deliveryReturnContent.has(e.target).length === 0) {
                    self.closeDeliveryReturn();
                }
            });
            self.$document.on('click', '#kt-modal.delivery-return-modal #modal-close', function (e) {
                e.preventDefault();
                self.closeDeliveryReturn();
            });

            self.$document.keyup(function (e) {
                if (e.keyCode === 27) {
                    self.closeDeliveryReturn();
                }
            });
        },

        closeDeliveryReturn: function () {
            var self = this,
                $deliveryReturnModal = self.$document.find('#kt-modal.delivery-return-modal'),
                $deliveryReturnContent = $deliveryReturnModal.find('#modal-content');

            $deliveryReturnModal.removeClass('shown loading open').addClass('closed');

            setTimeout(function () {
                self.$body.removeClass('modal-open');
                $deliveryReturnModal.removeClass('delivery-return-modal');
            }, 0)

            setTimeout(function () {
                var $data = $deliveryReturnContent.html();
                $('#main').append($data);
                var $deliveryReturn = $('.product-popup-content-delivery');
                $deliveryReturn.addClass('hidden')
                $deliveryReturnContent.html('');

            }, 1);
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Product detail faq popup
        /*-----------------------------------------------------------------------------------*/

        productFaqPopup: function () {
            var self = this,
                $faq = $('.product-popup-content-faq');

            if ( !self.$body.hasClass('single-product') ) {
                return;
            }

            var $faqModal = self.$document.find('#kt-modal'),
                $faqContent = $faqModal.find('#modal-content');

            if ($faqModal.length <= 0 || $faq.length <= 0 ) {
                return;
            }

            $('.product-popup.ask-question').on('click', function (e) {
                e.preventDefault();

                self.$body.addClass('modal-open'); // disable scrollbar
                $faqModal.addClass('faq-modal');

                if ( !$faqModal.removeClass('closed').hasClass('open') ) {
                    $faqModal.removeClass('loading').addClass('open');
                }

                var $data = $faq.removeClass('hidden');

                $faqContent.html($data);
                $faqModal.addClass('shown');
            });


            // Close quickview by click outside of content
            $faqModal.on('click', function (e) {
                if ( !$faqContent.is(e.target) && $faqContent.has(e.target).length === 0 ) {
                    self.closeFaq();
                }
            });

            // Close quickview by click close button
            self.$document.on('click', '#kt-modal.faq-modal #modal-close', function (e) {
                e.preventDefault();
                self.closeFaq();
            });

            // Close box with esc key
            self.$document.keyup(function (e) {
                if (e.keyCode === 27) {
                    self.closeFaq();
                }
            });
        },

        closeFaq: function () {
            var self = this;

            var $faqModal = self.$document.find('#kt-modal.faq-modal'),
                $faqContent = $faqModal.find('#modal-content');

            $faqModal.removeClass('shown loading open').addClass('closed');

            setTimeout(function () {
                self.$body.removeClass('modal-open');
                $faqModal.removeClass('faq-modal');
            }, 0)

            setTimeout(function () {
                var $data = $faqContent.html();
                $('#main').append($data);
                var $faq = $('.product-popup-content-faq');
                $faq.addClass('hidden')
                $faqContent.html('');

            }, 1);
        },

        /*-----------------------------------------------------------------------------------*/
        /*  product  detail - tabs
        /*-----------------------------------------------------------------------------------*/
        //Modified version of Woocommerce/assets/js/frontend/single-product.js

        productAccordionStyle: function () {
            $('.hide-during-load').removeClass('hide-during-load');
            $( '.accordion-tab ul.tabs li' ).removeClass( 'active' );
            $( '.accordion-tab ul.tabs .panel' ).removeClass( 'current' ).slideUp(300);

            var $accTab = $( '.accordion-tab ul.tabs' );
            if( $accTab.find('#tab-more_seller_product') ) {
                $('.woocommerce-Tabs-panel .products.grid_view').removeClass('shop-4column , shop-5column , shop-3column').addClass('shop-2column');
            }
        },
        productTabs: function () {

            var self = this,
                ratingInitCount = 1; // Control to init rating Run Once time

            // wc_single_product_params is required to continue, ensure the object exists
            if (typeof wc_single_product_params === 'undefined') {
                return false;
            }

            // Tabs
            $('body')
                .on('init', '.wc-tabs-wrapper:not(.accordion-tab), .woocommerce-tabs:not(.accordion-tab)', function () {
                    $('.wc-tab.hide-during-load, .woocommerce-tabs .panel.hide-during-load:not(.panel .panel)').hide();

                    var hash = window.location.hash,
                        url = window.location.href,
                        $tabs = $(this).find('.wc-tabs, ul.tabs').first();

                    if ( hash.toLowerCase().indexOf('comment-') >= 0 || hash === '#reviews' || hash === '#tab-reviews' ) {
                        $tabs.find('li.reviews_tab a').click();
                    } else if (url.indexOf('comment-page-') > 0 || url.indexOf('cpage=') > 0) {
                        $tabs.find('li.reviews_tab a').click();
                    } else {
                        $tabs.find('li:first a').click();
                    }
                    $('.hide-during-load').removeClass('hide-during-load');
                })
                //Kitest codes (custom version of click event for tabs)
                .on('click', '.wc-tabs li a, ul.tabs li a', function () {
                    var $this = $(this),
                        $currentPanelID = $this.attr('href'),
                        $currentPanel = $('.woocommerce-tabs').find($currentPanelID),
                        $visiblePanel = $currentPanel.siblings('.panel').filter(':visible');

                    if( $('.woocommerce-tabs').hasClass('accordion-tab') ){
                        if( $this.parent().hasClass( 'active' ) ) {
                            self.productAccordionStyle();
                            self.updateDocHeight();
                        } else {
                            self.productAccordionStyle();
                            $this.parent().addClass( 'active' );
                            $( '.accordion-tab ' + $currentPanelID ).addClass( 'current' ).slideDown(500, function () {
                                self.updateDocHeight();
                            });
                        }
                    } else{

                        $this.parent().siblings().removeClass('active').end().addClass('active');

                        if ( $visiblePanel.length <= 0 ) {
                            $currentPanel.addClass('current').fadeIn(300, function () {
                                self.updateDocHeight();
                            });
                        } else {
                            $visiblePanel.stop().fadeOut(300, function () {
                                $currentPanel.siblings('.panel').removeClass('current');
                                $currentPanel.addClass('current').stop().fadeIn(300, function () {
                                    self.updateDocHeight();
                                });
                            });
                        }
                    }

                    return false;
                })
                // Review link
                .on('click', 'a.woocommerce-review-link', function () {
                    $('.reviews_tab a').click();
                    return true;
                })
                //kiteSt code : modified version
                .on('init', '#rating', function () {
                    if (ratingInitCount == 1) { // Control to init rating Run Once time
                        $('#rating').hide().before('<p class="stars review_rating"><span><a class="star-1" href="#">1</a><a class="star-2" href="#">2</a><a class="star-3" href="#">3</a><a class="star-4" href="#">4</a><a class="star-5" href="#">5</a></span></p>');
                        ratingInitCount++;
                    }
                })
                .on('click', '#respond p.stars a', function () {
                    var $star = $(this),
                        $rating = $(this).closest('#respond').find('#rating'),
                        $container = $(this).closest('.stars');

                    $rating.val($star.text());
                    $star.siblings('a').removeClass('active');
                    $star.addClass('active');
                    $container.addClass('selected');

                    return false;
                })
                .on('click', '#respond #submit', function () {
                    var $rating = $(this).closest('#respond').find('#rating'),
                        rating = $rating.val();

                    if ($rating.length > 0 && !rating && wc_single_product_params.review_rating_required === 'yes') {
                        window.alert(wc_single_product_params.i18n_required_rating_text);

                        return false;
                    }
                })

            //KiteSt code : modified version
            if (ratingInitCount === 1) { // Control to init rating Run Once time
                //Init Tabs and Star Ratings
                $('.wc-tabs-wrapper, .woocommerce-tabs, #rating').trigger('init');
                ratingInitCount++;
            }

        },

        /*-----------------------------------------------------------------------------------*/
        /*  product  detail - zoom effect 
        /*-----------------------------------------------------------------------------------*/

        productImageZoom: function () {
            var self = this;
            if ( self.windowWidth <= 979 && self.$body.hasClass( 'kt-responsive-zoom-disable' ) ) {
                return;
            }

            var onState = self.windowWidth <= 979 ? 'toggle' : 'mouseover';
            $('.zoom-container.enable .swiper-slide').each(function () {
                var $zoomImage = $(this).attr('data-zoom-image');
                $(this).zoom({
                    url: $zoomImage,
                    on: onState
                });
            });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  product - sticky product thumbnails
        /*-----------------------------------------------------------------------------------*/	
        stickyProductThumbnails: function () {
            var self = this;
            var menuHeight = 0;
            if ($('#wpadminbar').length)
                var wpAdminBarHeight = $('#wpadminbar').height();
            else
                var wpAdminBarHeight = 0; 
            if ($('#headersecondstate').length > 0) {
                var menuHeight = $('#headersecondstate').outerHeight();
            } 
            if ($('.parent_div_product').hasClass('pd_sticky') && self.windowWidth > 979) {
                if ( $('.pd_sticky').length > 0) {
                    $('#product-thumbs .swiper-slide').on('click', function (event) {
                        var $stickyIndex = $( this ).attr( 'data-image-attribute' );
                        var $offsetTopValue = $( '#product-fullview-thumbs .swiper-slide:eq( ' + $stickyIndex + ' )' );
                        $offsetTopValue = $offsetTopValue.offset().top;
                        $('html, body').stop()
                            .animate({
                                'scrollTop': $offsetTopValue
                            });
                    });
                }
                if( ( $( '.summary.entry-summary , #product-thumbs' ).length > 0 ) && ($(window).width() > 1220) ) {
                    $('.summary.entry-summary , #product-thumbs').imagesLoaded( function() {
                        $( '.summary.entry-summary , #product-thumbs' ).stick_in_parent({
                            offset_top:menuHeight+wpAdminBarHeight+32
                        });
                    });
                }
            }
        },

        /*----------------------------------------------------------------------------------*/
        /*  light galley for product detail
        /*-----------------------------------------------------------------------------------*/

        productGalleryPopupLightGallery: function () {
            if (typeof $.fn.lightGallery !== 'function' || $('#product-fullview-thumbs .enable-popup').length <= 0) {
                return;
            }

            var $productPopupGallery = $('#product-fullview-thumbs');
            $productPopupGallery.lightGallery({
                selector: '.enable-popup',
                getCaptionFromTitleOrAlt: false
            });

            $('.popup-button').on('click', function () {
                $productPopupGallery.find('.swiper-slide').trigger('click.lgcustom');
            });

            $productPopupGallery.on('onSlideClick.lg', function () {
                $productPopupGallery.data('lightGallery').goToNextSlide();
            });
        },

        /*----------------------------------------------------------------------------------*/
        /*  ReviewForm  blog and product details
        /*-----------------------------------------------------------------------------------*/

        reviewForm: function () {

            // product detail
            if ( $('#review_form').length ) {


                $("#review_form input").focus(function () {
                    $(this).siblings('.label').addClass('inputfocus');
                    $(this).siblings('.graylabel').addClass('inputfocus');
                });


                $("#review_form input").focusout(function () {
                    $(this).siblings('.label').removeClass('inputfocus');
                    $(this).siblings('.graylabel').removeClass('inputfocus');
                });

                $("#review_form textarea").focus(function () {
                    $(this).siblings('.label').addClass('inputfocus');
                    $(this).siblings('.graylabel').addClass('inputfocus');
                });


                $("#review_form textarea").focusout(function () {
                    $(this).siblings('.label').removeClass('inputfocus');
                    $(this).siblings('.graylabel').removeClass('inputfocus');
                });

            }

        },

        /*----------------------------------------------------------------------------------*/
        /* Next/prev button for product
        /*-----------------------------------------------------------------------------------*/

        productNextPrevButton: function () {
            var self = this;

            if ( self.$body.hasClass('single-product') ) {
                var $originalNextButton = $('#main span#next-product'),
                    $originalPrevButton = $('#main span#prev-product');
                if ( $originalNextButton.length > 0 ) {
                    if ($('.toggle-sidebar-container').siblings('span#next-product').length > 0 || $('.toggle-sidebar-container').siblings('span#prev-product').length > 0) {
                        if ( $originalNextButton.find('a').length > 0 ) {
                            $('.toggle-sidebar-container').siblings('span#next-product').addClass('visible').empty('').html($originalNextButton.html());
                        } else {
                            $('.toggle-sidebar-container').siblings('span#next-product').removeClass('visible');
                        }

                        if ( $originalPrevButton.find('a').length > 0 ) {
                            $('.toggle-sidebar-container').siblings('span#prev-product').addClass('visible').empty('').html($originalPrevButton.html());
                        } else {
                            $('.toggle-sidebar-container').siblings('span#prev-product').removeClass('visible');
                        }
                    } else {
                        $('.toggle-sidebar-container').after($originalNextButton).after($originalPrevButton);
                        setTimeout(function () {
                            $originalNextButton.addClass('visible');
                            $originalPrevButton.addClass('visible');
                        }, 200);
                    }
                }
            } else {
                $('span#next-product').removeClass('visible');
                $('span#prev-product').removeClass('visible');
            }
        },

        /*----------------------------------------------------------------------------------*/
        /* Fixed add to cart
        /*-----------------------------------------------------------------------------------*/

        fixedAddToCartFunctionality: function () {

            var self = this;

            if ($('div.product.parent_div_product').length <= 0 || !self.$body.hasClass('fixed-add-to-cart-enable')) {
                return;
            }

            if ((($('.kt_product_page > div.product').hasClass('product-type-variable')) && self.windowWidth < 1140) || $('.kt_product_page > div.product').hasClass('product-type-grouped')) {
                $('a.single_add_to_cart_button').removeClass('add_to_cart_button').addClass('go-to-add-to-cart'); // change type of add-to-cart button
            } else {
                $('a.single_add_to_cart_button').addClass('add_to_cart_button').removeClass('go-to-add-to-cart'); // change type of add-to-cart button
            }

            //update add to cart button text
            var $add_to_cart_button = $('a.single_add_to_cart_button');
            if ( $('.fixed-add-to-cart-container a.single_add_to_cart_button .txt').empty() && $add_to_cart_button.length ) {

                if ($add_to_cart_button.eq(0).find('.txt').html()) {
                    var $add_to_cart_text = $add_to_cart_button.eq(0).find('.txt').html().trim();
                } else { 
                    // Add this line code becuse some translate plugin remove span.text and this cuase error
                    var $add_to_cart_text = $add_to_cart_button.eq(0).html().trim();
                }

                $('.fixed-add-to-cart-container a.single_add_to_cart_button .txt').html($add_to_cart_text).attr('data-hover', $add_to_cart_text);
                $('.fixed-add-to-cart-container a.single_add_to_cart_button').attr('title', $add_to_cart_text);
            }

            $('.fixed-add-to-cart .go-to-add-to-cart').on('click', function (e) {
                e.preventDefault();

                var $top;

                if ($('table.variations').length > 0) {
                    $top = $('table.variations').offset().top;
                } else {
                    $top = $('a.add_to_cart_button , a.single_add_to_cart_button').eq(0).offset().top;
                }
                if ($('#wpadminbar').length) {
                    var wpAdminBarHeight = $('#wpadminbar').height();
                } else {
                    var wpAdminBarHeight = 0;
                }
                $top = $top - (100 + wpAdminBarHeight);

                self.$scrollpals.stop().animate(

                    { scrollTop: $top },
                    1000,
                    'easeOutQuad'
                );

            });

             $('.fixed-add-to-cart a.single_add_to_cart_button:not(.product_type_variable)').not('.go-to-add-to-cart').on('click', function (e) {
                e.preventDefault();
                $('a.single_add_to_cart_button')[0].click();
            });
            $('.fixed-add-to-cart').find($('form.cart .yith-wcwl-add-to-wishlist')).remove();
            $('.fixed-add-to-cart').find($('form.cart .compare.button')).remove();

            //compare button
            $('.scrolltotop a.compare').on('click', function (e) {
                e.preventDefault();
                $('.woocommerce div.product div.summary a.compare').eq(0).trigger('click');
            });


        },

        syncFixedAddToCart: function () {

            var self = this;

            if ( $('div.product.parent_div_product').length <= 0 || !self.$body.hasClass('fixed-add-to-cart-enable') ) {
                return;
            }

            //listen to event of add to cart button
            $(document.body).on('adding_to_cart', function () {
                self.$document.find('.single_add_to_cart_button').addClass('loading');
            });

            $(document.body).on('added_to_cart', function () {
                $('a.added_to_cart').removeClass('hide');
                $('.single_add_to_cart_button').addClass('added').removeClass('loading');
            });

            //listen to event of add to wishlist
            $(document.body).on('added_to_wishlist', function () {
                $('.fixed-add-to-cart .yith-wcwl-add-button').removeClass('show').addClass('hide');
                $('.fixed-add-to-cart .ajax-loading').css('visibility', 'hidden');
                $('.fixed-add-to-cart .yith-wcwl-wishlistaddedbrowse').removeClass('hide').addClass('show');
            });

            setTimeout(function () {
                // When the variation is revealed
                $("form.variations_form").on('show_variation', function (event, variation, purchasable) {
                    $('.fixed-add-to-cart a.added_to_cart').addClass('hide');
                    $('.fixed-add-to-cart a.single_add_to_cart_button').removeClass('added');
                });

            }, 200);


        },

        fixedAddToCartVisibility: function () {

            var self = this;

            if ($('div.product.parent_div_product').length <= 0 || !self.$body.hasClass('fixed-add-to-cart-enable') || $('.kt_product_page > div.product').hasClass('outofstock')) {
                $('.fixed-add-to-cart, .scrolltotop').removeClass('visible');
                return;
            }

            if ( self.$body.find( '.summary form.gift-cards_form' ).length ) {
                return;
            }

            var latestKnownScrollPosition = 0,
                tick = false,
                visibilityThreshold = 50,
                visibilityRangeStart = $('a.single_add_to_cart_button').eq(0).offset().top,
                visibilityRangeEnd = self.documentHeight - self.windowHeight - visibilityThreshold,//50px before footer
                $fixedAddToCart = $('.fixed-add-to-cart-container'),
                $scrollToTop = $(".scrolltotop"),
                isVerticalMenu = self.$body.hasClass('vertical_menu_enabled');

            if ($('table.variations').length > 0) {
                visibilityRangeStart = $('table.variations').offset().top;
            }

            var updateFxedAddToCartPosition = function () {

                if (latestKnownScrollPosition >= visibilityRangeStart /* && (isVerticalMenu) */) {
                    $fixedAddToCart.addClass('visible');
                    $scrollToTop.addClass('visible');
                }
                else {
                    $fixedAddToCart.removeClass('visible');
                    $scrollToTop.removeClass('visible');
                }

                tick = false;
            }

            updateFxedAddToCartPosition();

            var updateRange = function () {
               visibilityRangeEnd = self.documentHeight - self.windowHeight;
            }

            var doUpdateRange = function () {
                setTimeout(updateRange, 1000); // wait 1s to get correct document height
            }

            doUpdateRange()// update end of visibility range

            self.$window.on('document-height-changed', updateRange);

            var requestTick = function () {
                if (tick == false) {
                    window.requestAnimationFrame(updateFxedAddToCartPosition);
                }
                tick = true;
            }

            var onScroll = function () {
                latestKnownScrollPosition = self.$window.scrollTop();
                requestTick();
            }

            self.$window.on('scroll', onScroll);

            self.$window.one('djaxClick', function () {
                self.$window.unbind('scroll', onScroll).unbind('document-height-changed', updateRange);
            });

        },

        fixedProductStyle: function () {
            if ( $('.product.pd_fixed_summary').length != 0 && $(window).width() >= 979 ) {
                $('.product.pd_fixed_summary #product-fullview-thumbs').waitForImages(function(){
                    var $productSummary = $('.summary.entry-summary'),
                        $productSummaryHeight = $productSummary.height(),
                        summaryOffset = $('.summary').offset().top,
                        maxWidth = $('.images').width(),
                        windowWidth = $(window).height();

                    var imagesHeight = $('.images').height();
                    var imagesHeightAndOffset = imagesHeight + summaryOffset;
                    var menuHeight = $('#headerfirststate').outerHeight();
                    var topbarHeight = $('#topbar').height();
                    var offset = 0,
                        absoluteTrigger = 0;
                    if ( $('#wpadminbar').length ) {
                        var wpAdminBarHeight = $('#wpadminbar').height();
                    } else {
                        var wpAdminBarHeight = 0;
                    }

                    if ( $('#kt-header').hasClass('normal-menu') ) {
                        menuHeight = 0;
                        topbarHeight = 0;
                        summaryOffset = summaryOffset - wpAdminBarHeight - 32;
                        offset = wpAdminBarHeight + 32;
                    }

                    if ( $('#headersecondstate').length > 0 ) {
                        menuHeight = $('#headersecondstate').outerHeight();
                        summaryOffset = summaryOffset - menuHeight - wpAdminBarHeight - 32;
                        offset = menuHeight + wpAdminBarHeight + 32;
                    }

                    if ($('#kt-header').hasClass('fixed-menu')) {
                        menuHeight = $('#headerfirststate').outerHeight();
                        summaryOffset = summaryOffset - wpAdminBarHeight - menuHeight - topbarHeight - 32;
                        offset = topbarHeight + menuHeight + wpAdminBarHeight + 32;
                    }

                    var checkFirst = function () {
                        absoluteTrigger = $(document).scrollTop() + $productSummaryHeight + menuHeight + topbarHeight + wpAdminBarHeight + 32;
                        if ( absoluteTrigger >= imagesHeightAndOffset ) {
                            if ($('#headersecondstate').length > 0) {
                                var top = imagesHeight - $productSummaryHeight - 32;
                            } else {
                                var top = imagesHeight - $productSummaryHeight;
                            }
                            $('.summary').css({
                                'position': 'absolute',
                                'top': top,
                                'left': '50%',
                                'width': '50%',
                                'max-width': maxWidth
                            });

                        }
                        if ( $(document).scrollTop() >= summaryOffset && absoluteTrigger < imagesHeightAndOffset ) {
                            $productSummary.addClass('fixed');
                            $('.summary').css({
                                'position': 'fixed',
                                'top': offset,
                                'left': '50%',
                                'width': '50%',
                                'padding-left': '0px',
                                'max-width': maxWidth,
                            });
                        } else if ($(document).scrollTop() < summaryOffset) {
                            $productSummary.removeClass('fixed');
                            $('.summary').removeAttr('style');
                        }

                    }
                    checkFirst();
                    $(document).scroll(function () {
                        checkFirst();
                    });
                });
            }
        },

        // product 360 view
        product360View: function () {

            var $product360ViewContainer = $("#product-360-view-container"),
                $product360ViewButton = $("#product_360_view_popup"),
                $product360ViewClose = $(".product-360-view-close");

            if (($product360ViewContainer.length) > 0) {
                var load = document.getElementById('circularloader').getContext('2d');
                var al = 0,
                    start = 4.72,
                    ew = load.canvas.width,
                    eh = load.canvas.height,
                    diff;

                var progressSim = function () {
                    diff = ((al / 100) * Math.PI * 2 * 10).toFixed(2);
                    load.clearRect(0, 0, ew, eh);
                    load.lineWidth = 5;
                    load.fillStyle = '#000';
                    load.strokeStyle = "#000";
                    load.textAlign = "center";
                    load.font = "30px monospace";
                    load.fillText(al + '%', ew * .52, eh * .5 + 5, ew + 12);
                    load.beginPath();
                    load.arc(100, 100, 75, start, diff / 10 + start, false);
                    load.stroke();
                    $('#circularloader').css('display', 'block');
                    $('.kite-threed-view').css('display', 'none');
                    al++;
                    if ( al > 100 ) {
                        clearTimeout(sim);
                        $('#circularloader').css('display', 'none');
                        $('.kite-threed-view').css('display', 'block');
                    }

                }
                var sim = setInterval(progressSim, 100);
            }

            // when users click on the popup button, show the gallery 360
            $product360ViewButton.click(function () {
                $product360ViewContainer.css('display', 'block');
            });

            // When the user clicks on the X button, close it
            $product360ViewClose.click(function () {
                $product360ViewContainer.css('display', 'none');
            });

            //when users press ESC button, close the modal
            $("body").keyup(function (event) {
                if (event.which === 27) {
                    $product360ViewContainer.css('display', 'none');
                }
            });

        },

        /*-----------------------------------------------------------------------------------*/
        /*  tabs
        /*-----------------------------------------------------------------------------------*/

        tabsTourAccordion: function () {

            var self = this;
            if ($('.vc_tta-panels-container .vc_tta-panel').not('.show')) {
                $('.vc_tta-panels div:nth-child(1)').addClass('show vc_active');
            }

            // tabsTourAccordion Height
            self.tabsTourAccordionHeight();

            //Tab & Tour
            $('.vc_tta-container .vc_tta-tabs .vc_tta-tabs-list a').addClass('no_djax').on('click', function (e) {
                // Fixing tab issue when clicking (Jump to content bug)
                e.preventDefault();


                var $currentTab = $(this);
                if ( $currentTab.closest('ul').hasClass('ui-sortable') ) {
                    var ttaTab = ('data-vc-target');
                } else {
                    var ttaTab = ('href');
                }

                var $container = $currentTab.closest('.vc_tta-container'),
                    $currentPanelID = $($currentTab.attr(ttaTab)),
                    $previousTabID = $($currentTab.closest('.vc_tta-tabs-list').find('.vc_active a').attr(ttaTab));

                if ($currentTab.closest('li').hasClass('vc_active'))
                    return;

                //activate new tab
                $container.find('.vc_tta-tabs-list li.vc_active').removeClass('vc_active');
                $currentTab.closest('li').addClass('vc_active');
                $previousTabID.removeClass('vc_active');

                $container.find('.vc_tta-panel').removeClass('show');
                $currentPanelID.addClass('show');
                $currentPanelID.addClass('vc_active');
                fixTabContentScripts($currentPanelID);


            });

            //Accordion
            $('.vc_tta-accordion .vc_tta-panel-heading a').on('click', function (e) {
                e.preventDefault();

                var $currentTab = $(this);
                if ( $currentTab.closest('.vc_tta-panels').hasClass('ui-sortable') ) {
                    var ttaAcc = ('data-vc-target');
                } else {
                    var ttaAcc = ('href');
                }

                var $container = $currentTab.closest('.vc_tta-accordion'),
                    $activeTabID = $($currentTab.attr(ttaAcc)),
                    $previousTabID = $($currentTab.closest('.vc_tta-panels').find('.vc_active a').attr(ttaAcc));

                //activate new tab
                if ( $container.hasClass('vc_tta-o-all-clickable') ) {
                    $activeTabID.toggleClass('vc_active');
                    $activeTabID.find('.vc_tta-panel-body').slideToggle();
                } else {
                    if ($activeTabID.hasClass('vc_active')) {
						return;
					}

                    $container.find('.vc_tta-panel.vc_active').removeClass('vc_active');
                    $activeTabID.addClass('vc_active');

                    $previousTabID.find('.vc_tta-panel-body').slideUp();
                    $previousTabID.find('.vc_tta-panel-heading').removeClass('vc_active');
                    $activeTabID.find('.vc_tta-panel-body').slideDown();
                    $activeTabID.find('.vc_tta-panel-heading').addClass('vc_active');
                }

            });

            var fixTabContentScripts = function ($activeTabID) {
                if ($activeTabID.find('.products.isotope').length > 0) {
                    $activeTabID.find('.products.isotope').isotope('destroy');
                }

                var $tabsParent = $activeTabID.closest('.vc_tta-panels');


                //Products
                self.productThumbnails();
				self.stickyProductThumbnails();
                self.productVariation();
                self.productProgressBar();

                self.runIsotopeInProducts($activeTabID);

                //Carousel
                self.carousel($activeTabID);

                //shortcodes
                self.shortcode(true);

                //product "info on click" style
                self.productsInfoOnClick();

                // tabsTourAccordion Height
                self.tabsTourAccordionHeight();

            }
        },

        tabsTourAccordionHeight: function () {

            if ( ! $('.vc_tta-container .vc_general').length ) { 
				return; 
			}
            $('.vc_tta-container .vc_general').each(function () {
                var $this = $(this);
                //Tabs & tour
                if ($this.hasClass('vc_tta-tabs')) {
                    var childsHeight = [];
                    $this.find('.vc_tta-panel').each(function () {
                        childsHeight.push($(this).outerHeight());
                    });
                    $this.find('.vc_tta-panels').css('min-height', Math.min.apply(null, childsHeight));


					$this.find('.vc_tta-panel.vc_active').addClass('show');
                } else if ($this.hasClass('vc_tta-accordion')) { //Accordion
                    $this.find('.vc_tta-panel:not(.vc_active) .vc_tta-panel-body').slideUp();
                }
            });
        },
        tabScrollbar: function () {
            if ( $(window).width() > 1025 ) {
				return;
			}
            var $tabList = $('.vc_tta-tabs-position-top .vc_tta-tabs-list,.vc_tta-tabs-position-bottom .vc_tta-tabs-list');
            var $tabListItem = $('.vc_tta-tabs-position-top .vc_tta-tabs-list > li,.vc_tta-tabs-position-bottom .vc_tta-tabs-list > li');
            if ( $tabList.parents('.ajax_products_tab').length ) {
                return;
            }
            if ($tabList.find('.swiper').length == 0) {
                $tabListItem.wrap('<div class="swiper-slide" style="width:fit-content;"></div>');
                $tabListItem.first().parent('.swiper-slide').addClass('swiper-slide-active');
                $tabList.wrapInner('<div class="swiper"><div class="swiper-wrapper"></div><div class="swiper-scrollbar"></div></div>')
            }
            var $scrollContainer = $tabList.find('.swiper');

            var swiper = new Swiper($scrollContainer[0], {
                scrollbar: {
                    el: '.swiper-scrollbar',
                    hide: false,
                    draggable: true,
                },
                direction: 'horizontal',
                slidesPerView: 'auto',
                mousewheelControl: true,
                freeMode: true,
                touchReleaseOnEdges: true,
                mousewheelReleaseOnEdges: true,
                mousewheelSensitivity: .6,
                watchSlidesProgress: true,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
            });
            $('.swiper-scrollbar-drag').each(function () {
                if ($(this).width() == $(this).parents('.swiper-scrollbar').width() || ($(this).width() > ($(this).parents('.swiper-scrollbar').width() - 5))) {
                    $(this).parents('.swiper-scrollbar').hide();
                } else {
                    $(this).parents('.swiper-scrollbar').show();
                }
            });
        },

        boughtTogetherProduct: function() {
            var $btProduct = $('#bt-product-summary');
            if ($btProduct.length <= 0) {
                return;
            }
            var $priceAt = $btProduct.find('.bt-total-price .woocommerce-Price-amount'),
                $btVal = $btProduct.find("input[name='add-to-cart']"),
                $button = $btProduct.find('.single_add_to_cart_button'),
                totalPrice = parseFloat($btProduct.find('#bt-data_price').data('price'));

            $('.bt-check-product').click(function(){
                var id = $(this).closest('li').find('a').data('id');
                var currentPrice = parseFloat($(this).closest('li').find('.s-price').data('price'));
                if($(this).is(":not(:checked)")){
                    $(this).addClass('uncheck');
                    $btProduct.find('.post-' + id).addClass('deactive');
                    totalPrice -= currentPrice;
                } else {
                    $btProduct.find('.post-' + id).removeClass('deactive');
                    $(this).removeClass('uncheck');
                    totalPrice += currentPrice;
                }

                var $productIDs = $('.bt-check-current-product').closest('li').find('a').data('id');
                $btProduct.find('.products-list li .bt-check-product').each(function () {
                    if (!$(this).hasClass('uncheck')) {
                        $productIDs += ',' + $(this).closest('li').find('a').data('id');
                    }
                });

                $btVal.attr('value', $productIDs);
                $button.attr('value', $productIDs);
                $priceAt.html((totalPrice));
            });


        },
        
        buyNow: function() {
            $('.single_add_to_cart_button.buy-now.disabled').on( 'click', function(e){
                e.preventDefault();
            })
        },

    };

    kiteTheme = Object.assign( kiteTheme, singleProduct );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($){
    kiteTheme.initSingleProduct();
    $(document).on( 'ready', function(){
        kiteTheme.productImageZoom();
    });
    $(window).on( 'resize', function(){
        kiteTheme.singleProductResizeEvent();
    });
})(jQuery);