/*-----------------------------------------------------------------------------------*/
/*  Woocommerce
/*-----------------------------------------------------------------------------------*/

( function ( kiteTheme, $ ) {
    'use strict';

    kiteTheme = kiteTheme || {};

    var woocommerce = {

        initWoocommerce: function () {
            this.woocommerceCats();
            this.cartWidgetUpdate();
            this.wishlistWidgetUpdate();
            this.wishlistButton();
            this.wishlistRemove();
            this.addToCart();
            this.addToCartEvents();
            this.addToCartVariationGroup();
            this.wcNotices();
            this.updateNotices();
            this.runIsotopeInProducts();
            this.updateWidgetCartOnCartPage();
            this.miniCartQuantityUpdate();
            this.miniCartEmptyCheck();
            this.catWidgetUpdate();
            this.catWidget();
            this.sortingPopup();
            this.accountPopup();
            this.recentlyViewedSlider();
            this.productProgressBar();
            this.shopHistory();
            this.productQuantity();

            if ($('#main-content').length) {
                this.lazyLoadSkeletonStyle('#main-content, .togglesidebar');
            } else {
                this.lazyLoadSkeletonStyle('body > .wrap, .togglesidebar');
            }
        },

        woocommerceResizeEvent: function(){
            this.runIsotopeInProducts();
        },

        /*-----------------------------------------------------------------------------------*/
        /*  Woocommerce categories
        /*-----------------------------------------------------------------------------------*/

        woocommerceCats: function () {
            var self = this;
            if ($(".product-category a").length <= 0) {
                return;
            }

            self.interactiveBackground( $('.product-category a') );
        },

        /*-----------------------------------------------------------------------------------*/
        /*  product cart widget,Cart page
        /*-----------------------------------------------------------------------------------*/

        cartWidgetUpdate: function () {
            var self = this;

            $(".mini_cart_item a.remove").addClass('no_djax');
            self.$document.off("click", ".mini_cart_item a.remove").addClass('no_djax');//unbind all functions binded to click to prevent unwanted behaviors
            self.$document.on("click", ".mini_cart_item a.remove", function (e) {

                e.preventDefault();
                var $this = $(this);
                var $productKey = $(this).data("item-key");

                $this.closest('li').addClass('loading');
                $this.siblings('.wc-loading').removeClass('hide');

                // Ajax action
                $.ajax({
                    url: kite_theme_vars.ajax_url,
                    dataType: 'json',
                    type: 'POST',
                    cache: false,
                    headers: { 'cache-control': 'no-cache' },
                    data: {
                        'action': 'cart_remove_item',
                        'item_key': $productKey
                    },
                    success: function (response) {

                        if (response.status === '1') {
                            $this.siblings('.wc-loading').addClass('hide');
                            $this.addClass('removed').closest('li').addClass('removed').removeClass('loading');

                            // Update cart item count
                            $('.cartcontentscount, .kt-cart .kt-count').html(response.cart_count);
                            $('.kt-cart .kt-amount').html(response.cart_subtotal);

                            // Is the cart empty?
                            if (response.cart_count == 0) {
                                $('.widget_shopping_cart_content .cart_list').addClass('empty-cart');
                                $('.cart-bottom-box').addClass('hide');
                            } else {
                                // Update cart subtotal
                                $('.cart-bottom-box .amount').html($(response.cart_subtotal).html());
                                if ( response.percentage !== undefined ) {
                                    if ( $('.kt-free-shipping-notice').length ) {
                                        $('.kt-free-shipping-notice').removeClass('kt-complete');
                                        $('.kt-free-shipping-notice').find('span.text').html(response.free_shipp_text);
                                        $('.kt-fill-free-shipping').css( 'width', response.percentage+'%');
                                    } else {
                                        var $free_notice_html = "<div class='kt-free-shipping-notice'><span class='kt-fill-free-shipping'></span><span class='icon icon-notification'></span><span class='text'>"+response.free_shipp_text+"</span></div>";
                                        $('.cart-bottom-box').prepend($free_notice_html);
                                        $('.kt-fill-free-shipping').css( 'width', response.percentage+'%');

                                    }
                                }
                            }
                        }

                        // Wait 3 second to get chance of undoing item
                        setTimeout(function () {
                            if ($this.closest('li').hasClass('removed')) {
                                $this.closest('li').find('.undo').hide('slow');

                                //after removing item from cart sidebar in cart page, cart page should be refreshed
                                if (self.$body.hasClass('woocommerce-cart')) {
                                    $(document).trigger('wc_update_cart');
                                    $(document.body).trigger( 'removed_from_cart', null, null, $this );
                                }
                            }
                        }, 3100);

                        setTimeout(function () {
                            if ($this.hasClass('removed')) {
                                $this.closest('li').addClass('removed_completly');
                                $(document).trigger('cart_item_removed_completely');
                            }
                        }, 3500);

                        $(document).trigger('wc_cart_updated');

                    }
                });
            });

            var ajaxCompleteHandler = function (event, xhr, settings) {

                if ( settings.url.indexOf('undo_item') > 0 ) {
                    setTimeout(function () {
                        $(document.body).trigger('wc_fragment_refresh');
                    }, 50)

                }
            }

            $(document).ajaxComplete(ajaxCompleteHandler);

            $(".mini_cart_item a.undo").addClass('no_djax');//unbind all functions binded to click to prevent unwanted behaviors
            self.$document.off("click", ".mini_cart_item a.undo");//unbind all functions binded to click to prevent unwanted behaviors
            self.$document.on("click", ".mini_cart_item a.undo", function (e) {
                e.preventDefault();
                var $this = $(this),
                    $productKey = $(this).data("item-key");

                $this.closest('li').removeClass('removed').addClass('loading');
                $this.siblings('a.remove').removeClass('removed');
                $this.siblings('.wc-loading').removeClass('hide');

                // Ajax action
                $.ajax({
                    url: kite_theme_vars.ajax_url,
                    dataType: 'json',
                    type: 'POST',
                    cache: false,
                    headers: { 'cache-control': 'no-cache' },
                    data: {
                        'action': 'undo_removed_item',
                        'item_key': $productKey
                    },
                    success: function (response) {

                        if ( response.status === '1' ) {
                            $this.siblings('.remove').removeClass('removed').end().closest('li').removeClass('removed loading');
                            $this.siblings('.wc-loading').addClass('hide');

                            // Update cart item count & cart subtotal
                            $('.cartcontentscount, .kt-cart .kt-count').html(response.cart_count);
                            $('.kt-cart .kt-amount').html(response.cart_subtotal);
                            $('.cart-bottom-box .amount').html($(response.cart_subtotal).html());
                            $('.cart-bottom-box').removeClass('hide');

                            //after undoing item from cart sidebar in cart page, cart page should be refreshed
                            if ( self.$body.hasClass('woocommerce-cart') ) {
                                $(document).trigger('wc_update_cart');
                            }
                            $(document).trigger('wc_cart_updated');
                        }
                    }
                });
            });
        },

        /*-----------------------------------------------------------------------------------*/
        /*  product  wishlist widget
        /*-----------------------------------------------------------------------------------*/

        wishlistWidgetUpdate: function () {
            var self = this;
            //Update it when a product added or removed to/from wishlist
            self.$body.on('added_to_wishlist removed_from_wishlist', function () {
                $.ajax({
                    url: kite_theme_vars.ajax_url,
                    data: {
                        'action': 'get_wishlist_quantity',
                        'security': kite_theme_vars.nonce
                    },
                    method: 'GET',//Use get to retrive data from server faster
                    success: function (data) {
                        $(".wishlist-content div.wishlist-contentcount, .kt-header-button.kt-wishlist .kt-total").html(data['wishlist_count_products']);
                    }
                });

                var $clicked_add_to_wishlist = self.$document.find('.add_to_wishlist.adding');
                $clicked_add_to_wishlist.find('.wc-loading').addClass('hide');
                $clicked_add_to_wishlist.fadeOut(400).siblings('.wishlist-link').fadeIn(400);

                self.addToCart();
                self.minPageHeightSet();
            });
        },

        /*-----------------------------------------------------------------------------------*/
        /* Wishlist remove item
        /*-----------------------------------------------------------------------------------*/
        wishlistButton: function () {
            var self = this;

            self.$document.on('click', '.add_to_wishlist', function () {
                if ($(this).hasClass('shop_wishlist_button') || $(this).hasClass('single_add_to_wishlist')) {
                    $(this).addClass('adding').find('.wc-loading').removeClass('hide');
                }
            });
        },

        /*-----------------------------------------------------------------------------------*/
        /* Wishlist remove item
        /*-----------------------------------------------------------------------------------*/

        wishlistRemove: function () {
            var self = this;

            self.$document.on('click', '.remove_from_wishlist', function (e) {
                e.preventDefault();
                $(this).addClass('show-loading').find('.wc-loading').removeClass('hide');
            });
        },

        /*------------------------------------------------------------------------------*/
        /*  Add To Cart - Open Toggle Sidebar When click On Add to cart Buttons
        /*------------------------------------------------------------------------------*/

        addToCart: function () {

            // check if there is any cart button with dropdown style in header or not
            if ($('.kt-header-button.kt-cart .widget_shopping_cart_content').length && $(window).width() > 1024) {
                var $dropdownCarts = $('.kt-header-button.kt-cart .widget_shopping_cart_content');
                if ($dropdownCarts.length > 1) {
                    for (let index = 0; index < $dropdownCarts.length; index++) {
                        const $element = $($dropdownCarts[index]);
                        if ($element.parents('.elementor-hidden-desktop').length) {
                            continue
                        }
                        return;
                    }
                } else {
                    if (!$dropdownCarts.parents('.elementor-hidden-desktop').length) {
                        return;
                    }
                }
            }

            if ( $('body').hasClass('single-product') && $('body').hasClass('remove-ajax-add-to-cart') ) {
                return;
            }

            var self = this,
                $toggleSidebarContainer = $('.toggle-sidebar-container:not(.filtersidebar)'),
                $cartSidebarContainer = $('.cart-sidebar-container');

            // Open the Toggle Sidebar When Click On Add To Cart Buttons
            self.$document.on('click', ".add_to_cart_button:not(.product_type_variable) , .single_add_to_cart_button", function (e) {
                //Ignore affilate products

                var $this = $(this);
                if (!$this.is('.ajax_add_to_cart')) {
                    $this.parents('form').submit();
                    return;
                }

                e.preventDefault();

				// for fixed add to cart in variable and grouped product detail - prevent Add to cart open
                if ( $(this).parent().parent('.fixed-add-to-cart-container').find('.go-to-add-to-cart').length || $(this).hasClass('disabled') ) { 
                    return 0;
                }

				// is quick view window first wait 300ms then close it and then open sidebar cart.
                if ( self.$body.hasClass('modal-open') ) {

                    setTimeout(function () {
                        self.closeQuickView();
                    }, 300);

                    if ( !self.$body.hasClass('vertical_menu_enabled:not(humburger_menu_enabled)') ) {

                        setTimeout(function () {

                            self.$ktHeader.addClass('sidebar-toggle-open');
                            $toggleSidebarContainer.addClass('sidebar-toggle-open');
                            $cartSidebarContainer.addClass('sidebar-toggle-open');
                            $('.kt-header-builder-overlay').addClass('show');
                            $('.cart-sidebarbtn').addClass('active');
                            $('.scrolltotop').addClass('toggleOpen');

                        }, 600);
                    }

                } else {

                    if ($(this).parent().parent('.fixed-add-to-cart-container').length) { // is quick view window first wait 300ms then close it and then open sidebar cart.

                        $('.fixed-add-to-cart-container .fixed-add-to-cart').addClass('toggleOpen');
                        $('.scrolltotop').addClass('toggleOpen');

                    }

                    if ( !self.$body.hasClass('vertical_menu_enabled') ) {
                        self.$ktHeader.addClass('sidebar-toggle-open');
                        $toggleSidebarContainer.addClass('sidebar-toggle-open');
                        $cartSidebarContainer.addClass('sidebar-toggle-open');
                        $('.kt-header-builder-overlay').addClass('show');
                        $('.cart-sidebarbtn').addClass('active');
                    }

                }
                $(document.body).on('added_to_cart', function () {
                    if ($(window).width() > 768) {
                        $this.closest('div.product:not(.parent_div_product)').find('.added_to_cart_icon').css({
                            opacity: '1',
                            visibility: 'visible'
                        });
                    }
                    $this.removeClass('added');
                    self.infoonhoverAndClickAddedToCart($this);
                    $this.closest('div.product:not(.parent_div_product)').trigger('mouseout');
                });

            });
        },

        /*------------------------------------------------------------------------------*/
        /*  product variation adding to cart
        /*------------------------------------------------------------------------------*/

        addToCartEvents: function () {
            var self = this;

            // Updating cart and show loading
            $(document.body).on('adding_to_cart', function () {
                $('.cart-sidebar-container .cartsidebarwrap').addClass('updatingcart');
            });

            $(document.body).on('added_to_cart', function () {
                $('.cart-sidebar-container .cartsidebarwrap').removeClass('updatingcart');
                $(document.body).trigger('wc_fragment_refresh');
                $('.cartButtonClicked').addClass('haveItemInCart');
                $('.cartButtonClicked').removeClass('cartButtonClicked');
                $('.haveItemInCart').find('.add_to_cart_button.product_type_variable').removeAttr('style');
                $('.haveItemInCart').find('.price:not(.simpleprice)').removeAttr('style');
                $('.haveItemInCart').find('.simpleAddToCart').attr('style', 'display : none !important');
                $('.haveItemInCart').find('.product-quantity').addClass('disable');
                $('.haveItemInCart').find('.simpleprice').attr('style', 'display : none !important');
                $('.haveItemInCart').find('input[type="radio"]').prop('checked', false);
            });
            self.$document.on('added_to_cart wc_cart_updated', function () {

                $(".mini_cart_item a.remove, .mini_cart_item a.undo").addClass('no_djax');
                if ( $('body').hasClass('woocommerce-checkout') ) {
                    $( 'body' ).trigger( 'update_checkout' );
                }
            });
        },
        addToCartVariationGroup: function () {
            var self = this;

            // Ajax variation Product - add to cart
            self.$document.on('click', 'table.variations button.single_add_to_cart_button, .single_add_to_cart_button.product_type_variable , .single_add_to_cart_button.product_type_grouped', function (e) {

                if ( !$(this).is('.ajax_add_to_cart') ) {
                    $(this).parents('form').submit();
                    return;
                }

                var b = this;
                e.preventDefault();
                // AJAX add to cart request
                var $thisButton = $(this);

                if ($thisButton.hasClass('disabled')) {
					return;
				}

                if ( $thisButton.hasClass('product_type_variable') || $thisButton.hasClass('product_type_grouped') || $thisButton.parent('table.variations') ) {

                    $thisButton.addClass('loading');

                    var $productForm = $thisButton.closest('form');

                    if ( !$productForm.length ) {
                        return;
                    }

                    var data = {
                        product_id: $productForm.find("input[name*='add-to-cart']").val(),
                        product_variation_group_data: $productForm.serialize() // get variation and Group value
                    };

                    // Trigger event
                    $(document.body).trigger('adding_to_cart', [$thisButton, data]);

                    // Ajax action
                    $.ajax({
                        type: "POST",
                        url: "?add-to-cart=" + data.product_id + "&kt-ajax-add-to-cart=1",
                        data: data.product_variation_group_data,
                        dataType: "html",
                        cache: false,
                        headers: { 'cache-control': 'no-cache' },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {

                        },
                        success: function (response) {

                            if (!response) {
                                return;
                            }

                            if (response.error && response.product_url) {
                                window.location = response.product_url;
                                return;
                            }

                            // Redirect to cart option
                            if (wc_add_to_cart_params.cart_redirect_after_add === 'yes') {

                                window.location = wc_add_to_cart_params.cart_url;
                                return;

                            } else {

                                $(".widget_shopping_cart_content").html(response)
                                var $response = $(".widget_shopping_cart_content");
                                
                                if ($response.length > 1) {
                                    const parser = new DOMParser();
                                    const doc = parser.parseFromString(response, 'text/html');
                                    var fragments = {
                                        ".cartcontentscount": doc.querySelector('.cartcontentscount').outerHTML, // Count Of Items in Cart
                                        ".cart-bottom-box": doc.querySelector('.cart-bottom-box').outerHTML, // Count Of Items in Cart
                                        ".product_list_widget": doc.querySelector('.product_list_widget').outerHTML, // Cart items Detail
                                        ".wc-notice-content": doc.querySelector('.woocommerce-error, .woocommerce-message').outerHTML // Cart items Detail
                                    };
                                } else {
                                    var fragments = {
                                        ".cartcontentscount": $response.find(' .cartcontentscount'), // Count Of Items in Cart
                                        ".cart-bottom-box": $response.find('.cart-bottom-box'), // Count Of Items in Cart
                                        ".product_list_widget": $response.find('.product_list_widget'), // Cart items Detail
                                        ".wc-notice-content": $response.first().find('.woocommerce-error, .woocommerce-message') // Cart items Detail
                                    };
                                }

                                // Replace elements
                                $.each(fragments, function (selector, $element) {
                                    if ($element.length) {
                                        $(selector).each(function () {
                                            if ($(this).parents('.widget_shopping_cart_content').length) { // Check Only Replace ( Update ) Dom in the Cart Sidebar
                                                $(this).replaceWith($element);
                                            }
                                        });
                                    }
                                });

                                // Update Cart Count in the Menus
                                $(".widget_woocommerce-dropdown-cart .cart-contents .cartcontentscount").replaceWith('<div class="cartcontentscount">' + $response.find('.cartcontentscount').text() + '</div>');
                                $('.kt-cart .kt-count').html( $response.find('.cartcontentscount').text() );

                                // wait All Replace Elemets Complete then trigger added_to_cart ( cause Fading Effect seen )
                                setTimeout(function () {
                                    $(document.body).trigger("added_to_cart", fragments, null, $thisButton);
                                    $thisButton.removeClass('loading');
                                    $thisButton.removeClass('added');
                                }, 100);
                            }
                        }
                    });

                    return false;
                }

                return true;
            });
        },
        /*------------------------------------------------------------------------------*/
        /*  Notices : accoutnt pag and form validation of checkout field are ignored
        /*------------------------------------------------------------------------------*/
        wcNotices: function () {
            var self = this;
            if ( self.$body.hasClass('no_wc_notices') ) {
                return;
            }

            /* Detect notices on adding simple product to cart */
            self.$body.on('added_to_cart', function (event, fragments) {

                // update cart element count and subtotal
                if ( typeof fragments != 'undefined' && fragments['div.widget_shopping_cart_content'] != 'undefined' ) {
                    var _cart_count = $(fragments['div.widget_shopping_cart_content']).find('.cartcontentscount').html();
                    var _cart_subtotal = $(fragments['div.widget_shopping_cart_content']).find('.total .woocommerce-Price-amount.amount').html();

                    $('.kt-cart .kt-count').html( _cart_count );
                    $('.kt-cart .woocommerce-Price-amount.amount').html( _cart_subtotal );
                }

                if ( fragments === undefined || (fragments["div.widget_shopping_cart_content"] === undefined && $(fragments[".wc-notice-content"]).length <= 0) ) {

				}
                    

                var replacedBefore = false;

                var $returnedMessage = $(fragments["div.widget_shopping_cart_content"]).find('.woocommerce-error, .woocommerce-message');

                if ($(fragments[".wc-notice-content"]).length > 0)
                    replacedBefore = true;

                //check existance of new notice
                if ($returnedMessage.length > 0 || replacedBefore == true) {
                    self.updateNotices($returnedMessage, replacedBefore);
                }

            });

        },

        updateNotices: function ($wcNoticesInCart, replacedBefore) {
            var self = this,
                $wcNoticesContainer = $('#kt_wc_notices');

            setTimeout(function () {

                if (replacedBefore == true) {
                    $wcNoticesContainer.wrapInner('<div class="wc-notice-content"></div>');
                } else {
                    $wcNoticesContainer.html($wcNoticesInCart);
                }

                $wcNoticesContainer.addClass('show');
                self.wcNoticeTimer = setTimeout(function () {
                    $wcNoticesContainer.removeClass('show');
                }, 6000);

            }, 470)
        },

        /*----------------------------------------------------------------------------------*/
        /*  products isotope
        /*-----------------------------------------------------------------------------------*/

        runIsotopeInProducts: function ($mainContainer) {
            var self = this;
            // Gets column number and divides to get column width

            if ($mainContainer === undefined)
                $mainContainer = self.$body;

            //WC shortcodes + main shop page loop
            $mainContainer.find('.woocommerce.wc-shortcode:not(.carousel) .products, .products.main-shop-loop').each(function () {
                var $container = $(this);
                //Reset width to calculate colWidth correctly in resize
                $container.css('width', '');
                var layout = 'fitRows';

                if ($container.is('.main-shop-loop')) {
                    layout = $container.data('layoutmode');
                } else {
                    layout = $container.parent().data('layoutmode');
                }

                if (layout != 'fitRows') {
                    layout = 'masonry';
                }

                if ($container.parents('.woocommerce.wc-shortcode.list').length == 0) {
                    // fix isotop masonry layout not runs in first load but run in resize or click load more button
                    var itemsGutter = ( $container.parents('.woocommerce.wc-shortcode.no-gutter').length || ( $('body.woocommerce.no-gutter').length && $container.parents('.wc-ajax-content').length ) ) ? 0 : 10;
                    $container.isotope({
                        itemSelector: '.product',
                        layoutMode: layout,
                        [layout]: {
                            gutter: itemsGutter
                        },
                        originLeft: ( ! $('body').hasClass('rtl') )
                    }, self.showAnimation($container));
                } else {
                    self.showAnimation($container);
                }

            });
        },

        /*----------------------------------------------------------------------------------*/
        /*  Show minicart | Show cart on sidebar when go to page with ajax | Code : cart-fragments.js in woocommerce plugin
        /*-----------------------------------------------------------------------------------*/
        updateWidgetCartOnCartPage: function () {
            var self = this;
            //Use ajaxSend event to detect when it's needed to update cart
            var ajaxStartHandlerForCartPage = function (event, xhr, settings) {
                if (settings.url.indexOf('get_cart_totals') > 0) {
                    $(document.body).trigger('wc_fragment_refresh');
                }
            }

            // just do it in cart page
            if ( self.$body.hasClass('woocommerce-cart') ) {
                $(document).ajaxSend(ajaxStartHandlerForCartPage);
            }
        },

        miniCartQuantityUpdate: function () {
            var sendParam;
            $(document).on('click', '.kt-quantity-change .icon', function(){
                var $this = $(this);
                var itemKey = $this.parents('li').data('item-key'),
                    min = $this.parents('li').data('min'),
                    max = $this.parents('li').data('max'),
                    $quantityWrapper = $this.parents('.quantity');
                if ( ! $quantityWrapper.length || $this.parents('li').hasClass('loading') ) {
                    return;
                }

                var currnetQuantity = parseInt( $quantityWrapper.find('.kt-num').first().text() );
                var newQuantity = 0;
                max = ( max == -1 ) ? Infinity : max;
                if ( $this.hasClass('kt-plus') && currnetQuantity < max ) {
                    newQuantity = ++currnetQuantity;
                    $quantityWrapper.find('.kt-num').text( newQuantity );
                    clearTimeout( sendParam );
                }

                if ( $this.hasClass('kt-minus') && currnetQuantity > min ) {
                    newQuantity = --currnetQuantity;
                    $quantityWrapper.find('.kt-num').text( newQuantity );
                    clearTimeout( sendParam );
                }

                if ( newQuantity == 0 ) {
                    return;
                }

                sendParam = setTimeout( function(){
                    $this.parents('li').addClass('loading');
                    $this.parents('li').find('.wc-loading').removeClass('hide');
                    // Ajax action
                    $.ajax({
                        url: kite_theme_vars.ajax_url,
                        dataType: 'json',
                        type: 'POST',
                        cache: false,
                        headers: { 'cache-control': 'no-cache' },
                        data: {
                            'action': 'update_mini_cart_item',
                            'item_key': itemKey,
                            'quantity': newQuantity
                        },
                        success: function (response) {
                            $this.parents('li').removeClass('loading');
                            $this.parents('li').find('.wc-loading').addClass('hide');
                            if (response.status === '1') {

                                // Update cart item count
                                $('.cartcontentscount, .kt-cart .kt-count').html(response.cart_count);
                                $('.kt-cart .kt-amount').html(response.cart_subtotal);
                                // Is the cart empty?
                                if (response.cart_count == 0) {
                                    $('.product_list_widget').each(function () {
                                        $('.cart-bottom-box').addClass('hide');
                                    });
                                } else {
                                    // Update cart subtotal
                                    $('.cart-bottom-box .amount').html($(response.cart_subtotal).html());
                                    if ( response.percentage !== undefined ) {
                                        if ( $('.kt-free-shipping-notice').length ) {
                                            $('.kt-free-shipping-notice').removeClass('kt-complete');
                                            $('.kt-free-shipping-notice').find('span.text').html(response.free_shipp_text);
                                            $('.kt-fill-free-shipping').css( 'width', response.percentage+'%');
                                        } else {
                                            var $free_notice_html = "<div class='kt-free-shipping-notice'><span class='kt-fill-free-shipping'></span><span class='icon icon-notification'></span><span class='text'>"+response.free_shipp_text+"</span></div>";
                                            $('.cart-bottom-box').prepend($free_notice_html);
                                            $('.kt-fill-free-shipping').css( 'width', response.percentage+'%');

                                        }
                                    }
                                }
                                $(document).trigger('wc_cart_updated');
                            }

                        }
                    });
                },1500);
            });
        },

        miniCartEmptyCheck: function () {
            $(document).on('wc_fragment_refresh cart_item_removed_completely', function (fragments) {
                $('.widget_shopping_cart_content').each(function () {
                    if ($(this).children().length === 0) {
                        $(this).html(kite_theme_vars.empty_cart_markup);
                    } else {
                        var $cartList = $(this).find('ul');
                        if ($cartList.hasClass('empty-cart')) {
                            $(this).html(kite_theme_vars.empty_cart_markup);
                        }
                    }
                });
                
            });
        },

        catWidgetUpdate: function () { //add toggle button to category widget + show current category/subcategory
            var $widget = $('.widget_product_categories'),
                $list = $widget.find('.product-categories');

            if ( ! $list.find('.cat-parent').length ) {
               return;
            }

            $list.find('.cat-parent').each(function () {
                var $this = $(this);
                if ( $this.find('ul').length <= 0 ) {
                    return true;
                }

                if ($this.hasClass('current-cat-parent')) {
                    if ( $this.find('.cats-toggle').length ) {
                        $this.find('.cats-toggle').addClass('toggle-active');
                    } else {
                        $this.append('<div class="cats-toggle toggle-active"></div>');
                    }
                } else {
                    if (!$this.find('.cats-toggle').length) {
                        $this.append('<div class="cats-toggle"></div>');
                    }
                }
            });


            if ( $list.find('li.current-cat').length > 0 ) {
                $list.find('li.current-cat').parents('ul').css("display", "block");
                $list.find('li.current-cat ul.children').css("display", "block");
                $list.find('.current-cat.cat-parent .cats-toggle').addClass('toggle-active');
            }
        },

        catWidget: function () {
            var $widget = $('.widget_product_categories'),
                $list = $widget.find('.product-categories'),
                time = 500;
            $list.off('click','.cats-toggle');
            $list.on('click', '.cats-toggle', function () {
                var $btn = $(this),
                    $subList = $btn.prev();
                if ($subList.hasClass('list-shown')) {
                    $btn.removeClass('toggle-active');
                    $subList.stop().slideUp(time).removeClass('list-shown');
                }
                else {
                    $subList.parent().parent().find('> li > .list-shown').slideUp().removeClass('list-shown');
                    $subList.parent().parent().find('> li > .toggle-active').removeClass('toggle-active');
                    $btn.addClass('toggle-active');
                    $subList.stop().slideDown(time).addClass('list-shown');
                }
            });
        },

        sortingPopup: function () {
            var self = this,
                $sort = $('.navicons.sorting');
            $sort.on('click', function (e) {
                e.preventDefault();

                var $sortModal = self.$document.find('#kt-modal'),
                    $sortHead = $sortModal.find('.modal-head'),
                    $sortContent = $sortModal.find('#modal-content');

                if ( $sortModal.length <= 0 ) {
                    return;
                }

                $sortModal.addClass('hidden-nav');

                self.$body.addClass('modal-open'); // disable scrollbar
                $sortModal.addClass('sort-modal');
                $sortHead.append('<div class="title">' + kite_theme_vars.sort_by_text + '</div>');

                if ( !$sortModal.removeClass('closed').hasClass('open') ) {
                    $sortModal.removeClass('loading').addClass('open');
                }


                var $data = $('.shop-filter > .special-filter.sort ul.list').clone();

                $sortContent.html($data);
                // content is ready, so show it
                $sortModal.addClass('shown');

                // Close quickview by click outside of content
                $sortModal.on('click', function (e) {
                    if (!$sortContent.is(e.target) && $sortContent.has(e.target).length === 0) {
                        self.closeSortPopup();
                    }
                });

                // Close quickview by click close button
                self.$document.on('click', '#kt-modal.sort-modal #modal-close', function (e) {
                    e.preventDefault();
                    self.closeSortPopup();
                });

                // Close box with esc key
                self.$document.keyup(function (e) {
                    if (e.keyCode === 27) {
                        self.closeSortPopup();
                    }
                });

            });
        },
        closeSortPopup: function () {
            var self = this;

            var $sortModal = self.$document.find('#kt-modal.sort-modal'),
                $sortTitle = $sortModal.find('.modal-head .title'),
                $sortContent = $sortModal.find('#modal-content');

            $sortModal.removeClass('shown loading open').addClass('closed');

            setTimeout(function () {
                self.$body.removeClass('modal-open');
                $sortTitle.remove();
                $sortModal.removeClass('sort-modal');
            }, 0)

            setTimeout(function () {
                $sortContent.html('');
            }, 10);
        },
        accountPopup: function () {
            var self = this,
                $accountLink = $('.login-link-popup'),
                $topBarLoginLink = $('.topbar_login_link, .kt-header-button.kt-account');
            $topBarLoginLink.on('click', function (event) {
                $(this).toggleClass('hover');
            });
            $accountLink.on('click', function (e) {
                e.preventDefault();

                var $accountModal = self.$document.find('#kt-modal'),
                    $accountContent = $accountModal.find('#modal-content');

                if ( $accountModal.length <= 0 ) {
                    return;
                }


                $accountModal.addClass('hidden-nav');

                self.$body.addClass('modal-open'); // disable scrollbar
                $accountModal.addClass('account-modal');

                if ( !$accountModal.removeClass('closed').hasClass('open') ) {
                    $accountModal.removeClass('loading').addClass('open');
                }


                var $data = $('#customer_login.hide-login').clone().removeClass('hide-login');
                $data.find('form').removeAttr('style');
                $accountContent.html($data);
                $accountModal.addClass('shown'); // content is ready, so show it


                // Close quickview by click outside of content
                $accountModal.on('click', function (e) {
                    if (!$accountContent.is(e.target) && $accountContent.has(e.target).length === 0) {
                        self.closeAccountPopup();
                    }
                });

                // Close quickview by click close button
                self.$document.on('click', '#kt-modal.account-modal #modal-close', function (e) {
                    e.preventDefault();
                    self.closeAccountPopup();
                });

                // Close box with esc key
                self.$document.keyup(function (e) {
                    if (e.keyCode === 27) {
                        self.closeAccountPopup();
                    }
                });

            });

        },
        closeAccountPopup: function () {
            var self = this;

            var $accountModal = self.$document.find('#kt-modal.account-modal'),
                $accountContent = $accountModal.find('#modal-content');

            $accountModal.removeClass('shown loading open').addClass('closed');

            setTimeout(function () {
                self.$body.removeClass('modal-open');
                $accountModal.removeClass('account-modal');
            }, 300)

            setTimeout(function () {
                $accountContent.html('');
            }, 300);
        },

        recentlyViewedSlider: function () {
            $('.showrecentproduct').on('click', function (event) {
                if ($('.showrecentproduct').hasClass('disable')) {
                    $('.showrecentproduct').removeClass('disable');
                    $('.showrecentproduct').addClass('enable');
                    $('.showrecentproduct').find('i').removeClass('up');
                    $('.showrecentproduct').find('i').addClass('down');
                    $('.recentproduct.overlay').addClass('show');
                    $('.recentproduct.products').addClass('show');
                } else {
                    $('.showrecentproduct').removeClass('enable');
                    $('.showrecentproduct').addClass('disable');
                    $('.showrecentproduct').find('i').removeClass('down');
                    $('.showrecentproduct').find('i').addClass('up');
                    $('.recentproduct.overlay').removeClass('show');
                    $('.recentproduct.products').removeClass('show');
                }
            });

            var numOfItems = $('.viewed-products').attr('data-num-of-prd');
            if ( numOfItems > 10 ) {
                var loop = true;
            } else {
                var loop = false;
            }

            var $recentproductNum = 10;

            var $nextButton = $('.viewed-products').find('.arrow-button-next'),
                $prevButton = $('.viewed-products').find('.arrow-button-prev');
            var loop = false;
            if ( $('.viewed-products').hasClass('single-product') ) {
                var $recentproductNum = 5;
                if ( numOfItems > 5 ) {
                    loop = true;
                    if ($(window).width() > 480 && numOfItems < 6) {
                        $nextButton.remove();
                        $prevButton.remove();
                        $nextButton = '';
                        $prevButton = '';
                    }
                }
            } else {
                var $recentproductNum = 10;
                if ( numOfItems > 10 ) {
                    loop = true;
                    if ( $(window).width() > 480 && numOfItems < 10 ) {
                        $nextButton.remove();
                        $prevButton.remove();
                        $nextButton = '';
                        $prevButton = '';
                    }
                }
            }
            var swiper = new Swiper('.recently-viewed-product', {
                autoplay: false,
                spaceBetween: 10,
                loop: loop,
                slidesPerView: $recentproductNum,
                watchSlidesProgress: true,
                navigation: {
                    nextEl: $nextButton[0] ?? '',
                    prevEl: $prevButton[0] ?? '',
                },
                // Responsive breakpoints
                breakpoints: {
                    // when window width is >= 320px
                    320: {
                        slidesPerView: 1,
                    },
                    // when window width is >= 365px
                    365: {
                        slidesPerView: 2,
                    },
                    480: {
                        slidesPerView: 3,
                    },
                    768: {
                        slidesPerView: 6,
                    },
                    1170: {
                        slidesPerView: $recentproductNum
                    }
                },
            });
            var swiper = new Swiper('.recently-viewed-product-style', {
                autoplay: false,
                spaceBetween: 10,
                loop: loop,
                slidesPerView: $recentproductNum,
                watchSlidesProgress: true,
                navigation: {
                    nextEl: $nextButton[0] ?? '',
                    prevEl: $prevButton[0] ?? '',
                },
                // Responsive breakpoints
                breakpoints: {
                    // when window width is >= 320px
                    320: {
                        slidesPerView: 1,
                    },
                    // when window width is >= 480px
                    365: {
                        slidesPerView: 2,
                    },
                    480: {
                        slidesPerView: 3,
                    },
                    768: {
                        slidesPerView: 4,
                    },
                    1170: {
                        slidesPerView: $recentproductNum
                    },
                },
            });
            // hide recently viewed products when clicking on overlay
            $('.recentproduct.overlay').on('click', function (event) {
                $('.showrecentproduct').trigger('click');
            });
            // hide recently viewed products when reaching to the footer
            $(window).scroll(function () {
                var $footer = $('.footer-bottom, div[data-elementor-type="footer"]');
                if (!$footer.length) {
                    return;
                }
                var $docViewTop = $(window).scrollTop();
                var $docViewBottom = $docViewTop + $(window).height();
                var $elementTop = $footer.offset().top;
                if ($docViewBottom >= $elementTop) {
                    if (!$('.showrecentproduct').hasClass('disable')) {
                        $('.showrecentproduct').trigger('click');
                    }
                    $('.showrecentproduct').hide();
                    if ($('.footer-bottom').hasClass('light')) {
                        $('.scrolltotop a').addClass('dark');
                    }
                } else {
                    $('.showrecentproduct').show();
                    $('.scrolltotop a').removeClass('dark');
                }
            });
        },

        productProgressBar: function () {
            var $barWidth = $('.progress-bar'),
                $productSummary = $('.summary.entry-summary');
            function barWidth() {
                var barWidth = $barWidth.width();
                $('.progress-fill-text').css('width', barWidth);
            }
            if ( $productSummary.length != 0 ) {
                barWidth();
            }
            $barWidth.each(function () {
                var $width = $(this).width();
                $(this).find('.progress-fill-text').css('width', $width);
            });
        },

        //a helper function to add/update querystrings of URL
        updateQueryStringParameter: function (uri, key, value) {
            var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
            var separator = uri.indexOf('?') !== -1 ? "&" : "?";
            if ( uri.match(re) ) {
                if ( value == '' ) {
                    return uri.includes('?') ? uri.replace(re, '?') : uri.replace(re, '');
                } else {
                    return uri.replace(re, '$1' + key + "=" + value + '$2');
                }
            } else if ( value != '' ) {
                return uri + separator + key + "=" + value;
            }
        },

        shopHistory: function() {
            var self = this,
                thisUrl = window.location.href;

            if ( $('body.is-woocommerce-shop').length || $('body.archive.tax-product_cat').length || $('body.archive.tax-product_tag').length ) {
                thisUrl = self.updateQueryStringParameter( thisUrl, 'sp', '');
                window.history.replaceState({ 'url': thisUrl, 'title': '' }, '', thisUrl);
                $(document).on('click', function(e){
                    if ( $(e.target).parents('.product').length ) {
                        $(window).on('beforeunload',function(){
                            var thisUrl = window.location.href;
                            thisUrl = self.updateQueryStringParameter( thisUrl, 'sp', 'infinite_scroll');
                            window.history.replaceState({ 'url': thisUrl, 'title': '' }, '', thisUrl);
                        });
                    } else {
                        $(window).off('beforeunload');
                    }
                });
            }
        },

        /*-----------------------------------------------------------------------------------*/
        /*  woocomerce -  product quantity input
        /*-----------------------------------------------------------------------------------*/

        productQuantity: function () {
            var self = this;

            self.$document.on("click", '.quantity .quantity-button', function () {
                var min = 0,
                    max = 0,
                    step = 1 ;

                if ( $(this).parent( '.quantity').find('input.qty').attr('min') !== '' ) {
                    min = $(this).parent( '.quantity').find('input.qty').attr('min')
                }

                if ( $(this).parent( '.quantity').find('input.qty').attr('max') !== '' ) {
                    max = $(this).parent( '.quantity').find('input.qty').attr('max')
                }

                if ( $(this).parent( '.quantity').find('input.qty').attr('step') !== '' ) {
                    step = $(this).parent( '.quantity').find('input.qty').attr('step')
                }

                var $button = $(this);
                var $quantityInput = $(this).parent( '.quantity').find('input.qty');


                var oldValue = $quantityInput.val();
                oldValue = ( oldValue == '' || isNaN(oldValue) ) ? 0 : oldValue;
                var newVal = oldValue;
                if ( $button.hasClass("plus") ) {
                    if ( max == 0 || ( parseFloat(oldValue) + parseFloat(step) ) <= max ) {
                        newVal = parseFloat(oldValue) + parseFloat(step);
                    }
                } else {
                    if (oldValue > 0) {
                        if ( min == 0 || ( parseFloat(oldValue) - parseFloat(step) ) >= min ) {
                            newVal = parseFloat(oldValue) - parseFloat(step);
                        }
                    }
                }
                if ( newVal !== oldValue ) {
                    $quantityInput.val(newVal).trigger('change');
                }

            });

            $(document).on('change', '.woocommerce .quantity input[type="number"]', function () {
                $(this).parent('.quantity').siblings('.add_to_cart_button').attr('data-quantity', $(this).val());
            });
        },

        lazyLoadSkeletonStyle: function (that) {
            var self = this,
                xhr = null;
            let $thatContainers = typeof that == 'string' ? document.querySelectorAll(that) : that.get();

            var lazy_load_callback = (entries) => {
                entries.forEach( entry => {
                    if ( entry.isIntersecting ) {
                        let $this = entry.target;
                        if ($this.classList.contains('skeleton') && !$this.classList.contains('request-sent') && !$this.classList.contains('main-shop-loop')) {
                            $this.classList.add('request-sent');
                            let $skeletonParent = $($this.parentNode);
                            var data = {
                                action: 'fetch_woocommerce_products_loop',
                                atts: $($this).data('shortcode-prop'),
                                kite_nonce: kite_theme_vars.nonce,
                                context: 'frontend'
                            };
                            xhr = $.ajax({
                                url: kite_theme_vars.ajax_url,
                                type: 'GET',
                                dataType: 'html',
                                data: data,
                            }).done(function (response) {
                                let isAjaxProductTab = $skeletonParent.parents('.ajax_products_tab').length ? true : false;
                                let $tabPanel = null;
                                if (isAjaxProductTab) {
                                    $tabPanel = $skeletonParent.parents('.vc_tta-panel');
                                }
                                $skeletonParent.replaceWith(response);
                                self.carousel();
                                self.runIsotopeInProducts();
                                self.lazyLoadOnLoad('.woocommerce .products')
                                self.lazyLoadOnHover($(response));
                                self.compare();
                                self.woocommerceVariationItemSelect();
                                self.woocommerceButtonsOnHoverCartClick();
                                self.mobileHoverState();
                                self.productsInfoOnClick();
                                self.productQuickView();
                                self.productProgressBar();

                                if (isAjaxProductTab) {
                                    $tabPanel.parents('.vc_tta-panels').attr('style', 'min-height:' + $tabPanel.height() + 'px !important;');
                                }

                                $(document).trigger('kite_ajax_products_loaded');
                            }).fail(function (response) {
                                $this.classList.remove('request-sent');
                            }).always(function () {

                            });
                        }
                    }
                })
            }

            let options = {
                root: null,
                rootMargin: '0px',
                threshold: 0
            }

            $thatContainers.forEach( $container => {
                let $lazyLoadCntainers = $container.querySelectorAll('.products.skeleton');
                if ($lazyLoadCntainers.length > 0) {

                    let observer = new IntersectionObserver( lazy_load_callback, options);
                    $lazyLoadCntainers.forEach( $lazyLoadElement => {
                        observer.observe( $lazyLoadElement );
                    })
                }
            })
        }
    };

    kiteTheme = Object.assign( kiteTheme, woocommerce );

} ).apply( this, [ window.kiteTheme, jQuery ] );

(function($){
    kiteTheme.initWoocommerce();
    $(window).on( 'resize', function(){
        kiteTheme.woocommerceResizeEvent();
    });

    $('body').on('woocommerce-content-updated', function () { 
        kiteTheme.runIsotopeInProducts();
    });

    $(window).on('elementor/frontend/init', function () {

        if ($('.kt_product_page').length) {
            if ($('.descriptionTab').find('section.elementor-section-stretched').length) {
                $('.descriptionTab').removeClass('container');
                $('.woocommerce-Tabs-panel').css('padding', '0');
                $('.descriptionTab').find('section').each(function () {
                    if (!$(this).hasClass('elementor-section-stretched')) {
                        $(this).addClass('container');
                        $(this).css('padding', '20px 0px');
                    }
                });
            }
        }

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-ajax-woocommerce-products.default', function ($scope) {
            kiteTheme.runIsotopeInProducts($scope);
        });

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-products.default', function ($scope) {
            kiteTheme.runIsotopeInProducts($scope);
            kiteTheme.productProgressBar();
        });

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-products-by-attribute.default', function ($scope) {
            kiteTheme.runIsotopeInProducts($scope);
        });

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-woocommerce-hand-picked-products.default', function ($scope) {
            kiteTheme.runIsotopeInProducts($scope);
        });

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-product-categories.default', function ($scope) {
            kiteTheme.runIsotopeInProducts($scope);
        });

        elementorFrontend.hooks.addAction('frontend/element_ready/kite-single-product.default', function ($scope) {
            kiteTheme.runIsotopeInProducts($scope);
        });
    });
})(jQuery);