{
    const mapNumber = (X,A,B,C,D) => (X-A)*(D-C)/(B-A)+C;
    // from http://www.quirksmode.org/js/events_properties.html#position
	const getMousePos = (e) => {
        let posx = 0;
        let posy = 0;
		if (!e) e = window.event;
		if (e.pageX || e.pageY) {
            posx = e.pageX;
			posy = e.pageY;
		}
		else if (e.clientX || e.clientY) 	{
			posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
			posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
		}
        return { x : posx, y : posy }
    }
    // Generate a random float.
    const getRandomFloat = (min, max) => (Math.random() * (max - min) + min).toFixed(2);

    // Effect 2
    class HoverImgFx2 {
        constructor(el) {
            this.DOM = {el: el};
            this.DOM.reveal = document.createElement('div');
            this.DOM.reveal.className = 'hover-reveal';
            this.DOM.reveal.innerHTML = `<div class="hover-reveal__inner"><div class="hover-reveal__img" style="background-image:url(${this.DOM.el.dataset.img})"></div></div>`;
            this.DOM.el.appendChild(this.DOM.reveal);
            this.DOM.revealInner = this.DOM.reveal.querySelector('.hover-reveal__inner');
            this.DOM.revealInner.style.overflow = 'hidden';
            this.DOM.revealImg = this.DOM.revealInner.querySelector('.hover-reveal__img');

            this.initEvents();
        }
        initEvents() {
            this.positionElement = (ev) => {
                const mousePos = getMousePos(ev);
                const docScrolls = {
                    left : document.body.scrollLeft + document.documentElement.scrollLeft, 
                    top : document.body.scrollTop + document.documentElement.scrollTop
                };
                this.DOM.reveal.style.top = `${mousePos.y+20-docScrolls.top}px`;
                if (document.body.classList.contains('rtl')) {
                    this.DOM.reveal.style.right = `${document.documentElement.clientWidth-mousePos.x+20-docScrolls.left}px`;
                } else {
                    this.DOM.reveal.style.left = `${mousePos.x+20-docScrolls.left}px`;
                }
            };
            this.mouseenterFn = (ev) => {
                this.positionElement(ev);
                this.showImage();
            };
            this.mousemoveFn = ev => requestAnimationFrame(() => {
                this.positionElement(ev);
            });
            this.mouseleaveFn = () => {
                this.hideImage();
            };
            
            this.DOM.el.addEventListener('mouseenter', this.mouseenterFn);
            this.DOM.el.addEventListener('mousemove', this.mousemoveFn);
            this.DOM.el.addEventListener('mouseleave', this.mouseleaveFn);
        }
        showImage() {
            if (window.innerWidth < 1140 )
                return;
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealImg);

            this.tl = new gsap.timeline({
                onStart: () => {
                    this.DOM.reveal.style.opacity = 1;
                    gsap.set(this.DOM.el, {zIndex: 1000});
                }
            })
            .add('begin')
            .add(gsap.to(this.DOM.revealInner, {
                duration: 0.4,
                ease: Quint.easeOut,
                startAt: {x: '-100%', y: '-100%'},
                x: '0%',
                y: '0%'
            }), 'begin')
            .add(gsap.to(this.DOM.revealImg, {
                duration: 0.4,
                ease: Quint.easeOut,
                startAt: {x: '100%', y: '100%'},
                x: '0%',
                y: '0%'
            }), 'begin');
        }
        hideImage() {
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealImg);

            this.tl = new gsap.timeline({
                onStart: () => {
                    gsap.set(this.DOM.el, {zIndex: 999});
                },
                onComplete: () => {
                    gsap.set(this.DOM.el, {zIndex: ''});
                    gsap.set(this.DOM.reveal, {opacity: 0});
                }
            })
            .add('begin')
            .add(gsap.to(this.DOM.revealInner, {
                duration: 0.3,
                ease: Quint.easeOut,
                x: '100%',
                y: '100%'
            }), 'begin')
            
            .add(gsap.to(this.DOM.revealImg, {
                duration: 0.3,
                ease: Quint.easeOut,
                x: '-100%',
                y: '-100%'
            }), 'begin');
        }
    }

    // Effect 4
    class HoverImgFx4 {
        constructor(el) {
            this.DOM = {el: el};
            this.DOM.reveal = document.createElement('div');
            this.DOM.reveal.className = 'hover-reveal';
            this.DOM.reveal.innerHTML = `<div class="hover-reveal__inner"><div class="hover-reveal__img" style="background-image:url(${this.DOM.el.dataset.img})"></div></div>`;
            this.DOM.el.appendChild(this.DOM.reveal);
            this.DOM.revealInner = this.DOM.reveal.querySelector('.hover-reveal__inner');
            this.DOM.revealInner.style.overflow = 'hidden';
            this.DOM.revealImg = this.DOM.revealInner.querySelector('.hover-reveal__img');
            this.DOM.letters = [...this.DOM.el.querySelectorAll('span')];
            this.initEvents();
        }
        initEvents() {
            this.positionElement = (ev) => {
                const mousePos = getMousePos(ev);
                const docScrolls = {
                    left : document.body.scrollLeft + document.documentElement.scrollLeft, 
                    top : document.body.scrollTop + document.documentElement.scrollTop
                };
                this.DOM.reveal.style.top = `${mousePos.y + 20 - docScrolls.top}px`;
                if (document.body.classList.contains('rtl')) {
                    this.DOM.reveal.style.right = `${document.documentElement.clientWidth-mousePos.x+20-docScrolls.left}px`;
                } else {
                    this.DOM.reveal.style.left = `${mousePos.x+20-docScrolls.left}px`;
                }
            };
            this.mouseenterFn = (ev) => {
                this.positionElement(ev);
                this.showImage();
            };
            this.mousemoveFn = ev => requestAnimationFrame(() => {
                this.positionElement(ev);
            });
            this.mouseleaveFn = () => {
                this.hideImage();
            };
            
            this.DOM.el.addEventListener('mouseenter', this.mouseenterFn);
            this.DOM.el.addEventListener('mousemove', this.mousemoveFn);
            this.DOM.el.addEventListener('mouseleave', this.mouseleaveFn);
        }
        showImage() {
            if (window.innerWidth < 1140 )
                return;
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealImg);

            this.tl = new gsap.timeline({
                onStart: () => {
                    this.DOM.reveal.style.opacity = 1;
                    gsap.set(this.DOM.el, {zIndex: 1000});
                }
            })
            .add('begin')
            .add(gsap.to(this.DOM.revealInner, {
                duration: 0.8,
                ease: Expo.easeOut,
                startAt: {opacity: 0, y: '50%', rotation: -15, scale:0},
                y: '0%',
                rotation: 0,
                opacity: 1,
                scale: 1
            }), 'begin')
            .add(gsap.to(this.DOM.revealImg, {
                duration: 0.8,
                ease: Expo.easeOut,
                startAt: {rotation: 15, scale: 2},
                rotation: 0,
                scale: 1
            }), 'begin');
        }
        hideImage() {
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealImg);

            this.tl = new gsap.timeline({
                onStart: () => {
                    gsap.set(this.DOM.el, {zIndex: 999});
                },
                onComplete: () => {
                    gsap.set(this.DOM.el, {zIndex: ''});
                    gsap.set(this.DOM.reveal, {opacity: 0});
                }
            })
            .add('begin')
            .add(gsap.to(this.DOM.revealInner, {
                duration: 0.15,
                ease: Sine.easeOut,
                y: '-40%',
                rotation: 10,
                scale: 0.9,
                opacity: 0
            }), 'begin')
            .add(gsap.to(this.DOM.revealImg, {
                duration: 0.15,
                ease: Sine.easeOut,
                rotation: -10,
                scale: 1.5
            }), 'begin')
        }
    }

    // Effect 5
    class HoverImgFx5 {
        constructor(el) {
            this.DOM = {el: el};
            
            this.DOM.reveal = document.createElement('div');
            this.DOM.reveal.className = 'hover-reveal';
            this.DOM.reveal.innerHTML = `<div class="hover-reveal__deco"></div><div class="hover-reveal__inner"><div class="hover-reveal__img" style="background-image:url(${this.DOM.el.dataset.img})"></div></div>`;
            this.DOM.el.appendChild(this.DOM.reveal);
            this.DOM.revealInner = this.DOM.reveal.querySelector('.hover-reveal__inner');
            this.DOM.revealInner.style.overflow = 'hidden';
            this.DOM.revealDeco = this.DOM.reveal.querySelector('.hover-reveal__deco');
            this.DOM.revealImg = this.DOM.revealInner.querySelector('.hover-reveal__img');
            this.DOM.letters = [...this.DOM.el.querySelectorAll('span')];
            this.initEvents();
        }
        initEvents() {
            this.positionElement = (ev) => {
                const mousePos = getMousePos(ev);
                const docScrolls = {
                    left : document.body.scrollLeft + document.documentElement.scrollLeft, 
                    top : document.body.scrollTop + document.documentElement.scrollTop
                };
                this.DOM.reveal.style.top = `${mousePos.y+20-docScrolls.top}px`;
                if (document.body.classList.contains('rtl')) {
                    this.DOM.reveal.style.right = `${document.documentElement.clientWidth-mousePos.x+20-docScrolls.left}px`;
                } else {
                    this.DOM.reveal.style.left = `${mousePos.x+20-docScrolls.left}px`;
                }
            };
            this.mouseenterFn = (ev) => {
                this.positionElement(ev);
                this.showImage();
            };
            this.mousemoveFn = ev => requestAnimationFrame(() => {
                this.positionElement(ev);
            });
            this.mouseleaveFn = () => {
                this.hideImage();
            };
            
            this.DOM.el.addEventListener('mouseenter', this.mouseenterFn);
            this.DOM.el.addEventListener('mousemove', this.mousemoveFn);
            this.DOM.el.addEventListener('mouseleave', this.mouseleaveFn);
        }
        showImage() {
            if (window.innerWidth < 1140 )
                return;
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealImg);
            gsap.killTweensOf(this.DOM.revealDeco);

            this.tl = new gsap.timeline({
                onStart: () => {
                    this.DOM.reveal.style.opacity = 1;
                    gsap.set(this.DOM.el, {zIndex: 1000});
                }
            })
            .set(this.DOM.revealInner, {opacity: 0})
            .add('begin')
            .add(gsap.to(this.DOM.revealDeco, {
                duration: 0.8,
                ease: Expo.easeOut,
                startAt: {opacity: 0, scale: 0, rotation: 35},
                opacity: 1,
                scale: 1,
                rotation: 0
            }), 'begin')
            .add(gsap.to(this.DOM.revealInner, {
                duration: 0.8,
                ease: Expo.easeOut,
                startAt: {scale: 0, rotation: 35},
                rotation: 0,
                scale: 1,
                opacity: 1
            }), 'begin+=0.15')
            .add(gsap.to(this.DOM.revealImg, {
                duration: 0.8,
                ease: Expo.easeOut,
                startAt: {rotation: -35, scale: 2},
                rotation: 0,
                scale: 1
            }), 'begin+=0.15')
        }
        hideImage() {
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealImg);
            gsap.killTweensOf(this.DOM.revealDeco);

            this.tl = new gsap.timeline({
                onStart: () => {
                    gsap.set(this.DOM.el, {zIndex: 999});
                },
                onComplete: () => {
                    gsap.set(this.DOM.el, {zIndex: ''});
                    gsap.set(this.DOM.reveal, {opacity: 0});
                }
            })
            .add('begin')
            .add(gsap.to([this.DOM.revealDeco, this.DOM.revealInner], {
                duration: 0.2,
                ease: Expo.easeOut,
                opacity: 0,
                scale: 0.9
            }), 'begin')
        }
    }

    // Effect 9
    class HoverImgFx9 {
        constructor(el) {
            this.DOM = {el: el};
            
            this.DOM.reveal = document.createElement('div');
            this.DOM.reveal.className = 'hover-reveal';
            this.DOM.reveal.innerHTML = `<div class="hover-reveal__deco"></div><div class="hover-reveal__inner"><div class="hover-reveal__img" style="background-image:url(${this.DOM.el.dataset.img})"></div></div>`;
            this.DOM.el.appendChild(this.DOM.reveal);
            this.DOM.revealInner = this.DOM.reveal.querySelector('.hover-reveal__inner');
            this.DOM.revealInner.style.overflow = 'hidden';
            this.DOM.revealDeco = this.DOM.reveal.querySelector('.hover-reveal__deco');
            this.DOM.revealImg = this.DOM.revealInner.querySelector('.hover-reveal__img');
            this.DOM.letters = [...this.DOM.el.querySelectorAll('span')];
            this.initEvents();
        }
        initEvents() {
            this.positionElement = (ev) => {
                const mousePos = getMousePos(ev);
                const docScrolls = {
                    left : document.body.scrollLeft + document.documentElement.scrollLeft, 
                    top : document.body.scrollTop + document.documentElement.scrollTop
                };
                this.DOM.reveal.style.top = `${mousePos.y+20-docScrolls.top}px`;
                if (document.body.classList.contains('rtl')) {
                    this.DOM.reveal.style.right = `${document.documentElement.clientWidth-mousePos.x+20-docScrolls.left}px`;
                } else {
                    this.DOM.reveal.style.left = `${mousePos.x+20-docScrolls.left}px`;
                }
            };
            this.mouseenterFn = (ev) => {
                this.positionElement(ev);
                this.showImage();
            };
            this.mousemoveFn = ev => requestAnimationFrame(() => {
                this.positionElement(ev);
            });
            this.mouseleaveFn = () => {
                this.hideImage();
            };
            
            this.DOM.el.addEventListener('mouseenter', this.mouseenterFn);
            this.DOM.el.addEventListener('mousemove', this.mousemoveFn);
            this.DOM.el.addEventListener('mouseleave', this.mouseleaveFn);
        }
        showImage() {
            if (window.innerWidth < 1140 )
                return;
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealImg);
            gsap.killTweensOf(this.DOM.revealDeco);

            this.tl = new gsap.timeline({
                onStart: () => {
                    this.DOM.reveal.style.opacity = 1;
                    gsap.set(this.DOM.el, {zIndex: 1000});
                }
            })
            .set([this.DOM.revealInner, this.DOM.revealImg, this.DOM.revealDeco], {transformOrigin: '120% 0%'})
            .set(this.DOM.revealInner, {opacity: 0})
            .add('begin')
            .add(gsap.to(this.DOM.revealDeco, {
                duration: 0.8,
                ease: Expo.easeOut,
                startAt: {opacity: 0, rotation: -80, x: '15%', y: '60%'},
                opacity: 1,
                rotation: 0,
                y: '-15%'
            }), 'begin')
            .add(gsap.to(this.DOM.revealInner, {
                duration: 0.8,
                ease: Expo.easeOut,
                startAt: {x: '50%', y: '150%', rotation: -25},
                opacity: 1,
                x: '0%',
                y: '0%',
                rotation: 0
            }), 'begin+=0.25')

            
            .add(gsap.to(this.DOM.revealImg, {
                duration: 0.8,
                ease: Expo.easeOut,
                startAt: {y: '-150%', rotation: -25},
                y: '0%',
                rotation: 0
            }), 'begin+=0.25');
        }
        hideImage() {
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealImg);
            gsap.killTweensOf(this.DOM.revealDeco);

            this.tl = new gsap.timeline({
                onStart: () => {
                    gsap.set(this.DOM.el, {zIndex: 999});
                },
                onComplete: () => {
                    gsap.set(this.DOM.el, {zIndex: ''});
                    gsap.set(this.DOM.reveal, {opacity: 0});
                }
            })
            .add('begin')
            .add(gsap.to([this.DOM.revealDeco, this.DOM.revealInner], {
                duration: 0.2,
                ease: Expo.easeOut,
                opacity: 0
            }), 'begin')
        }
    }

    // Effect 10
    class HoverImgFx10 {
        constructor(el) {
            this.DOM = {el: el};
            
            this.DOM.reveal = document.createElement('div');
            this.DOM.reveal.className = 'hover-reveal';
            this.DOM.reveal.innerHTML = `<div class="hover-reveal__deco"></div><div class="hover-reveal__inner"><div class="hover-reveal__img" style="background-image:url(${this.DOM.el.dataset.img})"></div></div>`;
            this.DOM.el.appendChild(this.DOM.reveal);
            this.DOM.revealInner = this.DOM.reveal.querySelector('.hover-reveal__inner');
            this.DOM.revealInner.style.overflow = 'hidden';
            this.DOM.revealDeco = this.DOM.reveal.querySelector('.hover-reveal__deco');
            this.DOM.revealImg = this.DOM.revealInner.querySelector('.hover-reveal__img');
            this.DOM.letters = [...this.DOM.el.querySelectorAll('span')];
            this.initEvents();
        }
        initEvents() {
            this.positionElement = (ev) => {
                const mousePos = getMousePos(ev);
                const docScrolls = {
                    left : document.body.scrollLeft + document.documentElement.scrollLeft, 
                    top : document.body.scrollTop + document.documentElement.scrollTop
                };
                this.DOM.reveal.style.top = `${mousePos.y+20-docScrolls.top}px`;
                if (document.body.classList.contains('rtl')) {
                    this.DOM.reveal.style.right = `${document.documentElement.clientWidth-mousePos.x+20-docScrolls.left}px`;
                } else {
                    this.DOM.reveal.style.left = `${mousePos.x+20-docScrolls.left}px`;
                }
            };
            this.mouseenterFn = (ev) => {
                this.positionElement(ev);
                this.showImage();
            };
            this.mousemoveFn = ev => requestAnimationFrame(() => {
                this.positionElement(ev);
            });
            this.mouseleaveFn = () => {
                this.hideImage();
            };
            
            this.DOM.el.addEventListener('mouseenter', this.mouseenterFn);
            this.DOM.el.addEventListener('mousemove', this.mousemoveFn);
            this.DOM.el.addEventListener('mouseleave', this.mouseleaveFn);
        }
        showImage() {
            if (window.innerWidth < 1140 )
                return;
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealDeco);

            this.tl = new gsap.timeline({
                onStart: () => {
                    this.DOM.reveal.style.opacity = 1;
                    gsap.set(this.DOM.el, {zIndex: 1000});
                }
            })
            .set(this.DOM.revealInner, {opacity: 0})
            .add('begin')
            .add(gsap.to(this.DOM.revealDeco, {
                duration: 0.5,
                ease: Expo.easeOut,
                startAt: {scale: 0, opacity: 1, rotation: -10},
                scale: 1.6,
                rotation: 0
            }), 'begin')
            .add(gsap.to(this.DOM.revealDeco, {
                duration: 0.3,
                ease: Sine.easeOut,
                opacity: 0
            }), 'begin+=0.2')
            .add(gsap.to(this.DOM.revealInner, {
                duration: 0.6,
                ease: Expo.easeOut,
                startAt: {scale: 0, opacity: 0, rotation: 10},
                scale: 1,
                opacity: 1,
                rotation: 0
            }), 'begin+=0.2');
        }
        hideImage() {
            gsap.killTweensOf(this.DOM.revealInner);
            gsap.killTweensOf(this.DOM.revealDeco);

            this.tl = new gsap.timeline({
                onStart: () => {
                    gsap.set(this.DOM.el, {zIndex: 999});
                },
                onComplete: () => {
                    gsap.set(this.DOM.el, {zIndex: ''});
                    gsap.set(this.DOM.reveal, {opacity: 0});
                }
            })
            .add('begin')
            .add(gsap.to([this.DOM.revealDeco, this.DOM.revealInner], {
                duration: 0.2,
                ease: Expo.easeOut,
                opacity: 0,
                scale: 0.9
            }), 'begin')
        }
    }

    [...document.querySelectorAll('[data-fx="2"] > a, a[data-fx="2"]')].forEach(link => new HoverImgFx2(link));
    [...document.querySelectorAll('[data-fx="4"] > a, a[data-fx="4"]')].forEach(link => new HoverImgFx4(link));
    [...document.querySelectorAll('[data-fx="5"] > a, a[data-fx="5"]')].forEach(link => new HoverImgFx5(link));
    [...document.querySelectorAll('[data-fx="9"] > a, a[data-fx="9"]')].forEach(link => new HoverImgFx9(link));
    [...document.querySelectorAll('[data-fx="10"] > a, a[data-fx="10"]')].forEach(link => new HoverImgFx10(link));
}