<?php

/** @var $theme WP_Theme */
$theme = is_child_theme() ? wp_get_theme( get_template() ) : wp_get_theme();

$version = $theme->Version;
$theme->name = $theme->slug = str_replace( ' ', '-', $theme->name );
$options_key = 'theme_teta_options';

$product_id = '33042760-rtl';


$constants = [
	'THEME_NAME'					=> $theme->Name,
	'THEME_SLUG'					=> $theme->slug,
	'THEME_NAME_SEO'				=> strtolower( str_replace( ' ', '_', $theme->Name ) ),
	'THEME_VERSION'					=> $version,
	'OPTIONS_KEY'					=> $options_key,
	'PRODUCT_ID'					=> $product_id,
	'DEFAULT_PRODUCT_STYLE'			=> 'modern-buttons-on-hover',
];

foreach ( $constants as $constant => $value ) {
	if ( !defined( $constant ) ) {
		define( 'KITE_' . $constant, $value );
	}
}


function kite_define_translatable_constants() {
	$theme = is_child_theme() ? wp_get_theme( get_template() ) : wp_get_theme();
	$constants = [
		'THEME_MAIN_NAME' 				=>  __( 'teta', 'teta' ),
		'THEME_AUTHOR'					=> $theme->Author,
		'PACK_MODE'						=>  __( 'Pro', 'teta' ),
	];

	foreach ( $constants as $constant => $value ) {
		if ( !defined( $constant ) ) {
			define( 'KITE_' . $constant, $value );
		}
	}
}
add_action( 'init', 'kite_define_translatable_constants', 9);