<?php

class Kite_Performance
{

    /**
	 * Holds the current instance of scripts loader
	 *
	 */
	protected static $instance 	= null;
	
	/**
	 * Retrieves class instance
	 *
	 * @return Kite_Performance
	 */
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance 	= new self;
		}

		return self::$instance;
	}


    public function __construct() {
        add_action( 'init', [ $this, 'disable_emojis' ] );

        add_filter( 'yith_wcwl_main_style_deps', [ $this, 'remove_redundant_dependecy_from_yith_wcwl' ], 10, 1 );
        add_action( 'wp_enqueue_scripts', [ $this, 'load_font_awesome_on_wishlist_page' ] );

        add_action( 'elementor/frontend/after_register_styles', [ $this, 'remove_unused_font_awesome_load_by_elementor' ], 20 );

        add_action( 'wp_enqueue_scripts', [ $this, 'disable_unneeded_scripts' ], 999 );

        add_action( 'wpcf7_enqueue_styles', [ $this, 'dequeue_wpcf7_scripts' ] );

        add_action( 'init', [ $this, 'disable_redux_template_library' ] );
    }

    /**
     * disable gutenberg scripts
     *
     * @return void
     */
    public function disable_unneeded_scripts() {
        if ( kite_opt('disable_gutenberg_scripts', true) ) {
            wp_dequeue_style( 'wp-block-library' );
 
            wp_dequeue_style( 'wp-block-library-theme' );
        }

        if ( kite_opt('disable_wc_block_styles', true) ) {
            wp_dequeue_style( 'wc-blocks-style' );
        }

    }

    /**
     * disable emoji scripts
     *
     * @return void
     */
    public function disable_emojis() {
        if ( !kite_opt('disable_emoji_scripts', true) ) {
            return;
        }

        remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
        remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
        remove_action( 'wp_print_styles', 'print_emoji_styles' );
        remove_action( 'admin_print_styles', 'print_emoji_styles' );	
        remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
        remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );	
        remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
        
        // Remove from TinyMCE
        add_filter( 'tiny_mce_plugins', [ $this, 'disable_emojis_tinymce'] );
    }

    /**
     * Filter out the tinymce emoji plugin.
     */
    public function disable_emojis_tinymce( $plugins ) {
        if ( is_array( $plugins ) ) {
            return array_diff( $plugins, array( 'wpemoji' ) );
        } else {
            return array();
        }
    }

    /**
     * remove duplicate font awesome load by elementor and yith wishlist
     * remove jquery select box style
     * remove woocommerce pretty photo style
     */
    public function remove_redundant_dependecy_from_yith_wcwl( $deps ) {
        if ( !kite_opt('disable_yith_dependent_scripts', true) ) {
            return $deps;
        }
        return [];
    }

    /**
     * load font awesome dequeued on wishlist page
     *
     * @return void
     */
    public function load_font_awesome_on_wishlist_page() {
        if ( !kite_opt('disable_yith_dependent_scripts', true) ) {
            return;
        }
        
        if ( class_exists( 'YITH_WCWL' ) ) {
            if ( get_the_ID() == YITH_WCWL::get_instance()->get_wishlist_page_id() ) {
                wp_enqueue_style( 'yith-wcwl-font-awesome', YITH_WCWL_URL . 'assets/css/font-awesome.css', array(), '4.7.0' );
            }   
        }
    }

    /**
     * Undocumented function
     *
     * @return void
     */
    public function remove_unused_font_awesome_load_by_elementor() {
        if ( !kite_opt('disable_elementor_font_awesome', false) ) {
            return;
        }
        foreach( [ 'solid', 'regular', 'brands' ] as $style ) { 
            wp_deregister_style( 'elementor-icons-fa-' . $style ); 
        } 
    }

     /**
     * dequeue contact form 7 scripts
     *
     * @return void
     */
    public function dequeue_wpcf7_scripts() {

        if ( kite_opt( 'disable_wpcf7_scripts', true ) ) {
            wp_dequeue_script( 'contact-form-7' );
            wp_dequeue_style( 'contact-form-7' );
        }

    }

    /**
     * Disable redux template library
     *
     * @return void
     */
    public function disable_redux_template_library() {
        if ( kite_opt( 'disable_redux_template_library', true ) ) {
            update_option( 'use_redux_templates', 0 );
            update_option( 'use_extendify_templates', 0 );
        } else {
            update_option( 'use_redux_templates', 1 );
            update_option( 'use_extendify_templates', 1 );
        }
    }
}

Kite_Performance::get_instance();