<?php

/**
 * ------------------------------------------------------------------------------------------------
 * Init Theme Settings and Options with Redux plugin
 * ------------------------------------------------------------------------------------------------
 */

if ( ! class_exists( 'Redux' ) ) {
	return;
}

	$opt_name = KITE_OPTIONS_KEY;
	$theme    = wp_get_theme();

	$args = array(
		'opt_name'             => $opt_name,
		'display_name'         => $theme->get( 'Name' ),
		'display_version'      => $theme->get( 'Version' ),
		'menu_type'            => 'menu',
		'allow_sub_menu'       => true,
		'menu_title'           => __( 'Theme Settings', 'teta' ),
		'page_title'           => __( 'Theme Settings', 'teta' ),
		'google_api_key'       => '',
		'google_update_weekly' => false,
		'async_typography'     => false,
		'admin_bar'            => true,
		'admin_bar_icon'       => 'dashicons-portfolio',
		'admin_bar_priority'   => 50,
		'global_variable'      => '',
		'dev_mode'             => false,
		'update_notice'        => true,
		'customizer'           => true,
		'page_priority'        => 3,
		'page_parent'          => 'themes.php',
		'page_permissions'     => 'manage_options',
		'menu_icon'            => '',
		'last_tab'             => '',
		'page_icon'            => 'icon-themes',
		'page_slug'            => 'theme_settings',
		'save_defaults'        => true,
		'default_show'         => false,
		'default_mark'         => '',
		'show_import_export'   => true,
		'transient_time'       => 60 * MINUTE_IN_SECONDS,
		'output'               => true,
		'output_tag'           => true,
		'footer_credit'        => '1.0',
		'database'             => '',
		'system_info'          => false,
		'hints'                => array(
			'icon'          => 'el el-question-sign',
			'icon_position' => 'right',
			'icon_color'    => 'lightgray',
			'icon_size'     => 'normal',
			'tip_style'     => array(
				'color'   => 'light',
				'shadow'  => true,
				'rounded' => false,
				'style'   => '',
			),
			'tip_position'  => array(
				'my' => 'top left',
				'at' => 'bottom right',
			),
			'tip_effect'    => array(
				'show' => array(
					'effect'   => 'slide',
					'duration' => '500',
					'event'    => 'mouseover',
				),
				'hide' => array(
					'effect'   => 'slide',
					'duration' => '500',
					'event'    => 'click mouseleave',
				),
			),
		),
	);

	Redux::setArgs( $opt_name, $args );

	do_action( 'kite_before_settings_initialized' );

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'General Settings', 'teta' ),
			'id'     => 'kite_general',
			'icon'   => 'icon-cog',
			'fields' => array(
				array(
					'id'      => 'page_breadcrumb',
					'type'    => 'switch',
					'title'   => __( 'Header BreadCrumb', 'teta' ),
					'default' => true,
				),
				array(
					'id'       => 'favicon',
					'type'     => 'media',
					'subtitle' => __( 'Specify custom favicon URL or upload a new one here.', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Favicon', 'teta' ),
					'class'    => 'favicon',
				),
				array(
					'id'       => 'scrolling-easing',
					'type'     => 'select',
					'title'    => __( 'Page Scrolling Motion Effect', 'teta' ),
					'subtitle' => __( 'Select one of the scrolling motion effects bellow.', 'teta' ),
					// Must provide key => value pairs for select options
					'options'  => array(
						'linear'           => 'linear',
						'easeInQuad'       => 'Ease In Quad',
						'easeOutQuad'      => 'Ease Out Quad',
						'easeInOutQuad'    => 'Ease In Out Quad',
						'easeInCubic'      => 'Ease In Cubic',
						'easeOutCubic'     => 'Ease Out Cubic',
						'easeInOutCubic'   => 'Ease In Out Cubic',
						'easeInQuart'      => 'Ease In Quart',
						'easeOutQuart'     => 'Ease Out Quart',
						'easeInOutQuart'   => 'Ease In Out Quart',
						'easeInQuint'      => 'Ease In Quint',
						'easeOutQuint'     => 'Ease Out Quint',
						'easeInOutQuint'   => 'Ease In Out Quint',
						'easeInSine'       => 'Ease In Sine',
						'easeOutSine'      => 'Ease Out Sine',
						'easeInOutSine'    => 'Ease In Out Sine',
						'easeInExpo'       => 'Ease In Expo',
						'easeOutExpo'      => 'Ease Out Expo',
						'easeInOutExpo'    => 'Ease In Out Expo',
						'easeInCirc'       => 'Ease In Circ',
						'easeOutCirc'      => 'Ease Out Circ',
						'easeInOutCirc'    => 'Ease In Out Circ',
						'easeInElastic'    => 'Ease In Elastic',
						'easeOutElastic'   => 'Ease Out Elastic',
						'easeInOutElastic' => 'Ease In Out Elastic',
						'easeInBack'       => 'Ease In Back',
						'easeOutBack'      => 'Ease Out Back',
						'easeInOutBack'    => 'Ease In Out Back',
						'easeInBounce'     => 'Ease In Bounce',
						'easeOutBounce'    => 'Ease Out Bounce',
						'easeInOutBounce'  => 'Ease In Out Bounce',
					),
					'default'  => 'easeInOutQuart',
				),
				array(
					'id'            => 'scrolling-speed',
					'type'          => 'slider',
					'title'         => __( 'Scrolling Speed', 'teta' ),
					'subtitle'      => __( 'Adjust the speed of pages vertical scrolling.', 'teta' ),
					'default'       => 1000,
					'min'           => 5,
					'step'          => 50,
					'max'           => 5000,
					'display_value' => 'label',
				),
				array(
					'id'       => 'login-logo',
					'type'     => 'media',
					'subtitle' => __( 'Upload dashboard\'s login page logo. ( best size : 302px X 62px ) ( PNG , JPG , GIF )', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Dashboard\'s Login Page Logo', 'teta' ),
				),
				array(
					'id'       => 'retina_ready',
					'type'     => 'switch',
					'title'    => __( 'Retina Ready', 'teta' ),
					'subtitle' => __( 'You can enable or disable retina. notice that enabling this option generate more images', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => 0,
				),
				array(
					'id'       => 'scrolltop_button',
					'type'     => 'switch',
					'title'    => __( 'Scroll Top Button', 'teta' ),
					'subtitle' => __( 'You can enable or disable scroll top button', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => true,
				),
				array(
					'id'       => 'layout_width',
					'type'     => 'switch',
					'title'    => __( 'Layout Width', 'teta' ),
					'subtitle' => __( 'Select width of layout', 'teta' ),
					'on'       => __( 'Fullwidth', 'teta' ),
					'off'      => __( 'Container', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'container_size',
					'type'     => 'switch',
					'title'    => __( 'Pages Container Size', 'teta' ),
					'subtitle' => __( 'Predefined size is set to 1170px.', 'teta' ),
					'on'       => __( 'Predefined Size', 'teta' ),
					'off'      => __( 'Custom Size', 'teta' ),
					'default'  => true,
				),
				array(
					'id'            => 'dynamic_container_size',
					'type'          => 'slider',
					'title'         => __( 'Custom Container Size', 'teta' ),
					'subtitle'      => __( 'Adjust the size of pages container width. (Defined by pixle)', 'teta' ),
					'default'       => 1170,
					'min'           => 1170,
					'step'          => 5,
					'max'           => 1600,
					'display_value' => 'label',
					'required'      => array( 'container_size', '=', false ),
				),
				array(
					'id'       => 'product_detail_container_size',
					'type'     => 'switch',
					'title'    => __( 'Product Details Container Size', 'teta' ),
					'subtitle' => __( 'Predefined size is set to 1170px.', 'teta' ),
					'on'       => __( 'Predefined Size', 'teta' ),
					'off'      => __( 'Custom Size', 'teta' ),
					'default'  => true,
				),
				array(
					'id'            => 'dynamic_product_detail_container_size',
					'type'          => 'slider',
					'title'         => __( 'Product Detail Custom Container Size', 'teta' ),
					'subtitle'      => __( 'Adjust the size of pages container width. (Defined by pixle)', 'teta' ),
					'default'       => 1170,
					'min'           => 1170,
					'step'          => 1,
					'max'           => 1600,
					'display_value' => 'label',
					'required'      => array( 'product_detail_container_size', '=', false ),
				),
				array(
					'id'       => 'blog_archive_style',
					'type'     => 'switch',
					'title'    => __( 'Blog Archive Style', 'teta' ),
					'on'       => __( 'Default Style', 'teta' ),
					'off'      => __( 'New Simple Style', 'teta' ),
					'default'  => true,
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Color Scheme', 'teta' ),
			'id'     => 'kite_color',
			'icon'   => 'icon-bucket',
			'fields' => array(
				array(
					'id'       => 'style-accent-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Accent Color', 'teta' ),
					'subtitle' => __( 'Accent color for theme elements.', 'teta' ),
					'default'  => array(
						'color' => '#5956e9',
						'alpha' => '1',
					),

					'mode'     => 'background',

				),
				array(
					'id'       => 'style-highlight-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Highlight Color', 'teta' ),
					'subtitle' => __( 'Highlight color on the highlited elements.', 'teta' ),
					'default'  => array(
						'color' => '#424242',
						'alpha' => '1',
					),

					'mode'     => 'background',

				),
				array(
					'id'      => 'element-on-accent-color-style',
					'title'   => __( 'Chroma of Elements Placed On Accent Color', 'teta' ),
					'type'    => 'switch',
					'on'      => __( 'Light', 'teta' ),
					'off'     => __( 'Dark', 'teta' ),
					'default' => true,
				),
				array(
					'id'     => 'Link_Color_section_start',
					'type'   => 'section',
					'title'  => __( 'Link Color', 'teta' ),
					'indent' => true,
				),
				array(
					'id'      => 'style-link-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Normal Link Color', 'teta' ),
					'default' => array(
						'color' => '#4592ff',
						'alpha' => '1',
					),

					'mode'    => 'background',

				),
				array(
					'id'      => 'style-link-hover-color',
					'type'    => 'color_rgba',
					'title'   => __( 'On Hover Link Color', 'teta' ),
					'default' => array(
						'color' => '#307adb',
						'alpha' => '1',
					),

					'mode'    => 'background',

				),
				array(
					'id'     => 'Link_Color_section_end',
					'type'   => 'section',
					'indent' => false,
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Pages Loading Transition', 'teta' ),
			'id'     => 'kite_preloader',
			'icon'   => 'icon-toggle',
			'fields' => array(
				array(
					'id'       => 'loader_display',
					'title'    => __( 'Switch preloader | page transition', 'teta' ),
					'subtitle' => __( 'You can switch between preloader and page transition effect. This loader would be shown before your website is loaded completely.', 'teta' ),
					'type'     => 'radio',
					'options'  => array(
						'1' => 'Preloader',
						'2' => 'None',
					),
					'default'  => '2',
				),
				array(
					'id'       => 'preloader_type_section_start',
					'type'     => 'section',
					'title'    => __( 'Preloader Type', 'teta' ),
					'indent'   => true,
					'required' => array( 'loader_display', '=', '1' ),

				),
				array(
					'id'      => 'preloader_display',
					'title'   => __( 'Switch preloader | page transition', 'teta' ),
					'type'    => 'switch',
					'on'      => __( 'Display always', 'teta' ),
					'off'     => __( 'Display just Between pages', 'teta' ),
					'default' => true,
				),
				array(
					'id'      => 'preloader-type',
					'type'    => 'image_select',
					// Must provide key => value(array:title|img) pairs for radio options
					'options' => array(
						'circular' => array(
							'alt' => 'circular',
							'img' => KITE_THEME_LIB_URI . '/admin/img/preloader/circular.png',
						),
						'creative' => array(
							'alt' => 'creative',
							'img' => KITE_THEME_LIB_URI . '/admin/img/preloader/creative.png',
						),
						'simple'   => array(
							'alt' => 'simple',
							'img' => KITE_THEME_LIB_URI . '/admin/img/preloader/simple.png',
						),
						'sniper'   => array(
							'alt' => 'sniper',
							'img' => KITE_THEME_LIB_URI . '/admin/img/preloader/sniper.png',
						),
					),
					'default' => 'simple',
				),
				array(
					'id'     => 'preloader_type_section_end',
					'type'   => 'section',
					'indent' => false,
				),

				array(
					'id'       => 'preloader_color_section_start',
					'type'     => 'section',
					'title'    => __( 'Preloader Color', 'teta' ),
					'indent'   => true,
					'required' => array( 'loader_display', '=', '1' ),

				),
				array(
					'id'      => 'preloader_color',
					'type'    => 'color_rgba',
					'title'   => __( 'color', 'teta' ),
					'default' => array(
						'color' => '#c7c7c7',
						'alpha' => '1',
					),

					'mode'    => 'background',

				),
				array(
					'id'      => 'preloader_bg_color',
					'type'    => 'color_rgba',
					'title'   => __( 'Background color', 'teta' ),
					'default' => array(
						'color' => '#efefef',
						'alpha' => '1',
					),

					'mode'    => 'background',

				),
				array(
					'id'       => 'preloader_box_color',
					'type'     => 'color_rgba',
					'title'    => __( 'Box color', 'teta' ),
					'default'  => array(
						'color' => '#f7f7f7',
						'alpha' => '1',
					),

					'mode'     => 'background',

					'required' => array( 'preloader-type', '=', 'creative' ),
				),
				array(
					'id'       => 'preloader_text_section_start',
					'type'     => 'section',
					'title'    => __( 'Preloader Text', 'teta' ),
					'indent'   => true,
					'required' => array( 'preloader-type', '=', 'creative' ),
				),
				array(
					'id'    => 'preloader-text',
					'type'  => 'text',
					'title' => __( 'Preloader Text', 'teta' ),
				),
				array(
					'id'      => 'preloader_text_color',
					'type'    => 'color_rgba',
					'title'   => __( 'Preloader Text color', 'teta' ),
					'default' => array(
						'color' => '#000',
						'alpha' => '1',
					),

					'mode'    => 'background',

				),
				array(
					'id'     => 'preloader_text_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'preloader-logo',
					'type'     => 'media',
					'subtitle' => __( 'Choose an image to make it appear in preloader page. (PNG, GIF, JPG)', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Preloader Image', 'teta' ),
					'required' => array( 'preloader-type', '=', 'creative' ),
				),

			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Popup Newsletter', 'teta' ),
			'id'     => 'kite_Popup_Newsletter',
			'icon'   => 'icon-news',
			'fields' => array(
				array(
					'id'       => 'popupNewsletterDisplay',
					'type'     => 'switch',
					'title'    => __( 'Popup Newsletter Display', 'teta' ),
					'subtitle' => __( 'This Newsletter will be shown to the visitors when they enter the site. You can enable or disable it.', 'teta' ),
					'default'  => false,
				),
				array(
					'id'     => 'popupNewsLetter_section_start',
					'type'   => 'section',
					'title'  => __( 'Popup Newsletter Title and Subtitle', 'teta' ),
					'indent' => true,
					'required'=> array( 'popupNewsletterDisplay', '=' , true ),
				),
				array(
					'id'       => 'popupNewsLetterTitle',
					'type'     => 'text',
					'title'    => __( 'Title', 'teta' ),
					'subtitle' => __( 'Choose a title for the newsletter.', 'teta' ),

				),
				array(
					'id'       => 'popupNewsLetterSubtitle',
					'type'     => 'text',
					'title'    => __( 'Subtitle', 'teta' ),
					'subtitle' => __( 'Choose a subtitle for the newsletter.', 'teta' ),

				),
				array(
					'id'     => 'popupNewsLetter_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'popupNewsLetterShortcode',
					'type'     => 'text',
					'title'    => __( 'Popup Newsletter Shortcode', 'teta' ),
					'subtitle' => __( 'Add a newsletter shortcode in this box. You can create your desired form by Mailchimp and then insert its shortcode here.', 'teta' ),
					'required'=> array( 'popupNewsletterDisplay', '=' , true ),
				),
				array(
					'id'       => 'popupNewsLetterBackgroundImage',
					'type'     => 'media',
					'operator' => 'and',
					'title'    => __( 'Popup Newsletter Background Image', 'teta' ),
					'subtitle' => __( 'Choose a background image for the popup newsletter. It is better to use vertical photo (320*400).', 'teta' ),
					'required'=> array( 'popupNewsletterDisplay', '=' , true ),
				),
				array(
					'id'       => 'popupNewsLetterText',
					'type'     => 'text',
					'title'    => __( 'Popup Newsletter Extra Content', 'teta' ),
					'subtitle' => __( 'You can write some extra text to show on the newsletter popup.', 'teta' ),
					'required'=> array( 'popupNewsletterDisplay', '=' , true ),
				),
				array(
					'id'       => 'popupNewsLetterDisplayMobile',
					'type'     => 'switch',
					'title'    => __( 'Show On Mobile', 'teta' ),
					'subtitle' => __( 'Show the popup in mobile devices', 'teta' ),
					'default'  => false,
					'required'=> array( 'popupNewsletterDisplay', '=' , true ),
				),
				array(
					'id'            => 'popupNewsLetterDelay',
					'type'          => 'slider',
					'title'         => __( 'Delay Time', 'teta' ),
					'default'       => 1000,
					'min'           => 5,
					'step'          => 50,
					'max'           => 8000,
					'display_value' => 'label',
					'subtitle'      => __( 'Adjust the popup delay time after page loaded. (Defined by Milliseconds)', 'teta' ),
					'required'=> array( 'popupNewsletterDisplay', '=' , true ),
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Header | Menu', 'teta' ),
			'id'     => 'kite_header_menu',
			'icon'   => 'icon-window',
			'fields' => array(
				array(
					'id'     => 'header_builder_section-start',
					'type'   => 'section',
					'indent' => true,
					'title'	 => __( 'Header Builder', 'teta' ),
				),
				array (
					'id'       => 'is_header_build_with_elementor',
					'type'     => 'switch',
					'title'    => __('Build Header With Elementor', 'teta'),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'elementor_header_template_id',
					'type'    => 'select',
					'title'   => __( 'Select Template', 'teta' ),
					'options' => kite_get_elementor_templates_list( 'header' ),
					'required'=> array( 'is_header_build_with_elementor', '=' , true ),
				),
				array(
					'id'       => 'header-type',
					'type'     => 'image_select',
					'title'    => __( 'Header Type', 'teta' ),
					'subtitle' => __( 'Select header type', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						0  => array(
							'alt' => 'type-0',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-0.png',
						),
						1  => array(
							'alt' => 'type-1',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-1.png',
						),
						2  => array(
							'alt' => 'type-2',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-2.png',
						),
						3  => array(
							'alt' => 'type-3',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-3.png',
						),
						4  => array(
							'alt' => 'type-4',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-4.png',
						),
						5  => array(
							'alt' => 'type-5',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-5.png',
						),
						6  => array(
							'alt' => 'type-6',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-6.png',
						),
						9  => array(
							'alt' => 'type-9',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-9.png',
						),
						10 => array(
							'alt' => 'type-10',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/type-10.png',
						),


					),
					'default'  => 1,
					'required'=> [
						array( 'is_header_build_with_elementor', '=' , false ),
					]
				),
				array(
					'id'     => 'header_builder_section-end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'header-style',
					'type'     => 'image_select',
					'title'    => __( 'Second State Header Type', 'teta' ),
					'subtitle' => __( 'Select what to happens to the header after scrolling down the page.', 'teta' ),

					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						'normal-menu' => array(
							'alt' => 'normal-menu',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/normal-menu.png',
						),
						'kite-menu'   => array(
							'alt' => 'kite-menu',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/kite-menu.png',
						),
						'fixed-menu'  => array(
							'alt' => 'fixed-menu',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/fixed-menu.png',
						),
					),
					'default'  => 'normal-menu',
					'required'=> [
						array( 'is_header_build_with_elementor', '=' , false ),
					]
				),
				array(
					'id'       => 'menu-container',
					'type'     => 'switch',
					'title'    => __( 'Header Width', 'teta' ),
					'subtitle' => __( 'Choose the header to be boxed or full-width.', 'teta' ),
					'on'       => __( 'Full Width', 'teta' ),
					'off'      => __( 'Boxed', 'teta' ),
					'default'  => false,
				),
				array(
					'id'     => 'responsive_header_section-start',
					'type'   => 'section',
					'indent' => true,
					'title'	 => esc_html( 'Responsive Header Settings', 'teta' ),
					'required' => array(
						array( 'header-type', '!=', 7 ),
						array( 'header-type', '!=', 8 ),
						array( 'is_header_build_with_elementor', '=' , false ),
					),
				),
				array(
					'id'       => 'mobile_header_style',
					'type'     => 'switch',
					'title'    => __( 'Mobile Header Style', 'teta' ),
					'subtitle' => __( 'Choose the style of header in responsive mode.', 'teta' ),
					'on'       => __( 'Dark', 'teta' ),
					'off'      => __( 'Light', 'teta' ),
					'default'  => false,
					'required' => array(
						array( 'header-type', '!=', 7 ),
						array( 'header-type', '!=', 8 ),
						array( 'header-type', '!=', '10' ),
					),
				),
				array(
					'id'       => 'mobile_menu-color',
					'type'     => 'switch',
					'title'    => __( 'Mobile Off Canvas Style', 'teta' ),
					'subtitle' => __( 'Choose the style of off canvas menu in responsive mode.', 'teta' ),
					'on'       => __( 'Dark', 'teta' ),
					'off'      => __( 'Light', 'teta' ),
					'default'  => false,
					'required' => array(
						array( 'header-type', '!=', 7 ),
						array( 'header-type', '!=', 8 ),
						array( 'header-type', '!=', '10' ),
					),
				),
				array(
					'id'      => 'responsive-second-state',
					'type'    => 'switch',
					'title'   => __( 'Second State Header On Mobile', 'teta' ),
					'default' => false,
				),
				array(
					'id'     => 'responsive_header_section-end',
					'type'   => 'section',
					'indent' => false,
					'required'=> [
						array( 'header-type', '!=', 7 ),
						array( 'header-type', '!=', 8 ),
						array( 'is_header_build_with_elementor', '=' , false ),
					]
				),
				array(
					'id'     => 'logo_section_start',
					'type'   => 'section',
					'title'  => __( 'Logo', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'logo',
					'type'     => 'media',
					'subtitle' => __( 'Uplaod your header logo.', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Initial Header Logo', 'teta' ),
				),
				array(
					'id'       => 'logo-second',
					'type'     => 'media',
					'subtitle' => __( 'This logo will be shown at the second state header.', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Second State Header Logo', 'teta' ),
					'required' => array( 'header-style', '=', 'kite-menu' ),
				),
				array(
					'id'       => 'responsivelogo',
					'type'     => 'media',
					'subtitle' => __( 'It\'s the logo that will only be shown in responsive mode (Mobile and tablets)', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Mobile Logo', 'teta' ),
				),
				array(
					'id'     => 'logo_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'shop_cart_button_section_start',
					'type'   => 'section',
					'title'  => __( 'Cart Button', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'shop-enable-cart',
					'type'     => 'switch',
					'title'    => __( 'Cart Button Display', 'teta' ),
					'subtitle' => __( 'Enable or disable menu cart menu button', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => true,
				),
				array(
					'id'      => 'icon_type',
					'type'    => 'image_select',
					'title'   => __( 'Cart icon', 'teta' ),
					'class'   => 'icon_type',
					'default' => 'cart',
					'options' => array(
						'cart-full'       => array(
							'alt' => 'cart-full',
							'img' => KITE_THEME_LIB_URI . '/admin/img/cart_icons/cart-full.png',
						),
						'cart-empty'      => array(
							'alt' => 'cart-empty',
							'img' => KITE_THEME_LIB_URI . '/admin/img/cart_icons/cart-empty.png',
						),
						'cart'            => array(
							'alt' => 'cart',
							'img' => KITE_THEME_LIB_URI . '/admin/img/cart_icons/cart.png',
						),
						'bag2'            => array(
							'alt' => 'bag2',
							'img' => KITE_THEME_LIB_URI . '/admin/img/cart_icons/bag2.png',
						),
						'bag'             => array(
							'alt' => 'bag',
							'img' => KITE_THEME_LIB_URI . '/admin/img/cart_icons/bag.png',
						),
						'shopping-basket' => array(
							'alt' => 'shopping-basket',
							'img' => KITE_THEME_LIB_URI . '/admin/img/cart_icons/shopping-basket.png',
						),
						'shopping-bag'    => array(
							'alt' => 'shopping-bag',
							'img' => KITE_THEME_LIB_URI . '/admin/img/cart_icons/shopping-bag.png',
						),
						'shopping-cart'   => array(
							'alt' => 'shopping-cart',
							'img' => KITE_THEME_LIB_URI . '/admin/img/cart_icons/shopping-cart.png',
						),
					),
				),
				array(
					'id'     => 'shop_cart_button_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'wishlist_button_section_start',
					'type'   => 'section',
					'title'  => __( 'Wishlist Button ', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'header-wishlist-display',
					'type'     => 'switch',
					'title'    => __( 'Wishlist Button Display', 'teta' ),
					'subtitle' => __( 'Enable or disable the display of the wishlist button.', 'teta' ),
					'default'  => true,
				),
				array(
					'id'       => 'responsive-wishlist-display',
					'type'     => 'switch',
					'title'    => __( 'Show Wishlist in Responsive', 'teta' ),
					'subtitle' => __( 'Show the wishlist button in responsive mode or not.', 'teta' ),
					'default'  => false,
				),
				array(
					'id'     => 'wishlist_button_section_end',
					'type'   => 'section',
					'indent' => false,
				),

				array(
					'id'     => 'wishlist_cart_button_section_start',
					'type'   => 'section',
					'title'  => __( 'Cart/wishlist Button Chroma', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'shop-wishlist-cart-style',
					'type'     => 'switch',
					'title'    => __( 'Cart/wishlist Button Style', 'teta' ),
					'subtitle' => __( 'Choose the Cart/wishlist button style.', 'teta' ),
					'subtitle' => __( 'Choose the Cart/wishlist button style.', 'teta' ),
					'on'       => __( 'Dark Icon', 'teta' ),
					'off'      => __( 'Light Icon', 'teta' ),
					'default'  => true,
				),
				array(
					'id'       => 'shop-wishlist-cart-bg-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Cart/wishlist Button Background Color', 'teta' ),
					'subtitle' => __( 'Choose a background color for the Cart/wishlist button.', 'teta' ),
					'default'  => array(
						'color' => '#eeeeee00',
						'alpha' => '0',
					),
					'mode'     => 'background',
				),
				array(
					'id'     => 'wishlist_cart_button_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'responsive-sticky-bottom-navbar_section_start',
					'type'   => 'section',
					'title'  => __( 'Mobile Sticky Bottom Navigation', 'teta' ),
					'indent' => true,
				),
				array (
					'id'       => 'responsive-sticky-bottom-navbar',
					'type'     => 'switch',
					'title'    => __('Sticky Bottom Navigation Bar', 'teta'),
					'subtitle'     => __('Show or hide bottom sticky navigation bar', 'teta'),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'mobile_category_menu',
					'type'    => 'switch',
					'title'   => __( 'Product Categories In Mobile Sticky Bottom Navigation', 'teta' ),
					'subtitle'     => __('Show or hide Product Categories in the mobile sticky bottom navigation bar', 'teta'),
					'default' => true,
					'on'       => __( 'Show', 'teta' ),
					'off'      => __( 'Hide', 'teta' ),
					'required' => array(
						array( 'responsive-sticky-bottom-navbar', '=', true ),
					),
				),
				array(
					'id'     => 'responsive-sticky-bottom-navbar_section_end',
					'type'   => 'section',
					'indent' => false,
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Header Promo Bar', 'teta' ),
			'id'     => 'kite_Header_PromoBar',
			'icon'   => 'icon-reading',
			'subsection' => true,
			'fields' => array(
				array(
					'id'       => 'Header_PromoBar_Display',
					'type'     => 'switch',
					'title'    => __( 'Promo Bar Display', 'teta' ),
					'subtitle' => __( 'The promo bar will be shown on top of the home page.', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'Header_PromoBar_text',
					'type'     => 'textarea',
					'title'    => __( 'Promo Bar Text', 'teta' ),
					'subtitle' => __( 'Add a text to show on promo bar.', 'teta' ),
					'required' => array(
						array( 'Header_PromoBar_Display', '=', true ),
					),
				),

				array(
					'id'      => 'Header_PromoBar_textcolor',
					'type'    => 'switch',
					'title'   => __( 'Chroma of Promo Bar Text', 'teta' ),
					'on'      => __( 'Dark', 'teta' ),
					'off'     => __( 'Light', 'teta' ),
					'default' => false,
					'required' => array(
						array( 'Header_PromoBar_Display', '=', true ),
					),
				),


				array(
					'id'       => 'Header_PromoBar_btntext',
					'type'     => 'text',
					'title'    => __( 'Promo Bar Button', 'teta' ),
					'subtitle' => __( 'This text will be Shown on your button. Leave it blank if you don\'t want to have the promo bar button.', 'teta' ),
					'required' => array(
						array( 'Header_PromoBar_Display', '=', true ),
					),
				),


				array(
					'id'       => 'Header_PromoBar_Link',
					'type'     => 'text',
					'title'    => __( 'Promo Bar link URL', 'teta' ),
					'subtitle' => __( 'This link will be used for redirecting visitors after clicking on the promo bar or its button.', 'teta' ),
					'required' => array(
						array( 'Header_PromoBar_Display', '=', true ),
					),
				),
				array(
					'id'     => 'Header_PromoBar_height_section_start',
					'type'   => 'section',
					'title'  => __( 'Promo Bar Height', 'teta' ),
					'indent' => true,
					'required' => array(
						array( 'Header_PromoBar_Display', '=', true ),
					),
				),
				array(
					'id'            => 'Header_PromoBar_height',
					'type'          => 'slider',
					'title'         => __( 'Height of promo bar in desktop', 'teta' ),
					'subtitle'      => __( 'Defined by pixle', 'teta' ),
					'default'       => 50,
					'min'           => 50,
					'step'          => 1,
					'max'           => 200,
					'display_value' => 'label',
				),
				array(
					'id'            => 'Header_PromoBar_mobileheight',
					'type'          => 'slider',
					'title'         => __( 'Height of promo bar in responsive', 'teta' ),
					'subtitle'      => __( 'The measurement unit is a pixel.', 'teta' ),
					'default'       => 60,
					'min'           => 60,
					'step'          => 1,
					'max'           => 200,
					'display_value' => 'label',
				),
				array(
					'id'     => 'Header_PromoBar_height_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'Header_PromoBar_style_section_start',
					'type'   => 'section',
					'title'  => __( 'Promo Bar Background Style', 'teta' ),
					'indent' => true,
					'required' => array(
						array( 'Header_PromoBar_Display', '=', true ),
					),
				),
				array(
					'id'       => 'Header_PromoBar_BgImage',
					'type'     => 'media',
					'operator' => 'and',
					'title'    => __( 'Promo Bar Background Image', 'teta' ),
					'subtitle' => __( 'Choose a background image for the Promo Bar.', 'teta' ),
				),

				array(
					'id'       => 'Header_PromoBar_BgColor',
					'type'     => 'color_rgba',
					'title'    => __( 'Promo Bar Background Color', 'teta' ),
					'subtitle' => __( 'Choose a background color for the Promo Bar.', 'teta' ),
					'default'  => array(
						'color' => '#000000',
						'alpha' => '1',
					),
					'mode'     => 'background',
				),
				array(
					'id'     => 'Header_PromoBar_style_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'Header_PromoBar_closebtn',
					'type'     => 'switch',
					'title'    => __( 'Promo Bar Close button Display', 'teta' ),
					'subtitle' => __( 'Showing of the close button.', 'teta' ),
					'default'  => true,
					'required' => array(
						array( 'Header_PromoBar_Display', '=', true ),
					),
				),
			),
		)
	);


	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Top Bar', 'teta' ),
			'id'     => 'kite_topbar',
			'icon'   => 'icon-window-maximize',
			'subsection' => true,
			'fields' => array(
				array(
					'id'       => 'topbar_display',
					'type'     => 'switch',
					'title'    => __( 'Enable Topbar', 'teta' ),
					'subtitle' => __( 'You can enable or disable the top bar here. Top bar is the bar that sticks to top of your page.', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'boxed_topbar',
					'type'     => 'switch',
					'title'    => __( 'Topbar Display', 'teta' ),
					'subtitle' => __( 'You can choose the top bar to be boxed or full-width', 'teta' ),
					'default'  => false,
					'on'       => __( 'Boxed', 'teta' ),
					'off'      => __( 'Fullwidth', 'teta' ),
				),
				array(
					'id'     => 'topbar_style_section_start',
					'type'   => 'section',
					'title'  => __( 'Style', 'teta' ),
					'indent' => true,
				),
				array(
					'id'      => 'topbar_bg_color',
					'type'    => 'color_rgba',
					'title'   => __( 'Topbar Content Chroma', 'teta' ),
					'default' => array(
						'color' => '#eee',
						'alpha' => '1',
					),

					'mode'    => 'background',

				),
				array(
					'id'       => 'topbar_border_color',
					'type'     => 'color_rgba',
					'title'    => 'Topbar Border Color',
					'class'    => 'topbar-border-color',
					'subtitle' => __( 'Do you want the top bar have border? Choose its color.', 'teta' ),
					'default'  => array(
						'color' => '#eee',
						'alpha' => '1',
					),

					'mode'     => 'background',

				),
				array(
					'id'      => 'topbar_style',
					'type'    => 'switch',
					'title'   => __( 'Topbar Color', 'teta' ),
					'on'      => __( 'Light', 'teta' ),
					'off'     => __( 'Dark', 'teta' ),
					'default' => false,
				),
				array(
					'id'     => 'topbar_style_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'    => 'topbar_icon',
					'type'  => 'icon_picker',
					'title' => __( 'Topbar Icon', 'teta' ),
				),
				array(
					'id'     => 'topbar_text_section_start',
					'type'   => 'section',
					'title'  => __( 'Title and Text', 'teta' ),
					'indent' => true,
				),
				array(
					'id'    => 'topbar_title',
					'type'  => 'text',
					'title' => __( 'Top bar title', 'teta' ),
				),
				array(
					'id'    => 'topbar_text',
					'type'  => 'text',
					'title' => __( 'Top bar text', 'teta' ),
				),
				array(
					'id'     => 'topbar_text_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'topbar-compare-display',
					'type'     => 'switch',
					'title'    => __( 'Top bar Compare', 'teta' ),
					'default'  => true,
					'subtitle' => __( 'This Item Works Perfectly If WooCommerce and YithCompare Plugins are active.', 'teta' ),
				),
				array(
					'id'     => 'topbar_language_section_start',
					'type'   => 'section',
					'title'  => __( 'Language', 'teta' ),
					'indent' => true,
				),
				array(
					'id'    => 'topbar-language-1',
					'type'  => 'text',
					'title' => __( '1st Language', 'teta' ),
				),
				array(
					'id'    => 'topbar-language-link-1',
					'type'  => 'text',
					'title' => __( '1st Language URL', 'teta' ),
				),
				array(
					'id'    => 'topbar-language-2',
					'type'  => 'text',
					'title' => __( 'Second Language', 'teta' ),
				),
				array(
					'id'    => 'topbar-language-link-2',
					'type'  => 'text',
					'title' => __( 'Second Language URL', 'teta' ),
				),
				array(
					'id'    => 'topbar-language-3',
					'type'  => 'text',
					'title' => __( 'Third Language', 'teta' ),
				),
				array(
					'id'    => 'topbar-language-link-3',
					'type'  => 'text',
					'title' => __( 'Third Language URL', 'teta' ),
				),
				array(
					'id'    => 'topbar-language-4',
					'type'  => 'text',
					'title' => __( 'Fourth Language', 'teta' ),
				),
				array(
					'id'    => 'topbar-language-link-4',
					'type'  => 'text',
					'title' => __( 'Fourth Language URL', 'teta' ),
				),
				array(
					'id'     => 'topbar_language_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'topbar-social-display',
					'type'     => 'switch',
					'title'    => __( 'Social Icons', 'teta' ),
					'subtitle' => __( 'Enable or disable the social icons on the top bar.', 'teta' ),
					'default'  => true,
				),
				array(
					'id'       => 'topbar_currency_shortcode',
					'type'     => 'text',
					'title'    => __( 'Currency Switcher shortcode', 'teta' ),
					'subtitle' => __(
						"Enter the currency switcher shortcode here. The default shortcode is [woocs show_flags=0 flag_position='left']. It is obvious that you should first install 'WooCommerce Currency Switcher' plugin which is available in theme's recommended plugins.",
						'teta'
					),
					'default'  => '[woocs show_flags=0 flag_position="left"]',


				),
				array(
					'id'       => 'shop-login-link',
					'type'     => 'switch',
					'title'    => __( 'Login/My-account Button', 'teta' ),
					'subtitle' => __( 'Show the Login/My Account button or not.', 'teta' ),
					'default'  => true,
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Menu Options', 'teta' ),
			'id'     => 'kite_header_menu_options',
			'icon'   => 'icon-menu',
			'subsection' => true,
			'fields' => array(
				array(
					'id'       => 'humburger_menu_section_start',
					'type'     => 'section',
					'title'    => __( 'Humburger Menu Options', 'teta' ),
					'indent'   => true,
					'required' => array(
						array( 'header-type', '=', '10' ),
					),
				),
				array(
					'id'      => 'animated_text',
					'type'    => 'text',
					'title'   => __( 'Animated text', 'teta' ),
					'default' => '',

				),
				array(
					'id'       => 'animated_text_Bgimage',
					'type'     => 'media',
					'operator' => 'and',
					'title'    => __( 'Animated text Background Image', 'teta' ),
					'subtitle' => __( 'Choose a background image for Animated text in humburger Menu.', 'teta' ),
				),
				array(
					'id'       => 'animated_text_color',
					'type'     => 'color_rgba',
					'title'    => __( 'Animated text color', 'teta' ),
					'subtitle' => __( 'Choose a color for Animated text in humburger Menu.', 'teta' ),
					'default'  => array(
						'color' => '#25252d',
						'alpha' => '1',
					),
					'mode'     => 'background',
				),
				array(
					'id'       => 'menu_icon_color',
					'type'     => 'color_rgba',
					'title'    => __( 'Menu Icon Color', 'teta' ),
					'subtitle' => __( 'Choose a color for Menu Icon.', 'teta' ),
					'default'  => array(
						'color' => '#25252d',
						'alpha' => '1',
					),
					'mode'     => 'background',
				),
				array(
					'id'       => 'menu_icon_bgcolor',
					'type'     => 'color_rgba',
					'title'    => __( 'Menu Icon Background Color', 'teta' ),
					'subtitle' => __( 'Choose a background color for Menu Icon', 'teta' ),
					'default'  => array(
						'color' => '#fafafa',
						'alpha' => '1',
					),
					'mode'     => 'background',
				),
				array(
					'id'     => 'humburger_menu_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'cat-menu_section_start',
					'type'     => 'section',
					'title'    => __( 'Ladder Menu', 'teta' ),
					'indent'   => true,
					'required' => array( 'header-type', '=', 0 ),

				),
				array(
					'id'    	=> 'cat-menu-title',
					'type'  	=> 'text',
					'title' 	=> __( 'Ladder Menu Title', 'teta' ),
					'default'	=> __( 'All Categories', 'teta' ),
				),
				array(
					'id'       => 'cat-menu-state-open',
					'type'     => 'switch',
					'title'    => __( 'Ladder Menu State', 'teta' ),
					'subtitle' => __( 'Select State Of Ladder Menu', 'teta' ),
					'on'       => __( 'Open', 'teta' ),
					'off'      => __( 'Close', 'teta' ),
					'default'  => false,
				),
				array(
					'id'      => 'cat-menu-state-light',
					'type'    => 'switch',
					'title'   => __( 'Ladder Menu Chroma', 'teta' ),
					'on'      => __( 'Light', 'teta' ),
					'off'     => __( 'Dark', 'teta' ),
					'default' => false,
				),
				array(
					'id'     => 'cat-menu_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'hover-menu_section_start',
					'type'     => 'section',
					'title'    => __( 'Menu Titles Hover Style', 'teta' ),
					'indent'   => true,
					'required' => array(
						array( 'header-type', '!=', 7 ),
						array( 'header-type', '!=', 8 ),
						array( 'header-type', '!=', '10' ),
					),
				),
				array(
					'id'       => 'menu-hover-style',
					'type'     => 'image_select',
					'title'    => __( 'Menu Hover Style', 'teta' ),
					'subtitle' => __( 'Choose menu hover style.', 'teta' ),
					'class'    => 'menu-hover-style',
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(


						3 => array(
							'alt' => 'hover_style1',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/hover_style1.png',
						),
						2 => array(
							'alt' => 'hover_style2',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/hover_style2.png',
						),
						1 => array(
							'alt' => 'hover_style4',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/hover_style4.png',
						),
						0 => array(
							'alt' => 'hover_style3',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/hover_style3.png',
						),
					),
					'default'  => 3,

				),
				array(
					'id'     => 'hover-menu_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'initial-menu-color_section_start',
					'type'     => 'section',
					'title'    => __( 'Initial Menu Colors', 'teta' ),
					'indent'   => true,
					'required' => array(
						array( 'header-type', '!=', 8 ),
						array( 'header-type', '!=', 7 ),
					),
				),
				array(
					'id'       => 'initial-menu-background-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Background Color', 'teta' ),
					'subtitle' => __( 'Choose the color and set the opacity for initial menu.', 'teta' ),
					'default'  => array(
						'color' => '#ffffff',
						'alpha' => '1',
					),
					'required' => array(
						array( 'header-type', '!=', '10' ),
					),
					'mode'     => 'background',

				),
				array(
					'id'       => 'initial-menu-text-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Text Color', 'teta' ),
					'subtitle' => __( 'Choose the color and set the opacity for initial menu.', 'teta' ),
					'default'  => array(
						'color' => '#000000',
						'alpha' => '1',
					),

					'mode'     => 'background',

				),
				array(
					'id'       => 'initial-menu-text-color-hover',
					'type'     => 'color_rgba',
					'title'    => __( 'Text hover Color', 'teta' ),
					'subtitle' => __( 'Choose the color and set the opacity for initial menu.', 'teta' ),
					'default'  => array(
						'color' => '#000000',
						'alpha' => '1',
					),
					'required' => array(
						array( 'header-type', '=', '10' ),
					),
					'mode'     => 'background',
				),
				array(
					'id'       => 'initial-menu-text-hover-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Text Hover Color', 'teta' ),
					'subtitle' => __( 'Choose the color and set the opacity for initial menu.', 'teta' ),
					'default'  => array(
						'color' => '#000000',
						'alpha' => '1',
					),
					'class'    => 'menu-hover-color',
					'mode'     => 'background',
					'required' => array(
						array( 'menu-hover-style', '!=', 3 ),
						array( 'header-type', '!=', '10' ),

					),
				),
				array(
					'id'       => 'initial-menu-text-bg-hover-color',
					'type'     => 'color_rgba',
					'title'    => __( 'on-hover Background Color', 'teta' ),
					'subtitle' => __( 'Choose the color and set the opacity for initial menu.', 'teta' ),
					'default'  => array(
						'color' => '#307adb',
						'alpha' => '1',
					),
					'mode'     => 'background',
					'required' => array(
						array( 'header-type', '!=', '10' ),
						array( 'menu-hover-style', '!=', 3 ),
						array( 'menu-hover-style', '!=', 2 ),

					),
				),
				array(
					'id'       => 'initial-menu-border-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Border Color', 'teta' ),
					'subtitle' => __( 'Choose the color and set the opacity for initial menu.', 'teta' ),
					'default'  => array(
						'color' => '#eeeeee00',
						'alpha' => '0',
					),
					'required' => array(
						array( 'header-type', '!=', '10' ),
					),
					'mode'     => 'background',
				),
				array(
					'id'     => 'initial-menu-color_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'menu-color_section_start',
					'type'     => 'section',
					'title'    => __( 'Second State Header Menu Colors', 'teta' ),
					'indent'   => true,
					'required' => array(
						array( 'header-type', '!=', 7 ),
						array( 'header-type', '!=', '10' ),
					),
				),
				array(
					'id'      => 'menu-background-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Menu Background Color', 'teta' ),
					'default' => array(
						'color' => '#ffffff',
						'alpha' => '1',
					),
					'mode'    => 'background',
				),
				array(
					'id'      => 'menu-text-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Menu Text Color', 'teta' ),
					'default' => array(
						'color' => '#000000',
						'alpha' => '1',
					),
					'mode'    => 'background',
				),
				array(
					'id'      => 'menu-text-hover-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Menu Text Hover Color', 'teta' ),
					'default' => array(
						'color' => '#000000',
						'alpha' => '1',
					),
					'class'   => 'menu-hover-color',
					'mode'    => 'background',
				),
				array(
					'id'       => 'menu-text-bg-hover-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Menu on-hover Background Color', 'teta' ),
					'default'  => array(
						'color' => '#e8e8e8',
						'alpha' => '1',
					),
					'required' => array(
						array( 'header-type', '!=', '10' ),
					),
					'class'    => 'menu-bg-hover-color',
					'mode'     => 'background',
				),
				array(
					'id'      => 'menu-border-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Menu Border Color', 'teta' ),
					'default' => array(
						'color' => '#eee',
						'alpha' => '0',
					),
					'class'   => 'border-color',
					'mode'    => 'background',
				),
				array(
					'id'            => 'menu-opacity',
					'type'          => 'slider',
					'title'         => __( 'Menu Background image Opacity', 'teta' ),
					'default'       => 30,
					'min'           => 0,
					'step'          => 1,
					'max'           => 100,
					'display_value' => 'label',
					'required'      => array(
						array( 'header-type', '=', 7 ),
						array( 'header-type', '=', 8 ),
					),
				),
				array(
					'id'       => 'submenu-hover_section_start',
					'type'     => 'section',
					'title'    => __( 'Submenu Items Hover Style', 'teta' ),
					'indent'   => true,
					'required' => array(
						array( 'header-type', '!=', 7 ),
						array( 'header-type', '!=', 8 ),
						array( 'header-type', '!=', '10' ),
					),
				),
				array(
					'id'       => 'submenu-hover-style',
					'type'     => 'image_select',
					'title'    => __( 'Submenu Hover Style', 'teta' ),
					'subtitle' => __( 'Choose the submenu items hover style.', 'teta' ),
					'class'    => 'submenu-hover-style',
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						1 => array(
							'alt' => 'submenu_hover_style1',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/submenu_hover_style1.jpg',
						),
						0 => array(
							'alt' => 'submenu_hover_style2',
							'img' => KITE_THEME_LIB_URI . '/admin/img/menu/submenu_hover_style2.jpg',
						),
					),
					'default'  => 0,
				),
				array(
					'id'     => 'submenu-hover_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'submenu-color_section_start',
					'type'     => 'section',
					'title'    => __( 'Submenu Colors', 'teta' ),
					'indent'   => true,
					'required' => array(
						array( 'header-type', '!=', 7 ),
						array( 'header-type', '!=', 8 ),
						array( 'header-type', '!=', '10' ),
					),
				),
				array(
					'id'      => 'submenu-background-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Submenu Background Color', 'teta' ),
					'default' => array(
						'color' => '#fff',
						'alpha' => '1',
					),
					'mode'    => 'background',

				),
				array(
					'id'      => 'submenu-text-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Submenu Text Color', 'teta' ),
					'default' => array(
						'color' => '#222',
						'alpha' => '1',
					),
					'mode'    => 'background',
				),
				array(
					'id'      => 'submenu-heading-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Submenu Heading Color', 'teta' ),
					'default' => array(
						'color' => '#111',
						'alpha' => '1',
					),
					'mode'    => 'background',
				),
				array(
					'id'     => 'submenu-color_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'vertical_menu-text_start',
					'type'     => 'section',
					'title'    => __( 'vertical Menu Text and Background', 'teta' ),
					'indent'   => true,
					'required' => array(
						array( 'header-type', '=', 7 ),
						array( 'header-type', '=', 8 ),
					),
				),
				array(
					'id'       => 'vertical_menu_background',
					'type'     => 'media',
					'subtitle' => __( 'Select image that Shown In Menu Background', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Upload Menu Background', 'teta' ),
				),
				array(
					'id'      => 'vertical_menu_copyright',
					'type'    => 'text',
					'title'   => __( 'Copyright Text', 'teta' ),
					'default' => '&copy; 2021 KiteStudio | Built With The '. KITE_THEME_NAME .' Theme',
				),
				array(
					'id'     => 'vertical_menu-text_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'menu_font_section_start',
					'type'   => 'section',
					'title'  => __( 'Menu Font', 'teta' ),
					'indent' => true,
				),
				array(
					'id'      => 'font-navigation-type',
					'type'    => 'select',
					'title'   => __( 'Menu Font', 'teta' ),
					// Must provide key => value pairs for select options
					'options' => array(
						'default' => __( 'Theme default font', 'teta' ),
						'google'  => __( 'Google fonts', 'teta' ),
						'custom'  => __( 'Custom font', 'teta' ),
					),
					'default' => 'default',
				),
				array(
					'id'          => 'font-navigation',
					'type'        => 'typography',
					'title'       => __( 'Google Font', 'teta' ),
					'google'      => true,
					'font-backup' => true,
					'output'      => array( 'h2.site-description' ),
					'units'       => 'px',
					'required'    => array( 'font-navigation-type', '=', 'google' ),
				),
				array(
					'id'          => 'custom-font-url-navigation',
					'type'        => 'text',
					'title'       => __( 'Font URL', 'teta' ),
					'placeholder' => 'i.e. http://fonts.googleapis.com/css?family=Dosis',
					'required'    => array( 'font-navigation-type', '=', 'custom' ),
				),
				array(
					'id'          => 'custom-font-name-navigation',
					'type'        => 'text',
					'title'       => __( 'Font Name', 'teta' ),
					'placeholder' => 'Dosis, sans-serif',
					'required'    => array( 'font-navigation-type', '=', 'custom' ),
				),
				array(
					'id'     => 'menu_font_section_end',
					'type'   => 'section',
					'indent' => false,
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Search Options', 'teta' ),
			'id'     => 'kite_header_search_options',
			'icon'   => 'icon-search',
			'fields' => array(
				array(
					'id'       => 'searchbox-style',
					'type'     => 'switch',
					'title'    => __( 'Search Box Chroma', 'teta' ),
					'on'       => __( 'dark', 'teta' ),
					'off'      => __( 'light', 'teta' ),
					'default'  => false,
					'required' => array(
						array( 'header-type', '=', 0 ),
					),
				),
				array(
					'id'       => 'menu-search',
					'type'     => 'switch',
					'title'    => __( 'Search Button', 'teta' ),
					'subtitle' => __( 'Enable or disable search in the header.', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => true,
				),
				array(
					'id'       => 'search_post_type',
					'type'     => 'select',
					'title'    => __( 'Search', 'teta' ),
					'subtitle' => __( 'Select the post type that you want the search engine work through it.', 'teta' ),
					// Must provide key => value pairs for select options
					'options'  => array(
						'product' => __( 'Product', 'teta' ),
						'post'    => __( 'Post', 'teta' ),
					),
					'default'  => 'product',
				),
				array(
					'id'       => 'search-widget-category',
					'type'     => 'switch',
					'title'    => __( 'Index Category In Search Widget', 'teta' ),
					'subtitle' => __( 'Enable this option if you want to search categories by using search widget.', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'search_form_hide_uncategorized',
					'type'     => 'switch',
					'title'    => __( 'Hide uncategorized option in categories list', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'search_form_hide_subcategories',
					'type'     => 'switch',
					'title'    => __( 'Show only parent categories in categories list', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'search_result_columns',
					'type'     => 'switch',
					'title'    => __( 'Select search results column number', 'teta' ),
					'on'       => __( '3 Columns', 'teta' ),
					'off'      => __( '2 Columns', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'show_history_in_search',
					'type'     => 'switch',
					'title'    => __( 'Show history before search result', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'show_tags_in_search_result',
					'type'     => 'switch',
					'title'    => __( 'Search in Keywords - show tags section in search result', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'show_cats_list_in_search_result',
					'type'     => 'switch',
					'title'    => __( 'Search in categories - show categories section in search result', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => false,
				),
				array(
					'id'       => 'trident_search_enabled_items',
					'type'     => 'switch',
					'title'    => __( 'Products/Posts list', 'teta' ),
					'subtitle' => __( 'Show all products/posts', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => true,
				),
				array(
					'id'       => 'trident_search_enabled_vendors',
					'type'     => 'switch',
					'title'    => __( 'Vendors list', 'teta' ),
					'subtitle' => __( 'Show all dokan vendors that sells the product', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => false,
				),
			)
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Fonts', 'teta' ),
			'id'     => 'kite_fonts',
			'icon'   => 'icon-text-size',
			'fields' => array(
				array(
					'id'     => 'primary_font_section_start',
					'type'   => 'section',
					'title'  => __( 'Primary Font', 'teta' ),
					'indent' => true,
				),
				array(
					'id'      => 'primary-font-type',
					'type'    => 'select',
					// Must provide key => value pairs for select options
					'options' => array(
						'default' => __( 'Theme default font', 'teta' ),
						'google'  => __( 'Google fonts', 'teta' ),
						'custom'  => __( 'Custom font', 'teta' ),
					),
					'default' => 'default',
				),
				array(
					'id'          => 'primary-font',
					'type'        => 'typography',
					'title'       => __( 'Google Font', 'teta' ),
					// Must provide key => value pairs for select options
					'google'      	=> true,
					'font-backup' 	=> false,
					'font-style' 	=> false,
					'font-weight' 	=> true,
					'font-size' 	=> false,
					'subsets' 		=> false,
					'line-height' 	=> true,
					'word-spacing' 	=> false,
					'letter-spacing' => true,
					'text-align' 	=> false,
					'text-transform' => false,
					'color' 		=> false,
					'output'      	=> array( 'h2.site-description' ),
					'units'       	=> 'px',
					'required'    	=> array( 'primary-font-type', '=', 'google' ),
				),
				array(
					'id'          => 'primary-font-custom-url',
					'type'        => 'text',
					'title'       => __( 'Font URL', 'teta' ),
					'placeholder' => 'i.e. http://fonts.googleapis.com/css?family=Dosis',
					'required'    => array( 'primary-font-type', '=', 'custom' ),
				),
				array(
					'id'          => 'primary-font-custom',
					'type'        => 'text',
					'title'       => __( 'Font Name', 'teta' ),
					'placeholder' => 'Dosis, sans-serif',
					'required'    => array( 'primary-font-type', '=', 'custom' ),
				),
				array(
					'id'     => 'primary_font_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'secondary_font_section_start',
					'type'   => 'section',
					'title'  => __( 'Secondary Font', 'teta' ),
					'indent' => true,
				),
				array(
					'id'      => 'secondary-font-type',
					'type'    => 'select',
					// Must provide key => value pairs for select options
					'options' => array(
						'default' => __( 'Theme default font', 'teta' ),
						'google'  => __( 'Google fonts', 'teta' ),
						'custom'  => __( 'Custom font', 'teta' ),
					),
					'default' => 'default',
				),
				array(
					'id'          => 'secondary-font',
					'type'        => 'typography',
					'title'       => __( 'Google Font', 'teta' ),
					// Must provide key => value pairs for select options
					'google'      	=> true,
					'font-backup' 	=> false,
					'font-style' 	=> false,
					'font-weight' 	=> true,
					'font-size' 	=> false,
					'subsets' 		=> false,
					'line-height' 	=> true,
					'word-spacing' 	=> false,
					'letter-spacing' => true,
					'text-align' 	=> false,
					'text-transform' => false,
					'color' 		=> false,
					'output'      => array( 'h2.site-description' ),
					'units'       => 'px',
					'required'    => array( 'secondary-font-type', '=', 'google' ),
				),
				array(
					'id'          => 'secondary-font-custom-url',
					'type'        => 'text',
					'title'       => __( 'Font URL', 'teta' ),
					'placeholder' => 'i.e. http://fonts.googleapis.com/css?family=Dosis',
					'required'    => array( 'secondary-font-type', '=', 'custom' ),
				),
				array(
					'id'          => 'secondary-font-custom',
					'type'        => 'text',
					'title'       => __( 'Font Name', 'teta' ),
					'placeholder' => 'Dosis, sans-serif',
					'required'    => array( 'secondary-font-type', '=', 'custom' ),
				),
				array(
					'id'     => 'secondary_font_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'condenced_font_section_start',
					'type'   => 'section',
					'title'  => __( 'Condenced Font', 'teta' ),
					'indent' => true,
				),
				array(
					'id'      => 'condenced-font-type',
					'type'    => 'select',
					// Must provide key => value pairs for select options
					'options' => array(
						'default' => __( 'Theme default font', 'teta' ),
						'google'  => __( 'Google fonts', 'teta' ),
						'custom'  => __( 'Custom font', 'teta' ),
					),
					'default' => 'default',
				),
				array(
					'id'          => 'condenced-font',
					'type'        => 'typography',
					'title'       => __( 'Google Font', 'teta' ),
					// Must provide key => value pairs for select options
					'google'      	=> true,
					'font-backup' 	=> false,
					'font-style' 	=> false,
					'font-weight' 	=> true,
					'font-size' 	=> false,
					'subsets' 		=> false,
					'line-height' 	=> true,
					'word-spacing' 	=> false,
					'letter-spacing' => true,
					'text-align' 	=> false,
					'text-transform' => false,
					'color' 		=> false,
					'output'      => array( 'h2.site-description' ),
					'units'       => 'px',
					'required'    => array( 'condenced-font-type', '=', 'google' ),
				),
				array(
					'id'          => 'condenced-font-custom-url',
					'type'        => 'text',
					'title'       => __( 'Font URL', 'teta' ),
					'placeholder' => 'i.e. http://fonts.googleapis.com/css?family=Dosis',
					'required'    => array( 'condenced-font-type', '=', 'custom' ),
				),
				array(
					'id'          => 'condenced-font-custom',
					'type'        => 'text',
					'title'       => __( 'Font Name', 'teta' ),
					'placeholder' => 'Dosis, sans-serif',
					'required'    => array( 'condenced-font-type', '=', 'custom' ),
				),
				array(
					'id'     => 'condenced_font_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'      => 'google_font_display',
					'type'    => 'select',
					'title'   => __( 'Google font display type', 'teta' ),
					'options' => array(
						'disable' 	=> __( 'Disable', 'teta' ),
						'block'  	=> __( 'Block', 'teta' ),
						'swap'  	=> __( 'Swap', 'teta' ),
						'fallback'  => __( 'Fallback', 'teta' ),
						'optional'  => __( 'optional', 'teta' ),
					),
					'default' => 'disable',
				),

			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Sidebar', 'teta' ),
			'id'     => 'kite_sidebar',
			'icon'   => 'icon-exit-right',
			'fields' => array(
				array(
					'id'          => 'custom_sidebars',
					'type'        => 'multi_text',
					'title'       => __( 'Custom Sidebar', 'teta' ),
					'subtitle'    => __( ' Select a sidebar for your pages. You can customise each sidebar widget from widget panel.', 'teta' ),
					'placeholder' => __( 'Enter a sidebar name', 'teta' ),
				),
				array(
					'id'       => 'sidebar-position',
					'type'     => 'image_select',
					'title'    => __( 'Page Sidebar Position', 'teta' ),
					'subtitle' => __( 'Choose the default sidebar position for those pages that have a sidebar.', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						1 => array(
							'alt' => 'left-side',
							'img' => KITE_THEME_LIB_URI . '/admin/img/left-sidebar.png',
						),
						2 => array(
							'alt' => 'right-side',
							'img' => KITE_THEME_LIB_URI . '/admin/img/right-sidebar.png',
						),
					),
					'default'  => 2,
				),
				array(
					'id'       => 'blog-sidebar-position',
					'type'     => 'image_select',
					'title'    => __( 'Blog and Blog Detail Sidebar', 'teta' ),
					'subtitle' => __( 'Here you can disable or enable the sidebar for your blog and blog detail.', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						'no-sidebar'   => array(
							'alt' => 'no-sidebar',
							'img' => KITE_THEME_LIB_URI . '/admin/img/no-sidebar.png',
						),
						'main-sidebar' => array(
							'alt' => 'main-sidebar',
							'img' => KITE_THEME_LIB_URI . '/admin/img/right-sidebar.png',
						),
						'left-sidebar' => array(
							'alt' => 'left-sidebar',
							'img' => KITE_THEME_LIB_URI . '/admin/img/left-sidebar.png',
						),
					),
					'default'  => 'main-sidebar',
				),
				array(
					'id'       => 'single-blog-sidebar-position',
					'type'     => 'image_select',
					'title'    => __( 'Blog Detail Sidebar', 'teta' ),
					'subtitle' => __( 'Here you can disable or enable the sidebar for your blog detail.', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						'no-sidebar'   => array(
							'alt' => 'no-sidebar',
							'img' => KITE_THEME_LIB_URI . '/admin/img/no-sidebar.png',
						),
						'main-sidebar' => array(
							'alt' => 'main-sidebar',
							'img' => KITE_THEME_LIB_URI . '/admin/img/right-sidebar.png',
						),
						'left-sidebar' => array(
							'alt' => 'left-sidebar',
							'img' => KITE_THEME_LIB_URI . '/admin/img/left-sidebar.png',
						),
					),
					'default'  => 'main-sidebar',
				),
				array(
					'id'       => 'blog_has_fixed_sidebar_style',
					'type'     => 'switch',
					'title'    => __( 'Enable this option if you want fixed sidebar style in blog and blog deatil pages', 'teta' ),
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'default'  => false,
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Shop Page', 'teta' ),
			'id'     => 'kite_woocommerce',
			'icon'   => 'icon-store',
			'fields' => array(
				array(
					'id'       => 'shop-column',
					'type'     => 'image_select',
					'title'    => __( 'Shop page Columns Number', 'teta' ),
					'subtitle' => __( 'Choose the number of products showing in every row in shop page.', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						5 => array(
							'alt' => 'five',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/five.png',
						),
						4 => array(
							'alt' => 'four',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/four.png',
						),
						3 => array(
							'alt' => 'three',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/three.png',
						),
						2 => array(
							'alt' => 'two',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/two.png',
						),
					),

					'default'  => 4,
				),
				array (
					'id'       => 'shop-column-tablet',
					'type'     => 'select',
					'title'    => __('Shop columns in tablet', 'teta'),
					'subtitle' => __('show products in a row in tablet.','teta'),
					'options'  => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
					),
					'default'  => '3'
				),
				array(
					'id'       => 'shop-column-responsive',
					'type'     => 'select',
					'title'    => __( 'Shop columns in mobile', 'teta' ),
					'subtitle' => __( 'show products in a row in responsive mode.', 'teta' ),
					// Must provide key => value pairs for select options
					'options'  => array(
						'1' => '1',
						'2' => '2',
					),
					'default'  => '1',
				),
				array(
					'id'     => 'shop_item_section_start',
					'type'   => 'section',
					'title'  => __( 'Products Per Page', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'shop-item-per-page',
					'type'     => 'select',
					'title'    => __( 'Items Per Page', 'teta' ),
					'subtitle' => __( 'The number of products that will be shown in a single page of your shop.', 'teta' ),
					// Must provide key => value pairs for select options
					'options'  => array(
						'1'  => '1',
						'2'  => '2',
						'3'  => '3',
						'4'  => '4',
						'5'  => '5',
						'6'  => '6',
						'7'  => '7',
						'8'  => '8',
						'9'  => '9',
						'10' => '10',
						'11' => '11',
						'12' => '12',
						'13' => '13',
						'14' => '14',
						'15' => '15',
						'16' => '16',
						'17' => '17',
						'18' => '18',
						'19' => '19',
						'20' => '20',
						'21' => '21',
						'22' => '22',
						'23' => '23',
						'24' => '24',
						'25' => '25',
						'26' => '26',
						'27' => '27',
						'28' => '28',
						'29' => '29',
						'30' => '30',
					),
					'default'  => '12',
				),
				array(
					'id'     => 'shop_page_pagination',
					'type'   => 'section',
					'title'  => __( 'Products Pagination', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'products-pagination',
					'type'     => 'select',
					'title'    => __( 'Products Pagination Type', 'teta' ),
					'subtitle' => __( 'Choose one of these shop pagination methods.', 'teta' ),
					'options'  => array(
						'pagination'      => 'Pagination',
						'load_more'       => 'Load More Button',
						'infinite_scroll' => 'Infinite Scroll',
					),
					'default'  => 'pagination',
				),
				array(
					'id'       => 'ajax_shop_pagination',
					'type'     => 'switch',
					'title'    => __( 'Shop AJAX Pagination', 'teta' ),
					'subtitle' => __( 'Enable/Disable the shop page AJAX pagination.', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable AJAX Pagination', 'teta' ),
					'off'      => __( 'Disable AJAX Pagination', 'teta' ),
					'required' => array( 'products-pagination', '=', 'pagination' ),
				),
				array(
					'id'     => 'shop_item_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'shop_layout_section_start',
					'type'   => 'section',
					'title'  => __( 'Product View Options', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'shop-product-view',
					'type'     => 'select',
					'title'    => __( 'Products layout', 'teta' ),
					'subtitle' => __( 'Choose the layout of shop page products.', 'teta' ),
					'options'  => array(
						'grid'    => __( 'Tiles', 'teta' ),
						'list'    => __( 'List', 'teta' ),
						'grid_sv' => __( 'Tiles with List view option', 'teta' ),
						'list_sv' => __( 'List with Grid view option', 'teta' ),
					),
					'default'  => 'grid',
				),
				array(
					'id'      => 'responsive-product-list-view',
					'type'    => 'switch',
					'title'   => __( 'List View In Responsive', 'teta' ),
					'default' => false,
					'on'      => __( 'Yes', 'teta' ),
					'off'     => __( 'No', 'teta' ),
					'required' => array( 'shop-product-view', '!=', 'grid' )
				),
				array(
					'id'       => 'shop-layout',
					'type'     => 'image_select',
					'title'    => __( 'Grid View', 'teta' ),
					'subtitle' => __( 'Products grid view style in shop page.', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						'fitRows' => array(
							'alt' => 'fitRows',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/fitRows.png',
						),
						'masonry' => array(
							'alt' => 'masonry',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/masonry.png',
						),
					),
					'default'  => 'fitRows',
				),
				array(
					'id'     => 'shop_layout_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'shop_style_section_start',
					'type'   => 'section',
					'title'  => __( 'Product Card Style', 'teta' ),
					'indent' => true,
				),
				array(
					'id'      => 'shop-product-style',
					'type'    => 'image_select',
					'options' => array(
						'modern-buttons-on-hover'     => array(
							'alt' => 'modern-buttons-on-hover',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/modern-buttons-on-hover.png',
						),
						'buttonsonhover'     => array(
							'alt' => 'buttonsonhover',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/classic.png',
						),
						'centered'           => array(
							'alt' => 'centered',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/centered.png',
						),
						'infoonhover'        => array(
							'alt' => 'infoonhover',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/info-on-hover.png',
						),
						'infoonclick'        => array(
							'alt' => 'infoonclick',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/info-on-click.png',
						),
						'instantshop'        => array(
							'alt' => 'instantshop',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/instant-shop.png',
						),
						'buttonsappearunder' => array(
							'alt' => 'buttonsappearunder',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/buttonsappearunder.png',
						),
					),
					'default' => 'modern-buttons-on-hover',
					'class'   => 'shop-styles',
				),
				array(
					'id'       => 'product-hover-color',
					'type'     => 'image_select',
					'title'    => __( 'Product Hover Color', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						'c0392b'       => array(
							'alt' => 'c0392b',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/c0392b.png',
						),
						'e74c3c'       => array(
							'alt' => 'e74c3c',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/e74c3c.png',
						),
						'd35400'       => array(
							'alt' => 'd35400',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/d35400.png',
						),
						'e67e22'       => array(
							'alt' => 'e67e22',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/e67e22.png',
						),
						'f39c12'       => array(
							'alt' => 'f39c12',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/f39c12.png',
						),
						'f1c40f'       => array(
							'alt' => 'f1c40f',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/f1c40f.png',
						),
						'1abc9c'       => array(
							'alt' => '1abc9c',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/1abc9c.png',
						),
						'2ecc71'       => array(
							'alt' => '2ecc71',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/2ecc71.png',
						),
						'3498db'       => array(
							'alt' => '3498db',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/3498db.png',
						),
						'01558f'       => array(
							'alt' => '01558f',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/01558f.png',
						),
						'9b59b6'       => array(
							'alt' => '9b59b6',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/9b59b6.png',
						),
						'ecf0f1'       => array(
							'alt' => 'ecf0f1',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/ecf0f1.png',
						),
						'bdc3c7'       => array(
							'alt' => 'bdc3c7',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/bdc3c7.png',
						),
						'7f8c8d'       => array(
							'alt' => '7f8c8d',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/7f8c8d.png',
						),
						'95a5a6'       => array(
							'alt' => '95a5a6',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/95a5a6.png',
						),
						'34495e'       => array(
							'alt' => '34495e',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/34495e.png',
						),
						'2e2e2e'       => array(
							'alt' => '2e2e2e',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/2e2e2e.png',
						),
						'custom-color' => array(
							'alt' => 'custom',
							'img' => KITE_THEME_LIB_URI . '/admin/img/vcimages/custom-color.png',
						),
					),
					'default'  => 'c0392b',
					'class'    => 'product_hover_preset',
					'required' => array(
						array( 'shop-product-style', '!=', 'buttonsappearunder' ),
						array( 'shop-product-style', '!=', 'buttonsonhover' ),
						array( 'shop-product-style', '!=', 'centered' ),
						array( 'shop-product-style', '!=', 'instantshop' ),
						array( 'shop-product-style', '!=', 'modern-buttons-on-hover' ),
					),
				),
				array(
					'id'       => 'product-hover-custom-color',
					'type'     => 'color_rgba',
					'title'    => __( 'Custom Hover Color', 'teta' ),
					'default'  => array(
						'color' => '#fff',
						'alpha' => '1',
					),
					'mode'     => 'background',
					'required' => array(
						array( 'shop-product-style', '!=', 'buttonsappearunder' ),
						array( 'shop-product-style', '!=', 'buttonsonhover' ),
						array( 'shop-product-style', '!=', 'centered' ),
						array( 'shop-product-style', '!=', 'instantshop' ),
						array( 'shop-product-style', '!=', 'modern-buttons-on-hover' ),
						array( 'product-hover-color', '=', 'custom-color' ),
					),
				),
				array(
					'id'      => 'shop-product-color-scheme',
					'type'    => 'switch',
					'title'   => __( 'Products Color Scheme', 'teta' ),
					'default' => true,
					'on'      => __( 'Light', 'teta' ),
					'off'     => __( 'Dark', 'teta' ),
				),
				array(
					'id'      => 'modern-button-on-hover-style',
					'title'   => __( 'Product Buttons Style', 'teta' ),
					'type'    => 'image_select',
					'options' => array(
						'horizontal'     => array(
							'alt' => 'modern-buttons-on-hover',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/horizontal.png',
						),
						'vertical'     => array(
							'alt' => 'buttonsonhover',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/vertical.png',
						),
					),
					'default' => 'horizontal',
					'required' => array(
						array( 'shop-product-style', '=', 'modern-buttons-on-hover' ),
					),
				),
				array(
					'id'      => 'modern-button-on-hover-cart-style',
					'title'   => __( 'Cart Button Style', 'teta' ),
					'type'    => 'image_select',
					'options' => array(
						'default'     => array(
							'alt' => 'modern-buttons-on-hover',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/vertical.png',
						),
						'stretched'     => array(
							'alt' => 'buttonsonhover',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/stretched.png',
						),
						'quantity'     => array(
							'alt' => 'buttonsonhover',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/quantity.png',
						),
					),
					'default' => 'default',
					'required' => array(
						array( 'modern-button-on-hover-style', '=', 'vertical' ),
					),
				),
				array(
					'id'       => 'shop-product-gutter',
					'type'     => 'switch',
					'title'    => __( 'Gutter', 'teta' ),
					'subtitle' => __( 'The gutter between products in the main shop page.', 'teta' ),
					'default'  => true,
					'on'       => __( 'With Gutter', 'teta' ),
					'off'      => __( 'No Gutter', 'teta' ),
				),
				array(
					'id'       => 'shop-product-border',
					'type'     => 'switch',
					'title'    => __( 'Border', 'teta' ),
					'subtitle' => __( 'The border of each product in the main shop page.', 'teta' ),
					'default'  => true,
					'on'       => __( 'With Border', 'teta' ),
					'off'      => __( 'No Border', 'teta' ),
				),
				array(
					'id'      => 'shop-product-rating',
					'type'    => 'switch',
					'title'   => __( 'Product Rating', 'teta' ),
					'default' => false,
					'class'   => 'product_rating',
					'on'      => __( 'Show Rating', 'teta' ),
					'off'     => __( 'Hide Rating', 'teta' ),
				),
				array(
					'id'      => 'shop-loop-product-categories',
					'type'    => 'switch',
					'title'   => __( 'Product Categories', 'teta' ),
					'subtitle' => __( 'Show/Hide product categories on product cards', 'teta' ),
					'default' => true,
					'on'      => __( 'Show Categories', 'teta' ),
					'off'     => __( 'Hide Categories', 'teta' ),
				),
				array(
					'id'       => 'percentage_sale',
					'type'     => 'switch',
					'title'    => __( 'On-Sale Products Percentage Badge', 'teta' ),
					'subtitle' => __( 'Enable/ Disable Percentage sale badge on products', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'shop-entrance-animation',
					'type'    => 'select',
					'title'   => __( 'Entrance animation', 'teta' ),
					// Must provide key => value pairs for select options
					'options' => array(
						'fadein'           => __( 'FadeIn', 'teta' ),
						'fadeinfrombottom' => __( 'FadeIn From Bottom', 'teta' ),
						'fadeinfromtop'    => __( 'FadeIn From Top', 'teta' ),
						'fadeinfromright'  => __( 'FadeIn From Right', 'teta' ),
						'fadeinfromleft'   => __( 'FadeIn From Left', 'teta' ),
						'zoomin'           => __( 'Zoom-in', 'teta' ),
						'default'          => __( 'No animation', 'teta' ),
					),
					'default' => 'fadein',
				),
				array(
					'id'     => 'shop_style_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'variations_on_card_section_start',
					'title'	 =>	esc_html( 'Product Variations', 'teta' ),
					'type'   => 'section',
					'indent' => true,
				),
				array(
					'id'      => 'show_card_variations_desktop',
					'type'    => 'switch',
					'title'   => __( 'Show Variations On Product Cards', 'teta' ),
					'default' => true,
					'on'      => __( 'Enable', 'teta' ),
					'off'     => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'show_card_variations_tablet',
					'type'    => 'switch',
					'title'   => __( 'Show Variations On Product Cards - Tablet', 'teta' ),
					'default' => true,
					'on'      => __( 'Enable', 'teta' ),
					'off'     => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'show_card_variations_mobile',
					'type'    => 'switch',
					'title'   => __( 'Show Variations On Product Cards - Mobile', 'teta' ),
					'default' => true,
					'on'      => __( 'Enable', 'teta' ),
					'off'     => __( 'Disable', 'teta' ),
				),
				array (
					'id'       => 'show_variations_number_badge',
					'type'     => 'switch',
					'title'    => __('Show variations number badge on product cards', 'teta'),
					'default'  => false,
					'on'       => __( 'On', 'teta' ),
					'off'      => __( 'Off', 'teta' ),
				),
				array(
					'id'     => 'variations_on_card_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'      => 'shop-enable-fullwidth',
					'type'    => 'switch',
					'title'   => __( 'Full Width Shop Page', 'teta' ),
					'default' => false,
					'on'      => __( 'Enable', 'teta' ),
					'off'     => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'shop-sidebar-position',
					'type'     => 'image_select',
					'title'    => __( 'Filter Sidebar Position', 'teta' ),
					'subtitle' => __( 'Choose the default filter sidebar position shop page.', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						0 => array(
							'alt' => 'none',
							'img' => KITE_THEME_LIB_URI . '/admin/img/no-sidebar.png',
						),
						1 => array(
							'alt' => 'left-side',
							'img' => KITE_THEME_LIB_URI . '/admin/img/left-sidebar.png',
						),
						2 => array(
							'alt' => 'right-side',
							'img' => KITE_THEME_LIB_URI . '/admin/img/right-sidebar.png',
						),
					),
					'default'  => 0,
					'class'    => 'page-sidebar',
				),
				array(
					'id'     => 'recently_viewed_product_section_start',
					'type'   => 'section',
					'title'  => __( 'Recently Viewed Products', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'recently_viewed_product',
					'type'     => 'switch',
					'title'    => __( 'Recently viewed products', 'teta' ),
					'subtitle' => __( 'Enable or disable recently viewd products on product page', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'recently_viewed_product_display',
					'type'     => 'switch',
					'title'    => __( 'Recently viewed products Display', 'teta' ),
					'default'  => true,
					'on'       => __( 'Full width', 'teta' ),
					'off'      => __( 'Container', 'teta' ),
					'required' => array( 'recently_viewed_product', '=', true ),
				),
				array(
					'id'       => 'recently_viewed_product_responsive',
					'type'     => 'switch',
					'title'    => __( 'Recently viewed products Display in Mobile', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'required' => array( 'recently_viewed_product', '=', true ),
				),
				array(
					'id'     => 'recently_viewed_product_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'shop_catalog_section_start',
					'title'  => __( 'Catalog Mode', 'teta' ),
					'type'   => 'section',
					'indent' => true,
				),
				array(
					'id'      => 'catalog_mode',
					'type'    => 'switch',
					'title'   => __( 'Catalog Mode Display', 'teta' ),
					'subtitle'=> __( 'Note that if you enable this option, the add to cart button and cart  will be deactivated', 'teta' ),
					'default' => false,
					'on'      => __( 'Enable', 'teta' ),
					'off'     => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'catalog_mode_price',
					'type'     => 'switch',
					'title'    => __( 'Price in Catalog Mode', 'teta' ),
					'default'  => false,
					'on'       => __( 'Show Price', 'teta' ),
					'off'      => __( 'Hide Price', 'teta' ),
					'required' => array( 'catalog_mode', '=', true ),
				),
				array(
					'id'     => 'shop_catalog_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'      => 'shop-enable-quickview',
					'type'    => 'switch',
					'title'   => __( 'Quick View', 'teta' ),
					'default' => false,
					'on'      => __( 'Enable', 'teta' ),
					'off'     => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'product-hover-image',
					'type'     => 'switch',
					'title'    => __( 'Products Hover Image', 'teta' ),
					'subtitle' => __( 'If you enable this, The first image of gallery will be shown as hover of each product', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'     => 'shop_category_page_section_start',
					'type'   => 'section',
					'title'	 => __( 'Category Page', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'category-description-position',
					'type'     => 'switch',
					'title'    => __( 'Category Description Position', 'teta' ),
					'subtitle' => __( 'You can manage the position of categories description with this option', 'teta' ),
					'default'  => true,
					'on'       => __( 'On The Header', 'teta' ),
					'off'      => __( 'After The Header', 'teta' ),
				),
				array(
					'id'       => 'responsive-category-header',
					'type'     => 'switch',
					'title'    => __( 'Responsive Category Header', 'teta' ),
					'subtitle' => __( 'Enable/Disable category header title and description in responsive devices', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'     => 'shop_category_page_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'shop_widgets_start',
					'type'   => 'section',
					'title'	 => __( 'Widgets Settings', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'rating_in_woocommerce_product_widget',
					'type'     => 'switch',
					'title'    => __( 'Rating in woocommerce products widget', 'teta' ),
					'subtitle' => __( 'Enable/Disable Rating in woocommerce products widget', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array (
					'id'       => 'show_more_button_in_woocommerce_categories_widget',
					'type'     => 'switch',
					'title'    => __('Show More button in woocommerce categories widget', 'teta'),
					'subtitle'     => __('Enable/Disable Show More button in woocommerce categories widget', 'teta'),
					'default'  => true,
					'on'       => __('Enable', 'teta'),
					'off'      => __('Disable', 'teta'),
				),
				array (  
					'id'       => 'show_more_button_in_woocommerce_widgets',
					'type'     => 'switch',
					'title'    => __('Show More button in woocommerce widgets', 'teta'),
					'subtitle' => __('Enable/Disable Show More button in woocommerce widgets', 'teta'),
					'default'  => true,
					'on'       => __('Enable', 'teta'),
					'off'      => __('Disable', 'teta'),
				),
				array (
					'id'       => 'categories_widget_scroll_animation',
					'type'     => 'switch',
					'title'    => __('Categories widget scroll animation', 'teta'),
					'subtitle'    => __('Enable/Disable categories widget scroll animation in shop page', 'teta'),
					'default'  => false,
					'on'       => __('Enable', 'teta'),
					'off'      => __('Disable', 'teta'),
				),
				array(
					'id'     => 'shop_widgets_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id' 		=> 'shop_template_section_start',
					'type' 		=> 'section',
					'title' 	=> __( 'Shop Extra Templates', 'teta' ),
					'indent' 	=> true,
				),
				array (
					'id'       => 'shop_show_top_template',
					'type'     => 'switch',
					'title'    => __('Shop Page Top Template', 'teta'),
					'subtitle' => __( 'You can add Elemntor templates at the top of the shop page', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'shop_top_template_id',
					'type'    => 'select',
					'title'   => __( 'Select Template', 'teta' ),
					'options' => kite_get_elementor_templates_list( 'container' ),
					'required'=> array( 'shop_show_top_template', '=' , true ),
				),
				array (
					'id'       => 'shop_show_bottom_template',
					'type'     => 'switch',
					'title'    => __('Shop Page Bottom Template', 'teta'),
					'subtitle' => __( 'You can add Elemntor templates at the bottom of the shop page', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'shop_bottom_template_id',
					'type'    => 'select',
					'title'   => __( 'Select Template', 'teta' ),
					'options' => kite_get_elementor_templates_list( 'container' ),
					'required'=> array( 'shop_show_bottom_template', '=' , true ),
				),
				array(
					'id' => 'shop_template_section_end',
					'type' => 'section',
					'indent' => false,
				),
				array(
					'id' => 'shop_extra_options_section_start',
					'type' => 'section',
					'title' =>__( 'Shop Extra Options', 'teta' ),
					'indent' => true,
				),
				array (
					'id'       => 'direct_link_external_products',
					'type'     => 'switch',
					'title'    => __('Bypass product detail in External/Affiliate products', 'teta'),
					'subtitle' => __('Link external products directly to product url instead of product detail page', 'teta'),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array (
					'id'       => 'remove_responsive_hover_state',
					'type'     => 'switch',
					'title'    => __('Remove responsive product cards hover state', 'teta'),
					'default'  => false,
					'on'       => __( 'On', 'teta' ),
					'off'      => __( 'Off', 'teta' ),
				),
				array (
					'id'       => 'show_custom_label_in_shop',
					'type'     => 'switch',
					'title'    => __('Show custom label on product cards', 'teta'),
					'default'  => true,
					'on'       => __( 'On', 'teta' ),
					'off'      => __( 'Off', 'teta' ),
				),
				array(
					'id'       => 'trim_mini_cart_product_title',
					'type'     => 'text',
					'title'    => __('Trim Product Title In Mini Cart','teta'),
					'subtitle'     => __( 'If you want to trim product title in mini cart, specify length of title.', 'teta'),
				),
				array (
					'id'       => 'show_out_of_stock_products_price',
					'type'     => 'switch',
					'title'    => __('Out of stock products price', 'teta'),
					'subtitle' => __('Show out of stock products price on their product cards and single product page', 'teta'),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id' => 'shop_extra_options_section_end',
					'type' => 'section',
					'indent' => false,
				),
				array (
					'id'       => 'does_products_have_purchase_limit',
					'type'     => 'switch',
					'title'    => __('Set Purchase limit for products', 'teta'),
					'subtitle'     => __('If you enable this option, you\'ll set the maximum number for a product per order which user can buy.', 'teta'),
					'default'  => false,
					'on'       => __( 'On', 'teta' ),
					'off'      => __( 'Off', 'teta' ),
				),
				array(
					'id'       => 'max_products_purchase_number',
					'type'     => 'text',
					'title'    => __('Maximum number of purchasable products','teta'),
					'required' => array('does_products_have_purchase_limit', '=' , true)
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Shop Filters Toolbar', 'teta' ),
			'id'     => 'kite_shop_page_filters',
			'icon'   => 'icon-filter',
			'subsection' => true,
			'fields' => array(
				array(
					'id'       => 'shop-filter',
					'type'     => 'switch',
					'title'    => __( 'Shop Filter display', 'teta' ),
					'subtitle' => __( 'Enable or disable Shop Filter Toolbar on top of the products in shop page.', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'shop-filter-style',
					'type'     => 'switch',
					'title'    => __( 'Shop Filter Toggling Style', 'teta' ),
					'subtitle' => __( 'Choose Shop filter display on shop page.', 'teta' ),
					'default'  => true,
					'on'       => __( 'Top expandable filters', 'teta' ),
					'off'      => __( 'Off-canvas filters', 'teta' ),
					'required' => array(
						array( 'shop-filter', '=', true ),
					),
				),
				array(
					'id'       => 'always-open-expandable-filters',
					'type'     => 'switch',
					'title'    => __( 'Expandable filter style', 'teta' ),
					'subtitle' => __( 'Set style of expandable filters', 'teta' ),
					'default'  => false,
					'on'       => __( 'Always open', 'teta' ),
					'off'      => __( 'Expandable', 'teta' ),
					'required' => array(
						array( 'shop-filter-style', '=', true ),
					),
				),
				array(
					'id'       => 'shop-filter-categories',
					'type'     => 'switch',
					'title'    => __( 'Categories Dropdown Display', 'teta' ),
					'subtitle' => __( 'Caategories dropdown showing in the shop filter toolbar.', 'teta' ),
					'default'  => true,
					'on'       => __( 'Show Categories', 'teta' ),
					'off'      => __( 'Hide Categories', 'teta' ),

				),
				array(
					'id'       => 'shop_filter_hidden_empty_category',
					'type'     => 'switch',
					'title'    => __( 'Empty Category Showing', 'teta' ),
					'default'  => false,
					'on'       => __( 'Show empty categories', 'teta' ),
					'off'      => __( 'Hide empty categories', 'teta' ),
					'required' => array( 'shop-filter-categories', '=', true ),
				),
				array(
					'id'      => 'shop-filter-sorting',
					'type'    => 'switch',
					'title'   => __( 'Sorting Filter', 'teta' ),
					'default' => true,
					'on'      => __( 'Show Sorting filter', 'teta' ),
					'off'     => __( 'Hide Sorting filter', 'teta' ),
				),
				array(
					'id'       => 'product-per-page',
					'type'     => 'switch',
					'title'    => __( 'Product Per Page Filter', 'teta' ),
					'subtitle' => __( 'Product Per Page Filter is shown when the main Shop pagination method is on pagination.', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'shop-filter-active-filters',
					'type'    => 'switch',
					'title'   => __( 'Active Filters', 'teta' ),
					'default' => true,
					'on'      => __( 'Show Active filters', 'teta' ),
					'off'     => __( 'Hide Active filters', 'teta' ),
				),
				array(
					'id'      => 'shop-filter-search',
					'type'    => 'switch',
					'title'   => __( 'Search Filter', 'teta' ),
					'default' => true,
					'on'      => __( 'Show Search', 'teta' ),
					'off'     => __( 'Hide Search', 'teta' ),
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Free Shipping Threshold', 'teta' ),
			'id'     => 'kite_shop_page_free_shipping',
			'icon'   => 'icon-truck',
			'subsection' => true,
			'fields' => array(
				array (
					'id'       => 'show_free_shipping_threshold',
					'type'     => 'switch',
					'title'    => __('Show free shipping threshold notice', 'teta'),
					'default'  => false,
					'on'       => __('Enable', 'teta'),
					'off'      => __('Disable', 'teta'),
				),
				array(
					'id'       => 'minimum_free_shipping_amount',
					'type'     => 'text',
					'title'    => __('Required amount to show free shipping','teta'),
					'subtitle'     => __('You should enable free shipping and minimum amount for free shipping in Woocommerce -> settings -> shipping -> shipping zones -> manage shipping method', 'teta'),
					'required' => array('show_free_shipping_threshold', '=' , true)
				),
				array (
					'id'       => 'threshold_notice_price_color',
					'type'     => 'color_rgba',
					'title'    => __('Price Color', 'teta'),
					'subtitle'     => __('This color only applies in product detail page.', 'teta'),
					'default'  => array(
						'color' => '#ee1c25',
						'alpha' => '1'
					),
					'required' => array('show_free_shipping_threshold', '=' , true),
					'mode'     => 'background',

				),
				array (
					'id'       => 'threshold_notice_background_color',
					'type'     => 'color_rgba',
					'title'    => __('Notice Background Color', 'teta'),
					'default'  => array(
						'color' => '#a7a7a7',
						'alpha' => '1'
					),
					'required' => array('show_free_shipping_threshold', '=' , true),
					'mode'     => 'background',

				),
				array (
					'id'       => 'threshold_notice_progress_background_color',
					'type'     => 'color_rgba',
					'title'    => __('Notice Progress Background Color', 'teta'),
					'default'  => array(
						'color' => '#21c809',
						'alpha' => '1'
					),
					'required' => array('show_free_shipping_threshold', '=' , true),
					'mode'     => 'background',

				),
				array (
					'id'       => 'threshold_notice_text_color',
					'type'     => 'color_rgba',
					'title'    => __('Notice Text Color', 'teta'),
					'default'  => array(
						'color' => '#ffffff',
						'alpha' => '1'
					),
					'required' => array('show_free_shipping_threshold', '=' , true),
					'mode'     => 'background',

				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Product Details', 'teta' ),
			'id'     => 'kite_Product_Detail',
			'icon'   => 'icon-product-hunt',
			'fields' => array(
				array(
					'id'       => 'product-detail-style',
					'type'     => 'image_select',
					'title'    => __( 'Layout', 'teta' ),
					'subtitle' => __( 'Select product details page layout style', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						'pd_classic'         => array(
							'alt' => 'pd_classic',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_classic.png',
						),
						'pd_top'             => array(
							'alt' => 'pd_top',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_top.png',
						),
						'pd_kt_classic'      => array(
							'alt' => 'pd_kt_classic',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_kt_classic.png',
						),
						'pd_background'      => array(
							'alt' => 'pd_background',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_background.png',
						),
						'pd_classic_sidebar' => array(
							'alt' => 'pd_classic_sidebar',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_classic_sidebar.png',
						),
						'pd_fixed_summary'   => array(
							'alt' => 'pd_fixed_summary',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_fixed.png',
						),
						'pd_col_gallery'   => array(
							'alt' => 'pd_col_gallery',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_col_gallery.png',
						),
						'pd_sticky'   => array(
							'alt' => 'pd_sticky',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_sticky.png',
						),
						'pd_fullwidth_top'             => array(
							'alt' => 'pd_fullwidth_top',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_fullwidth_top.png',
						),
					),
					'default'  => 'pd_classic',
					'class'    => 'product-detail',
				),
				array(
					'id'       => 'product_detail_gallery_sidebar',
					'type'     => 'switch',
					'title'    => __( 'Sidebar In product column gallery style', 'teta' ),
					'default'  => true,
					'on'       => __( 'Hide sidebar', 'teta' ),
					'off'      => __( 'Show sidebar', 'teta' ),
					'required' => array( 'product-detail-style', '=', 'pd_col_gallery' ),
				),
				array(
					'id'       => 'product-detail-gallery-sidebar-position',
					'type'     => 'image_select',
					'title'    => __( 'Product detail sidebar position', 'teta' ),
					'subtitle' => __( 'Choose product detail sidebar position', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						'left'  => array(
							'alt' => 'left',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_left_sidebar.png',
						),
						'right' => array(
							'alt' => 'right',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_right_sidebar.png',
						),
					),
					'default'  => 'right',
					'class'    => 'product-detail-gallery-sidebar',
					'required' =>array( 'product_detail_gallery_sidebar', '=', false ),

				),
				array(
					'id'       => 'product-detail-sidebar-position',
					'type'     => 'image_select',
					'title'    => __( 'Product detail sidebar position', 'teta' ),
					'subtitle' => __( 'Choose product detail sidebar position', 'teta' ),
					// Must provide key => value(array:title|img) pairs for radio options
					'options'  => array(
						'left'  => array(
							'alt' => 'left',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_left_sidebar.png',
						),
						'right' => array(
							'alt' => 'right',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/pd_right_sidebar.png',
						),
					),
					'default'  => 'right',
					'class'    => 'product-detail-sidebar',
					'required' => array( 'product-detail-style', '=', 'pd_classic_sidebar' ),


				),
				array(
					'id'       => 'product-detail-sidebar-responsive',
					'type'     => 'switch',
					'title'    => __( 'Sidebar In Responsive', 'teta' ),
					'default'  => false,
					'on'       => __( 'Show sidebar in responsive', 'teta' ),
					'off'      => __( 'Hide sidebar in responsive', 'teta' ),
					'required' => array( 'product-detail-style', '=', 'pd_classic_sidebar' ),
				),
				array (
					'id'       => 'gallery-column-number',
					'type'     => 'select',
					'title'    => __('gallery column ', 'teta'),
					'subtitle' => __('show images gallery.','teta'),
					'options'  => array(
						'2' => '2',
						'3' => '3',
					),
					'required' => array( 'product-detail-style', '=', 'pd_col_gallery' ),
					'default'  => '3'
				),
				array(
					'id'       => 'product_detail_txt_color',
					'type'     => 'switch',
					'title'    => __( 'Product detail text-color', 'teta' ),
					'subtitle' => __( 'Choose a color for the text of "Product short description" on the product detail page.', 'teta' ),
					'on'       => __( 'Dark', 'teta' ),
					'off'      => __( 'Light', 'teta' ),
					'required' => array( 'product-detail-style', '=', 'pd_background' ),

				),
				array(
					'id'       => 'product-detail-bg',
					'type'     => 'color_rgba',
					'title'    => __( 'Product detail background-color', 'teta' ),
					'subtitle' => __( 'Choose a color for background of product detail page and thumbnails', 'teta' ),
					'default'  => array(
						'color' => '#fff',
						'alpha' => '1',
					),
					'mode'     => 'background',
					'required' => array(
						array( 'product-detail-style', '!=', 'pd_classic' ),
						array( 'product-detail-style', '!=', 'pd_kt_classic' ),
						array( 'product-detail-style', '!=', 'pd_classic_sidebar' ),
						array( 'product-detail-style', '!=', 'pd_fixed_summary' ),
						array( 'product-detail-style', '!=', 'pd_col_gallery' ),
						array( 'product-detail-style', '!=', 'pd_sticky' ),
						array( 'product-detail-style', '!=', 'pd_fullwidth_top' ),
					),
				),
				array(
					'id'      => 'product-gallery-direction',
					'type'    => 'switch',
					'title'   => __( 'Product gallery direction in Product details', 'teta' ),
					'on'      => __( 'right', 'teta' ),
					'off'     => __( 'left', 'teta' ),
					'default' => false,
					'required' => array(
						array( 'product-detail-style', '!=', 'pd_top' ),
						array( 'product-detail-style', '!=', 'pd_fullwidth_top' ),
					),

				),
				array(
					'id' => 'variable_options_start',
					'type' => 'section',
					'title'	=> __( 'Variable Options', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'variations_select_style',
					'type'     => 'switch',
					'title'    => __( 'Variations Select Style', 'teta' ),
					'subtitle' => __( 'Select Variable Selection Style in Product detail', 'teta' ),
					'default'  => true,
					'on'       => __( 'Swatch Style', 'teta' ),
					'off'      => __( 'Dropdown Style', 'teta' ),
				),
				array(
					'id'       => 'variable_title',
					'type'     => 'switch',
					'title'    => __( 'Variable Title in Product details', 'teta' ),
					'subtitle' => __( 'Enable/Disable this option to show Variable Title in Product details', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'woocommerce_ajax_variation_threshold',
					'type'     => 'text',
					'title'    => __( 'WooCommerce ajax variation threshold', 'teta' ),
					'subtitle' => __( 'Woocommerce by default Support 30  variation to show the gallery images, change the following number  to increase it', 'teta' ),
					'default'  => 30,
				),
				array(
					'id' => 'variable_options_end',
					'type' => 'section',
					'indent' => false,
				),
				array(
					'id'      => 'product_description_align',
					'type'    => 'switch',
					'title'   => __( 'Product Summary Alignment in Product details', 'teta' ),
					'on'      => __( 'left', 'teta' ),
					'off'     => __( 'center', 'teta' ),
					'default' => true,
				),
				array(
					'id'       => 'product_navigation',
					'type'     => 'switch',
					'title'    => __( 'Product navigation in Product details', 'teta' ),
					'subtitle' => __( 'this option is to show next/previous products in Product details.', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'product_breadcrumb',
					'type'     => 'switch',
					'title'    => __( 'Product breadcrumb in Product details', 'teta' ),
					'subtitle' => __( 'Enable/Disable this option to show breadcrunb in Product details', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'     => 'product_gallery_section_start',
					'type'   => 'section',
					'title'  => __( 'product gallery', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'shop_enable_zoom',
					'type'     => 'switch',
					'title'   => __( 'Zooming of Products Gallery', 'teta'),
					'subtitle' => __( 'Enable or disable zooming of products gallery','teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'shop_enable_zoom_responsive',
					'type'     => 'switch',
					'title'   => __( 'Responsive Zooming of Products Gallery', 'teta'),
					'subtitle' => __( 'Enable or disable zooming of products gallery in responsive state','teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'required' => array(
						array( 'shop_enable_zoom', '=', true ),
					),
				),
				array(
					'id'       => 'product_gallery_popup',
					'type'     => 'switch',
					'title'    => __( 'Product Gallery Popup', 'teta' ),
					'subtitle' => __( 'Enable or disable product gallery popup on product detail pages', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'product_gallery_style',
					'type'    => 'switch',
					'title'   => __( 'Product Gallery Button Scheme', 'teta' ),
					'default' => false,
					'on'      => __( 'Dark Button', 'teta' ),
					'off'     => __( 'Light Button', 'teta' ),
				),
				array(
					'id'      => 'product_gallery_autoplay',
					'type'    => 'switch',
					'title'   => __( 'Product Gallery Carousel AutoPlay', 'teta' ),
					'default' => true,
					'on'      => __( 'Enable', 'teta' ),
					'off'     => __( 'Disable', 'teta' ),
				),
				array(
					'id'     => 'product_gallery_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
                    'id'       => 'product_desc_tab',
                    'type'     => 'image_select',
                    'title'    => __( 'product description', 'teta' ),
                    'subtitle' => __( 'Select style of product description', 'teta' ),
					'options'  => array(
						'tab'         => array(
							'alt' => 'tab',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/tab.png',
						),
						'vartical_tab'             => array(
							'alt' => 'vartical_tab',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/vartical_tab.png',
						),
						'accordion_tab'             => array(
							'alt' => 'accordion_tab',
							'img' => KITE_THEME_LIB_URI . '/admin/img/shop/accordion_tab.png',
						),

                    ),
                    'default'  => 'tab',
					'class'    => 'product-desc-tab',

                ),
				array(
					'id'       => 'payment_methods_image',
					'type'     => 'media',
					'subtitle' => __( 'Upload Payment Methods Image for Products.', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Payment Methods Image', 'teta' ),
				),
				array(
					'id'       => 'buy_now_button',
					'type'     => 'switch',
					'title'    => __( 'Buy Now Button', 'teta' ),
					'subtitle' => __( 'Enable button to redirect to the cart page after successful addition', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'single_product_meta',
					'type'     => 'switch',
					'title'    => __( 'Product Meta', 'teta' ),
					'subtitle' => __( 'Select position of product meta', 'teta' ),
					'default'  => true,
					'on'       => __( 'In Summary Section', 'teta' ),
					'off'      => __( 'After Summary Section', 'teta' ),
				),
				array(
					'id'       => 'product_360_view',
					'type'     => 'switch',
					'title'    => __( 'Product 360 View', 'teta' ),
					'subtitle' => __( 'Enable or disable product 360 view on product detail pages', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'     => 'product-detail-instagram-section-start',
					'type'   => 'section',
					'title'	 => __( 'Instagram', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'instagram_in_product_detail',
					'type'     => 'switch',
					'title'    => __( 'Show instagram in product detail', 'teta' ),
					'subtitle' => __( 'Enable or disable instagram section in product detail', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'product_detail_use_instagram_api',
					'type'     => 'switch',
					'title'    => __( 'Instagram Connection Method', 'teta' ),
					'subtitle' => __( 'Select connection method to instagram. The best and trusted way recommended by instagram is the Api method. For Api method you have to set the app id and app secret in setting\'s social tab.', 'teta' ),
					'default'  => false,
					'on'       => __( 'Api', 'teta' ),
					'off'      => __( 'Scrape/Ajax', 'teta' ),
				),
				array(
					'id'     => 'product-detail-instagram-section-end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'shop_add_to_cart_start',
					'type'   => 'section',
					'title'	 => __( 'Add to cart', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'single-product-ajax-addtocart',
					'type'     => 'switch',
					'title'    => __( 'Ajax Add To Cart', 'teta' ),
					'subtitle' => __( 'Enable or disable ajax add to cart in single products', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'required' => array('catalog_mode', '=' , false)
				),
				array(
					'id'       => 'shop-enable-fixed-addtocart',
					'type'     => 'switch',
					'title'    => __( 'Sticky add to Cart', 'teta' ),
					'subtitle' => __( 'Enable or disable Sticky add to cart button. It will be displayed after scrolling to bottom of page to have better accessibility', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'required' => array('catalog_mode', '=' , false)
				),
				array(
					'id'       => 'shop-enable-fixed-addtocart_responsive',
					'type'     => 'switch',
					'title'    => __( 'Sticky add to Cart in Mobile', 'teta' ),
					'subtitle' => __( 'Enable or disable Sticky add to cart button in mobile. It will be displayed after scrolling to bottom of page to have better accessibility', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'required' => array('shop-enable-fixed-addtocart', '=' , true)
				),
				array(
					'id'       => 'woocommerce-notices',
					'type'     => 'switch',
					'title'    => __( 'Show/Hide add to cart notices in ajax requests', 'teta' ),
					'subtitle' => __( 'If you Hide this and ajax-add-to-cart was enabled in woocomerce, add-to-cart notices would be hide', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'     => 'shop_add_to_cart_end',
					'type'   => 'section',
					'indent' => false,
				),

			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Product Manual and Guides visibility', 'teta' ),
			'id'     => 'product_extera_content_visibility',
			'icon'   => 'icon-cart-full',
			'subsection' => true,
			'fields' => array(
				array(
					'id'       => 'product_extera_content',
					'type'     => 'switch',
					'title'    => __( 'Product Manual and Guides', 'teta' ),
					'subtitle' => __( 'Enable or disable product manual and guides to show size guide, delivery and ask question fields.', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'     => 'sizeguide_section_start',
					'type'   => 'section',
					'title'  => __( 'Size Guide', 'teta' ),
					'indent' => true,
					'required' => array( 'product_extera_content', '=', true ),
				),
				array(
					'id'       => 'size_guideTitle',
					'type'     => 'text',
					'title'    => __( 'Title', 'teta' ),
					'subtitle' => __( 'Choose a title for the sizeguide.', 'teta' ),
					'default'  => 'Size Guide',

				),
				array(
					'id'       => 'size_guide',
					'type'     => 'editor',
				),
				array(
					'id'     => 'sizeguide_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'deliveryreturn_section_start',
					'type'   => 'section',
					'title'    => __( 'Delivery & Return', 'teta' ),
					'indent' => true,
					'required' => array( 'product_extera_content', '=', true ),
				),
				array(
					'id'       => 'delivery_returnTitle',
					'type'     => 'text',
					'title'    => __( 'Title', 'teta' ),
					'subtitle' => __( 'Choose a title for the Delivery & Return.', 'teta' ),
					'default'  => 'Delivery & Return',

				),
				array(
					'id'       => 'delivery_return',
					'type'     => 'editor',
				),
				array(
					'id'     => 'deliveryreturn_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'faq_section_start',
					'type'   => 'section',
					'title'    => __( 'Ask a Question', 'teta' ),
					'indent' => true,
					'required' => array( 'product_extera_content', '=', true ),
				),
				array(
					'id'       => 'faq_title',
					'type'     => 'text',
					'title'    => __( 'Title', 'teta' ),
					'subtitle' => __( 'Choose a title for the faq.', 'teta' ),
					'default'  => 'FAQ',
				),
				array(
					'id'       => 'ask_question',
					'type'     => 'editor',
				),
				array(
					'id'     => 'faq_section_end',
					'type'   => 'section',
					'indent' => false,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'upsells/related products', 'teta' ),
			'id'     => 'kite_product_detail_upsell_related',
			'icon'   => 'icon-cart-full',
			'subsection' => true,
			'fields' => array(
				array(
					'id'       => 'upsells_position_unchanged',
					'type'     => 'switch',
					'title'    => __( 'Upsells Position', 'teta' ),
					'default'  => true,
					'on'       => __( 'After Product Description Tabs', 'teta' ),
					'off'      => __( 'Before Product Description Tabs', 'teta' ),
				),
				array(
					'id'       => 'upsells_grid_mode',
					'type'     => 'switch',
					'title'    => __( 'Upsells Display Mode', 'teta' ),
					'default'  => false,
					'on'       => __( 'Gird Mode', 'teta' ),
					'off'      => __( 'Carousel Mode', 'teta' ),
				),
				array(
					'id'       => 'upsells_fullwidth',
					'type'     => 'switch',
					'title'    => __( 'Upsells Width', 'teta' ),
					'default'  => false,
					'on'       => __( 'Full width', 'teta' ),
					'off'      => __( 'Container', 'teta' ),
				),
				array(
					'id'       => 'related_product',
					'type'     => 'switch',
					'title'    => __( 'Related Products', 'teta' ),
					'subtitle' => __( 'Enable or disable related products on product page', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'related_product_display',
					'type'     => 'switch',
					'title'    => __( 'Related Products Display Mode', 'teta' ),
					'default'  => true,
					'on'       => __( 'Gird Mode', 'teta' ),
					'off'      => __( 'Carousel Mode', 'teta' ),
					'required' => array( 'related_product', '=', true ),
				),
				array(
					'id'       => 'related_product_width',
					'type'     => 'switch',
					'title'    => __( 'Related Products Width', 'teta' ),
					'default'  => false,
					'on'       => __( 'Full width', 'teta' ),
					'off'      => __( 'Container', 'teta' ),
					'required' => array( 'related_product', '=', true ),
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Cookie Law', 'teta' ),
			'id'     => 'kite_cookie',
			'icon'   => 'icon-candy',
			'fields' => array(
				array(
					'id'       => 'cookies_info',
					'type'     => 'switch',
					'title'    => __( 'Show cookies info', 'teta' ),
					'subtitle' => __( 'Under EU privacy regulations, websites must make it clear to visitors what information about them is being stored. This specifically includes cookies. Turn on this option and user will see info box at the bottom of the page that your web-site is using cookies.', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'          => 'cookies_text_message',
					'type'        => 'textarea',
					'title'       => __( 'cookies Popup text', 'teta' ),
					'default' 	  => __( 'We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.', 'teta' ),
					'required'    => array( 'cookies_info', '=', true ),
				),
				array(
					'id'       => 'cookies_policy_page',
					'type'     => 'select',
					'data'     => 'pages',
					'title'    => __( 'Cookies detail page', 'teta' ),
					'subtitle' => __( 'Choose page that will contain detailed information about your Privacy Policy', 'teta' ),
					'required' => array( 'cookies_info', '=', true ),
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Footer And Widget Area', 'teta' ),
			'id'     => 'kite_footer',
			'icon'   => 'icon-enter-down',
			'fields' => array(
				array(
					'id'     => 'footer_builder_section_start',
					'type'   => 'section',
					'title'  => __( 'Footer Builder', 'teta' ),
					'indent' => true,
				),
				array (
					'id'       => 'is_footer_build_with_elementor',
					'type'     => 'switch',
					'title'    => __('Build Footer With Elementor', 'teta'),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'elementor_footer_template_id',
					'type'    => 'select',
					'title'   => __( 'Select Template', 'teta' ),
					'options' => kite_get_elementor_templates_list( 'footer' ),
					'required'=> array( 'is_footer_build_with_elementor', '=' , true ),
				),
				array(
					'id'     => 'footer_builder_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'footer_text_section_start',
					'type'   => 'section',
					'title'  => __( 'Footer Title And Subtitle', 'teta' ),
					'indent' => true,
					'required'=> array( 'is_footer_build_with_elementor', '=' , false ),
				),
				array(
					'id'          => 'footer_title',
					'type'        => 'text',
					'title'       => __( 'Footer Title', 'teta' ),
					'placeholder' => __( 'Enter footer title text here. ', 'teta' ),
				),
				array(
					'id'          => 'footer_subtitle',
					'type'        => 'text',
					'title'       => __( 'Footer Subitle', 'teta' ),
					'placeholder' => __( 'Enter footer subtitle text here. ', 'teta' ),
				),
				array(
					'id'     => 'footer_text_section_end',
					'type'   => 'section',
					'indent' => false,
					'required'=> array( 'is_footer_build_with_elementor', '=' , false ),
				),
				array(
					'id'     => 'footer_widget_section_start',
					'type'   => 'section',
					'title'  => __( 'Widget Area', 'teta' ),
					'title'  => __( 'Widget Area', 'teta' ),
					'indent' => true,
					'required'=> array( 'is_footer_build_with_elementor', '=' , false ),
				),
				array(
					'id'      => 'footer-widget-area',
					'type'    => 'switch',
					'title'   => __( 'Footer Widget Area', 'teta' ),
					'default' => false,
					'on'      => __( 'Enable', 'teta' ),
					'off'     => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'footer_widgets',
					'type'    => 'image_select',
					// Must provide key => value(array:title|img) pairs for radio options
					'options' => array(
						1  => array(
							'alt' => 'one',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget1.png',
						),
						2  => array(
							'alt' => 'Six-Six',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget2.png',
						),
						3  => array(
							'alt'   => 'eight-four',
							'class' => 'eight-four',
							'img'   => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget3.png',
						),
						4  => array(
							'alt'   => 'four-eight',
							'class' => 'four-eight',
							'img'   => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget4.png',
						),
						5  => array(
							'alt' => 'four-four-four',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget5.png',
						),
						6  => array(
							'alt' => 'three-three-three-three',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget6.png',
						),
						7  => array(
							'alt'   => 'three-three-six',
							'class' => 'three-three-six',
							'img'   => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget7.png',
						),
						8  => array(
							'alt'   => 'six-three-three',
							'class' => 'six-three-three',
							'img'   => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget8.png',
						),
						9  => array(
							'alt'   => 'three-three-two-two-two',
							'class' => 'three-three-two-two-two',
							'img'   => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget9.png',
						),
						10 => array(
							'alt'   => 'two-two-two-three-three',
							'class' => 'two-two-two-three-three',
							'img'   => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget10.png',
						),
						11 => array(
							'alt' => 'one-three-three-three-three',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget11.png',
						),
						12 => array(
							'alt' => 'two-two-two-two-two-two',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget12.png',
						),
						13 => array(
							'alt'   => 'one-three-three-two-two-two',
							'class' => 'one-three-three-two-two-two',
							'img'   => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget13.png',
						),
						14 => array(
							'alt' => 'six-six-three-three-three-three',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget14.png',
						),
						15 => array(
							'alt'   => 'six-six-three-three-two-two-two',
							'class' => 'six-six-three-three-two-two-two',
							'img'   => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer_widget15.png',
						),
					),
					'default' => 0,
					'class'   => 'footer-widgets',
				),
				array(
					'id'     => 'footer_widget_section_end',
					'type'   => 'section',
					'indent' => false,
					'required'=> array( 'is_footer_build_with_elementor', '=' , false ),
				),
				array(
					'id'     => 'product_widget_section_start',
					'type'   => 'section',
					'title'  => __( 'Products & Categories In Widget Area', 'teta' ),
					'indent' => true,
					'required'=> array( 'is_footer_build_with_elementor', '=' , false ),
				),
				array(
					'id'       => 'product_widget_area',
					'type'     => 'switch',
					'title'    => __( 'Footer widget area in products page', 'teta' ),
					'subtitle' => __( 'Show widgetized footer in product page', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'required' => array( 'is_footer_build_with_elementor', '=', false )
				),
				array(
					'id'       => 'category_widget_area',
					'type'     => 'switch',
					'title'    => __( 'Footer widget area in categories page', 'teta' ),
					'subtitle' => __( 'Show widgetized footer in product page', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
					'required' => array( 'is_footer_build_with_elementor', '=', false )
				),
				array(
					'id'     => 'product_widget_section_end',
					'type'   => 'section',
					'indent' => false,
					'required'=> array( 'is_footer_build_with_elementor', '=' , false ),
				),
				array(
					'id'     => 'footer_widget_banner_section_start',
					'type'   => 'section',
					'title'  => __( 'Widget Area Background', 'teta' ),
					'indent' => true,
					'required'=> array( 'is_footer_build_with_elementor', '=' , false ),
				),
				array(
					'id'       => 'footer-widget-banner',
					'type'     => 'media',
					'subtitle' => __( 'Upload an image to be shown as Widget area background', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Background Image', 'teta' ),
				),
				array(
					'id'       => 'footer-widget-gradient',
					'type'     => 'switch',
					'title'    => __( 'Gradient Overlay', 'teta' ),
					'subtitle' => __( 'Enable or disable Gradient Overlay on the footer background image', 'teta' ),
					'default'  => false,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'      => 'footer-widget-color',
					'type'    => 'color_rgba',
					'title'   => __( 'Footer Widget Background Color', 'teta' ),
					'default' => array(
						'color' => '#f5f5f5',
						'alpha' => '1',
					),
					'mode'    => 'background',
				),
				array(
					'id'      => 'footer-widget-style',
					'type'    => 'switch',
					'title'   => __( 'Widget Area Color Scheme', 'teta' ),
					'default' => false,
					'on'      => __( 'Light', 'teta' ),
					'off'     => __( 'Dark', 'teta' ),
				),
				array(
					'id'      => 'footer-widget_width',
					'type'    => 'switch',
					'title'   => __( 'Widget Area Width', 'teta' ),
					'default' => false,
					'on'      => __( 'Container', 'teta' ),
					'off'     => __( 'Full width', 'teta' ),
				),
				array(
					'id'     => 'footer_widget_banner_section_end',
					'type'   => 'section',
					'indent' => false,
					'required'=> array( 'is_footer_build_with_elementor', '=' , false ),
				),
				array(
					'id'     => 'footer_style_section_start',
					'type'   => 'section',
					'title'  => __( 'Footer Layout', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'footerType',
					'type'     => 'image_select',
					'title'    => __( 'Footyer Layout Style', 'teta' ),
					'subtitle' => __( 'Choose the Footer style', 'teta' ),
					'options'  => array(
						'logo-in-middle' => array(
							'alt' => 'one',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer-type1.png',
						),
						'triangular'     => array(
							'alt' => 'tweleve',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer-type2.png',
						),
						'leftaligned'    => array(
							'alt' => 'eight-four',
							'img' => KITE_THEME_LIB_URI . '/admin/img/footer_widget/footer-type3.png',
						),
					),
					'default'  => 'logo-in-middle',
					'class'    => 'footerType',
					'required' => array( 'is_footer_build_with_elementor', '=', false )
				),
				array(
					'id'      => 'footer-copyright',
					'type'    => 'text',
					'title'   => __( 'Copyright Text', 'teta' ),
					'default' => '&copy; 2021 KiteStudio | Built With The '. KITE_THEME_NAME .' Theme',
					'required' => array( 'is_footer_build_with_elementor', '=', false )
				),
				array(
					'id'       => 'footerlogo',
					'type'     => 'media',
					'subtitle' => __( 'Upload Footer Logo', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Footer Logo', 'teta' ),
					'required' => array( 'is_footer_build_with_elementor', '=', false )
				),
				array(
					'id'       => 'footerStyle',
					'type'     => 'switch',
					'title'    => __( 'Footer Color Scheme', 'teta' ),
					'subtitle' => __( 'Choose footer color scheme', 'teta' ),
					'default'  => true,
					'on'       => __( 'Dark', 'teta' ),
					'off'      => __( 'Light', 'teta' ),
					'required' => array( 'is_footer_build_with_elementor', '=', false )
				),
				array(
					'id'       => 'footerFullwidth',
					'type'     => 'switch',
					'title'    => __( 'Footer Width', 'teta' ),
					'subtitle' => __( 'Choose the footer to be boxed or full-width.', 'teta' ),
					'default'  => false,
					'on'       => __( 'Fullwidth', 'teta' ),
					'off'      => __( 'Container', 'teta' ),
				),
				array(
					'id'       => 'social_network_display',
					'type'     => 'switch',
					'title'    => __( 'Social Network Icons', 'teta' ),
					'default'  => true,
					'subtitle' => __( 'Enable/disable Social Network icons on footer.', 'teta' ),
					'required' => array( 'is_footer_build_with_elementor', '=', false )
				),
				array(
					'id'     => 'footer_style_section_end',
					'type'   => 'section',
					'indent' => false,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Socials', 'teta' ),
			'id'     => 'kite_socials',
			'icon'   => 'icon-share2',
			'fields' => array(
				array(
					'id'     => 'social_login_section_start',
					'type'   => 'section',
					'title'  => __( 'Social Login', 'teta' ),
					'indent' => true,
				),
				array(
					'id'    => 'google_app_id',
					'type'  => 'text',
					'title' => __( 'Google App Id', 'teta' ),
				),
				array(
					'id'    => 'google_app_secret',
					'type'  => 'text',
					'title' => __( 'Google App Secret', 'teta' ),
				),
				array(
					'id'    => 'facebook_app_id',
					'type'  => 'text',
					'title' => __( 'Facebook App Id', 'teta' ),
				),
				array(
					'id'    => 'facebook_app_secret',
					'type'  => 'text',
					'title' => __( 'Facebook App Secret', 'teta' ),
				),
				array(
					'id'    => 'microsoft_app_id',
					'type'  => 'text',
					'title' => __( 'Microsoft App Id', 'teta' ),
				),
				array(
					'id'    => 'microsoft_app_secret',
					'type'  => 'text',
					'title' => __( 'Microsoft App Secret', 'teta' ),
				),
				array(
					'id'     => 'social_login_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'instagram_api_section_start',
					'type'   => 'section',
					'title'  => __( 'Instagram Api', 'teta' ),
					'indent' => true,
				),
				array(
					'id'    => 'instagram_app_id',
					'type'  => 'text',
					'title' => __( 'Instagram App Id', 'teta' ),
				),
				array(
					'id'    => 'instagram_app_secret',
					'type'  => 'text',
					'title' => __( 'Instagram App Secret', 'teta' ),
				),
				array(
					'id'    => 'instagram_api',
					'type'  => 'instagram_api_connector',
				),
				array(
					'id'     => 'instagram_api_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'rss_section_start',
					'type'   => 'section',
					'title'  => __( 'Rss display', 'teta' ),
					'indent' => true,
				),
				array(
					'id'      => 'rss_url',
					'type'    => 'switch',
					'title'   => __( 'Rss', 'teta' ),
					'default' => false,
				),
				array(
					'id'       => 'social_rss_url',
					'type'     => 'text',
					'title'    => __( 'Rss Feed', 'teta' ),
					'required' => array( 'rss_url', '=', true ),
				),
				array(
					'id'     => 'rss_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'social_share_display_section_start',
					'type'   => 'section',
					'title'  => __( 'Social Share Buttons Display', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'social_share_display',
					'type'     => 'switch',
					'title'    => __( 'Social Share Buttons', 'teta' ),
					'default'  => false,
					'subtitle' => __( 'Enable/disable Social share buttons on products/post. This setting could be overrided in each products/post item', 'teta' ),
				),
				array(
					'id'       => 'social_share_facebook',
					'type'     => 'switch',
					'title'    => __( 'Facebook', 'teta' ),
					'default'  => true,
					'required' => array( 'social_share_display', '=', true ),
				),
				array(
					'id'       => 'social_share_mail',
					'type'     => 'switch',
					'title'    => __( 'Email', 'teta' ),
					'default'  => true,
					'required' => array( 'social_share_display', '=', true ),
				),
				array(
					'id'       => 'social_share_twitter',
					'type'     => 'switch',
					'title'    => __( 'Twitter', 'teta' ),
					'default'  => true,
					'required' => array( 'social_share_display', '=', true ),
				),
				array(
					'id'       => 'social_share_telegram',
					'type'     => 'switch',
					'title'    => __( 'Telegram', 'teta' ),
					'default'  => true,
					'required' => array( 'social_share_display', '=', true ),
				),
				array(
					'id'       => 'social_share_whatsapp',
					'type'     => 'switch',
					'title'    => __( 'Whatsapp', 'teta' ),
					'default'  => true,
					'required' => array( 'social_share_display', '=', true ),
				),
				array(
					'id'       => 'social_share_linkedin',
					'type'     => 'switch',
					'title'    => __( 'LinkedIn', 'teta' ),
					'default'  => true,
					'required' => array( 'social_share_display', '=', true ),
				),
				array(
					'id'       => 'social_share_vk',
					'type'     => 'switch',
					'title'    => __( 'VK', 'teta' ),
					'default'  => true,
					'required' => array( 'social_share_display', '=', true ),
				),
				array(
					'id'       => 'social_share_pinterest',
					'type'     => 'switch',
					'title'    => __( 'Pinterest', 'teta' ),
					'default'  => true,
					'required' => array( 'social_share_display', '=', true ),
				),
				array(
					'id'     => 'social_share_display_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'     => 'social_network_display_section_start',
					'type'   => 'section',
					'title'  => __( 'Social Network URLs', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'social_facebook_url',
					'type'     => 'text',
					'title'    => __( 'Facebook', 'teta' ),
				),
				array(
					'id'       => 'social_twitter_url',
					'type'     => 'text',
					'title'    => __( 'Twitter', 'teta' ),
				),
				array(
					'id'       => 'social_vimeo_url',
					'type'     => 'text',
					'title'    => __( 'Vimeo', 'teta' ),
				),
				array(
					'id'       => 'social_youtube_url',
					'type'     => 'text',
					'title'    => __( 'Youtube', 'teta' ),
				),
				array(
					'id'       => 'social_dribbble_url',
					'type'     => 'text',
					'title'    => __( 'Dribbble', 'teta' ),
				),
				array(
					'id'       => 'social_tumblr_url',
					'type'     => 'text',
					'title'    => __( 'Tumbler', 'teta' ),
				),
				array(
					'id'       => 'social_linkedin_url',
					'type'     => 'text',
					'title'    => __( 'LinkedIn', 'teta' ),
				),
				array(
					'id'       => 'social_flickr_url',
					'type'     => 'text',
					'title'    => __( 'Flicker', 'teta' ),
				),
				array(
					'id'       => 'social_github_url',
					'type'     => 'text',
					'title'    => __( 'GitHub', 'teta' ),
				),
				array(
					'id'       => 'social_lastfm_url',
					'type'     => 'text',
					'title'    => __( 'Last.fm', 'teta' ),
				),
				array(
					'id'       => 'social_paypal_url',
					'type'     => 'text',
					'title'    => __( 'PayPal', 'teta' ),
				),
				array(
					'id'       => 'social_skype_url',
					'type'     => 'text',
					'title'    => __( 'Skype', 'teta' ),
				),
				array(
					'id'       => 'social_wordpress_url',
					'type'     => 'text',
					'title'    => __( 'Wordpress', 'teta' ),
				),
				array(
					'id'       => 'social_yahoo_url',
					'type'     => 'text',
					'title'    => __( 'Yahoo', 'teta' ),
				),
				array(
					'id'       => 'social_deviantart_url',
					'type'     => 'text',
					'title'    => __( 'DeviantArt', 'teta' ),
				),
				array(
					'id'       => 'social_steam_url',
					'type'     => 'text',
					'title'    => __( 'Steam', 'teta' ),
				),
				array(
					'id'       => 'social_reddit_url',
					'type'     => 'text',
					'title'    => __( 'Reddit', 'teta' ),
				),
				array(
					'id'       => 'social_stumbleupon_url',
					'type'     => 'text',
					'title'    => __( 'stumbleupon', 'teta' ),
				),
				array(
					'id'       => 'social_pinterest_url',
					'type'     => 'text',
					'title'    => __( 'Pinterest', 'teta' ),
				),
				array(
					'id'       => 'social_xing_url',
					'type'     => 'text',
					'title'    => __( 'Xing', 'teta' ),
				),
				array(
					'id'       => 'social_blogger_url',
					'type'     => 'text',
					'title'    => __( 'Blogger', 'teta' ),
				),
				array(
					'id'       => 'social_soundcloud_url',
					'type'     => 'text',
					'title'    => __( 'SoundCloud', 'teta' ),
				),
				array(
					'id'       => 'social_delicious_url',
					'type'     => 'text',
					'title'    => __( 'Delicious', 'teta' ),
				),
				array(
					'id'       => 'social_foursquare_url',
					'type'     => 'text',
					'title'    => __( 'Foursquare', 'teta' ),
				),
				array(
					'id'       => 'social_instagram_url',
					'type'     => 'text',
					'title'    => __( 'Instagram', 'teta' ),
				),
				array(
					'id'       => 'social_behance_url',
					'type'     => 'text',
					'title'    => __( 'Behance', 'teta' ),
				),
				array(
					'id'       => 'social_vk_url',
					'type'     => 'text',
					'title'    => __( 'VK', 'teta' ),
				),
				array(
					'id'     => 'social_network_display_section_end',
					'type'   => 'section',
					'indent' => false,
				),
				array(
					'id'       => 'first_social_network_section_start',
					'type'     => 'section',
					'title'    => __( 'First Custom Social Network', 'teta' ),
					'indent'   => true, // Indent all options below until the next 'section' option is set.
					'required' => array( 'social_network_display', '=', true ),
				),
				array(
					'id'    => 'social_custom1_title',
					'type'  => 'text',
					'title' => __( 'First custom social network Title : ', 'teta' ),

				),
				array(
					'id'    => 'social_custom1_url',
					'type'  => 'text',
					'title' => __( 'First custom social network URL : ', 'teta' ),
				),
				array(
					'id'       => 'social_custom1_image',
					'type'     => 'media',
					'subtitle' => __( 'Upload logo image for custom Social Network.', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Logo Image', 'teta' ),
				),
				array(
					'id'      => 'social_custom1_color',
					'type'    => 'color_rgba',
					'title'   => __( 'Accent color', 'teta' ),
					'default' => array(
						'color' => '#a7a7a7',
						'alpha' => '1',
					),

					'mode'    => 'background',

				),
				array(
					'id'     => 'first_social_network_section_end',
					'type'   => 'section',
					'indent' => false, // Indent all options below until the next 'section' option is set.
				),
				array(
					'id'       => 'second_social_network_section_start',
					'type'     => 'section',
					'title'    => __( 'Second Custom Social Network', 'teta' ),
					'indent'   => true, // Indent all options below until the next 'section' option is set.
					'required' => array( 'social_network_display', '=', true ),
				),
				array(
					'id'    => 'social_custom2_title',
					'type'  => 'text',
					'title' => __( 'Second custom social network Title : ', 'teta' ),
				),
				array(
					'id'    => 'social_custom2_url',
					'type'  => 'text',
					'title' => __( 'Second custom social network URL : ', 'teta' ),
				),
				array(
					'id'       => 'social_custom2_image',
					'type'     => 'media',
					'subtitle' => __( 'Upload logo image for custom Social Network.', 'teta' ),
					'operator' => 'and',
					'title'    => __( 'Logo Image', 'teta' ),
				),
				array(
					'id'      => 'social_custom2_color',
					'type'    => 'color_rgba',
					'title'   => __( 'Accent color', 'teta' ),
					'default' => array(
						'color' => '#a7a7a7',
						'alpha' => '1',
					),

					'mode'    => 'background',

				),
				array(
					'id'     => 'second_social_network_section_end',
					'type'   => 'section',
					'indent' => false, // Indent all options below until the next 'section' option is set.
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Performance', 'teta' ),
			'id'     => 'kite_performance',
			'icon'   => 'icon-chart-growth',
			'fields' => array(
				array(
                    'id'       => 'is_lazy_load_enable',
                    'type'     => 'switch',
                    'title'    => __( 'Lazy Load', 'teta' ),
                    'subtitle' => __( 'Enable or disable lazy load', 'teta' ),
                    'on'       => __( 'Enable', 'teta' ),
                    'off'      => __( 'Disable', 'teta' ),
                    'default'  => true,
                ),
				array(
					'id'      => 'shop-skeleton-style',
					'type'    => 'switch',
					'title'   => __( 'Load Skeleton style in shop page', 'teta' ),
					'default' => false,
					'on'      => __( 'Yes', 'teta' ),
					'off'     => __( 'No', 'teta' ),
				),
				array(
                    'id'       => 'load_script_when_required',
                    'type'     => 'switch',
                    'title'    => __( 'Load Js when required', 'teta' ),
                    'subtitle' => __( 'To have better speed score, enable this option to load js files when its required. Enable this option if you are using elementor as page builder.', 'teta' ),
                    'on'       => __( 'Enable', 'teta' ),
                    'off'      => __( 'Disable', 'teta' ),
                    'default'  => false,
                ),
				array(
                    'id'       => 'load_style_when_required',
                    'type'     => 'switch',
                    'title'    => __( 'Load styles when required', 'teta' ),
                    'subtitle' => __( 'To have better speed score, enable this option to load css files when its required. Enable this option if you are using elementor as page builder.', 'teta' ),
                    'on'       => __( 'Enable', 'teta' ),
                    'off'      => __( 'Disable', 'teta' ),
                    'default'  => false,
                ),
				array(
                    'id'       => 'disable_emoji_scripts',
                    'type'     => 'switch',
                    'title'    => __( 'Disable Emoji Scripts', 'teta' ),
                    'subtitle' => __( 'If you don\'t use emoji on your websites enable this option to have better speed score.', 'teta' ),
                    'on'       => __( 'Yes', 'teta' ),
                    'off'      => __( 'No', 'teta' ),
                    'default'  => true,
                ),
				array(
                    'id'       => 'disable_gutenberg_scripts',
                    'type'     => 'switch',
                    'title'    => __( 'Disable Gutenberg Styles', 'teta' ),
                    'subtitle' => __( 'If you don\'t use gutenberg on your websites enable this option to have better speed score.', 'teta' ),
                    'on'       => __( 'Yes', 'teta' ),
                    'off'      => __( 'No', 'teta' ),
                    'default'  => true,
                ),
				array(
                    'id'       => 'disable_wc_block_styles',
                    'type'     => 'switch',
                    'title'    => __( 'Disable Woocommerce Block Styles', 'teta' ),
                    'subtitle' => __( 'If you don\'t use Woocommerce blocks on your websites enable this option to have better speed score.', 'teta' ),
                    'on'       => __( 'Yes', 'teta' ),
                    'off'      => __( 'No', 'teta' ),
                    'default'  => true,
                ),
				array(
                    'id'       => 'disable_yith_dependent_scripts',
                    'type'     => 'switch',
                    'title'    => __( 'Disable Yith Dependent Scripts', 'teta' ),
                    'subtitle' => __( 'To have better speed score, It\'s recommanded to enable this option.', 'teta' ),
                    'on'       => __( 'Yes', 'teta' ),
                    'off'      => __( 'No', 'teta' ),
                    'default'  => true,
                ),
				array(
                    'id'       => 'disable_elementor_font_awesome',
                    'type'     => 'switch',
                    'title'    => __( 'Disable Elementor Font Awesome', 'teta' ),
                    'subtitle' => __( 'To have better speed score, It\'s recommanded to enable this option.', 'teta' ),
                    'on'       => __( 'Yes', 'teta' ),
                    'off'      => __( 'No', 'teta' ),
                    'default'  => false,
                ),
				array(
                    'id'       => 'disable_wpcf7_scripts',
                    'type'     => 'switch',
                    'title'    => __( 'Load contact form 7 plugin scripts when required', 'teta' ),
                    'subtitle' => __( 'To have better speed score, It\'s recommanded to enable this option.', 'teta' ),
                    'on'       => __( 'Yes', 'teta' ),
                    'off'      => __( 'No', 'teta' ),
                    'default'  => true,
                ),
				array(
                    'id'       => 'disable_redux_template_library',
                    'type'     => 'switch',
                    'title'    => __( 'Disable redux gutenberg template library', 'teta' ),
                    'subtitle' => __( 'To have better speed score, It\'s recommanded to enable this option.', 'teta' ),
                    'on'       => __( 'Yes', 'teta' ),
                    'off'      => __( 'No', 'teta' ),
                    'default'  => true,
                ),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Maintenance', 'teta' ),
			'id'     => 'kite_maintenance',
			'icon'   => 'icon-hammer-wrench',
			'fields' => array(
				array(
					'id'     => 'maintenance_section_start',
					'type'   => 'section',
					'title'  => __( 'Maintenance Settings', 'teta' ),
					'indent' => true,
				),
				array(
					'id'       => 'maintenance_mode',
					'type'     => 'switch',
					'title'    => __( 'Maintenance mode', 'teta' ),
					'subtitle' => __( 'If it is enabled, no one except admins can see frontend of the website. Users who have a role, such as authors, translators, etc, only can see the dashboard. You should create a maintenance page and select it in the next option.', 'teta' ),
					'default'  => true,
					'on'       => __( 'Enable', 'teta' ),
					'off'      => __( 'Disable', 'teta' ),
				),
				array(
					'id'       => 'maintenance_page',
					'type'     => 'select',
					'options'  => kite_get_maintenance_page(),
					'title'    => __( 'Maintenance page', 'teta' ),
					'required' => array( 'maintenance_mode', '=', true ),
				),
				array(
					'id'     => 'maintenance_section_end',
					'type'   => 'section',
					'indent' => false,
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Additional Scripts', 'teta' ),
			'id'     => 'kite_additional-scripts',
			'icon'   => 'icon-file-code',
			'fields' => array(
				array(
					'id'       => 'additional-js',
					'type'     => 'ace_editor',
                    'theme'    => 'chrome',
					'title'    => __( 'Additional JavaScript', 'teta' ),
					'subtitle' => __( 'Enter custom JavaScript code such as Google Analytics code here. Please note that you should not include &lt;script&gt; tags in your scripts.', 'teta' ),
				),
				array(
					'id'       => 'additional-css',
					'type'     => 'ace_editor',
					'mode'     => 'css',
                    'theme'    => 'chrome',
					'title'    => __( 'Custom CSS', 'teta' ),
					'subtitle' => __( 'Enter custom CSS code such as style overrides here. Please note that you should not include &lt;style&gt; tags in your css code.', 'teta' ),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'      => __( 'Import / Export', 'teta' ),
			'id'         => 'kite_import/export',
			'heading'    => 'Import / Export Options',
			'icon'       => 'el el-refresh',
			'customizer' => false,
			'fields'     => array(
				array(
					'id'         => 'redux_import_export',
					'type'       => 'import_export',
					'full_width' => true,
				),
			),
		)
	);

	do_action( 'kite_after_settings_initialized' );
