<?php 
// Needed variables for search element
$search_post_type = kite_opt( 'search_post_type', 'product' );
$cat_args         = array(
    'orderby' => 'term_id',
    'order' => 'ASC',
    'hide_empty' => false,
);
if ( $search_post_type == 'product' && kite_woocommerce_installed() ) {
    $terms = get_terms( 'product_cat', $cat_args );
} else {
    $terms = get_terms( 'category', $cat_args );
}
if ( kite_opt( 'search_form_hide_uncategorized', false ) ) {
    foreach( $terms as $key => $term ) {
        if ( $term->slug == 'uncategorized' ) {
            unset( $terms[$key] );
            break;
        }
    }
}
if ( kite_opt( 'search_form_hide_subcategories', false ) ) {
    foreach( $terms as $key => $term ) {
        if ( $term->parent ) {
            unset( $terms[$key] );
        }
    }
}
$wrap_classes = "first-search-input-wrapper search-inputwrapper search-container ";
if ( kite_opt( 'searchbox-style', false ) == 1 ) {
    $wrap_classes .= ' dark';
    $style = '';
} else {
    $style = 'light';
}
// end of variables
?>
<header id="kt-header" data-fixed="<?php echo esc_attr( $data_fixed ); ?>"  class="<?php echo esc_attr( implode(' ', $classes ) );?>" >
    <div class="wrap headerwrap hidden-phone hidden-tablet">
        <div id="headerfirststate">
            <div class="menubgcolor hidden-phone hidden-tablet"></div>
                <?php 
                if ( !$is_header_fullwidth ) {
                    echo '<div class="container clearfix">';
                } else {
                    echo '<div class="fullwidth">';
                }
                ?>
                <!-- First Logo -->
                <div id='firstrow'>
                    <div class="logo" style="display: block; width: 16.66666667%;">
                        <?php if ( ! empty( $logo ) ) { ?>
                            <a class="locallink logo" href="<?php echo esc_url( home_url() ); ?>#home">
                                <?php if ( $responsivelogo != '' ) { ?>
                                    <img class="firstLogo responsivelogo hidden-desktop" src="<?php echo esc_url( $responsivelogo ); ?>" alt="<?php esc_attr_e( 'Logo', 'teta' ); ?>"/>
                                <?php } ?>
                                <img class="firstLogo" src="<?php echo esc_url( $logo ); ?>" alt="<?php esc_attr_e( 'Logo', 'teta' ); ?>"/>
                            </a>
                            <a class="externallink logo" href="<?php echo esc_url( home_url() ); ?>">
                                <?php if ( $responsivelogo != '' ) { ?>
                                    <img class="firstLogo responsivelogo hidden-desktop" src="<?php echo esc_url( $responsivelogo ); ?>" alt="<?php esc_attr_e( 'Logo', 'teta' ); ?>"/>
                                <?php } ?>
                                <img class="firstLogo" src="<?php echo esc_url( $logo ); ?>" alt="<?php esc_attr_e( 'Logo', 'teta' ); ?>"/>
                            </a>
                        <?php } else {
                            echo "<div class='logo-title'><a href='" . home_url() . "' ><h5  >" . get_bloginfo( 'name' ) . "</h5></a></div>";
                        } ?>
                </div>
                <?php
                kite_generate_search_form(
                    array(
                        'wrap_classes'          => $wrap_classes,
                        'form_classes'          => "firstStateSearchForm",
                        'style'                 => $style,
                        'terms'                 => $terms,
                        'search_place_holder'   => esc_html__( 'Search Product Name ', 'teta' ),
                        'search_post_type'      => $search_post_type
                    )
                );
                ?>
                <div class="header-buttons">
                    <?php
                    // Check if WooCommerce is active
                    if ( $shop_cart_enabled && !$catalog_mode && kite_woocommerce_installed() ) {
                        /*woocomerce drop down cart widget */
                        // Because it pushes the entire content to a side, it should be placed outside of layout element
                        get_template_part( 'templates/woocommerce/cart' );
                    }
                    ?>
                    <?php 
                    // @TODO: remove kite_teme_check 
                    ?>
                    <?php if ( kite_woocommerce_installed() && class_exists( 'YITH_WCWL' ) && kite_opt( 'header-wishlist-display', true ) == 1 && ( class_exists( 'Kite_Theme_Check' ) || class_exists( 'Kite_Register_Widgets' ) ) ) { ?>
                    <div class="topbar_wishlist <?php if ( $cart_style == 1 ) { echo 'dark'; } ?>">
                        <?php the_widget( 'Kite_Woocommerce_Wishlist_Icon_Widget' ); ?>
                    </div>
                    <?php } ?>
                </div>
                <!-- close container div -->
                </div>
                <div id="secondrow" <?php if ( has_nav_menu( 'category-nav' ) ) { echo 'class="has-cat-nav"'; } ?>>
                    <?php if ( has_nav_menu( 'category-nav' ) ) { ?>
                    <div class="category-menu-container">
                        <div class="allcats <?php if ( ! kite_opt( 'cat-menu-state-light', false ) ) { echo 'dark'; } ?>">
                            <span class="icon icon-menu"></span><?php echo kite_opt( 'cat-menu-title', esc_html__( 'All Categories', 'teta' ) ); ?>
                        </div>
                        <nav class="navigation hidden-phone hidden-tablet catmenu <?php if ( ! kite_opt( 'cat-menu-state-open', false ) || ! is_front_page() ) { echo 'close'; } if ( ! kite_opt( 'cat-menu-state-light', false ) ) { echo ' dark'; } ?>">
                            <?php
                            wp_nav_menu(
                                array(
                                    'container'      => '',
                                    'menu_class'     => 'clearfix',
                                    'before'         => '',
                                    'theme_location' => 'category-nav',
                                    'walker'         => new Kite_Nav_Walker(),
                                    'fallback_cb'    => false,
                                    'after'          => '',
                                )
                            );
                            ?>
                        </nav>
                    </div>
                    <?php } ?>  
                    <?php if ( has_nav_menu( 'primary-nav' ) ) { ?>
                    <nav class="navigation hidden-phone hidden-tablet pr-menu">
                        <?php
                        wp_nav_menu(
                            array(
                                'container'      => '',
                                'menu_class'     => 'clearfix',
                                'before'         => '',
                                'theme_location' => 'primary-nav',
                                'walker'         => new Kite_Nav_Walker(),
                                'fallback_cb'    => false,
                                'after'          => '',
                            )
                        );
                        ?>
                    </nav>
                    <?php } ?>                   
                </div>
            </div>                            
        </div>  

        <?php 
        if ( isset( $headerStyle ) ) {
            if ( $headerStyle == 'kite-menu' ) {
        ?>
        <div id="headersecondstate">
            <div id="menubgcolor" class="hidden-phone hidden-tablet"></div>
                <?php 
                if ( !$is_header_fullwidth ) {
                    echo '<div class="container clearfix">';
                } else {
                    echo '<div class="fullwidth clearfix">';
                }
                ?>
                <!-- Second Logo -->
                <div class="logo" style="display: block; width: 16.66666667%;">
                <?php if ( ! empty( $logoSecond ) ) { ?>
                    <a class="locallink logo" href="<?php echo esc_url( home_url() ); ?>#home">
                        <?php if ( $responsivelogo != '' ) { ?>
                            <img class="secoundlogo responsivelogo hidden-desktop" src="<?php echo esc_url( $responsivelogo ); ?>" alt="<?php esc_attr_e( 'Logo', 'teta' ); ?>"/>
                        <?php } ?>
                        <img class="secoundlogo" src="<?php echo esc_url( $logoSecond ); ?>" alt="<?php esc_attr_e( 'Logo', 'teta' ); ?>"/>
                    </a>
                    <a class="externallink logo" href="<?php echo esc_url( home_url() ); ?>">
                        <?php if ( $responsivelogo != '' ) { ?>
                            <img class="secoundlogo responsivelogo hidden-desktop" src="<?php echo esc_url( $responsivelogo ); ?>" alt="<?php esc_attr_e( 'Logo', 'teta' ); ?>"/>
                        <?php } ?>
                        <img class="secoundlogo" src="<?php echo esc_url( $logoSecond ); ?>" alt="<?php esc_attr_e( 'Logo', 'teta' ); ?>"/>
                    </a>
                <?php } else {
                    echo "<div class='logo-title'><a href='" . home_url() . "' ><h5  >" . get_bloginfo( 'name' ) . "</h5></a></div>";
                } ?>
                </div>
                <?php
                kite_generate_search_form(
                    array(
                        'wrap_id'               => "second-search-input-wrapper",
                        'wrap_classes'          => $wrap_classes,
                        'form_classes'          => "secondstatesearchform",
                        'style'                 => $style,
                        'terms'                 => $terms,
                        'search_place_holder'   => esc_html__( 'Search Product Name ', 'teta' ),
                        'search_post_type'      => $search_post_type
                    )
                );
                ?>
                <div class="header-buttons">
                    <?php
                    // Check if WooCommerce is active
                    if ( $shop_cart_enabled && !$catalog_mode && kite_woocommerce_installed() ) {
                        /* woocomerce drop down cart widget */
                        // Because it pushes the entire content to a side, it should be placed outside of layout element
                        get_template_part( 'templates/woocommerce/cart' );
                    }
                    ?>
                    <?php if ( kite_woocommerce_installed() && class_exists( 'YITH_WCWL' ) && kite_opt( 'header-wishlist-display', true ) == 1 && ( class_exists( 'Kite_Theme_Check' ) || class_exists( 'Kite_Register_Widgets' ) ) ) { ?>
                        <div class="topbar_wishlist <?php if ( $cart_style == 1 ) { echo 'dark'; } ?>">
                            <?php the_widget( 'Kite_Woocommerce_Wishlist_Icon_Widget' ); ?>
                        </div>
                    <?php } ?>
                    <?php if ( kite_woocommerce_installed() && kite_opt( 'shop-login-link', true ) == 1 ) { ?>
                        <div class="topbar_login_link">
                            <div class="topbar_login">
                                <div class="topbar_login_text ">
                                    <?php echo kite_get_myaccount_link( false ); ?>
                                </div>
                                <?php if ( is_user_logged_in() && kite_woocommerce_installed() ) { ?>
                                <ul  class="topbar_login-content">
                                    <?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
                                    <li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
                                        <a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
                                    </li>
                                    <?php endforeach; ?>
                                </ul>               
                                <?php } ?>
                            </div>
                        </div> 
                    <?php } ?>
                </div>
            </div>

        </div>  
        <?php 
            }
        }
        ?>
    </div>           
    <?php
        // Because it pushes the entire content to a side, it should be placed outside of layout element
        get_template_part( 'templates/nav/header-mobile' );

    ?>
</header>
<!-- Header Navigation End -->