<div <?php wc_product_class( $classes, $product ); ?>>
	<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>
	<div class="productwrap">
		<span class="added_to_cart_icon icon icon-check"></span>
		<div class="add_to_cart_btn_wrap lazy-load-hover-container">
		<?php
			if ( $badges != 'disable' ) {
                kite_show_badges();
            }

			do_action( "woocommerce_before_{$request_from}_loop_item_title" );

			if ( $request_from == 'widget' ) {
				woocommerce_template_loop_product_link_open();
				echo '</a>';

				echo woocommerce_get_product_thumbnail( $image_size );
			}
			if ( $hover_image == 'show' && count( $attachment_ids ) > 0 ) {
				if ( $request_from == 'shop' ) {
					$first_gallery_img = reset( $attachment_ids ); // get the first image of gallery
					$image_link        = wp_get_attachment_url( $first_gallery_img );

					if ( isset( $image_link ) ) {

						if ( $layout == 'masonry' ) {
							// Auto-height product images used in masonry style
							$img_src = wp_get_attachment_image_src( $first_gallery_img, 'Kite_product_thumbnail-auto-height' );
						} else {
							$img_src = wp_get_attachment_image_src( $first_gallery_img, 'shop_catalog' );
						}

						if ( $img_src != false ) {
							printf( '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="%s"></div>', esc_url( $img_src[0] ) );
						} else {
							printf( '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="%s"></div>', esc_url( $image_link ) );
						}
					}
				} else {
					$image_src     = '';
					$image         = '';
					$attachment_id = $attachment_ids[0];

					if ( $image_size == 'full' ) {
						$image_src = wp_get_attachment_image_src( $attachment_id, 'full' );
						$image     = '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="' . esc_url( $image_src[0] ) . '"></div>';

					} else {
						if ( function_exists( 'wc_get_image_size' ) ) {

							$image_dimension = wc_get_image_size( $image_size );

							$image_link = wp_get_attachment_url( $attachment_id );
							$img_url    = aq_resize( $image_link, $image_dimension['width'], $image_dimension['height'], $image_dimension['crop'], true, true );

							if ( ! $img_url ) {
								$img_url = $image_link;
							}

							$image = '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="' . esc_url( $img_url ) . '"></div>';

						} else {

							$image_url = wp_get_attachment_image_src( $attachment_id, apply_filters( 'single_product_large_thumbnail_size', $image_size ) );
							if ( $image_url != false ) {
								$image = '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="' . esc_url( $image_url[0] ) . '"></div>';
							} else {
								$image_src = wp_get_attachment_image_src( $attachment_id, 'full' );
								$image     = '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="' . esc_url( $image_src[0] ) . '"></div>';
							}
						}
					}
					// Sanitization performed in above lines!
					echo '' . $image;
				}
			}
			if ( ! isset( $show_variations_activation ) || $show_variations_activation == 'on' ) {
				if ( $product->is_type( 'variable' ) && ( $product->is_in_stock() && ! ( sizeof( $product->get_variation_attributes() ) > 1 ) ) ) {
					?>
					<div class="variations <?php echo esc_attr( 'yes' === $ajax_add_to_cart ? 'ajax_enabled' : '' ); ?>">
						<?php show_product_variations( true, $image_size ); ?>
					</div>
					<?php

				}
			}
			
			$button = apply_filters(
				'woocommerce_loop_add_to_cart_link',
				sprintf(
					'<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="button %s product_type_%s %s mobileAddToCart"><span class="icon"></span><span class="txt" data-hover="%s">%s</span></a>',
					esc_url( $product->add_to_cart_url() ),
					esc_attr( $product->get_id() ),
					esc_attr( $product->get_sku() ),
					esc_attr( isset( $quantity ) ? $quantity : 1 ),
					$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
					esc_attr( $product->get_type() ),
					esc_attr( $product->get_type() == 'simple' && 'yes' === $ajax_add_to_cart ? 'ajax_add_to_cart' : 'swiper-no-swiping' ), // KiteSt codes
					esc_attr( $product->add_to_cart_text() ),
					esc_html( $product->add_to_cart_text() )
				),
				$product
			);

			if ( ! $catalog_mode ) {
				echo '' . $button;
			}
			?>
		</div>
		<div class="wrap_after_thumbnail">
			<div class="productinfo">
				<?php do_action( 'woocommerce_shop_loop_item_title' ); ?>
			</div>
			<?php 
			if ( ! isset( $hide_buttons ) || ! $hide_buttons ) : 
				$product_buttons_classes = ['product-buttons'];
				if ( $product->is_type( 'variable' ) ) {
					$product_buttons_classes[] = 'has-variation';
				}
				if ( $quickview !== 'disable' ) {
					$product_buttons_classes[] = 'has-quickview';
				}

				if ( $compare !== 'disable' ) {
					$product_buttons_classes[] = 'has-compare';
				}

				if ( $wishlist !== 'disable' ) {
					$product_buttons_classes[] = 'has-wishlist';
				}
			?>
				<div class="<?php echo esc_attr( implode( ' ', $product_buttons_classes ) ); ?>">	
					<?php do_action( "kite_woocommerce_{$request_from}_loop_buttons", $product, $quickview, $wishlist, $compare, $ajax_add_to_cart, $catalog_mode ); ?>
				</div>
			<?php
			endif;
			/**
			 * woocommerce_after_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_template_loop_rating - 5
			 * @hooked woocommerce_template_loop_price - 10
			 */
			do_action( "woocommerce_after_shop_loop_item_title" ); 
			
			if ( $request_from == 'widget' ) {
				if ( $countdown_activation == 'on' ) {
					add_deal_count_down_timer( 1 );
				}
				if ( $progressbar_activation == 'on' ) {
					kite_stock_progress_bar( 1 );
				}
			}

			?>
		</div>
	</div>
</div>
