<?php
$quick_view_button = kite_opt( 'shop-enable-quickview', false );

if ( $quickview !== 'disable' && $quick_view_button ) {
    $classes[] = 'hasQuickView';
}
?>
<div <?php wc_product_class( $classes, $product ); ?>>
    <?php
    /**
     * woocommerce_before_shop_loop_item hook.
     *
     * @hooked woocommerce_template_loop_product_link_open - 10
     */
    do_action( 'woocommerce_before_shop_loop_item' );
    ?>
    <div class="productwrap">
        <span class="added_to_cart_icon icon icon-check"></span>
        <div class="add_to_cart_btn_wrap lazy-load-hover-container">

            <?php

            if ( $badges != 'disable' ) {
                kite_show_badges();
            }
            
            /**
             * woocommerce_before_shop_loop_item_title hook
             *
             * @hooked woocommerce_show_product_loop_sale_flash - 10
             * @hooked woocommerce_template_loop_product_thumbnail - 10
             */
            do_action( "woocommerce_before_{$request_from}_loop_item_title" );

            if ( $request_from == 'widget' ) {
                echo '<a href="' . esc_url( get_the_permalink() ) . '" class="product-link"></a>';
                echo woocommerce_get_product_thumbnail( $image_size );
            }             
            
            if ( $hover_image == 'show' && count( $attachment_ids ) > 0 ) {
                if ( $request_from == 'shop' ) {
                    $first_gallery_img = reset( $attachment_ids );// get the first image of gallery
                    $image_link        = wp_get_attachment_url( $first_gallery_img );

                    if ( isset( $image_link ) ) {

                        if ( $layout == 'masonry' ) {
                            // Auto-height product images used in masonry style
                            $img_src = wp_get_attachment_image_src( $first_gallery_img, 'Kite_product_thumbnail-auto-height' );
                        } else {
                            $img_src = wp_get_attachment_image_src( $first_gallery_img, 'shop_catalog' );
                        }

                        if ( $img_src != false ) {
                            printf( '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="%s"></div>', esc_url( $img_src[0] ) );
                        } else {
                            printf( '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="%s"></div>', esc_url( $image_link ) );
                        }
                    }
                } else {
                    $image_src     = '';
                    $image         = '';
                    $attachment_id = $attachment_ids[0];

                    if ( ! function_exists( 'aq_resize' ) && $image_size != 'full' ) {
                        $image_size = 'full';
                    }

                    if ( $image_size == 'full' ) {
                        $image_src = wp_get_attachment_image_src( $attachment_id, 'full' );
                        $image     = '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="' . esc_url( $image_src[0] ) . '"></div>';

                    } else {
                        if ( function_exists( 'wc_get_image_size' ) ) {

                            $image_dimension = wc_get_image_size( $image_size );

                            $image_link = wp_get_attachment_url( $attachment_id );
                            $img_url    = aq_resize( $image_link, $image_dimension['width'], $image_dimension['height'], $image_dimension['crop'], true, true );

                            if ( ! $img_url ) {
                                $img_url = $image_link;
                            }

                            $image = '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="' . esc_url( $img_url ) . '"></div>';

                        } else {

                            $image_url = wp_get_attachment_image_src( $attachment_id, apply_filters( 'single_product_large_thumbnail_size', $image_size ) );
                            if ( $image_url != false ) {
                                $image = '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="' . esc_url( $image_url[0] ) . '"></div>';
                            } else {
                                $image_src = wp_get_attachment_image_src( $attachment_id, 'full' );
                                $image     = '<div class="hover-image lazy-load lazy-load-hover bg-lazy-load" data-src="' . esc_url( $image_src[0] ) . '"></div>';
                            }
                        }
                    }
                    // Sanitization performed in above lines!
                    echo '' . $image;
                }
                
            }
            ?>
                <?php 
                if ( $request_from == 'shop' && $quickview != 0 ) { 
                ?>
                    <div class="product-buttons">
                        <?php do_action( 'kite_woocommerce_shop_loop_hover_buttons' ); ?>
                    </div>
                <?php
                }
                if ( ! isset( $show_variations_activation ) || $show_variations_activation == 'on' ) {
                    if ( $product->is_type( 'variable' ) && $product->is_in_stock() && ! ( sizeof( $product->get_variation_attributes() ) > 1 ) ) {
                    ?>
                        <div class="variations <?php echo esc_attr( 'yes' === $ajax_add_to_cart ? 'ajax_enabled' : '' ); if ( $quickview == 'disable' ||  !$quick_view_button ) { echo ' no-quickview'; } ?>">
                            <?php show_product_variations( true, $image_size ); ?>
                        </div>
                    <?php
                    }
                }
                ?>
            <?php

            if ( $quickview !== 'disable' && $quick_view_button ) {
                
                global $product;

                if ( !( class_exists( '\Elementor\Plugin' ) && \Elementor\Plugin::$instance->preview->is_preview_mode() ) && kite_opt( 'load_style_when_required', false ) ) {
                    wp_enqueue_style( 'kite-quickview' );
                }

                echo '<div class="quick-view"><span class="kt-qv"><a href="' . esc_url( '#' ) . '" class="quick-view-button" data-product_id="' . esc_attr( $product->get_id() ) . '"  title="' . esc_attr__( 'Show in quickview', 'teta' ) . '">' . esc_attr__( 'Quick View', 'teta' ) . '</a></span></div>';

            }
            ?>
        </div>

        <div class="wrap_after_thumbnail">

            <?php
                do_action( 'woocommerce_shop_loop_item_title' );

                /**
                 * woocommerce_after_shop_loop_item_title hook
                 *
                 * @hooked woocommerce_template_loop_rating - 5
                 * @hooked woocommerce_template_loop_price - 10
                 */
                do_action( 'woocommerce_after_shop_loop_item_title' );

                $data_attribute = apply_filters( 'kite_loop_add_to_cart_button_attributes', array(), $product, $ajax_add_to_cart );
            ?>

            <div class="instant_shop_button">
            <?php if ( ! isset( $hide_buttons ) || ! $hide_buttons ) : ?>
            <?php if ( ! $catalog_mode ) : ?>
                    <div class="addtocartbutton product_type_<?php echo esc_attr( $product->get_type() ); ?> " >
                        <a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" rel="nofollow" <?php foreach( $data_attribute as $key => $data ) { echo '' . $key . '="' . $data . '" '; } ?> ><?php echo '' . ( $product->add_to_cart_text() ); ?></a>
                    </div>
                <?php
                endif;
            endif;
            ?>
            </div>
        </div>  
        <?php
        if ( $request_from == 'widget' ) {
            if ( $countdown_activation == 'on' ) {
                add_deal_count_down_timer( 1 );
            }
            if ( $progressbar_activation == 'on' ) {
                kite_stock_progress_bar( 1 );
            }
        }
        ?>
    </div>
</div>