<?php
/**
 * Template part for displaying standard posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package ekko
 * by KeyDesign
 */

?>

<?php
	$without_image_class = '';

	if (!has_post_thumbnail()) {
		$without_image_class .= 'without-image';
	}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
	<?php if (has_post_thumbnail()) : ?>
		<div class="entry-image">
			<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('keydesign-grid-image'); ?></a>
		</div>
	<?php endif; ?>
	<div class="entry-wrapper <?php echo esc_attr( $without_image_class ); ?>">
		<?php get_template_part( 'core/templates/post/partials/content', 'meta' ); ?>
		<h5 class="blog-single-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h5>
		<div class="entry-content">
			<a class="post-link" href="<?php the_permalink(); ?>"><?php echo apply_filters( 'blog-readmore-text', esc_html__("Read more", "ekko") ); ?></a>
		</div>
	</div>
</article>
