<?php if ( !defined( 'ABSPATH' ) ) {
    die;
} // Cannot access pages directly.
/*==========================================================================
METABOX BOX OPTIONS
===========================================================================*/
if ( !function_exists( 'elinor_metabox_options' ) && class_exists( 'OVIC_Metabox' ) ) {
    function elinor_metabox_options()
    {
        $vertical_menu = 'style-01,style-03,style-04,style-05,style-08';
        $sections      = array();
        // -----------------------------------------
        // Page Side Meta box Options              -
        // -----------------------------------------
        $sections[] = array(
            'id'             => '_custom_page_side_options',
            'title'          => esc_html__( 'Custom Page Side Options', 'elinor' ),
            'post_type'      => 'page',
            'context'        => 'side',
            'priority'       => 'high',
            'page_templates' => 'default',
            'sections'       => array(
                array(
                    'name'   => 'page_option',
                    'fields' => array(
                        array(
                            'id'      => 'page_title',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Page Title', 'elinor' ),
                            'desc'    => esc_html__( 'for Default Template', 'elinor' ),
                            'default' => 1,
                        ),
                        array(
                            'id'         => 'page_title_bg',
                            'type'       => 'image',
                            'title'      => esc_html__( 'Page Title Background', 'elinor' ),
                            'dependency' => array( 'page_title', '==', 1 ),
                        ),
                        array(
                            'id'         => 'page_title_fixed',
                            'type'       => 'switcher',
                            'title'      => esc_html__( 'Background - Fixed', 'elinor' ),
                            'dependency' => array( 'page_title', '==', 1 ),
                        ),
                        array(
                            'id'         => 'sidebar_page_layout',
                            'type'       => 'image_select',
                            'title'      => esc_html__( 'Single Page Sidebar Position', 'elinor' ),
                            'desc'       => esc_html__( 'Select sidebar position on Page.', 'elinor' ),
                            'options'    => array(
                                'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                            ),
                            'default'    => 'left',
                            'attributes' => array(
                                'data-depend-id' => 'sidebar_page_layout',
                            ),
                        ),
                        array(
                            'id'         => 'page_sidebar',
                            'type'       => 'select',
                            'title'      => esc_html__( 'Page Sidebar', 'elinor' ),
                            'options'    => 'sidebars',
                            'dependency' => array( 'sidebar_page_layout', '!=', 'full' ),
                        ),
                        array(
                            'id'    => 'page_extra_class',
                            'type'  => 'text',
                            'title' => esc_html__( 'Extra Class', 'elinor' ),
                        ),
                    ),
                ),
            ),
        );
        $sections[] = array(
            'id'        => '_custom_page_e_side_options',
            'title'     => esc_html__( 'Elementor Builder', 'elinor' ),
            'post_type' => 'page',
            'context'   => 'side',
            'priority'  => 'high',
            'sections'  => array(
                array(
                    'name'   => 'page_e_option',
                    'fields' => array(
                        array(
                            'id'    => 'page_bg_fixed',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Background - Attachment Fixed', 'elinor' ),
                            'desc'  => esc_html__( 'works only on >= 1200px', 'elinor' ),
                        ),
                    ),
                ),
            ),
        );
        // -----------------------------------------
        // Page Meta box Options                   -
        // -----------------------------------------
        $sections[] = array(
            'id'        => '_custom_metabox_theme_options',
            'title'     => esc_html__( 'Custom Theme Options', 'elinor' ),
            'post_type' => 'page',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => array(
                'options'     => array(
                    'name'   => 'options',
                    'title'  => esc_html__( 'General', 'elinor' ),
                    'icon'   => 'fa fa-wordpress',
                    'fields' => array(
                        array(
                            'id'    => 'enable_metabox_options',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Metabox Options', 'elinor' ),
                            'desc'  => esc_html__( 'If this option enable then this page will get setting in here, else this page will get setting in Theme Options', 'elinor' ),
                        ),
                        array(
                            'id'    => 'metabox_logo',
                            'type'  => 'image',
                            'title' => esc_html__( 'Logo', 'elinor' ),
                            'desc'  => esc_html__( 'Setting Logo For Site', 'elinor' ),
                        ),
                        array(
                            'id'      => 'metabox_default_color',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#3E445A',
                            'title'   => esc_html__( 'Default Color', 'elinor' ),
                        ),
                        array(
                            'id'      => 'metabox_main_color',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#219653',
                            'title'   => esc_html__( 'Main Color', 'elinor' ),
                        ),
                        array(
                            'id'      => 'metabox_main_color_t',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#fff',
                            'title'   => esc_html__( 'Main Color - Text Inside', 'elinor' ),
                            'desc'    => esc_html__( 'Text inside "Boxes has background main color" will has this color', 'elinor' ),
                        ),
                        array(
                            'id'      => 'metabox_main_color_2',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#FFB800',
                            'title'   => esc_html__( 'Main Color 2', 'elinor' ),
                        ),
                        array(
                            'id'      => 'metabox_main_color_2_t',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#18191B',
                            'title'   => esc_html__( 'Main Color 2 - Text Inside', 'elinor' ),
                            'desc'    => esc_html__( 'Text inside "Boxes has background main color 2" will has this color', 'elinor' ),
                        ),
                        array(
                            'id'      => 'metabox_main_color_3',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#E80E29',
                            'title'   => esc_html__( 'Main Color 3', 'elinor' ),
                        ),
                        array(
                            'id'      => 'metabox_main_container',
                            'type'    => 'slider',
                            'title'   => esc_html__( 'Main Container', 'elinor' ),
                            'min'     => 1140,
                            'max'     => 1470,
                            'step'    => 10,
                            'unit'    => esc_html__( 'px', 'elinor' ),
                            'default' => 1400,
                        ),
                        array(
                            'id'      => 'metabox_main_fw',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Main Font Weight', 'elinor' ),
                            'options' => array(
                                400 => esc_html__( 'Regular', 'elinor' ),
                                500 => esc_html__( 'Medium', 'elinor' ),
                                600 => esc_html__( 'Semi-bold', 'elinor' ),
                                700 => esc_html__( 'Bold', 'elinor' ),
                            ),
                            'default' => 500,
                        ),
                        array(
                            'id'      => 'metabox_main_bora',
                            'type'    => 'number',
                            'title'   => esc_html__( 'Main Border Radius', 'elinor' ),
                            'min'     => 0,
                            'max'     => 1000,
                            'unit'    => esc_html__( 'px', 'elinor' ),
                            'default' => 90,
                        ),
                        array(
                            'id'    => 'metabox_main_bora_button',
                            'type'  => 'text',
                            'title' => esc_html__( 'Button Border Radius', 'elinor' ),
                            'desc'  =>
                                '<ul>
                                    <li>' . esc_html__( 'Example:', 'elinor' ) . '</li>
                                    <li>' . esc_html__( '+ top-left <space> top-right <space> bottom-right <space> bottom-left:', 'elinor' ) . '</li>
                                    <li><b>' . esc_html__( '20px 20px 20px 20px', 'elinor' ) . '</b></li>
                                    <li>' . esc_html__( '+ top-left-bottom-right <space> top-right-bottom-left:', 'elinor' ) . '</li>
                                    <li><b>' . esc_html__( '20px 0', 'elinor' ) . '</b></li>
                                    <li>' . esc_html__( '+ all:', 'elinor' ) . '</li>
                                    <li><b>' . esc_html__( '20px', 'elinor' ) . '</b></li>
                                </ul>',
                        ),
                    ),
                ),
                'header'      => array(
                    'name'   => 'header',
                    'title'  => esc_html__( 'Header', 'elinor' ),
                    'icon'   => 'fa fa-folder-open-o',
                    'fields' => array(
                        array(
                            'id'         => 'metabox_header_template',
                            'type'       => 'select_preview',
                            'options'    => elinor_file_options( '/templates/header/', 'header' ),
                            'default'    => 'style-01',
                            'attributes' => array(
                                'data-depend-id' => 'metabox_header_template',
                            ),
                        ),
                        array(
                            'id'         => 'metabox_header_home_bg',
                            'type'       => 'switcher',
                            'title'      => esc_html__( 'Homepage has Background', 'elinor' ),
                            'default'    => 1,
                            'dependency' => array(
                                'metabox_header_template', 'any',
                                'style-04'
                            ),
                        ),
                        array(
                            'id'          => 'metabox_header_banner',
                            'type'        => 'select',
                            'options'     => 'page',
                            'chosen'      => true,
                            'ajax'        => true,
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'title'       => esc_html__( 'Header Banner', 'elinor' ),
                            'desc'        => esc_html__( 'Get banner on header from page builder', 'elinor' ),
                        ),
                        array(
                            'id'         => 'metabox_header_bg',
                            'type'       => 'image',
                            'title'      => esc_html__( 'Header Background', 'elinor' ),
                            'dependency' => array(
                                'metabox_header_template', 'any',
                                'style-02,style-06'
                            ),
                        ),
                        array(
                            'id'      => 'metabox_enable_primary_menu',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Enable Primary Menu', 'elinor' ),
                            'default' => 1,
                        ),
                        array(
                            'id'          => 'metabox_primary_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Primary Menu', 'elinor' ),
                            'desc'        => esc_html__( 'default is Display location on Menu panel: "Primary Menu"', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'dependency'  => array( 'metabox_enable_primary_menu', '==', 1 ),
                        ),
                        array(
                            'id'         => 'metabox_primary_menu_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Primary Menu Title', 'elinor' ),
                            'dependency' => array(
                                'metabox_header_template', 'any',
                                'style-05'
                            ),
                        ),
                        array(
                            'id'          => 'metabox_brand_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Brands Menu', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'dependency'  => array(
                                'metabox_header_template', 'any',
                                'style-05'
                            ),
                        ),
                        array(
                            'id'         => 'metabox_brand_menu_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Brands Menu Title', 'elinor' ),
                            'dependency' => array(
                                'metabox_header_template', 'any',
                                'style-05'
                            ),
                        ),
                        array(
                            'id'          => 'metabox_header_submenu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Header Submenu', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                        ),
                        array(
                            'id'          => 'metabox_header_submenu_2',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Header Submenu 2', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                        ),
                        array(
                            'id'          => 'metabox_header_submenu_3',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Header Submenu 3', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'dependency'  => array(
                                'metabox_header_template', 'any',
                                'style-03,style-07'
                            ),
                        ),
                        array(
                            'id'              => 'metabox_header_info',
                            'type'            => 'group',
                            'title'           => esc_html__( 'Header Info', 'elinor' ),
                            'button_title'    => esc_html__( 'Add item', 'elinor' ),
                            'accordion_title' => esc_html__( 'Add New item', 'elinor' ),
                            'max'             => 1,
                            'fields'          => array(
                                array(
                                    'id'    => 'info_title',
                                    'type'  => 'text',
                                    'title' => esc_html__( 'Title', 'elinor' ),
                                ),
                                array(
                                    'id'    => 'info_subtitle',
                                    'type'  => 'text',
                                    'title' => esc_html__( 'Subtitle', 'elinor' ),
                                ),
                                array(
                                    'id'    => 'info_icon',
                                    'type'  => 'icon',
                                    'title' => esc_html__( 'Icon', 'elinor' ),
                                ),
                                array(
                                    'id'    => 'info_link',
                                    'type'  => 'text',
                                    'title' => esc_html__( 'Link', 'elinor' ),
                                ),
                            ),
                            'dependency'      => array(
                                'metabox_header_template', 'any',
                                'style-01,style-04'
                            ),
                        ),
                        array(
                            'id'         => 'metabox_header_search_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Header Search Title', 'elinor' ),
                            'dependency' => array(
                                'metabox_header_template', 'any',
                                'style-09'
                            ),
                        ),
                        array(
                            'id'         => 'metabox_header_minicart_bg',
                            'type'       => 'image',
                            'title'      => esc_html__( 'Mini cart Background', 'elinor' ),
                            'dependency' => array(
                                'metabox_header_template', 'any',
                                'style-07'
                            ),
                        ),
                        array(
                            'id'          => 'metabox_vertical_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Vertical Menu', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'dependency'  => array( 'metabox_header_template', 'any', $vertical_menu, true ),
                        ),
                        array(
                            'id'         => 'metabox_vertical_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Vertical Title', 'elinor' ),
                            'dependency' => array( 'metabox_header_template', 'any', $vertical_menu, true ),
                        ),
                    ),
                ),
                'footer'      => array(
                    'name'   => 'footer',
                    'title'  => esc_html__( 'Footer', 'elinor' ),
                    'icon'   => 'fa fa-folder-open-o',
                    'fields' => array(
                        array(
                            'id'      => 'metabox_footer_template',
                            'type'    => 'select_preview',
                            'default' => 'footer-01',
                            'options' => elinor_footer_preview(),
                        ),
                    ),
                ),
                'woocommerce' => array(
                    'name'   => 'woocommerce',
                    'title'  => esc_html__( 'Woocommerce', 'elinor' ),
                    'icon'   => 'fa fa-shopping-bag',
                    'fields' => array(
                        array(
                            'id'      => 'metabox_price_typo',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Product Price Typography', 'elinor' ),
                            'options' => array(
                                'default' => esc_html__( 'Default', 'elinor' ),
                                'special' => esc_html__( 'Special', 'elinor' ),
                            ),
                            'default' => 'special',
                        ),
                    ),
                ),
                'typography'  => array(
                    'name'   => 'typography',
                    'title'  => esc_html__( 'Typography', 'elinor' ),
                    'icon'   => 'fa fa-font',
                    'fields' => array(
                        array(
                            'id'             => 'body_typography',
                            'type'           => 'typography',
                            'title'          => esc_html__( 'Typography of Body', 'elinor' ),
                            'font_family'    => true,
                            'font_weight'    => true,
                            'font_style'     => true,
                            'subset'         => true,
                            'text_align'     => true,
                            'text_transform' => true,
                            'font_size'      => true,
                            'line_height'    => true,
                            'letter_spacing' => true,
                            'extra_styles'   => true,
                            'color'          => true,
                            'output'         => 'body',
                        ),
                        array(
                            'id'             => 'metabox_special_typography',
                            'type'           => 'typography',
                            'title'          => esc_html__( 'Typography of Special texts', 'elinor' ),
                            'font_family'    => true,
                            'font_weight'    => true,
                            'font_style'     => true,
                            'subset'         => false,
                            'text_align'     => false,
                            'text_transform' => false,
                            'font_size'      => false,
                            'line_height'    => false,
                            'letter_spacing' => false,
                            'extra_styles'   => true,
                            'color'          => false,
                            'output'         => '.main-special-font',
                            'default'        => array(
                                'font-family'  => 'Cairo',
                                'font-weight'  => '600',
                                'extra-styles' => array(
                                    0 => 'normal',
                                    1 => '600'
                                ),
                                'type'         => 'google',
                                'unit'         => 'px',
                            ),
                        ),
                    ),
                ),
            ),
        );
        // -----------------------------------------
        // Post Meta box Options                   -
        // -----------------------------------------
        $sections[] = array(
            'id'        => '_custom_metabox_post_options',
            'title'     => esc_html__( 'Post Meta', 'elinor' ),
            'post_type' => 'post',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => array(
                array(
                    'name'   => 'post_options',
                    'icon'   => 'fa fa-picture-o',
                    'fields' => array(
                        array(
                            'id'    => 'post_formats',
                            'type'  => 'tabbed',
                            'title' => esc_html__( 'Post formats', 'elinor' ),
                            'desc'  => esc_html__( 'The data post formats', 'elinor' ),
                            'tabs'  => array(
                                array(
                                    'title'  => esc_html__( 'Quote', 'elinor' ),
                                    'fields' => array(
                                        array(
                                            'id'         => 'quote',
                                            'type'       => 'text',
                                            'title'      => esc_html__( 'Quote Text', 'elinor' ),
                                            'attributes' => array(
                                                'style' => 'width:100%',
                                            ),
                                        ),
                                    ),
                                ),
                                array(
                                    'title'  => esc_html__( 'Gallery', 'elinor' ),
                                    'fields' => array(
                                        array(
                                            'id'    => 'gallery',
                                            'type'  => 'gallery',
                                            'title' => esc_html__( 'Gallery source', 'elinor' ),
                                        ),
                                    ),
                                ),
                                array(
                                    'title'  => esc_html__( 'Video', 'elinor' ),
                                    'fields' => array(
                                        array(
                                            'id'      => 'video',
                                            'type'    => 'upload',
                                            'library' => 'video',
                                            'title'   => esc_html__( 'Video source', 'elinor' ),
                                        ),
                                    ),
                                ),
                                array(
                                    'title'  => esc_html__( 'Audio', 'elinor' ),
                                    'fields' => array(
                                        array(
                                            'id'      => 'audio',
                                            'type'    => 'upload',
                                            'title'   => esc_html__( 'Audio source', 'elinor' ),
                                            'library' => 'audio',
                                        ),
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),

            ),
        );
        // -----------------------------------------
        // Product Meta box Options                -
        // -----------------------------------------
        if ( class_exists( 'WooCommerce' ) ) {
            $sections[] = array(
                'id'        => '_custom_metabox_product_options',
                'title'     => esc_html__( 'Custom Contents', 'elinor' ),
                'post_type' => 'product',
                'context'   => 'side',
                'priority'  => 'low',
                'sections'  => array(
                    array(
                        'name'   => 'custom_contents',
                        'fields' => array(
                            array(
                                'id'    => 'poster',
                                'type'  => 'image',
                                'title' => esc_html__( 'Poster Video', 'elinor' ),
                            ),
                            array(
                                'id'    => 'video',
                                'type'  => 'text',
                                'title' => esc_html__( 'Video Url', 'elinor' ),
                            ),
                            array(
                                'id'    => 'gallery',
                                'type'  => 'gallery',
                                'title' => esc_html__( '360 Degree', 'elinor' ),
                            ),
                            array(
                                'id'           => 'custom_info',
                                'type'         => 'group',
                                'title'        => esc_html__( 'Infomation', 'elinor' ),
                                'button_title' => esc_html__( 'Add New', 'elinor' ),
                                'fields'       => array(
                                    array(
                                        'id'    => 'title',
                                        'type'  => 'text',
                                        'title' => esc_html__( 'Title', 'elinor' ),
                                    ),
                                    array(
                                        'id'    => 'subtitle',
                                        'type'  => 'text',
                                        'title' => esc_html__( 'Subtitle', 'elinor' ),
                                    ),
                                    array(
                                        'id'    => 'icon',
                                        'type'  => 'icon',
                                        'title' => esc_html__( 'Icon', 'elinor' ),
                                    ),
                                ),
                            ),
                        )
                    )
                ),
            );
        }

        OVIC_Metabox::instance( apply_filters( 'elinor_framework_metabox_options', $sections ) );
    }

    add_action( 'init', 'elinor_metabox_options' );
}