<?php
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if ( !class_exists( 'Widget_Ovic_Blog' ) ) {
    class Widget_Ovic_Blog extends OVIC_Widget
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
            $this->widget_cssclass    = 'ovic-blog';
            $this->widget_description = 'Display the customer blog.';
            $this->widget_id          = 'ovic_blog';
            $this->widget_name        = esc_html__( 'Ovic: Blog', 'elinor' );
            $this->settings           = array(
                'title'    => array(
                    'type'  => 'text',
                    'title' => esc_html__( 'Title', 'elinor' ),
                ),
                'style'    => array(
                    'type'    => 'select_preview',
                    'title'   => esc_html__( 'Select style', 'elinor' ),
                    'options' => elinor_file_options( '/shortcode/ovic_blog/layout/', '' ),
                    'default' => 'style-01',
                ),
                'target'   => array(
                    'type'       => 'select',
                    'title'      => esc_html__( 'Target', 'elinor' ),
                    'options'    => array(
                        'recent_post' => esc_html__( 'Recent post', 'elinor' ),
                        'popularity'  => esc_html__( 'Popularity', 'elinor' ),
                        'date'        => esc_html__( 'Date', 'elinor' ),
                        'title'       => esc_html__( 'Title', 'elinor' ),
                        'random'      => esc_html__( 'Random', 'elinor' ),
                    ),
                    'attributes' => array(
                        'data-depend-id' => 'target',
                        'style'          => 'width:100%',
                    ),
                    'default'    => 'recent_post',
                ),
                'category' => array(
                    'type'           => 'select',
                    'title'          => esc_html__( 'Category Blog', 'elinor' ),
                    'options'        => 'categories',
                    'chosen'         => true,
                    'query_args'     => array(
                        'orderby' => 'name',
                        'order'   => 'ASC',
                    ),
                    'default_option' => esc_html__( 'Select a category', 'elinor' ),
                    'placeholder'    => esc_html__( 'Select a category', 'elinor' ),
                ),
                'limit'    => array(
                    'type'        => 'number',
                    'unit'        => 'items(s)',
                    'default'     => '6',
                    'title'       => esc_html__( 'Limit', 'elinor' ),
                    'description' => esc_html__( 'How much items per page to show', 'elinor' ),
                ),
                'orderby'  => array(
                    'type'        => 'select',
                    'title'       => esc_html__( 'Order by', 'elinor' ),
                    'options'     => array(
                        ''              => esc_html__( 'None', 'elinor' ),
                        'date'          => esc_html__( 'Date', 'elinor' ),
                        'ID'            => esc_html__( 'ID', 'elinor' ),
                        'author'        => esc_html__( 'Author', 'elinor' ),
                        'title'         => esc_html__( 'Title', 'elinor' ),
                        'modified'      => esc_html__( 'Modified', 'elinor' ),
                        'rand'          => esc_html__( 'Random', 'elinor' ),
                        'comment_count' => esc_html__( 'Comment count', 'elinor' ),
                        'menu_order'    => esc_html__( 'Menu order', 'elinor' ),
                    ),
                    'attributes'  => array(
                        'style' => 'width:100%',
                    ),
                    'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.',
                        'elinor' ),
                        '<a href="' . esc_url( 'http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters' ) . '" target="_blank">' . esc_html__( 'WordPress codex page',
                            'elinor' ) . '</a>' ),
                ),
                'order'    => array(
                    'type'        => 'select',
                    'title'       => esc_html__( 'Sort order', 'elinor' ),
                    'options'     => array(
                        ''     => esc_html__( 'None', 'elinor' ),
                        'DESC' => esc_html__( 'Descending', 'elinor' ),
                        'ASC'  => esc_html__( 'Ascending', 'elinor' ),
                    ),
                    'attributes'  => array(
                        'style' => 'width:100%',
                    ),
                    'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.',
                        'elinor' ),
                        '<a href="' . esc_url( 'http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters' ) . '" target="_blank">' . esc_html__( 'WordPress codex page',
                            'elinor' ) . '</a>' ),
                ),
            );

            parent::__construct();
        }

        /**
         * Output widget.
         *
         * @param  array $args
         * @param  array $instance
         *
         * @see WP_Widget
         *
         */
        public function widget( $args, $instance )
        {
            $atts                 = $instance;
            $atts['list_style']   = 'owl';
            $atts['carousel']     = array(
                'slidesToShow'  => 1,
                'slidesMargin'  => 30,
                'arrows'        => false,
                'dots'          => true,
                'infinite'      => true,
                'autoplay'      => true,
                'autoplaySpeed' => 3000,
                'speed'         => 700,
                'responsive'    => array(
                    array(
                        'breakpoint' => 768,
                        'settings'   => array(
                            'slidesMargin' => 16,
                        ),
                    ),
                ),
            );
            $atts['image_width']  = 400;
            $atts['image_height'] = 224;

            $this->widget_start( $args, $instance );

            unset( $instance['title'] );

            echo ovic_do_shortcode( 'ovic_blog', $atts );

            $this->widget_end( $args );
        }
    }
}