<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Category extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_category';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Category', 'elinor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-product-categories';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'elinor' ),
            )
        );

        $this->add_control(
            'style',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'Select style', 'elinor' ),
                'options' => elinor_preview_options( $this->get_name() ),
                'default' => 'style-01',
            ]
        );

        $this->add_control(
            'category',
            [
                'label'       => esc_html__( 'Category', 'elinor' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy( [
                    'hide_empty' => false,
                    'taxonomy'   => 'product_cat',
                ] ),
                'multiple'    => false,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'image',
            [
                'label'   => esc_html__( 'Image', 'elinor' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'elinor' ),
                'type'  => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'desc',
            [
                'label'     => esc_html__( 'Description', 'elinor' ),
                'type'      => Controls_Manager::TEXTAREA,
                'condition' => [
                    'style' => [
                        'style-04'
                    ]
                ],
            ]
        );

        $this->add_control(
            'desc_line',
            [
                'label'     => esc_html__( 'Description Line Count', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 4,
                'condition' => [
                    'style' => [
                        'style-04'
                    ]
                ],
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Count', 'elinor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'elinor' ),
                'type'  => Controls_Manager::URL,
            ]
        );

        $this->add_control(
            'image_effect',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'Hover Effect', 'elinor' ),
                'options' => elinor_effect_style(),
                'default' => '',
            ]
        );

        $this->end_controls_section();
    }
}