<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Infobox extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_infobox';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Information box', 'elinor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-icon-box';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the image widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * @return array Widget categories.
     * @since 2.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return array( 'ovic' );
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'elinor' ),
            )
        );

        $this->add_control(
            'info_popup',
            [
                'label' => esc_html__( 'Popup', 'elinor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'popup_open',
            [
                'label'     => esc_html__( 'Open', 'elinor' ),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => [
                    'info_popup' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'info_icon',
            [
                'label'            => esc_html__( 'Icon', 'elinor' ),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'condition'        => [
                    'info_popup' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'info_icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ovic-infobox > a' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'info_popup' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'info_position',
            [
                'type'         => Controls_Manager::SELECT,
                'label'        => esc_html__( 'Content Position', 'elinor' ),
                'options'      => [
                    'start' => esc_html__( 'Start', 'elinor' ),
                    'end'   => esc_html__( 'End', 'elinor' ),
                ],
                'prefix_class' => 'content-',
                'default'      => 'start',
            ]
        );

        $this->add_control(
            'info_img',
            [
                'label'   => esc_html__( 'Image', 'elinor' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater = new Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'label'       => esc_html__( 'Title', 'elinor' ),
            ]
        );

        $repeater->add_control(
            'item_icon',
            [
                'label'            => esc_html__( 'Icon', 'elinor' ),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
            ]
        );

        $repeater->add_control(
            'item_link',
            [
                'label' => esc_html__( 'Link', 'elinor' ),
                'type'  => Controls_Manager::URL,
            ]
        );

        $this->add_control(
            'info_list',
            [
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        echo ovic_do_shortcode( $this->get_name(), $settings );
    }
}