<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Infobox"
 * @version 1.0.0
 */
class Shortcode_Ovic_Infobox extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode = 'ovic_infobox';
    public $default   = array();

    public function content( $atts, $content = null )
    {
        $css_class = $this->main_class( $atts,
            array(
                'ovic-infobox'
            )
        );
        if ( $atts['info_popup'] == 'yes' )
            $css_class .= ' elinor-dropdown';
        if ( $atts['popup_open'] == 'yes' )
            $css_class .= ' open';

        ob_start();
        ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <?php if ( $atts['info_popup'] == 'yes' ) : ?>
                <a href="#" data-elinor="elinor-dropdown">
                    <span class="icon">
                        <?php \Elementor\Icons_Manager::render_icon( $atts['info_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </span>
                </a>
            <?php endif; ?>
            <div class="sub-menu">
                <?php if ( !empty( $atts['info_img']['id'] ) ) : ?>
                    <div class="thumb">
                        <?php echo wp_get_attachment_image( $atts['info_img']['id'], 'full' ); ?>
                    </div>
                <?php endif; ?>
                <?php if ( !empty( $atts['info_list'] ) ): ?>
                    <div class="list">
                        <?php foreach ( $atts['info_list'] as $item ) : ?>
                            <?php
                            $atts['item_link']['class'] = 'item';
                            $item['item_link']['url']   = apply_filters( 'ovic_shortcode_vc_link', $item['item_link']['url'] );
                            $link                       = $this->add_link_attributes( $item['item_link'], true );
                            ?>
                            <a <?php echo esc_attr( $link ); ?>>
                                <?php if ( !empty( $atts['item_icon'] ) ) : ?>
                                    <span class="i-icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </span>
                                <?php endif; ?>
                                <?php if ( !empty( $item['item_title'] ) ): ?>
                                    <span class="i-text"><?php echo esc_html( $item['item_title'] ); ?></span>
                                <?php endif; ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}