<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Newsletter extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_newsletter';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Newsletter', 'elinor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-yoast';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'elinor' ),
            )
        );

        $this->add_control(
            'style',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'Select style', 'elinor' ),
                'options' => elinor_preview_options( $this->get_name() ),
                'default' => 'style-01',
            ]
        );

        $this->add_control(
            'form_id',
            [
                'type'        => Controls_Manager::SELECT,
                'label'       => esc_html__( 'Newsletter Form', 'elinor' ),
                'options'     => elinor_get_form_newsletter(),
                'default'     => '0',
                'description' => sprintf( '%s <a href="%s" target="_blank">%s</a>',
                    esc_html__( 'Add new form', 'elinor' ),
                    admin_url( 'admin.php?page=mailchimp-for-wp-forms&view=add-form' ),
                    esc_html__( 'Here!', 'elinor' )
                ),
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'type'        => Controls_Manager::TEXT,
                'label'       => esc_html__( 'Input Placeholder', 'elinor' ),
                'default'     => esc_html__( 'Your email address', 'elinor' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button',
            [
                'type'        => Controls_Manager::TEXT,
                'label'       => esc_html__( 'Button', 'elinor' ),
                'default'     => esc_html__( 'Subscribe', 'elinor' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label'            => esc_html__( 'Button Icon', 'elinor' ),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
            ]
        );

        $this->add_control(
            'input_bg',
            [
                'label'     => esc_html__( 'Input Background', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}' => '--input-bg: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'has_border',
            [
                'type'         => Controls_Manager::SWITCHER,
                'label'        => esc_html__( 'Input Border', 'elinor' ),
                'prefix_class' => 'border-',
            ]
        );

        $this->start_controls_tabs( 'tabs_button' );

        $this->start_controls_tab(
            'button_normal',
            [
                'label' => esc_html__( 'Button', 'elinor' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit-newsletter' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_color_t',
            [
                'label'     => esc_html__( 'Text Color', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit-newsletter' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_hover',
            [
                'label' => esc_html__( 'Hover', 'elinor' ),
            ]
        );

        $this->add_control(
            'button_color_h',
            [
                'label'     => esc_html__( 'Color', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit-newsletter:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_color_t_h',
            [
                'label'     => esc_html__( 'Text Color', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .submit-newsletter:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        echo ovic_do_shortcode( $this->get_name(), $settings );
    }
}