<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Person"
 * @version 1.0.0
 */
class Shortcode_Ovic_Person extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode = 'ovic_person';
    public $default   = array(
        'style' => 'style-01',
    );

    public function content( $atts, $content = null )
    {
        $css_class = $this->main_class( $atts, array(
            'ovic-person',
            $atts['style']
        ) );

        ob_start();
        ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <div class="inner">
                <?php if ( !empty( $atts['avatar']['id'] ) ): ?>
                    <div class="avatar">
                        <?php echo wp_get_attachment_image( $atts['avatar']['id'], 'full' ); ?>
                        <div class="socials">
                            <?php if ( !empty( $atts['persons'] ) ): ?>
                                <?php foreach ( $atts['persons'] as $item ):
                                    $item['link']['url'] = apply_filters( 'ovic_shortcode_vc_link', $item['link']['url'] );
                                    $link = $this->add_link_attributes( $item['link'], true ); ?>
                                    <a <?php echo esc_attr( $link ); ?>>
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="content">
                    <?php if ( !empty( $atts['name'] ) ): ?>
                        <p class="name"><?php echo esc_html( $atts['name'] ); ?></p>
                    <?php endif; ?>
                    <?php if ( !empty( $atts['posi'] ) ): ?>
                        <p class="posi"><?php echo esc_html( $atts['posi'] ); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}