<?php

class Editor_Ovic_Products
{
    public static function shortcode_config()
    {
        return array(
            'name'   => 'ovic_products',
            'title'  => 'Products',
            'fields' => array(
                'title'         => array(
                    'id'    => 'title',
                    'type'  => 'text',
                    'title' => esc_html__( 'Title', 'elinor' ),
                ),
                'list_style'    => array(
                    'id'      => 'list_style',
                    'type'    => 'text',
                    'class'   => 'ovic-hidden',
                    'default' => 'none',
                    'title'   => esc_html__( 'List style', 'elinor' ),
                ),
                'product_style' => array(
                    'id'          => 'product_style',
                    'type'        => 'select_preview',
                    'title'       => esc_html__( 'Product style', 'elinor' ),
                    'options'     => elinor_product_options( 'Shortcode' ),
                    'default'     => 'style-01',
                    'description' => esc_html__( 'Select a style for product item', 'elinor' ),
                ),
                'target'        => array(
                    'id'          => 'target',
                    'type'        => 'select',
                    'title'       => esc_html__( 'Target', 'elinor' ),
                    'options'     => array(
                        'recent_products'       => esc_html__( 'Recent Products', 'elinor' ),
                        'featured_products'     => esc_html__( 'Feature Products', 'elinor' ),
                        'sale_products'         => esc_html__( 'Sale Products', 'elinor' ),
                        'best_selling_products' => esc_html__( 'Best Selling Products', 'elinor' ),
                        'top_rated_products'    => esc_html__( 'Top Rated Products', 'elinor' ),
                        'products'              => esc_html__( 'Products', 'elinor' ),
                        'product_category'      => esc_html__( 'Products Category', 'elinor' ),
                        'related_products'      => esc_html__( 'Products Related', 'elinor' ),
                    ),
                    'attributes'  => array(
                        'data-depend-id' => 'target',
                    ),
                    'default'     => 'recent_products',
                    'description' => esc_html__( 'Choose the target to filter products', 'elinor' ),
                ),
                'ids'           => array(
                    'id'          => 'ids',
                    'type'        => 'select',
                    'chosen'      => true,
                    'multiple'    => true,
                    'sortable'    => true,
                    'ajax'        => true,
                    'options'     => 'posts',
                    'query_args'  => array(
                        'post_type' => 'product',
                    ),
                    'title'       => esc_html__( 'Products', 'elinor' ),
                    'description' => esc_html__( 'Enter List of Products', 'elinor' ),
                    'dependency'  => array( 'target', '==', 'products' ),
                ),
                'category'      => array(
                    'id'          => 'category',
                    'type'        => 'select',
                    'chosen'      => true,
                    'ajax'        => true,
                    'options'     => 'categories',
                    'placeholder' => esc_html__( 'Select Products Category', 'elinor' ),
                    'query_args'  => array(
                        'hide_empty' => true,
                        'taxonomy'   => 'product_cat',
                    ),
                    'title'       => esc_html__( 'Product Categories', 'elinor' ),
                    'description' => esc_html__( 'Note: If you want to narrow output, select category(s) above. Only selected categories will be displayed.',
                        'elinor' ),
                    'dependency'  => array( 'target', '!=', 'products' ),
                ),
                'limit'         => array(
                    'id'          => 'limit',
                    'type'        => 'number',
                    'unit'        => 'items(s)',
                    'default'     => '6',
                    'title'       => esc_html__( 'Limit', 'elinor' ),
                    'description' => esc_html__( 'How much items per page to show', 'elinor' ),
                ),
                'orderby'       => array(
                    'id'          => 'orderby',
                    'type'        => 'select',
                    'title'       => esc_html__( 'Order by', 'elinor' ),
                    'options'     => array(
                        ''              => esc_html__( 'None', 'elinor' ),
                        'date'          => esc_html__( 'Date', 'elinor' ),
                        'ID'            => esc_html__( 'ID', 'elinor' ),
                        'author'        => esc_html__( 'Author', 'elinor' ),
                        'title'         => esc_html__( 'Title', 'elinor' ),
                        'modified'      => esc_html__( 'Modified', 'elinor' ),
                        'rand'          => esc_html__( 'Random', 'elinor' ),
                        'comment_count' => esc_html__( 'Comment count', 'elinor' ),
                        'menu_order'    => esc_html__( 'Menu order', 'elinor' ),
                        'price'         => esc_html__( 'Price: low to high', 'elinor' ),
                        'price-desc'    => esc_html__( 'Price: high to low', 'elinor' ),
                        'rating'        => esc_html__( 'Average Rating', 'elinor' ),
                        'popularity'    => esc_html__( 'Popularity', 'elinor' ),
                        'post__in'      => esc_html__( 'Post In', 'elinor' ),
                        'most-viewed'   => esc_html__( 'Most Viewed', 'elinor' ),
                    ),
                    'default'     => 'date',
                    'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.',
                        'elinor' ),
                        '<a href="' . esc_url( 'http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters' ) . '" target="_blank">' . esc_html__( 'WordPress codex page',
                            'elinor' ) . '</a>' ),
                ),
                'order'         => array(
                    'id'          => 'order',
                    'type'        => 'select',
                    'title'       => esc_html__( 'Sort order', 'elinor' ),
                    'options'     => array(
                        ''     => esc_html__( 'None', 'elinor' ),
                        'DESC' => esc_html__( 'Descending', 'elinor' ),
                        'ASC'  => esc_html__( 'Ascending', 'elinor' ),
                    ),
                    'default'     => 'DESC',
                    'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.',
                        'elinor' ),
                        '<a href="' . esc_url( 'http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters' ) . '" target="_blank">' . esc_html__( 'WordPress codex page',
                            'elinor' ) . '</a>' ),
                ),
            ),
        );
    }
}