<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Search"
 * @version 1.0.0
 */
class Shortcode_Ovic_Search extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode = 'ovic_search';
    public $default   = array();

    public function content( $atts, $content = null )
    {
        $css_class = $this->main_class( $atts, array(
            'ovic-search'
        ) );

        ob_start(); ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <?php
            if ( $atts['category'] == 'yes' ) {
                elinor_header_search( true );
            } else {
                elinor_header_search();
            }
            ?>
        </div>
        <?php
        return ob_get_clean();
    }
}