<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Tabs extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_tabs';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Tabs', 'elinor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-product-tabs';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            [
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'elinor' ),
            ]
        );

        $this->add_control(
            'style',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'Tab style', 'elinor' ),
                'options' => elinor_preview_options( $this->get_name() ),
                'default' => 'style-01',
            ]
        );

        $this->add_control(
            'active',
            [
                'label'   => esc_html__( 'Active', 'elinor' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 1,
                'min'     => 1,
            ]
        );

        $this->add_control(
            'is_ajax',
            [
                'label'   => esc_html__( 'Enable ajax', 'elinor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'tab_title',
            [
                'label' => esc_html__( 'Title', 'elinor' ),
                'type'  => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'tab_title_image',
            [
                'label'     => esc_html__( 'Title Image', 'elinor' ),
                'type'      => Controls_Manager::MEDIA,
                'condition' => [
                    'style' => 'style-09'
                ],
            ]
        );

        $this->add_control(
            'tab_title_color',
            [
                'label'     => esc_html__( 'Title Color', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tab_section',
            [
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'Tab Content', 'elinor' ),
            ]
        );

        $repeater = new Elementor\Repeater();

        $repeater->start_controls_tabs( 'tab_repeater' );

        $repeater->start_controls_tab(
            'tab_title',
            [
                'label' => esc_html__( 'Title', 'elinor' ),
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__( 'Title', 'elinor' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Tab Title', 'elinor' ),
                'placeholder' => esc_html__( 'Tab Title', 'elinor' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'content',
            [
                'label'   => esc_html__( 'Content', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'product'  => esc_html__( 'Products', 'elinor' ),
                    'template' => esc_html__( 'Template', 'elinor' ),
                    'link'     => esc_html__( 'Simple Link', 'elinor' ),
                ],
                'default' => 'product',
            ]
        );

        $repeater->add_control(
            'selected_media',
            [
                'label'   => esc_html__( 'Media', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'image' => esc_html__( 'Image', 'elinor' ),
                    'icon'  => esc_html__( 'Icon', 'elinor' ),
                ],
                'default' => 'image',
            ]
        );

        $repeater->add_control(
            'selected_icon',
            [
                'label'            => esc_html__( 'Icon', 'elinor' ),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition'        => [
                    'selected_media' => 'icon'
                ],
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label'     => esc_html__( 'Image', 'elinor' ),
                'type'      => Controls_Manager::MEDIA,
                'condition' => [
                    'selected_media' => 'image'
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label'       => esc_html__( 'Link', 'elinor' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'elinor' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'content' => 'link',
                ],
            ]
        );

        $repeater->add_control(
            'class',
            [
                'label'       => esc_html__( 'Class', 'elinor' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            'tab_template',
            [
                'label'     => esc_html__( 'Template', 'elinor' ),
                'condition' => [
                    'content' => 'template',
                ],
            ]
        );

        if ( class_exists( 'ElementorPro\Modules\QueryControl\Module' ) ) {
            $repeater->add_control(
                'template_id',
                [
                    'label'        => esc_html__( 'Template ID', 'elinor' ),
                    'type'         => ElementorPro\Modules\QueryControl\Module::QUERY_CONTROL_ID,
                    'options'      => [],
                    'label_block'  => true,
                    'multiple'     => false,
                    'autocomplete' => [
                        'object' => ElementorPro\Modules\QueryControl\Module::QUERY_OBJECT_POST,
                        'query'  => [
                            'post_type' => 'elementor_library'
                        ],
                    ],
                    'description'  => sprintf( '%s <a href="%s" target="_blank">%s</a>',
                        esc_html__( 'Create template from', 'elinor' ),
                        admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ),
                        esc_html__( 'Here', 'elinor' )
                    ),
                    'export'       => false,
                ]
            );
        } else {
            $repeater->add_control(
                'template_id',
                [
                    'label'       => esc_html__( 'Template ID', 'elinor' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => '1',
                    'description' => sprintf( '%s <a href="%s" target="_blank">%s</a>',
                        esc_html__( 'Create template from', 'elinor' ),
                        admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ),
                        esc_html__( 'Here', 'elinor' )
                    ),
                ]
            );
        }

        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            'tab_product',
            [
                'label'     => esc_html__( 'Product', 'elinor' ),
                'condition' => [
                    'content' => 'product',
                ],
            ]
        );

        $repeater->add_control(
            'target',
            [
                'label'   => esc_html__( 'Target', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'recent_products'       => esc_html__( 'Recent Products', 'elinor' ),
                    'featured_products'     => esc_html__( 'Feature Products', 'elinor' ),
                    'sale_products'         => esc_html__( 'Sale Products', 'elinor' ),
                    'best_selling_products' => esc_html__( 'Best Selling Products', 'elinor' ),
                    'top_rated_products'    => esc_html__( 'Top Rated Products', 'elinor' ),
                    'products'              => esc_html__( 'Products', 'elinor' ),
                    'product_category'      => esc_html__( 'Products Category', 'elinor' ),
                    'product_brand'         => esc_html__( 'Products Brand', 'elinor' ),
                    'related_products'      => esc_html__( 'Products Related', 'elinor' ),
                ],
                'default' => 'recent_products',
            ]
        );

        if ( class_exists( 'ElementorPro\Modules\QueryControl\Module' ) ) {
            $repeater->add_control(
                'ids',
                [
                    'label'        => esc_html__( 'Search Product', 'elinor' ),
                    'type'         => ElementorPro\Modules\QueryControl\Module::QUERY_CONTROL_ID,
                    'options'      => [],
                    'label_block'  => true,
                    'multiple'     => true,
                    'autocomplete' => [
                        'object' => ElementorPro\Modules\QueryControl\Module::QUERY_OBJECT_POST,
                        'query'  => [
                            'post_type' => 'product'
                        ],
                    ],
                    'condition'    => [
                        'target' => 'products'
                    ],
                    'export'       => false,
                ]
            );
        } else {
            $repeater->add_control(
                'ids',
                [
                    'label'       => esc_html__( 'Product', 'elinor' ),
                    'type'        => Controls_Manager::TEXT,
                    'description' => esc_html__( 'Product ids', 'elinor' ),
                    'placeholder' => '1,2,3',
                    'label_block' => true,
                    'condition'   => [
                        'target' => 'products'
                    ],
                ]
            );
        }

        $repeater->add_control(
            'category',
            [
                'label'       => esc_html__( 'Products Category', 'elinor' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy( [
                    'hide_empty' => true,
                    'taxonomy'   => 'product_cat',
                ] ),
                'label_block' => true,
                'condition'   => [
                    'target!' => 'products'
                ],
            ]
        );

        $repeater->add_control(
            'category_brand',
            [
                'label'       => esc_html__( 'Products Brand', 'elinor' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy( [
                    'hide_empty' => true,
                    'taxonomy'   => 'product_brand',
                ] ),
                'label_block' => true,
                'condition'   => [
                    'target!' => 'products'
                ],
            ]
        );

        $repeater->add_control(
            'limit',
            [
                'label'       => esc_html__( 'Limit', 'elinor' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 6,
                'placeholder' => 6,
            ]
        );

        $repeater->add_control(
            'orderby',
            [
                'label'   => esc_html__( 'Order by', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''              => esc_html__( 'None', 'elinor' ),
                    'date'          => esc_html__( 'Date', 'elinor' ),
                    'ID'            => esc_html__( 'ID', 'elinor' ),
                    'author'        => esc_html__( 'Author', 'elinor' ),
                    'title'         => esc_html__( 'Title', 'elinor' ),
                    'modified'      => esc_html__( 'Modified', 'elinor' ),
                    'rand'          => esc_html__( 'Random', 'elinor' ),
                    'comment_count' => esc_html__( 'Comment count', 'elinor' ),
                    'menu_order'    => esc_html__( 'Menu order', 'elinor' ),
                    'price'         => esc_html__( 'Price: low to high', 'elinor' ),
                    'price-desc'    => esc_html__( 'Price: high to low', 'elinor' ),
                    'rating'        => esc_html__( 'Average Rating', 'elinor' ),
                    'popularity'    => esc_html__( 'Popularity', 'elinor' ),
                    'post__in'      => esc_html__( 'Post In', 'elinor' ),
                    'most-viewed'   => esc_html__( 'Most Viewed', 'elinor' ),
                ],
                'default' => 'date',
            ]
        );

        $repeater->add_control(
            'order',
            [
                'label'   => esc_html__( 'Sort order', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''     => esc_html__( 'None', 'elinor' ),
                    'DESC' => esc_html__( 'Descending', 'elinor' ),
                    'ASC'  => esc_html__( 'Ascending', 'elinor' ),
                ],
                'default' => 'DESC',
            ]
        );

        $repeater->end_controls_tab();

        $repeater->end_controls_tabs();

        $this->add_control(
            'tabs',
            [
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'product_section',
            [
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'label' => esc_html__( 'Product Settings', 'elinor' ),
            ]
        );

        $this->add_control(
            'product_style',
            array(
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'Product style', 'elinor' ),
                'options' => elinor_product_options( 'Shortcode', true ),
                'default' => 'style-01',
            )
        );

        $this->add_responsive_control(
            'thumb_padding',
            [
                'label'      => esc_html__( 'Image Padding', 'elinor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .thumb-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->product_size_field();

        $this->add_control(
            'product_border',
            array(
                'type'      => Controls_Manager::SELECT,
                'label'     => esc_html__( 'Product Border', 'elinor' ),
                'options'   => [
                    ''                 => esc_html__( 'None', 'elinor' ),
                    'product-border-1' => esc_html__( 'Border 1', 'elinor' ),
                    'product-border-2' => esc_html__( 'Border 2', 'elinor' ),
                ],
                'default'   => '',
                'condition' => [
                    'product_style' => [
                        'style-01',
                        'style-02',
                        'style-04',
                        'style-05',
                        'style-06',
                        'style-09',
                        'style-10',
                        'style-11',
                        'style-12',
                        'style-13',
                        'style-18'
                    ]
                ],
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'product_border_wrap',
                'label'    => esc_html__( 'Border Type', 'elinor' ),
                'selector' => '{{WRAPPER}} ul.products',
            ]
        );

        $this->add_responsive_control(
            'product_border_wrap_r',
            [
                'label'      => esc_html__( 'Border Radius', 'elinor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} ul.products' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'product_padding_h',
            [
                'label'     => esc_html__( 'Product Padding - horizontal', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} .product-item' => '--product-pd-h: {{VALUE}}px;',
                ],
                'condition' => [
                    'product_style' => [
                        'style-01',
                        'style-02',
                        'style-04',
                        'style-05',
                        'style-06',
                        'style-09',
                        'style-10',
                        'style-11',
                        'style-12',
                        'style-13',
                        'style-18'
                    ]
                ],
            ]
        );

        $this->add_responsive_control(
            'product_padding_v',
            [
                'label'     => esc_html__( 'Product Padding - vertical', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} .product-item' => '--product-pd-v: {{VALUE}}px;',
                ],
                'condition' => [
                    'product_style' => [
                        'style-01',
                        'style-02',
                        'style-04',
                        'style-05',
                        'style-06',
                        'style-09',
                        'style-10',
                        'style-11',
                        'style-12',
                        'style-13',
                        'style-18'
                    ]
                ],
            ]
        );

        $this->add_control(
            'product_bg',
            [
                'label'     => esc_html__( 'Product Background', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ovic-products' => '--product-bg: {{VALUE}};',
                ],
                'condition' => [
                    'product_style' => 'style-12',
                ],
            ]
        );

        $this->add_control(
            'disable_labels',
            [
                'label'        => esc_html__( 'Disable Labels', 'elinor' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'labels-not-',
            ]
        );

        $this->add_control(
            'disable_rating',
            [
                'label'        => esc_html__( 'Disable Rating', 'elinor' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'rating-not-',
            ]
        );

        $this->add_control(
            'short_text',
            [
                'label'        => esc_html__( 'Short Title', 'elinor' ),
                'prefix_class' => 'short-text-',
                'type'         => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'overflow_visible',
            [
                'label' => esc_html__( 'Content Overflow', 'elinor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'carousel_section',
            [
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'label' => esc_html__( 'Carousel settings', 'elinor' ),
            ]
        );

        $this->add_control(
            'slide_nav',
            [
                'label'   => esc_html__( 'Nav style', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => elinor_nav_style(),
                'default' => '',
            ]
        );

        $this->add_control(
            'slide_dot',
            [
                'label'   => esc_html__( 'Dot style', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => elinor_dot_style(),
                'default' => '',
            ]
        );

        $this->carousel_settings( false );

        $this->end_controls_section();
    }
}