<?php
/**
 * Template Vertical menu
 *
 * @return string
 * @var $layout
 *
 */
?>
<?php
global $post;

$id = 0;

if ( !empty( $post->ID ) ) {
    $id = $post->ID;
}
if ( $layout == 'popup' ) {
    $classes = 'popup-vertical';
} else {
    $classes = 'box-nav-vertical elinor-dropdown';
}
$vertical_menu  = elinor_theme_option_meta(
    '_custom_metabox_theme_options',
    'vertical_menu',
    'metabox_vertical_menu'
);
$vertical_title = elinor_theme_option_meta(
    '_custom_metabox_theme_options',
    'vertical_title',
    'metabox_vertical_title'
);
$always_open    = elinor_get_option( 'vertical_always_open' );
if ( !empty( $always_open ) && is_page() && is_array( $always_open ) && in_array( $id, $always_open ) && $layout != 'popup' ) {
    $classes .= ' always-open';
}
if ( !empty( $vertical_menu ) ) : ?>
    <div class="header-vertical">
        <div class="<?php echo esc_attr( $classes ); ?>">
            <?php if ( $layout == 'popup' ) : ?>
                <div class="block-title">
                    <span class="text"><?php echo esc_html( $vertical_title ); ?></span>
                    <a href="#" class="vertical-close">
                        <span class="icon main-icon-e-close-circle"></span>
                    </a>
                </div>
            <?php else: ?>
                <a href="#" data-elinor="elinor-dropdown" class="block-title">
                    <span class="icon main-icon-e-menu"></span>
                    <?php if ( !empty( $vertical_title ) ) : ?>
                        <span class="text"><?php echo esc_html( $vertical_title ); ?></span>
                    <?php endif; ?>
                </a>
            <?php endif; ?>
            <div class="block-content sub-menu">
                <?php
                wp_nav_menu(
                    array(
                        'menu'            => $vertical_menu,
                        'theme_location'  => $vertical_menu,
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'megamenu'        => true,
                        'mobile_enable'   => true,
                        'menu_class'      => 'elinor-nav vertical-menu',
                        'megamenu_layout' => 'vertical',
                    )
                );
                ?>
            </div>
        </div>
    </div>
<?php endif;