<?php
/**
 * Template Page Head
 *
 * @return string
 *
 * @var $page_title
 * @var $page_title_bg
 * @var $page_title_fixed
 */

if ( $page_title == 1 ) :
    if ( !empty( $page_title_bg ) ) {
        $bg = 'background-image: url("' . esc_url( wp_get_attachment_image_url( $page_title_bg, 'full' ) ) . '")';
    } else {
        $bg = '';
    }
    ?>
    <div class="page-head <?php if ( $page_title_fixed == 1 ) echo esc_attr( 'bg-fixed' ); ?>" style="<?php echo esc_attr( $bg ); ?>">
        <div class="container">
            <?php elinor_page_title(); ?>
        </div>
    </div>
<?php endif; ?>