<?php
/**
 * Product loop sale flash
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/sale-flash.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @package    WooCommerce/Templates
 * @version     1.6.4
 */

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $post, $product;

$html = '';

/* LABEL NEW */
$datestamp = strtotime( get_the_time( 'Y-m-d' ) );
$newness   = elinor_get_option( 'product_newness', 0 );
if ( $newness > 0 && ( time() - ( 60 * 60 * 24 * (int)$newness ) ) < (int)$datestamp ) {
    $html .= '<span class="onnew product-label"><span class="text">' . esc_html__( 'New', 'elinor' ) . '</span></span>';
}
/* LABEL SALE */
if ( $product->is_on_sale() && $product->is_type( 'simple' ) ) {
    $percent = elinor_sale_percent();
    $html    .= '<span class="onsale product-label">';
    $html    .= '<span class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
<g clip-path="url(#clip0_95:577)">
<path d="M8.58734 4.50032L8.98219 3.47045C9.0255 3.35683 8.99175 3.22803 8.8967 3.15097L8.04063 2.45689L7.86739 1.3674C7.84827 1.24704 7.75378 1.15311 7.63341 1.13398L6.54392 0.960745L5.85041 0.104116C5.77391 0.00906005 5.64229 -0.0246876 5.53149 0.0186219L4.50106 0.414032L3.47119 0.0191844C3.35701 -0.0246876 3.22933 0.010185 3.15228 0.104679L2.4582 0.961308L1.36871 1.13455C1.24891 1.15367 1.15441 1.24816 1.13529 1.36797L0.962051 2.45746L0.105422 3.15153C0.0109284 3.22803 -0.0233817 3.35683 0.0199278 3.47045L0.414776 4.50032L0.0199278 5.53018C-0.0239442 5.6438 0.0109284 5.7726 0.105422 5.8491L0.962051 6.54261L1.13529 7.6321C1.15441 7.75247 1.24834 7.84696 1.36871 7.86609L2.4582 8.03932L3.15228 8.89539C3.22933 8.99101 3.35814 9.02476 3.47176 8.98089L4.50106 8.5866L5.53093 8.98145C5.56355 8.99382 5.5973 9.00001 5.63161 9.00001C5.71429 9.00001 5.79585 8.96345 5.85041 8.89539L6.54392 8.03932L7.63341 7.86609C7.75378 7.84696 7.84827 7.75247 7.86739 7.6321L8.04063 6.54261L8.8967 5.8491C8.99175 5.77204 9.0255 5.6438 8.98219 5.53018L8.58734 4.50032Z" fill="#E80E29"/>
<path d="M3.65631 3.93861C3.19116 3.93861 2.81262 3.56007 2.81262 3.09491C2.81262 2.62976 3.19116 2.25122 3.65631 2.25122C4.12147 2.25122 4.50001 2.62976 4.50001 3.09491C4.50001 3.56007 4.12147 3.93861 3.65631 3.93861ZM3.65631 2.81368C3.50107 2.81368 3.37508 2.93967 3.37508 3.09491C3.37508 3.25015 3.50107 3.37614 3.65631 3.37614C3.81155 3.37614 3.93754 3.25015 3.93754 3.09491C3.93754 2.93967 3.81155 2.81368 3.65631 2.81368Z" fill="#FAFAFA"/>
<path d="M5.34375 6.75038C4.8786 6.75038 4.50006 6.37184 4.50006 5.90668C4.50006 5.44153 4.8786 5.06299 5.34375 5.06299C5.80891 5.06299 6.18745 5.44153 6.18745 5.90668C6.18745 6.37184 5.80891 6.75038 5.34375 6.75038ZM5.34375 5.62545C5.18908 5.62545 5.06252 5.752 5.06252 5.90668C5.06252 6.06136 5.18908 6.18791 5.34375 6.18791C5.49843 6.18791 5.62498 6.06136 5.62498 5.90668C5.62498 5.752 5.49843 5.62545 5.34375 5.62545Z" fill="#FAFAFA"/>
<path d="M3.09501 6.75025C3.0382 6.75025 2.98139 6.73337 2.93189 6.69794C2.80534 6.60738 2.77609 6.4319 2.86665 6.30534L5.67895 2.36811C5.76951 2.24156 5.945 2.21231 6.07155 2.30286C6.19811 2.39286 6.22679 2.56891 6.1368 2.6949L3.32449 6.63213C3.26881 6.70919 3.18275 6.75025 3.09501 6.75025Z" fill="#FAFAFA"/>
</g>
</svg></span>';
    $html    .= '<span class="text">' . esc_html__( 'Sale', 'elinor' ) . '</span>';
    $html    .= '</span>';
}
/* LABEL FEATURED */
if ( $product->is_featured() ) {
    $html .= '<span class="featured product-label">';
    $html .= '<span class="icon"><svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
<g clip-path="url(#clip0_95:596)">
<path d="M0.9529 4.38926C0.9529 4.38926 1.30847 4.91163 2.05371 5.35379C2.05371 5.35379 1.51398 0.792229 5.03071 0C4.12971 3.30681 6.1768 4.23939 6.92301 2.49233C8.16918 4.15612 7.223 5.60769 7.223 5.60769C7.73398 5.6813 8.1632 5.12306 8.1632 5.12306C8.16703 5.19182 8.16918 5.26106 8.16918 5.33079C8.16919 7.35724 6.52643 9 4.49997 9C2.47351 9 0.83075 7.35724 0.83075 5.33078C0.83075 5.00527 0.873359 4.68974 0.9529 4.38926Z" fill="#FF6536"/>
<path d="M8.16325 5.12306C8.16325 5.12306 7.73402 5.6813 7.22305 5.60769C7.22305 5.60769 8.16922 4.15612 6.92306 2.49233C6.17685 4.23939 4.12975 3.30681 5.03075 0C4.8424 0.0424336 4.66578 0.095748 4.5 0.15852V9C6.52646 9 8.16922 7.35724 8.16922 5.33078C8.16922 5.26104 8.16708 5.19182 8.16325 5.12306Z" fill="#FF421D"/>
<path d="M2.89081 7.3908C2.89081 8.27952 3.61127 8.99998 4.49998 8.99998C5.38869 8.99998 6.10915 8.27952 6.10915 7.3908C6.10915 6.91512 5.90277 6.48766 5.57464 6.19306C4.95248 7.03831 4.06587 5.75614 4.75683 4.81982C4.75683 4.81982 2.89081 5.05367 2.89081 7.3908Z" fill="#FBBF00"/>
<path d="M6.10917 7.3908C6.10917 6.91512 5.90279 6.48766 5.57466 6.19306C4.9525 7.03831 4.06589 5.75614 4.75685 4.81982C4.75685 4.81982 4.65546 4.83257 4.5 4.88163V8.99998C5.38872 8.99998 6.10917 8.27952 6.10917 7.3908Z" fill="#FFA900"/>
</g>
</svg></span>';
    $html .= '<span class="text">' . esc_html__( 'Hot', 'elinor' ) . '</span>';
    $html .= '</span>';
}
/* LABEL STOCK */
if ( !$product->is_in_stock() && $product->is_type( 'simple' ) ) {
    $html .= '<span class="out-of-stock product-label"><span class="text">' . esc_html__( 'Out of stock', 'elinor' ) . '</span></span>';
}


/* LABEL WRAPPER */
if ( !empty( $html ) ) {
    echo apply_filters( 'woocommerce_sale_flash',
        '<div class="product-labels">' . wp_specialchars_decode( $html ) . '</div>', $post, $product
    );
}

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
