jQuery(document).ready(function($) {
    'use strict';
    jQuery(document).on('change', '.woocommerce.widget_shopping_cart input.qty', function(){
        var value = $(this).val();
        if (!isNaN(value) && value > 0) {
            var holder = $(this).closest('li');
            if (holder.length) {
                var removeButton = $(holder).find('.remove_from_cart_button');
                if (removeButton.length) {
                    var itemHash = removeButton.attr('data-cart_item_key');
                    if (itemHash) {
                        holder.block({
                            message: null,
                            overlayCSS: {
                                opacity: 0.6
                            }
                        });
                        $.ajax({
                            type: 'POST',
                            dataType: 'json',
                            url: nutreko_cart_widget_qty_ajax.ajax_url,
                            data: {
                                action: 'nutreko_change_widget_cart_qty',
                                hash: itemHash,
                                quantity: value,
                            },
                            success: function(response) {
                                if (response.data.subtotal_html) {
                                    var miniCart = $(holder).closest('div.widget_shopping_cart_content');
                                    if (miniCart.length) {
                                        var subTotalHolder = $(miniCart).find('.woocommerce-mini-cart__total .woocommerce-Price-amount.amount');
                                        if (subTotalHolder) {
                                            subTotalHolder.replaceWith(response.data.subtotal_html);
                                        }
                                    }
                                }
                                if(response.data.product_quantity){
                                    var cartItem = $(holder).find('.cart-item');
                                    if(cartItem.length){
                                        cartItem.html(response.data.product_quantity);
                                    }
                                }
                                if(response.data.mess){
                                    alert(response.data.mess);
                                }
                            },
                            complete: function() {
                                holder.css( 'opacity', '1' ).unblock();
                            },
                        });
                    }
                }

            }
        }
    });
});