(function ($) {
    'use strict';
    var Countdown = function ($countdown, endTime, $) {
        var self = this;
        self.timeInterval = null;

        var elements = {
            $daysSpan: $countdown.find('.countdown-days'),
            $hoursSpan: $countdown.find('.countdown-hours'),
            $minutesSpan: $countdown.find('.countdown-minutes'),
            $secondsSpan: $countdown.find('.countdown-seconds')
        };

        var updateClock = function () {
            var timeRemaining = Countdown.getTimeRemaining(endTime);

            $.each(timeRemaining.parts, function (timePart) {
                var $element = elements['$' + timePart + 'Span'],
                    partValue = this.toString();

                if (1 === partValue.length) {
                    partValue = 0 + partValue;
                }

                if ($element.length) {
                    $element.text(partValue);
                }
            });

            if (timeRemaining.total <= 0) {
                clearInterval(self.timeInterval);
            }
        };

        var initializeClock = function () {
            updateClock();

            self.timeInterval = setInterval(updateClock, 1000);
        };

        initializeClock();
    };

    Countdown.getTimeRemaining = function (endTime) {
        var timeRemaining = endTime - new Date(),
            seconds = Math.floor((timeRemaining / 1000) % 60),
            minutes = Math.floor((timeRemaining / 1000 / 60) % 60),
            hours = Math.floor((timeRemaining / (1000 * 60 * 60)) % 24),
            days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24));

        if (days < 0 || hours < 0 || minutes < 0) {
            seconds = minutes = hours = days = 0;
        }

        return {
            total: timeRemaining,
            parts: {
                days: days,
                hours: hours,
                minutes: minutes,
                seconds: seconds
            }
        };
    };

    function init_countdown() {
        var $parent = $('.time-sale');
        var $element = $('.nutreko-countdown', $parent);
        if ($element.length) {
            $element.each(function (index, el) {
                let $that = $(this);
                let data_date = $that.data('date');
                if ($(el).hasClass('simple')) {
                    var date = new Date(data_date * 1000);
                    new Countdown($that, date, $);
                } else {
                    var countdown = false;
                    $('form.variations_form').on('found_variation.wc-variation-form', function (e, v) {
                        var time = data_date[v.variation_id];
                        if (time) {
                            var date = new Date(time * 1000);
                            var now = Date.now();
                            if (!countdown) {
                                countdown = new Countdown($that, date, $);
                            } else {
                                clearInterval(countdown.timeInterval);
                                countdown = new Countdown($that, date, $);
                            }
                            $(el).closest('.time-sale').show()
                            if (date < now) {
                                $(el).closest('.time-sale').hide()
                            }
                        } else {
                            $(el).closest('.time-sale').hide()
                        }
                    });
                }
            });
        }
    }

    $(document).ready(function () {
        init_countdown();
    }).on('nutreko-products-loaded', function () {
        init_countdown();
    });

})(jQuery);
