<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Nutreko_Customize')) {

    class Nutreko_Customize {


        public function __construct() {
            add_action('customize_register', array($this, 'customize_register'));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         */
        public function customize_register($wp_customize) {

            /**
             * Theme options.
             */
            require_once get_theme_file_path('inc/customize-control/editor.php');
            require_once get_theme_file_path('inc/customize-control/color.php');
            require_once get_theme_file_path('inc/customize-control/button-switch.php');

            $this->init_nutreko_blog($wp_customize);
            $this->init_nutreko_scroll($wp_customize);

            $this->init_nutreko_social($wp_customize);

            if (nutreko_is_woocommerce_activated()) {
                $this->init_woocommerce($wp_customize);
            }

            do_action('nutreko_customize_register', $wp_customize);
        }

        public function init_nutreko_scroll($wp_customize) {

            $wp_customize->add_section('nutreko_settings', array(
                'title' => esc_html__('Nutreko Settings', 'nutreko'),
            ));

            $wp_customize->add_setting('nutreko_options_smooth_scroll', array(
                'type'              => 'option',
                'default'           => '',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control(new Nutreko_Customize_Control_Button_Switch( $wp_customize, 'nutreko_options_smooth_scroll', array(
                'section' => 'nutreko_settings',
                'label' => esc_html__( 'Enable', 'nutreko' ),
                'description' => esc_html__('Smooth Scroll On Windows', 'nutreko'),
            ) ));

            $wp_customize->add_setting('nutreko_options_enable_backtop', array(
                'type'              => 'option',
                'default'           => '',
                'sanitize_callback' => 'nutreko_sanitize_button_switch',
            ));

            $wp_customize->add_control(new Nutreko_Customize_Control_Button_Switch($wp_customize, 'nutreko_options_enable_backtop', array(
                'section'   => 'nutreko_settings',
                'transport' => 'refresh',
                'label'     => esc_html__('Enable back to top', 'nutreko'),
            )));
        }


        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_nutreko_blog($wp_customize) {

            $wp_customize->add_section('nutreko_blog_archive', array(
                'title' => esc_html__('Blog', 'nutreko'),
            ));

            // =========================================
            // Select Style
            // =========================================

            $wp_customize->add_setting('nutreko_options_blog_style', array(
                'type'              => 'option',
                'default'           => 'standard',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_blog_style', array(
                'section' => 'nutreko_blog_archive',
                'label'   => esc_html__('Blog style', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    'standard' => esc_html__('Blog Standard', 'nutreko'),
                    //====start_premium
                    'grid'  => esc_html__('Blog Grid', 'nutreko'),
                    'list'     => esc_html__('Blog List', 'nutreko'),
                    //====end_premium
                ),
            ));

            $wp_customize->add_setting('nutreko_options_blog_columns', array(
                'type'              => 'option',
                'default'           => 1,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_blog_columns', array(
                'section' => 'nutreko_blog_archive',
                'label'   => esc_html__('Colunms', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'nutreko'),
                    2 => esc_html__('2', 'nutreko'),
                    3 => esc_html__('3', 'nutreko'),
                    4 => esc_html__('4', 'nutreko'),
                ),
            ));

            $wp_customize->add_setting('nutreko_options_blog_archive_sidebar', array(
                'type'              => 'option',
                'default'           => 'right',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_blog_archive_sidebar', array(
                'section' => 'nutreko_blog_archive',
                'label'   => esc_html__('Sidebar Position', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'nutreko'),
                    'right' => esc_html__('Right', 'nutreko'),
                ),
            ));

        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_nutreko_social($wp_customize) {

            $wp_customize->add_section('nutreko_social', array(
                'title' => esc_html__('Socials', 'nutreko'),
            ));
            $wp_customize->add_setting('nutreko_options_social_share', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_social_share', array(
                'type'    => 'checkbox',
                'section' => 'nutreko_social',
                'label'   => esc_html__('Show Social Share', 'nutreko'),
            ));
            $wp_customize->add_setting('nutreko_options_social_share_facebook', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_social_share_facebook', array(
                'type'    => 'checkbox',
                'section' => 'nutreko_social',
                'label'   => esc_html__('Share on Facebook', 'nutreko'),
            ));
            $wp_customize->add_setting('nutreko_options_social_share_twitter', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_social_share_twitter', array(
                'type'    => 'checkbox',
                'section' => 'nutreko_social',
                'label'   => esc_html__('Share on Twitter', 'nutreko'),
            ));
            $wp_customize->add_setting('nutreko_options_social_share_linkedin', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_social_share_linkedin', array(
                'type'    => 'checkbox',
                'section' => 'nutreko_social',
                'label'   => esc_html__('Share on Linkedin', 'nutreko'),
            ));
            $wp_customize->add_setting('nutreko_options_social_share_google-plus', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_social_share_google-plus', array(
                'type'    => 'checkbox',
                'section' => 'nutreko_social',
                'label'   => esc_html__('Share on Google+', 'nutreko'),
            ));

            $wp_customize->add_setting('nutreko_options_social_share_pinterest', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_social_share_pinterest', array(
                'type'    => 'checkbox',
                'section' => 'nutreko_social',
                'label'   => esc_html__('Share on Pinterest', 'nutreko'),
            ));
            $wp_customize->add_setting('nutreko_options_social_share_email', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_social_share_email', array(
                'type'    => 'checkbox',
                'section' => 'nutreko_social',
                'label'   => esc_html__('Share on Email', 'nutreko'),
            ));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_woocommerce($wp_customize) {

            $wp_customize->add_panel('woocommerce', array(
                'title' => esc_html__('Woocommerce', 'nutreko'),
            ));

            $wp_customize->add_section('nutreko_woocommerce_archive', array(
                'title'      => esc_html__('Archive', 'nutreko'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
                'priority'   => 1,
            ));

            $wp_customize->add_setting('nutreko_options_woocommerce_archive_layout', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_woocommerce_archive_layout', array(
                'section' => 'nutreko_woocommerce_archive',
                'label'   => esc_html__('Layout Style', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    'default'  => esc_html__('Sidebar', 'nutreko'),
                    //====start_premium
                    'canvas'   => esc_html__('Canvas Filter', 'nutreko'),
                    'menu'     => esc_html__('Menu Filter', 'nutreko'),
                    'dropdown' => esc_html__('Dropdown Filter', 'nutreko'),
                    'drawing'  => esc_html__('Drawing Filter', 'nutreko'),
                    //====end_premium
                ),
            ));

            $wp_customize->add_setting('nutreko_options_woocommerce_archive_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_woocommerce_archive_sidebar', array(
                'section' => 'nutreko_woocommerce_archive',
                'label'   => esc_html__('Sidebar Position', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'nutreko'),
                    'right' => esc_html__('Right', 'nutreko'),

                ),
            ));

            $wp_customize->add_setting('nutreko_options_woocommerce_shop_pagination', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('nutreko_options_woocommerce_shop_pagination', array(
                'section' => 'nutreko_woocommerce_archive',
                'label'   => esc_html__('Products pagination', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    'default'  => esc_html__('Pagination', 'nutreko'),
                    'more-btn' => esc_html__('Load More', 'nutreko'),
                    'infinit'  => esc_html__('Infinit Scroll', 'nutreko'),
                ),
            ));

            // =========================================
            // Single Product
            // =========================================

            $wp_customize->add_section('nutreko_woocommerce_single', array(
                'title'      => esc_html__('Single Product', 'nutreko'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
            ));

            $wp_customize->add_setting('nutreko_options_single_product_gallery_layout', array(
                'type'              => 'option',
                'default'           => 'horizontal',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('nutreko_options_single_product_gallery_layout', array(
                'section' => 'nutreko_woocommerce_single',
                'label'   => esc_html__('Layout Style', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    'horizontal'     => esc_html__('Horizontal', 'nutreko'),
                    'vertical'       => esc_html__('Vertical', 'nutreko'),
                    'sticky'         => esc_html__('Sticky', 'nutreko'),
                    'gallery'        => esc_html__('Gallery', 'nutreko'),
                    'collage'        => esc_html__('Collage', 'nutreko'),
                    'with-sidebar'   => esc_html__('With Sidebar', 'nutreko'),
                    'without-thumb'  => esc_html__('Without Thumb', 'nutreko'),
                    'sticky-sidebar' => esc_html__('Sticky Sidebar', 'nutreko'),
                    'sticky-summary' => esc_html__('Sticky Summary', 'nutreko'),
                ),
            ));

            $wp_customize->add_setting('nutreko_options_single_product_content_meta', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'nutreko_sanitize_editor',
            ));

            $wp_customize->add_control(new Nutreko_Customize_Control_Editor($wp_customize, 'nutreko_options_single_product_content_meta', array(
                'section' => 'nutreko_woocommerce_single',
                'label'   => esc_html__('Single extra description', 'nutreko'),
            )));

            $wp_customize->add_section('nutreko_woocommerce_product', array(
                'title'      => esc_html__('Product Block', 'nutreko'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
            ));

            $wp_customize->add_setting('nutreko_options_wocommerce_block_style', array(
                'type'              => 'option',
                'default'           => '',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('nutreko_options_wocommerce_block_style', array(
                'section' => 'nutreko_woocommerce_product',
                'label'   => esc_html__('Style', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    ''  => esc_html__('Style Default', 'nutreko'),
                ),
            ));

            $wp_customize->add_setting('nutreko_options_woocommerce_product_hover', array(
                'type'              => 'option',
                'default'           => 'none',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('nutreko_options_woocommerce_product_hover', array(
                'section' => 'nutreko_woocommerce_product',
                'label'   => esc_html__('Animation Image Hover', 'nutreko'),
                'type'    => 'select',
                'choices' => array(
                    'none'          => esc_html__('None', 'nutreko'),
                    'bottom-to-top' => esc_html__('Bottom to Top', 'nutreko'),
                    'top-to-bottom' => esc_html__('Top to Bottom', 'nutreko'),
                    'right-to-left' => esc_html__('Right to Left', 'nutreko'),
                    'left-to-right' => esc_html__('Left to Right', 'nutreko'),
                    'swap'          => esc_html__('Swap', 'nutreko'),
                    'fade'          => esc_html__('Fade', 'nutreko'),
                    'zoom-in'       => esc_html__('Zoom In', 'nutreko'),
                    'zoom-out'      => esc_html__('Zoom Out', 'nutreko'),
                ),
            ));

        }
    }
}
return new Nutreko_Customize();
