<?php

use Elementor\Plugin;

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Nutreko_Elementor')) :

    /**
     * The Nutreko Elementor Integration class
     */
    class Nutreko_Elementor {
        private $suffix = '';

        public function __construct() {
            $this->suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';

            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'register_auto_scripts_frontend']);
            add_action('elementor/elements/categories_registered', [$this, 'register_widget_category']);
            add_action('wp_enqueue_scripts', [$this, 'add_scripts'], 15);
            add_action('elementor/widgets/register', array($this, 'customs_widgets'));
            add_action('elementor/widgets/register', array($this, 'include_widgets'));
            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'add_js']);

            // Custom Animation Scroll
            add_filter('elementor/controls/animations/additional_animations', [$this, 'add_animations_scroll']);

            // Elementor Fix Noitice WooCommerce
            add_action('elementor/editor/before_enqueue_scripts', array($this, 'woocommerce_fix_notice'));

            // Backend
            add_action('elementor/editor/after_enqueue_styles', [$this, 'add_style_editor'], 99);

            add_filter('elementor/shapes/additional_shapes', [$this, 'additional_shapes'], 10, 1);

            // Add Icon Custom
            add_action('elementor/icons_manager/native', [$this, 'add_icons_native']);
            add_action('elementor/controls/register', [$this, 'add_icons']);

            if (!nutreko_is_elementor_pro_activated()) {
                require trailingslashit(get_template_directory()) . 'inc/elementor/custom-css.php';
                require trailingslashit(get_template_directory()) . 'inc/elementor/sticky-section.php';
                if (is_admin()) {
                    add_action('manage_elementor_library_posts_columns', [$this, 'admin_columns_headers']);
                    add_action('manage_elementor_library_posts_custom_column', [$this, 'admin_columns_content'], 10, 2);
                }

                require get_theme_file_path('inc/elementor/motion-fx/controls-group.php');
                require get_theme_file_path('inc/elementor/motion-fx/module.php');
            }

            require get_theme_file_path('inc/elementor/modules/page-settings.php');
            if (function_exists('hfe_init')) {
                require get_theme_file_path('inc/elementor/modules/header-settings.php');
            }
            add_filter('elementor/fonts/additional_fonts', [$this, 'additional_fonts']);
            add_action('wp_enqueue_scripts', [$this, 'elementor_kit']);

            require get_theme_file_path('inc/elementor/modules/settings.php');
        }

        public function elementor_kit() {
            $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
            Elementor\Plugin::$instance->kits_manager->frontend_before_enqueue_styles();
            $myvals = get_post_meta($active_kit_id, '_elementor_page_settings', true);
            if (!empty($myvals)) {
                $css = '';
                foreach ($myvals['system_colors'] as $key => $value) {
                    $css .= $value['color'] !== '' ? '--' . $value['_id'] . ':' . $value['color'] . ';' : '';
                }

                $var = "body{{$css}}";
                wp_add_inline_style('nutreko-style', $var);
            }
        }

        public function additional_shapes($additional_shapes) {
            $additional_shapes['nutreko_wave'] = [
                'title'    => esc_html_x('FootPaw Waves', 'Shapes', 'nutreko'),
                'path'     => get_theme_file_path('assets/images/shape/waves.svg'),
                'url'      => get_theme_file_uri('assets/images/shape/waves.svg'),
                'has_flip' => true,
            ];
            return $additional_shapes;
        }

        public function additional_fonts($fonts) {
            return $fonts;
        }

        public function admin_columns_headers($defaults) {
            $defaults['shortcode'] = esc_html__('Shortcode', 'nutreko');

            return $defaults;
        }

        public function admin_columns_content($column_name, $post_id) {
            if ('shortcode' === $column_name) {
                ob_start();
                ?>
                <input class="elementor-shortcode-input" type="text" readonly onfocus="this.select()" value="[hfe_template id='<?php echo esc_attr($post_id); ?>']"/>
                <?php
                ob_get_contents();
            }
        }

        public function add_js() {

            wp_enqueue_script('nutreko-elementor-frontend', get_theme_file_uri('/assets/js/elementor-frontend.js'), ['jquery', 'elementor-frontend'], NUTREKO_VERSION);
        }

        public function add_style_editor() {

            wp_enqueue_style('nutreko-elementor-editor-icon', get_theme_file_uri('/assets/css/admin/elementor/icons.css'), [], NUTREKO_VERSION);
        }

        public function add_scripts() {

            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            wp_enqueue_style('nutreko-elementor', get_template_directory_uri() . '/assets/css/base/elementor.css', '', NUTREKO_VERSION);
            wp_style_add_data('nutreko-elementor', 'rtl', 'replace');

            // Add Scripts
            wp_enqueue_style('e-swiper');
            $e_swiper_latest     = Plugin::$instance->experiments->is_feature_active('e_swiper_latest');
            $e_swiper_asset_path = $e_swiper_latest ? 'assets/lib/swiper/v8/' : 'assets/lib/swiper/';
            $e_swiper_version    = $e_swiper_latest ? '8.4.5' : '5.3.6';
            wp_register_script(
                'swiper',
                plugins_url('elementor/' . $e_swiper_asset_path . 'swiper.js', 'elementor'),
                [],
                $e_swiper_version,
                true
            );
        }

        public function register_auto_scripts_frontend() {
            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            wp_register_script('nutreko-elementor-swiper', get_theme_file_uri('/assets/js/elementor-swiper' . $suffix . '.js'), array('jquery', 'elementor-frontend'), NUTREKO_VERSION, true);
            // Register auto scripts frontend

            $files = glob(get_theme_file_path('/assets/js/elementor/*' . $suffix . '.js'));
            foreach ($files as $file) {
                $file_name = wp_basename($file);
                $handle    = str_replace($suffix . ".js", '', $file_name);
                $scr       = get_theme_file_uri('/assets/js/elementor/' . $file_name);
                if (file_exists($file)) {
                    wp_register_script('nutreko-elementor-' . $handle, $scr, ['jquery', 'elementor-frontend'], NUTREKO_VERSION, true);
                }
            }
        }

        public function register_widget_category($this_cat) {
            $this_cat->add_category(
                'nutreko-addons',
                [
                    'title' => esc_html__('Nutreko Addons', 'nutreko'),
                    'icon'  => 'fa fa-plug',
                ]
            );
            return $this_cat;
        }

        public function add_animations_scroll($animations) {
            $animations['Nutreko Animation'] = [
                'opal-move-up'    => 'Move Up',
                'opal-move-down'  => 'Move Down',
                'opal-move-left'  => 'Move Left',
                'opal-move-right' => 'Move Right',
                'opal-flip'       => 'Flip',
                'opal-helix'      => 'Helix',
                'opal-scale-up'   => 'Scale',
                'opal-am-popup'   => 'Popup',
            ];

            return $animations;
        }

        public function customs_widgets() {
            $files = glob(get_theme_file_path('/inc/elementor/custom-widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }
        }

        /**
         * @param $widgets_manager Elementor\Widgets_Manager
         */
        public function include_widgets($widgets_manager) {
            require 'base-swiper-widget.php';
            $files = glob(get_theme_file_path('/inc/elementor/widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }
        }

        public function woocommerce_fix_notice() {
            if (nutreko_is_woocommerce_activated()) {
                remove_action('woocommerce_cart_is_empty', 'woocommerce_output_all_notices', 5);
                remove_action('woocommerce_shortcode_before_product_cat_loop', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_single_product', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_cart', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_checkout_form', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_account_content', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_customer_login_form', 'woocommerce_output_all_notices', 10);
            }
        }


        public function add_icons( $manager ) {
            $new_icons = json_decode( '{"nutreko-icon-addtocart":"addtocart","nutreko-icon-award":"award","nutreko-icon-box":"box","nutreko-icon-chat":"chat","nutreko-icon-compare":"compare","nutreko-icon-delivery":"delivery","nutreko-icon-email":"email","nutreko-icon-eye":"eye","nutreko-icon-payments":"payments","nutreko-icon-quickview":"quickview","nutreko-icon-quotes-1":"quotes-1","nutreko-icon-shield-check1":"shield-check1","nutreko-icon-smart-phone":"smart-phone","nutreko-icon-star1":"star1","nutreko-icon-wishlist":"wishlist","nutreko-icon-360":"360","nutreko-icon-angle-down":"angle-down","nutreko-icon-angle-left":"angle-left","nutreko-icon-angle-right":"angle-right","nutreko-icon-angle-up":"angle-up","nutreko-icon-arrow-left":"arrow-left","nutreko-icon-arrow-right":"arrow-right","nutreko-icon-arrow-top":"arrow-top","nutreko-icon-bars":"bars","nutreko-icon-cart-empty":"cart-empty","nutreko-icon-cart":"cart","nutreko-icon-check-square":"check-square","nutreko-icon-check":"check","nutreko-icon-circle":"circle","nutreko-icon-clock":"clock","nutreko-icon-cloud-download-alt":"cloud-download-alt","nutreko-icon-comment":"comment","nutreko-icon-comments":"comments","nutreko-icon-contact":"contact","nutreko-icon-copy":"copy","nutreko-icon-credit-card":"credit-card","nutreko-icon-dot-circle":"dot-circle","nutreko-icon-edit":"edit","nutreko-icon-envelope":"envelope","nutreko-icon-expand-alt":"expand-alt","nutreko-icon-expand":"expand","nutreko-icon-external-link-alt":"external-link-alt","nutreko-icon-file-alt":"file-alt","nutreko-icon-file-archive":"file-archive","nutreko-icon-filter":"filter","nutreko-icon-folder-open":"folder-open","nutreko-icon-folder":"folder","nutreko-icon-frown":"frown","nutreko-icon-gift":"gift","nutreko-icon-grape":"grape","nutreko-icon-grid":"grid","nutreko-icon-grip-horizontal":"grip-horizontal","nutreko-icon-heart-fill":"heart-fill","nutreko-icon-heart":"heart","nutreko-icon-history":"history","nutreko-icon-home":"home","nutreko-icon-info-circle":"info-circle","nutreko-icon-instagram":"instagram","nutreko-icon-letter":"letter","nutreko-icon-level-up-alt":"level-up-alt","nutreko-icon-list":"list","nutreko-icon-long-left-arrow":"long-left-arrow","nutreko-icon-long-right-arrow":"long-right-arrow","nutreko-icon-map-marker-check":"map-marker-check","nutreko-icon-map-marker":"map-marker","nutreko-icon-meh":"meh","nutreko-icon-minus-circle":"minus-circle","nutreko-icon-minus":"minus","nutreko-icon-mobile-android-alt":"mobile-android-alt","nutreko-icon-money-bill":"money-bill","nutreko-icon-pencil-alt":"pencil-alt","nutreko-icon-plus":"plus","nutreko-icon-quotes":"quotes","nutreko-icon-random":"random","nutreko-icon-reply-all":"reply-all","nutreko-icon-reply":"reply","nutreko-icon-search":"search","nutreko-icon-shield-check":"shield-check","nutreko-icon-shop":"shop","nutreko-icon-shopping-bag":"shopping-bag","nutreko-icon-shopping-basket":"shopping-basket","nutreko-icon-sign-out-alt":"sign-out-alt","nutreko-icon-smile":"smile","nutreko-icon-spinner":"spinner","nutreko-icon-square":"square","nutreko-icon-star":"star","nutreko-icon-store":"store","nutreko-icon-sync":"sync","nutreko-icon-tabs":"tabs","nutreko-icon-tachometer-alt":"tachometer-alt","nutreko-icon-thumbtack":"thumbtack","nutreko-icon-ticket":"ticket","nutreko-icon-times-circle":"times-circle","nutreko-icon-times-square":"times-square","nutreko-icon-times":"times","nutreko-icon-trophy-alt":"trophy-alt","nutreko-icon-truck":"truck","nutreko-icon-user":"user","nutreko-icon-video":"video","nutreko-icon-wishlist-empty":"wishlist-empty","nutreko-icon-adobe":"adobe","nutreko-icon-amazon":"amazon","nutreko-icon-android":"android","nutreko-icon-angular":"angular","nutreko-icon-apper":"apper","nutreko-icon-apple":"apple","nutreko-icon-atlassian":"atlassian","nutreko-icon-behance":"behance","nutreko-icon-bitbucket":"bitbucket","nutreko-icon-bitcoin":"bitcoin","nutreko-icon-bity":"bity","nutreko-icon-bluetooth":"bluetooth","nutreko-icon-btc":"btc","nutreko-icon-centos":"centos","nutreko-icon-chrome":"chrome","nutreko-icon-codepen":"codepen","nutreko-icon-cpanel":"cpanel","nutreko-icon-discord":"discord","nutreko-icon-dochub":"dochub","nutreko-icon-docker":"docker","nutreko-icon-dribbble":"dribbble","nutreko-icon-dropbox":"dropbox","nutreko-icon-drupal":"drupal","nutreko-icon-ebay":"ebay","nutreko-icon-facebook-solid":"facebook-solid","nutreko-icon-facebook":"facebook","nutreko-icon-figma":"figma","nutreko-icon-firefox":"firefox","nutreko-icon-google-plus":"google-plus","nutreko-icon-google":"google","nutreko-icon-grunt":"grunt","nutreko-icon-gulp":"gulp","nutreko-icon-html5":"html5","nutreko-icon-joomla":"joomla","nutreko-icon-link-brand":"link-brand","nutreko-icon-linkedin":"linkedin","nutreko-icon-mailchimp":"mailchimp","nutreko-icon-opencart":"opencart","nutreko-icon-paypal":"paypal","nutreko-icon-pinterest-p":"pinterest-p","nutreko-icon-reddit":"reddit","nutreko-icon-skype":"skype","nutreko-icon-slack":"slack","nutreko-icon-snapchat":"snapchat","nutreko-icon-spotify":"spotify","nutreko-icon-trello":"trello","nutreko-icon-twitter-x":"twitter-x","nutreko-icon-vimeo":"vimeo","nutreko-icon-whatsapp":"whatsapp","nutreko-icon-wordpress":"wordpress","nutreko-icon-yoast":"yoast","nutreko-icon-youtube":"youtube"}', true );
			$icons     = $manager->get_control( 'icon' )->get_settings( 'options' );
			$new_icons = array_merge(
				$new_icons,
				$icons
			);
			// Then we set a new list of icons as the options of the icon control
			$manager->get_control( 'icon' )->set_settings( 'options', $new_icons ); 
        }

        public function add_icons_native($tabs) {
            $tabs['opal-custom'] = [
                'name'          => 'nutreko-icon',
                'label'         => esc_html__('Nutreko Icon', 'nutreko'),
                'prefix'        => 'nutreko-icon-',
                'displayPrefix' => 'nutreko-icon-',
                'labelIcon'     => 'fab fa-font-awesome-alt',
                'ver'           => NUTREKO_VERSION,
                'fetchJson'     => get_theme_file_uri('/inc/elementor/icons.json'),
                'native'        => true,
            ];
            return $tabs;
        }

    }

endif;

return new Nutreko_Elementor();
