<?php

use Elementor\Core\Base\Document;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Nutreko_Elementor_Settings_Woocommerce extends Elementor\Core\Kits\Documents\Tabs\Tab_Base {

    public function get_id() {
        return 'settings-woocommerce';
    }

    public function get_title() {
        return esc_html__('Nutreko WooCommerce', 'nutreko');
    }

    public function get_group() {
        return 'settings';
    }

    public function get_icon() {
        return 'eicon-woocommerce';
    }

    protected function register_tab_controls() {
        $this->start_controls_section(
            'section_' . $this->get_id(),
            [
                'label' => $this->get_title(),
                'tab'   => $this->get_id(),
            ]
        );

        $this->add_control(
            $this->get_id() . '_refresh_notice',
            [
                'type'            => Controls_Manager::RAW_HTML,
                'raw'             => esc_html__('Changes will be reflected in the preview only after the page reloads.', 'nutreko'),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            ]
        );

        $this->add_control(
            'woocommerce_product_catalog',
            [
                'label' => esc_html__( 'Product Catalog', 'nutreko' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'woocommerce_catalog_columns',
            [
                'label'     => esc_html__('Products Columns', 'nutreko'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 3,
                'options'   => [1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5, 6 => 6],
                'selectors' => [
                    'ul.nutreko-products.products:not(.products-list)' => 'grid-template-columns: repeat({{VALUE}}, 1fr)',
                ],
            ]
        );

        $this->add_responsive_control(
            'woocommerce_catalog_gutter',
            [
                'label'      => esc_html__('Gutter Width (px)', 'nutreko'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 60,
                    ],
                ],
                'default' => [
                    'size' => 30
                ],
                'size_units' => ['px'],
                'selectors'  => [
                    'ul.nutreko-products.products:not(.products-list)' => 'grid-gap:{{SIZE}}{{UNIT}}; --gutter-width:{{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'woocommerce_catalog_rows',
            [
                'label'   => esc_html__('Products per row', 'nutreko'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => 4,
            ]
        );

        $this->add_control(
            'nutreko_options_woocommerce_product_hover',
            [
                'label'     => esc_html__('Product Hover', 'nutreko'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'none',
                'options' => [
                    'fade'  => esc_html__( 'Fade', 'nutreko' ),
                    'zoom-in' => esc_html__( 'Zoom in', 'nutreko' ),
                    'swap' => esc_html__( 'Swap', 'nutreko' ),
                    'top-to-bottom' => esc_html__( 'Top to bottom', 'nutreko' ),
                    'bottom-to-top' => esc_html__( 'Bottom to Top', 'nutreko' ),
                    'left-to-right' => esc_html__( 'Left to right', 'nutreko' ),
                    'right-to-left' => esc_html__( 'Right to left', 'nutreko' ),
                    'none' => esc_html__( 'None', 'nutreko' ),
                ],
            ]
        );

        $this->add_control(
            'woocommerce_product_related_carousel',
            [
                'label' => esc_html__( 'Product Carousel Global', 'nutreko' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $slides_to_show = range(1, 10);
        $slides_to_show = array_combine($slides_to_show, $slides_to_show);

        $this->add_responsive_control(
            'woo_carousel_slides_to_show',
            [
                'label'              => esc_html__('Slides to Show', 'nutreko'),
                'type'               => Controls_Manager::TEXT,
                'frontend_available' => true,
                'default'            => 4,
                'render_type'        => 'template',
                'selectors'          => [
                    '.related .swiper:not(.swiper-initialized) .swiper-slide' => 'flex: 0 0 calc(100% / {{VALUE}}); width: calc(100% / {{VALUE}}); margin-right:{{woo_carousel_spaceBetween.SIZE}}{{woo_carousel_spaceBetween.UNIT}}',
                    '.upsells .swiper:not(.swiper-initialized) .swiper-slide' => 'flex: 0 0 calc(100% / {{VALUE}}); width: calc(100% / {{VALUE}}); margin-right:{{woo_carousel_spaceBetween.SIZE}}{{woo_carousel_spaceBetween.UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'woo_carousel_slides_to_scroll',
            [
                'label'              => esc_html__('Slides to Scroll', 'nutreko'),
                'type'               => Controls_Manager::SELECT,
                'description'        => esc_html__('Set how many slides are scrolled per swipe.', 'nutreko'),
                'options'            => [
                                            '' => esc_html__('Default', 'nutreko'),
                                        ] + $slides_to_show,
                'frontend_available' => true,
                'condition'          => [
                    'woo_carousel_slides_to_show!' => '1'
                ],
            ]
        );

        $this->add_responsive_control(
            'woo_carousel_spaceBetween',
            [
                'label'              => esc_html__('Space Between', 'nutreko'),
                'type'               => Controls_Manager::SLIDER,
                'range'              => [
                    'px' => [
                        'min' => 0,
                        'max' => 60,
                    ],
                ],
                'default'            => [
                    'size' => 30
                ],
                'size_units'         => ['px'],
                'frontend_available' => true,
            ]
        );


        $this->add_control(
            'woo_carousel_navigation',
            [
                'label'              => esc_html__('Navigation', 'nutreko'),
                'type'               => Controls_Manager::SELECT,
                'default'            => 'dots',
                'options'            => [
                    'both'   => esc_html__('Arrows and Dots', 'nutreko'),
                    'arrows' => esc_html__('Arrows', 'nutreko'),
                    'dots'   => esc_html__('Dots', 'nutreko'),
                    'none'   => esc_html__('None', 'nutreko'),
                ],
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'woo_carousel_autoplay',
            [
                'label'              => esc_html__('Autoplay', 'nutreko'),
                'type'               => Controls_Manager::SELECT,
                'default'            => 'no',
                'options'            => [
                    'yes' => esc_html__('Yes', 'nutreko'),
                    'no'  => esc_html__('No', 'nutreko'),
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_control(
            'woo_carousel_autoplay_speed',
            [
                'label'              => esc_html__('Autoplay Speed', 'nutreko'),
                'type'               => Controls_Manager::NUMBER,
                'default'            => 5000,
                'condition'          => [
                    'woo_carousel_autoplay' => 'yes',
                ],
                'render_type'        => 'none',
                'frontend_available' => true,
            ]
        );

        $this->end_controls_section();
    }

    public function on_save($data) {
        if (
            !isset($data['settings']['post_status'])
            || Document::STATUS_PUBLISH !== $data['settings']['post_status']
            || // Should check for the current action to avoid infinite loop
            // when updating options like: "blogname" and "blogdescription".
            strpos(current_action(), 'update_option_') === 0
        ) {
            return;
        }

        if (isset($data['settings']['woocommerce_catalog_columns'])) {
            update_option('woocommerce_catalog_columns', $data['settings']['woocommerce_catalog_columns']);
        }
        if (isset($data['settings']['woocommerce_catalog_rows'])) {
            update_option('woocommerce_catalog_rows', $data['settings']['woocommerce_catalog_rows']);
        }

        if (isset($data['settings']['nutreko_options_woocommerce_product_hover'])) {
            update_option('nutreko_options_woocommerce_product_hover', $data['settings']['nutreko_options_woocommerce_product_hover']);
        }

        if (isset($data['settings']['woocommerce_product_style'])) {
            update_option('nutreko_options_woocommerce_product_style', $data['settings']['woocommerce_product_style']);
        }

    }
}
