(function ($) {
    'use strict';

    function nutrekoquantity() {

        var $quantityBoxes = $('.quantity:not(.buttons_added):not(.hidden)').find('.qty');

        if ($quantityBoxes && 'number' == $quantityBoxes.prop('type')) {

            // Add plus and minus boxes

            $quantityBoxes.parent().addClass('buttons_added').prepend('<button type="button" class="minus" >-</button>');
            $quantityBoxes.addClass('input-text').after('<button type="button" class="plus">+</button>');

            // Target quantity inputs on product pages
            $('input' + '.qty' + ':not(.product-quantity input' + '.qty' + ')').each(function () {
                var $min = parseFloat($(this).attr('min'));

                if ($min && $min > 0 && parseFloat($(this).val()) < $min) {
                    $(this).val($min);
                }
            });


            $('.plus, .minus').unbind('click');

            $('.plus, .minus').on('click', function () {

                    // Get values
                    var $quantityBox = $(this).parent().find('.qty'),
                        $currentQuantity = parseFloat($quantityBox.val()),
                        $maxQuantity = parseFloat($quantityBox.attr('max')),
                        $minQuantity = parseFloat($quantityBox.attr('min')),
                        $step = $quantityBox.attr('step');

                    // Fallback default values
                    if (!$currentQuantity || '' === $currentQuantity || 'NaN' === $currentQuantity) {
                        $currentQuantity = 0;
                    }
                    if ('' === $maxQuantity || 'NaN' === $maxQuantity) {
                        $maxQuantity = '';
                    }

                    if ('' === $minQuantity || 'NaN' === $minQuantity) {
                        $minQuantity = 0;
                    }
                    if ('any' === $step || '' === $step || undefined === $step || 'NaN' === parseFloat($step)) {
                        $step = 1;
                    }

                    // Change the value
                    if ($(this).is('.plus')) {

                        if ($maxQuantity && ($maxQuantity == $currentQuantity || $currentQuantity > $maxQuantity)) {
                            $quantityBox.val($maxQuantity);
                        } else {
                            $quantityBox.val($currentQuantity + parseFloat($step));
                        }

                    } else {

                        if ($minQuantity && ($minQuantity == $currentQuantity || $currentQuantity < $minQuantity)) {
                            $quantityBox.val($minQuantity);
                        } else if ($currentQuantity > 0) {
                            $quantityBox.val($currentQuantity - parseFloat($step));
                        }

                    }

                    // Trigger change event
                    $quantityBox.trigger('change');
                }
            );
        }
    }
    nutrekoquantity();

    $(window).on('focus', function() {
        if (typeof wc_cart_fragments_params !== 'undefined') {
            $(document.body).trigger('wc_fragments_loaded');
        }
    });

    $(document).on('woosq_loaded qv_loader_stop wc_fragments_loaded updated_wc_div nutreko-products-loaded',function () {
        nutrekoquantity();
    });
    $( document.body ).on( 'wc_fragments_loaded',function () {
        nutrekoquantity();
    } );

})(jQuery);
