<?php
// nested-tabs
use Elementor\Controls_Manager;

add_action('elementor/element/nested-tabs/section_title_style/before_section_end', function ($element, $args) {
    /** @var \Elementor\Element_Base $element */

    $element->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
            'name'      => 'tabs_heading_border',
            'selector'  => '{{WRAPPER}} .e-n-tabs-heading',
            'separator' => 'before'
        ]
    );

    $element->add_responsive_control(
        'tabs_heading_border_radius',
        [
            'label'      => esc_html__('Border Radius', 'nutreko'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .e-n-tabs-heading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    $element->add_responsive_control(
        'tabs_heading_padding',
        [
            'label'      => esc_html__('Padding', 'nutreko'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .e-n-tabs-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );

}, 10, 2);

add_action('elementor/element/nested-tabs/section_tabs/before_section_end', function ($element, $args) {
    $element->add_control(
        'style_theme',
        [
            'label'        => esc_html__('Style Theme', 'nutreko'),
            'type'         => Controls_Manager::SWITCHER,
            'prefix_class' => 'style-theme-'
        ]
    );
}, 10, 2);