<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Modules\DynamicTags\Module as TagsModule;
use Elementor\Utils;
use Elementor\Group_Control_Text_Stroke;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Nutreko_Elementor_Widget_Heading extends Elementor\Widget_Base {

    public function get_name() {
        return 'nutreko_animated-headline';
    }

    public function get_title() {
        return esc_html__('Nutreko Headline', 'nutreko');
    }

    public function get_icon() {
        return 'eicon-animated-headline';
    }

    public function get_keywords() {
        return ['headline', 'heading', 'animation', 'title', 'text'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'text_elements',
            [
                'label' => esc_html__('Headline', 'nutreko'),
            ]
        );

        $this->add_control(
            'before_text',
            [
                'label'       => esc_html__('Before Text', 'nutreko'),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active'     => true,
                    'categories' => [
                        TagsModule::TEXT_CATEGORY,
                    ],
                ],
                'default'     => esc_html__('This page is', 'nutreko'),
                'placeholder' => esc_html__('Enter your headline', 'nutreko'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'highlighted_text',
            [
                'label'       => esc_html__('Highlighted Text', 'nutreko'),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active'     => true,
                    'categories' => [
                        TagsModule::TEXT_CATEGORY,
                    ],
                ],
                'default'     => esc_html__('Amazing', 'nutreko'),
                'label_block' => true,
                'separator'   => 'none',
            ]
        );

        $this->add_control(
            'after_text',
            [
                'label'       => esc_html__('After Text', 'nutreko'),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active'     => true,
                    'categories' => [
                        TagsModule::TEXT_CATEGORY,
                    ],
                ],
                'placeholder' => esc_html__('Enter your headline', 'nutreko'),
                'label_block' => true,
                'separator'   => 'none',
            ]
        );

        $this->add_control(
            'link',
            [
                'label'     => esc_html__('Link', 'nutreko'),
                'type'      => Controls_Manager::URL,
                'dynamic'   => [
                    'active' => true,
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label'     => esc_html__('Alignment', 'nutreko'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__('Left', 'nutreko'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'nutreko'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__('Right', 'nutreko'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .elementor-headline' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tag',
            [
                'label'   => esc_html__('HTML Tag', 'nutreko'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'h1'   => 'H1',
                    'h2'   => 'H2',
                    'h3'   => 'H3',
                    'h4'   => 'H4',
                    'h5'   => 'H5',
                    'h6'   => 'H6',
                    'div'  => 'div',
                    'span' => 'span',
                    'p'    => 'p',
                ],
                'default' => 'h2',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_style_text',
            [
                'label' => esc_html__('Headline', 'nutreko'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Text Color', 'nutreko'),
                'type'      => Controls_Manager::COLOR,
                'global'    => [
                    'default' => Global_Colors::COLOR_SECONDARY,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-headline-plain-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'global'   => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector' => '{{WRAPPER}} .elementor-headline',
            ]
        );

        $this->add_control(
            'heading_words_style',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__('Highlighted Text', 'nutreko'),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'words_color',
            [
                'label'     => esc_html__('Text Color', 'nutreko'),
                'type'      => Controls_Manager::COLOR,
                'global'    => [
                    'default' => Global_Colors::COLOR_SECONDARY,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-headline-dynamic-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'words_typography',
                'global'   => [
                    'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
                ],
                'selector' => '{{WRAPPER}} .elementor-headline-dynamic-text',
                'exclude'  => ['font_size'],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Stroke::get_type(),
            [
                'name' => 'text_stroke',
                'selector' => '{{WRAPPER}} .elementor-headline-dynamic-text',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $tag      = Utils::validate_html_tag($settings['tag']);
        $this->add_render_attribute('headline', 'class', 'elementor-headline');
        if (!empty($settings['link']['url'])) {
            $this->add_link_attributes('url', $settings['link']);
            ?>
            <a <?php $this->print_render_attribute_string('url'); ?>>

            <?php
        }
        ?>
        <<?php Utils::print_validated_html_tag($tag); ?>  <?php $this->print_render_attribute_string('headline'); ?>>
        <?php if (!empty($settings['before_text'])) : ?>
            <span class="elementor-headline-plain-text elementor-headline-text-wrapper"><?php $this->print_unescaped_setting('before_text'); ?></span>
        <?php endif; ?>
        <span class="elementor-headline-dynamic-wrapper elementor-headline-text-wrapper">
        <?php if (!empty($settings['highlighted_text'])) : ?>
            <span class="elementor-headline-dynamic-text elementor-headline-text-active"><span><?php $this->print_unescaped_setting('highlighted_text'); ?></span></span>
        <?php endif ?>
		</span>
        <?php if (!empty($settings['after_text'])) : ?>
            <span class="elementor-headline-plain-text elementor-headline-text-wrapper"><?php $this->print_unescaped_setting('after_text'); ?></span>
        <?php endif; ?>
        </<?php Utils::print_validated_html_tag($tag); ?>>
        <?php

        if (!empty($settings['link']['url'])) {
            echo '</a>';
        }
    }

}

$widgets_manager->register(new Nutreko_Elementor_Widget_Heading());