(function ($) {
    'use strict';
    var $nutreko_apply = $('#nutreko_apply');
    nutreko_terms_select();
    nutreko_conditional_init();
    nutreko_conditional_select();
    nutreko_labels_select();

    $('.color-picker').wpColorPicker();

    $nutreko_apply.on('change', function() {
        var apply = $(this).val();
        var $terms = $('#nutreko_terms');

        $('#nutreko_configuration_combination').hide();
        $('#nutreko_configuration_terms').hide();

        if (apply === '' || apply === 'none' || apply === 'all' || apply ===
            'sale' || apply === 'featured' || apply === 'bestselling' || apply ===
            'instock' || apply === 'outofstock' || apply === 'backorder') {
            return;
        }

        if (apply === 'combination') {
            $('#nutreko_configuration_combination').show();
            return;
        }

        $('#nutreko_configuration_terms').show();

        if ((typeof $terms.data(apply) === 'string' || $terms.data(apply) instanceof
            String) && $terms.data(apply) !== '') {
            $terms.val($terms.data(apply).split(',')).change();
        } else {
            $terms.val([]).change();
        }

        nutreko_terms_select();
    });

    function nutreko_terms_select() {
        var apply = $nutreko_apply.val();
        var label = $nutreko_apply.find(':selected').text().trim();

        $('#nutreko_configuration_terms_label').html(label);

        $('#nutreko_terms').selectWoo({
            ajax: {
                url: ajaxurl, dataType: 'json', delay: 250, data: function(params) {
                    return {
                        q: params.term,
                        action: 'nutreko_search_term',
                        nonce: nutreko_vars.nonce,
                        taxonomy: apply,
                    };
                }, processResults: function(data) {
                    var options = [];
                    if (data) {
                        $.each(data, function(index, text) {
                            options.push({id: text[0], text: text[1]});
                        });
                    }
                    return {
                        results: options,
                    };
                }, cache: true,
            }, minimumInputLength: 1,
        });
    }

    $(document).on('click touch', '.nutreko_add_conditional', function(e) {
        e.preventDefault();

        var $this = $(this);

        $this.addClass('disabled');

        var data = {
            action: 'nutreko_add_conditional', nonce: nutreko_vars.nonce,
        };

        $.post(ajaxurl, data, function(response) {
            $('.nutreko_conditionals').append(response);
            nutreko_conditional_init();
            $this.removeClass('disabled');
        });
    });

    function nutreko_conditional_init() {
        $('.nutreko_conditional_apply').each(function() {
            var $this = $(this);
            var $value = $this.closest('.nutreko_conditional').
            find('.nutreko_conditional_value');
            var $select_wrap = $this.closest('.nutreko_conditional').
            find('.nutreko_conditional_select_wrap');
            var $select = $this.closest('.nutreko_conditional').
            find('.nutreko_conditional_select');
            var $compare = $this.closest('.nutreko_conditional').
            find('.nutreko_conditional_compare');
            var apply = $this.val();
            var compare = $compare.val();

            if (apply === 'sale' || apply === 'featured' || apply === 'bestselling' ||
                apply === 'instock' || apply === 'outofstock' || apply ===
                'backorder') {
                $compare.hide();
                $value.hide();
                $select_wrap.hide();
            } else {
                $compare.show();

                if (apply === 'price' || apply === 'rating' || apply === 'release') {
                    $select_wrap.hide();
                    $value.show();
                    $compare.find('.nutreko_conditional_compare_price option').
                    prop('disabled', false);
                    $compare.find('.nutreko_conditional_compare_terms option').
                    prop('disabled', true);

                    if (compare === 'is' || compare === 'is_not') {
                        $compare.val('equal').trigger('change');
                    }
                } else {
                    $select_wrap.show();
                    $value.hide();
                    $compare.find('.nutreko_conditional_compare_price option').
                    prop('disabled', true);
                    $compare.find('.nutreko_conditional_compare_terms option').
                    prop('disabled', false);

                    if (compare !== 'is' && compare !== 'is_not') {
                        $compare.val('is').trigger('change');
                    }
                }
            }

            if ($value.data(apply) !== '') {
                $value.val($value.data(apply));
            }

            if ((typeof $select.data(apply) === 'string' ||
                $select.data(apply) instanceof String) && $select.data(apply) !==
                '') {
                $select.val($select.data(apply).split(',')).change();
            } else {
                $select.val([]).change();
            }
        });
    }

    function nutreko_conditional_select() {
        $('.nutreko_conditional_select').each(function() {
            var $this = $(this);
            var apply = $this.closest('.nutreko_conditional').
            find('.nutreko_conditional_apply').
            val();

            $this.selectWoo({
                ajax: {
                    url: ajaxurl, dataType: 'json', delay: 250, data: function(params) {
                        return {
                            action: 'nutreko_search_term',
                            nonce: nutreko_vars.nonce,
                            q: params.term,
                            taxonomy: apply,
                        };
                    }, processResults: function(data) {
                        var options = [];
                        if (data) {
                            $.each(data, function(index, text) {
                                options.push({id: text[0], text: text[1]});
                            });
                        }
                        return {
                            results: options,
                        };
                    }, cache: true,
                }, minimumInputLength: 1,
            });
        });
    }

    function nutreko_labels_select() {
        $('#nutreko_labels').selectWoo({
            ajax: {
                url: ajaxurl, dataType: 'json', delay: 250, data: function(params) {
                    return {
                        action: 'nutreko_search_labels',
                        nonce: nutreko_vars.nonce,
                        q: params.term,
                    };
                }, processResults: function(data) {
                    var options = [];
                    if (data) {
                        $.each(data, function(index, text) {
                            options.push({id: text[0], text: text[1]});
                        });
                    }
                    return {
                        results: options,
                    };
                }, cache: true,
            }, minimumInputLength: 1, select: function(e) {
                var element = e.params.data.element;
                var $element = $(element);

                $(this).append($element);
                $(this).trigger('change');
            },
        });
    }

    $(document).on('change', '.nutreko_conditional_apply', function() {
        nutreko_conditional_init();
        nutreko_conditional_select();
    });

    $(document).on('click touch', '.nutreko_conditional_remove', function(e) {
        e.preventDefault();

        $(this).closest('.nutreko_conditional').remove();
    });

})(jQuery);