<?php
/**
 * Nutreko WooCommerce Gallery Video Class
 *
 * @package  nutreko
 * @since    1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Nutreko_WooCommerce_Video')) :

    /**
     * The Nutreko WooCommerce Gallery Video Class
     */
    class Nutreko_WooCommerce_Video {

        public function __construct() {
            add_filter('woocommerce_product_data_tabs', array($this, 'video_product_tabs'));
            add_filter('woocommerce_product_data_panels', array(
                $this,
                'video_options_product_tab_content'
            ));
            add_action('woocommerce_process_product_meta', array($this, 'save_video_option_fields'));
            add_action('woocommerce_product_thumbnails', array($this, 'template_single_product_video'), 30);
            add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
        }

        public function enqueue_scripts($hook) {
            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            if ($hook === 'post.php' && get_post_type() === 'product') {
                $opal_l10n['choose_featured_img'] = esc_html__('Upload video thumbnail', 'nutreko');
                $opal_l10n['choose_file']         = esc_html__('Choose a file', 'nutreko');
                $opal_l10n['ajaxurl']             = admin_url('admin-ajax.php');
                wp_enqueue_script('nutreko-woocommerce-admin', get_template_directory_uri() . '/assets/js/woocommerce/admin' . $suffix . '.js', array('jquery'), NUTREKO_VERSION, true);
                wp_localize_script('nutreko-woocommerce-admin', 'nutreko_media', $opal_l10n);
                wp_enqueue_style('nutreko-woocommerce-admin', get_template_directory_uri() . '/assets/css/admin/woocommerce/style.css', array(), NUTREKO_VERSION);
            }
        }

        public function video_product_tabs($tabs) {

            $tabs['video'] = array(
                'label'    => __('Product Video', 'nutreko'),
                'target'   => 'video_options',
                'class'    => array(),
                'priority' => 80,
            );

            return $tabs;

        }

        public function video_options_product_tab_content() {

            ?>
            <div id='video_options' class='panel woocommerce_options_panel'><?php

                ?>
                <div class='options_group'><?php

                    woocommerce_wp_text_input(array(
                        'id'    => '_video_select',
                        'label' => __('Url Video', 'nutreko'),
                    ));

                    $video_thumbnail_id = get_post_meta($_GET['post'], '_video_thumbnail', true);
                    $alt                = '';

                    if ($video_thumbnail_id) {
                        $video_thumbnail = wp_get_attachment_image_url($video_thumbnail_id, 'thumbnail');
                        $alt             = wp_get_attachment_caption($video_thumbnail_id);
                    } else {
                        $video_thumbnail = wc_placeholder_img_src();
                    }
                    ?>
                    <p class="form-field _video_thumbnail_field ">
                        <label for="_video_thumbnail"><?php echo esc_html__('Video Thumbnail', 'nutreko'); ?></label>
                        <a href="#" class="video_thumbnail_button"><img height="100" width="100" src="<?php echo esc_attr($video_thumbnail); ?>" alt="<?php echo esc_attr($alt); ?>"></a>
                        <input type="hidden" id="_video_thumbnail" name="_video_thumbnail" class="video_thumbnail" value="<?php echo esc_attr($video_thumbnail_id); ?>">
                    </p>
                </div>

            </div>
            <?php

        }

        public function save_video_option_fields($post_id) {
            if (isset($_POST['_video_select'])) {
                update_post_meta($post_id, '_video_select', esc_attr($_POST['_video_select']));
            }
            if (isset($_POST['_video_thumbnail'])) {
                update_post_meta($post_id, '_video_thumbnail', esc_attr($_POST['_video_thumbnail']));
            }
        }

        public function template_single_product_video() {
            global $product;
            $video = get_post_meta($product->get_id(), '_video_select', true);
            if (!$video) {
                return;
            }
            $video_thumbnail = get_post_meta($product->get_id(), '_video_thumbnail', true);
            if ($video_thumbnail) {
                $video_thumbnail = wp_get_attachment_image_url($video_thumbnail, 'thumbnail');
            } else {
                $video_thumbnail = wc_placeholder_img_src();
            }
            $video                = wc_do_oembeds($video);
            $product_single_style = nutreko_get_theme_option('single_product_gallery_layout', 'horizontal');
            if ($product_single_style === 'sticky') {
                echo '<div class="swiper-slide">';
            }
            echo '<div data-thumb="' . esc_url_raw($video_thumbnail) . '" class="woocommerce-product-gallery__image"><a>' . $video . '</a></div>';
            if ($product_single_style === 'sticky') {
                echo '</div>';
            }
        }
    }

    return new Nutreko_WooCommerce_Video();

endif;
