<?php

defined('ABSPATH') || exit;

global $product;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
    return;
}
$class = wc_get_loop_prop('product-carousel') == 'swiper-wrapper' ? 'swiper-slide product-style-default' : 'product-style-default';
?>
<li <?php wc_product_class($class, $product); ?>>
    <div class="product-block-list product-block-list-1">
        <div class="left">
            <a href="<?php echo esc_url($product->get_permalink()); ?>">
                <?php echo wp_kses_post($product->get_image()); ?>
            </a>
        </div>
        <div class="right">
            <div class="right-inner">
                <?php woocommerce_template_loop_product_title(); ?>
                <?php nutreko_woocommerce_get_product_category(); ?>
            </div>
            <?php woocommerce_template_loop_price(); ?>
        </div>
    </div>
</li>
