<?php
/**
 * The template for displaying social-meta
 *
 */

$enable_social_meta = G5Plus_Auteur()->options()->get_social_meta_enable();
if ((!is_singular() && !is_tax('product_author'))  || class_exists('WPSEO_Admin') || ($enable_social_meta !== 'on')) {
	return;
}
$site_name         = get_bloginfo( 'name' );
$twitter_author    = G5Plus_Auteur()->options()->get_twitter_author_username();
$googleplus_author = G5Plus_Auteur()->options()->get_googleplus_author();
$image_url = '';
$title = '';
$permalink = '';
$excerpt = '';
if (is_singular()) {
	$title             = strip_tags( get_the_title() );
	$permalink         = get_permalink();
	$excerpt           = get_the_excerpt();
	if ( has_post_thumbnail( get_the_ID() ) ) {
		$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
		if (isset($thumbnail[0]) ) {
			$image_url = $thumbnail[0];
		}
	}

} else {
	$obj_id = get_queried_object_id();
	$term = get_term($obj_id);
	$permalink = get_term_link( $obj_id );
	$title = $term->name;
	$excerpt = $term->description;
	$img = G5Plus_Auteur()->termMeta()->get_product_author_thumb($obj_id);
	$img_id = isset($img['id']) && !empty($img['id']) ? $img['id'] : '';
	if ($img_id) {
		$thumbnail = wp_get_attachment_image_src($img_id, 'full' );
		if (isset($thumbnail[0]) ) {
			$image_url = $thumbnail[0];
		}
	}
}


if ($image_url === '') {
	$logo = G5Plus_Auteur()->options()->get_logo();
	if ( isset( $logo['url'] ) && !empty($logo['url'])) {
		$image_url = $logo['url'];
	}
}


?>
	<!-- Facebook Meta -->
	<meta property="og:title" content="<?php echo esc_attr($title); ?> - <?php echo esc_attr($site_name); ?>"/>
	<meta property="og:type" content="article"/>
	<meta property="og:url" content="<?php echo esc_url($permalink); ?>"/>
	<meta property="og:site_name" content="<?php echo esc_attr($site_name); ?>"/>
	<meta property="og:description" content="<?php echo esc_attr($excerpt);?>">
<?php if (!empty($image_url)) : ?>
	<meta property="og:image" content="<?php echo esc_url($image_url); ?>"/>
<?php endif; ?>



	<!-- Twitter Card data -->
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:title" content="<?php echo esc_attr($title); ?>">
	<meta name="twitter:description" content="<?php echo esc_attr($excerpt); ?>">
<?php if(!empty($twitter_author)) : ?>
	<meta name="twitter:site" content="@<?php echo esc_attr($twitter_author); ?>">
	<meta name="twitter:creator" content="@<?php echo esc_attr($twitter_author); ?>">
<?php endif; ?>

<?php if (!empty($image_url)) : ?>
	<meta property="twitter:image:src" content="<?php echo esc_url($image_url); ?>"/>
<?php endif; ?>

<?php if ( function_exists( 'is_product' ) && is_product() ) : ?>
	<?php $product = new WC_Product( get_the_ID() ); ?>
	<?php if (is_object($product)): ?>
		<meta property="og:price:amount" content="<?php echo esc_attr($product->price);?>" />
		<meta property="og:price:currency" content="<?php echo esc_attr(get_woocommerce_currency()); ?>" />
		<meta name="twitter:data1" content="<?php echo esc_attr($product->price); ?>">
		<meta name="twitter:label1" content="Price">
	<?php endif; ?>
<?php endif; ?>

	<!-- Google Authorship and Publisher Markup -->
<?php if (!empty($googleplus_author)) : ?>
	<link rel="author" href="https://plus.google.com/<?php echo esc_attr($googleplus_author); ?>/posts"/>
	<link rel="publisher" href="https://plus.google.com/<?php echo esc_attr($googleplus_author); ?>"/>
<?php endif; ?>