<?php
if ( ! function_exists( 'thim_get_all_plugins_require' ) ) {
	function thim_get_all_plugins_require( $plugins ) {

		$plugins = array(
			array(
				'name'     => 'LearnPress',
				'slug'     => 'learnpress',
				'required' => true,
				'icon'     => 'https://ps.w.org/learnpress/assets/icon-128x128.gif',
			),
			array(
				'name'     => 'Thim Course Builder',
				'slug'     => 'thim-course-builder',
				'premium'  => true,
				'required' => true,
				'icon'     => 'https://updates.thimpress.com/images/default.svg',
			),

			array(
				'name'     => 'Certificates Add-On for LearnPress',
				'slug'     => 'learnpress-certificates',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'       => 'Paid Memberships Pro',
				'slug'       => 'paid-memberships-pro',
				'required'   => false,
				'no-install' => true,
				'premium'    => true,
				'source'     => 'https://license.paidmembershipspro.com/downloads/free/paid-memberships-pro.zip',
			),
			array(
				'name'     => 'Collections Add-On for LearnPress',
				'slug'     => 'learnpress-collections',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'     => 'Paid Memberships Pro Add-On for LearnPress',
				'slug'     => 'learnpress-paid-membership-pro',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Co-Instructors Add-On for LearnPress',
				'slug'     => 'learnpress-co-instructor',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'LearnPress – Course Review',
				'slug'     => 'learnpress-course-review',
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'     => 'WooCommerce Add-On for LearnPress',
				'slug'     => 'learnpress-woo-payment',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'     => 'Authorize.Net Add-On for LearnPress',
				'slug'     => 'learnpress-authorizenet-payment',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Coming Soon Add-On for LearnPress',
				'slug'     => 'learnpress-coming-soon-courses',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Commission Add-On for LearnPress',
				'slug'     => 'learnpress-commission',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Content Drip Add-On for LearnPress',
				'slug'     => 'learnpress-content-drip',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Gradebook Add-On for LearnPress',
				'slug'     => 'learnpress-gradebook',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'myCRED Add-On for LearnPress',
				'slug'     => 'learnpress-mycred',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Random Quiz Add-On for LearnPress',
				'slug'     => 'learnpress-random-quiz',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Stripe Add-On for LearnPress',
				'slug'     => 'learnpress-stripe',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Sorting Choice Add-On for LearnPress',
				'slug'     => 'learnpress-sorting-choice',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'Student List Add-On for LearnPress',
				'slug'     => 'learnpress-students-list',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'LearnPress – Course Wishlist',
				'slug'     => 'learnpress-wishlist',
				'required' => false,
				'add-on'   => true,
			),

			array(
				'name'     => 'LearnPress – bbPress Integration',
				'slug'     => 'learnpress-bbpress',
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'     => 'LearnPress – BuddyPress Integration',
				'slug'     => 'learnpress-buddypress',
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'     => '2Checkout Add-On for LearnPress',
				'slug'     => 'learnpress-2checkout-payment',
				'premium'  => true,
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'     => 'LearnPress – Prerequisites Courses',
				'slug'     => 'learnpress-prerequisites-courses',
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'     => 'LearnPress – Export Import',
				'slug'     => 'learnpress-import-export',
				'required' => false,
				'add-on'   => true,
			),
			array(
				'name'        => 'WP Events Manager - WooCommerce Payment ',
				'slug'        => 'wp-events-manager-woo-payment',
				'premium'     => true,
				'required'    => false,
				'description' => 'Support paying for a booking with the payment methods provided by Woocommerce',
				'add-on'      => true,
			),
			array(
				'name'       => 'WPBakery Visual Composer',
				'slug'       => 'js_composer',
				'premium'    => true,
				'no-install' => true,
				'icon'       => 'https://s3.envato.com/files/260579516/wpb-logo.png',
				'required'   => false,
			),
			array(
				'name'        => 'Elementor Page Builder',
				'slug'        => 'elementor',
				'required'    => false,
				'no-install'  => true,
				'description' => 'The most advanced frontend drag & drop page builder. Create high-end, pixel perfect websites at record speeds. Any theme, any page, any design.',
				'icon'        => 'https://ps.w.org/elementor/assets/icon-128x128.gif',
			),
			array(
				'name'       => 'Thim Elementor Kit',
				'slug'       => 'thim-elementor-kit',
				// 'premium'     => true,
				'no-install' => true,
				'required'   => false,
			),

			array(
				'name'        => 'WooCommerce',
				'slug'        => 'woocommerce',
				'required'    => false,
				'description' => 'An eCommerce toolkit that helps you sell anything. Beautifully.',
				'icon'        => 'https://ps.w.org/woocommerce/assets/icon.svg',
			),
			array(
				'name'     => 'Contact Form 7',
				'slug'     => 'contact-form-7',
				'required' => false,
			),
			array(
				'name'     => 'WP Events Manager',
				'slug'     => 'wp-events-manager',
				'required' => false,
			),

			array(
				'name'       => 'WordPress Social Login and Register',
				'slug'       => 'miniorange-login-openid',
				'required'   => false,
				'no-install' => true,
				'icon'       => 'https://ps.w.org/miniorange-login-openid/assets/icon-128x128.gif',
			),
			array(
				'name'       => 'HubSpot – CRM, Email Marketing, Live Chat, Forms & Analytics',
				'slug'       => 'leadin',
				'required'   => false,
				'no-install' => true,
			),
			array(
				'name'       => 'MailChimp for WordPress',
				'slug'       => 'mailchimp-for-wp',
				'required'   => false,
				'no-install' => true,
			),

			array(
				'name'        => 'bbPress',
				'slug'        => 'bbpress',
				'required'    => false,
				'no-install'  => true,
				'description' => 'bbPress is forum software with a twist from the creators of WordPress. By The bbPress Community.',
			),

			array(
				'name'        => 'Thim Portfolio',
				'slug'        => 'tp-portfolio',
				'premium'     => true,
				'no-install'  => true,
				'required'    => false,
				'version'     => '1.6',
				'description' => 'A plugin that allows you to show off your portfolio. By ThimPress.',
			),

			array(
				'name'       => 'Slider Revolution',
				'slug'       => 'revslider',
				'premium'    => true,
				'no-install' => true,
			),
		);

		return $plugins;
	}
}

add_filter( 'thim_core_get_all_plugins_require', 'thim_get_all_plugins_require' );

add_filter( 'thim_core_plugin_icon_install', 'thim_custom_plugin_icon', 10, 2 );
if ( ! function_exists( 'thim_custom_plugin_icon' ) ) {
	function thim_custom_plugin_icon( $icon, $plugin ) {
		if ( $plugin->get_slug() == 'thim-course-builder' ) {
			return $icon;
		}
		if ( ! $plugin->is_wporg() ) {
			$icon = 'https://updates.thimpress.com/images/' . $plugin->get_slug() . '.png?v=1';
		}

		return $icon;
	}
}

function thim_envato_item_id() {
	return '20370918';
}

add_filter( 'thim_envato_item_id', 'thim_envato_item_id' );
