<?php

/**
 * Class Thim_LP_Filter_Layout
 *
 * @since   from LP v4.2.6.2
 * @version 1.0.0
 */

use LearnPress\Helpers\Template;
use LearnPress\TemplateHooks\Course\SingleCourseTemplate;
use LearnPress\TemplateHooks\Instructor\SingleInstructorTemplate;

class Thim_LP_Filter_Layout {
	public function __construct() {
		add_filter( 'template_include', array( $this, 'check_to_load_override_files' ), 11 );
		//      remove_all_actions( 'learn-press/template-footer' );
		add_filter( 'lp/show-archive-course/title', '__return_false' );
		add_filter( 'learn-press/layout/list-courses/section/top', array( $this, 'thim_course_layout_archive_section_top' ), 10, 3 );
		add_filter( 'learn-press/layout/list-courses/item-li', array( $this, 'thim_html_course_wrapper' ), 10, 3 );
		add_filter( 'learn-press/layout/list-courses/item/section-top', array( $this, 'course_item_section_top' ), 10, 3 );
		add_filter( 'learn-press/layout/list-courses/item/section/bottom', array( $this, 'course_item_section_bottom' ), 11, 3 );
		add_filter( 'learn-press/layout/list-courses/item/section/bottom/end', array( $this, 'course_item_section_bottom_end' ), 10, 3 );

		// Layout collection
		add_filter( 'learn-press/layout/list-collections/section', array( $this, 'lp_list_collection_layout' ), 10, 3 );

		add_filter(
			'learn-press/single-collection/layout/section',
			function ( $sections ) {
				$sections['wrap'] = '<div class="lp-single-collection">' . $this->top_heading_collection();

				return $sections;
			},
			10,
			2
		);
		add_filter(
			'learn-press/single-collection-learning/layout/section',
			function ( $sections ) {
				$sections['container'] = '<div class="lp-collection-learning">' . $this->top_heading_collection();

				return $sections;
			},
			10,
			2
		);
	}

	function check_to_load_override_files( $template ) {
		if ( version_compare( LEARNPRESS_VERSION, '4.2.6', '>=' ) ) {
			$files_no_override = [
				'content-course.php',
				'archive-course.php',
			];
			foreach ( $files_no_override as $file ) {
				$regex = '#.*./learnpress-v4/' . $file . '#';
				preg_match( $regex, $template, $matches );
				if ( ! empty( $matches ) && ! check_learnpress_child_theme_overrides( $file ) ) {
					$template = LP_PLUGIN_PATH . "templates/{$file}";
				}
			}
		}

		return $template;
	}

	function thim_course_layout_archive_section_top( $sections, $course, $settings ) {
		$new_sections = [
			'wrapper'                   => $sections['wrapper'],
			'switch_layout'             => $sections['switch_layout'],
			'order_by'                  => $sections['order_by'],
			'search'                    => $sections['search'],
			'btn_filter_courses_mobile' => $sections['btn_filter_courses_mobile'],
			'wrapper_end'               => $sections['wrapper_end'],
		];
		if ( ! get_theme_mod( 'learnpress_display_course_sort', true ) ) {
			unset( $new_sections['order_by'] );
		}

		return $new_sections;
	}

	function thim_html_course_wrapper( $sections, $course, $settings ) {
		$column_product = get_theme_mod( 'learnpress_cate_grid_column', 3 );

		if ( get_theme_mod( 'lp_course_archive_list_style', 'style_1' ) == 'style_2' ) {
			$classes[] = 'style_2';
		}

		$classes[]              = 'col-' . $column_product;
		$sections['wrapper_li'] = '<li class="course ' . esc_attr( implode( ' ', get_post_class( $classes ) ) ) . '">';

		if ( get_query_var( 'post_type' ) == 'lp_collection' ) {
			$sections['wrapper_li'] = '<li class="course">';
		}
		$sections['wrapper_div'] = sprintf( '<div class="course-item content" data-id="%s">', esc_attr( $course->get_id() ) );

		return $sections;
	}

	public function course_item_section_top( $sections, $course, $settings ) {
		$section['wrapper'] = '<div class="course-wrap-thumbnail"><div class="course-thumbnail thumbnail">';
		if ( $course->has_sale_price() ) {
			$section['text_sale'] = '<span class="sale"><span class="text-sale">' . esc_html__( 'Sale', 'course-builder' ) . '</span></span>';
		}
		$section['img'] = $sections['img'];
		if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) && learn_press_is_coming_soon( $course->get_id() ) ) {
			$section['price'] = '<span class="status price">' . esc_html__( 'Coming Soon', 'course-builder' ) . '</span>';
		} else {

			$section['price'] = '<span class="price">' . SingleCourseTemplate::instance()->html_price( $course ) . '</span>';

			ob_start();
			thim_course_wishlist_button( $course->get_id() );
			$wishlist_html       = ob_get_clean();
			$section['wishlist'] = $wishlist_html;
		}

		$section['wrapper_end'] = '</div></div>';

		return $section;
	}

	public function course_item_section_bottom( $sections, $course, $settings ) {
		$section['wrapper'] = '<div class="course-content sub-content">';
		unset( $sections['review'] );

		$section['review'] = $this->add_html_rating_course_item( $course );

		$section['title']   = $sections['title'];

		if ( get_theme_mod( 'lp_course_archive_list_style', 'style_1' ) == 'style_1' ) {
			$html_meta_data = thim_course_comment_info( $course );
		} else {
			ob_start();
			thim_course_review_info( $course->get_id() );
 			$html_meta_data = ob_get_clean();
			$html_meta_data .= SingleCourseTemplate::instance()->html_count_student( $course );
		}

		$section['meta']        = sprintf( '<div class="course-wrap-meta">%s</div>', $html_meta_data );
		$section['description'] = SingleCourseTemplate::instance()->html_short_description( $course );
		$section['info']        = $sections['info'];
		$section['wrapper_end'] = $sections['wrapper_end'];

		return $section;
	}

	public function course_item_section_bottom_end( $sections, $course, $settings ) {
		$section['short_des'] = '<div class="course-description">' . wpautop( get_the_excerpt( $course->get_id() ) ) . '</div>';
		$section['wrapper']   = '<div class="course-info group-author-btn ' . get_theme_mod( 'lp_course_archive_list_style', 'style_1' ) . '">';

		$instructor = $course->get_author_model();
		if ( $instructor ) {
			$section['instructor'] = sprintf(
				'<div class="course-author">
							<span class="avatar"><a href="%s">%s</a></span>
							<span class="info">
								<span class="major label">%s</span>
								<a href="%s" class="name">%s</a>
							</span>
						</div>',
				esc_url( $instructor->get_url_instructor() ),
				SingleInstructorTemplate::instance()->html_avatar(
					$instructor,
					[
						'width'  => 50,
						'height' => 50,
					]
				),
				esc_html__( 'Teacher', 'course-builder' ),
				esc_url( $instructor->get_url_instructor() ),
				SingleInstructorTemplate::instance()->html_display_name( $instructor ),
			);
		}

		if ( get_theme_mod( 'lp_course_archive_list_style', 'style_1' ) == 'style_2' ) {
			$section['btn_read_more'] = sprintf(
				'<a class="btn-course-view-detail" href="%s">%s</a>',
				$course->get_permalink(),
				esc_html__( 'View Detail', 'course-builder' ),
			);
		} else {
			if ( class_exists( 'LP_Addon_Course_Review' ) && class_exists( 'LearnPress\CourseReview\TemplateHooks\CourseRatingTemplate' ) ) {
				$course_rated      = learn_press_get_course_rate( $course->get_id() );
				$section['review'] = sprintf(
					'<div class="course-reviews">
							<span class="label">%s</span>
							%s
						</div>',
					__( 'Review:', 'course-builder' ),
					LearnPress\CourseReview\TemplateHooks\CourseRatingTemplate::instance()->html_rated_star( $course_rated )
				);
			}
			$section['student'] = sprintf(
				'<div class="course-student">
							<span class="label">%s</span>
							 %s
						</div>',
				__( 'Students:', 'course-builder' ),
				$course->count_students()
			);
		}

		$section['wrapper_end'] = $sections['wrapper_end'];

		return $section;
	}

	function add_html_rating_course_item( $course ) {
		$course_id = $course->get_id();
		if ( ! class_exists( 'LP_Addon_Course_Review' ) ) {
			return;
		}
		$top_wrapper = [
			'<div class="course-rating-list">' => '</div>',
		];
		ob_start();
		thimpress_html_course_item_average_rating( $course_id );
		$content     = ob_get_clean();
		$html_bottom = Template::instance()->nest_elements( $top_wrapper, $content );

		return $html_bottom;
	}

	public function lp_list_collection_layout( $sections ) {
		ob_start();
		do_action( 'thim_wrapper_loop_start' );
		$sections['container'] = ob_get_clean();
		unset( $sections['title'] );
		ob_start();
		do_action( 'thim_wrapper_loop_end' );
		$sections['container_end'] = ob_get_clean();

		return $sections;
	}

	public function top_heading_collection() {
		$cate_top_image = get_theme_mod( 'page_title_collections_archive_background_image', THIM_URI . 'assets/images/page-title/bg.jpg' );
		if ( is_numeric( $cate_top_image ) ) {
			$cate_top_attachment = wp_get_attachment_image_src( $cate_top_image, 'full' );
			$cate_top_image_src  = $cate_top_attachment[0];
		} else {
			$cate_top_image_src = $cate_top_image;
		}
		$main_css = $cate_top_image_src ? ' style="background-image:url(' . $cate_top_image_src . ')"' : '';

		$html_top_heading = '<div class="page-title height-unset"><div class="main-top" ' . $main_css . '></div></div>';

		return $html_top_heading;
	}
}

new Thim_LP_Filter_Layout();
