<?php

/**
 * Widget Logic Integration for Theme (Classic Widgets)
 *
 * Integrates Widget Logic functionality into the theme for Classic Widgets,
 * allowing conditional display using PHP expressions.
 *
 * Security Note: Uses eval(), restrict to trusted users (administrators) only.
 *
 * @package course-builder
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Constants
const WIDGET_LOGIC_FIELD = 'widget_logic';

// Add widget logic field to Classic Widget form
add_action( 'in_widget_form', 'thim_widget_logic_field', 10, 3 );
function thim_widget_logic_field( $widget, $return, $instance ) {
	$logic      = isset( $instance[ WIDGET_LOGIC_FIELD ] ) ? $instance[ WIDGET_LOGIC_FIELD ] : '';
	$field_id   = esc_attr( $widget->get_field_id( WIDGET_LOGIC_FIELD ) );
	$field_name = esc_attr( $widget->get_field_name( WIDGET_LOGIC_FIELD ) );
	?>
	<p>
		<label for="<?php echo $field_id; ?>">
			<?php esc_html_e( 'Widget Logic:', 'course-builder' ); ?>
		</label>
		<input
			type="text"
			name="<?php echo $field_name; ?>"
			id="<?php echo $field_id; ?>"
			value="<?php echo esc_attr( $logic ); ?>"
			class="widefat"/>
		<small class="description">
			<?php esc_html_e( 'Enter PHP condition (e.g., is_home() || is_front_page()). Widget shows if true.', 'course-builder' ); ?>
		</small>
	</p>
	<?php
}

// Save widget logic field
add_filter( 'widget_update_callback', 'thim_widget_logic_save', 10, 4 );
function thim_widget_logic_save( $instance, $new_instance, $old_instance, $widget ) {
	$instance[ WIDGET_LOGIC_FIELD ] = isset( $new_instance[ WIDGET_LOGIC_FIELD ] )
		? sanitize_text_field( $new_instance[ WIDGET_LOGIC_FIELD ] )
		: '';

	return $instance;
}

// Control widget display based on logic
add_filter( 'widget_display_callback', 'thim_widget_logic_display', 10, 3 );
function thim_widget_logic_display( $instance, $widget, $args ) {
	if ( empty( $instance[ WIDGET_LOGIC_FIELD ] ) ) {
		return $instance;
	}

	$logic = trim( $instance[ WIDGET_LOGIC_FIELD ] );

	// Basic validation before eval
	if ( ! thim_is_valid_logic_expression( $logic ) ) {
		error_log( 'Widget Logic: Invalid expression detected - ' . $logic );

		return false;
	}

	try {
		// Use a closure to sandbox the evaluation
		$eval_func = function () use ( $logic ) {
			return eval( 'return (' . $logic . ');' );
		};

		$result = $eval_func();

		return $result === false ? false : $instance;
	} catch ( Throwable $e ) {
		error_log( 'Widget Logic error: ' . $e->getMessage() . ' in expression: ' . $logic );

		return false;
	}
}

// Validate logic expression
function thim_is_valid_logic_expression( $logic ) {
	// Prevent dangerous functions and patterns
	$forbidden = [
		'eval\(',
		'exec\(',
		'system\(',
		'passthru\(',
		'shell_exec\(',
		'`\s', // backticks
		'phpinfo\(',
		'\$GLOBALS',
		'\$_SERVER',
		'\$_POST',
		'\$_GET',
	];

	foreach ( $forbidden as $pattern ) {
		if ( preg_match( "/$pattern/i", $logic ) ) {
			return false;
		}
	}

	// Basic syntax check
	return ! empty( $logic ) &&
		strlen( $logic ) < 1000 && // Arbitrary length limit
		preg_match( '/^[a-zA-Z0-9_\(\)\|\&!=\s]+$/i', $logic );
}
