<?php
// wishlist button
if ( ! function_exists( 'thim_course_wishlist_button' ) ) {
	function thim_course_wishlist_button( $course_id = null ) {
		if ( get_theme_mod( 'learnpress_icon_archive_display', 1 ) ) {
			$class_wishlist = '';
			$course_current = learn_press_get_course( $course_id );
			$user_current   = learn_press_get_current_user();
			if ( class_exists( 'LP_Addon_Wishlist' ) || $user_current->has_purchased_course( $course_current->get_id() ) ) {
				$class_wishlist = 'has-wishlist';
			}

			echo '<div class="button-when-logged ' . esc_attr( $class_wishlist ) . '">';
			if ( $user_current->has_purchased_course( $course_current->get_id() ) ) {
				echo '<span class="purchased icon ion-android-checkmark-circle" title="' . esc_html__( 'You have purchased this course', 'course-builder' ) . '"><ion-icon name="checkbox-outline"></ion-icon></span>';
			} elseif ( class_exists( 'LP_Addon_Wishlist' ) ) {
				LP_Addon_Wishlist::instance()->wishlist_button( $course_id );
			}
			echo '</div>';
		}
	}
}

/**
 * Get course, lesson, ... duration in hours
 *
 * @param $id
 *
 * @param $post_type
 *
 * @return string
 */

if ( ! function_exists( 'thim_duration_time_calculator' ) ) {
	function thim_duration_time_calculator( $id, $post_type = 'lp_course' ) {
		if ( $post_type == 'lp_course' || $post_type == 'lp_quiz' ) {
			$course_duration_meta = get_post_meta( $id, '_lp_duration', true );
			$course_duration_arr  = array_pad( explode( ' ', $course_duration_meta, 2 ), 2, 'minute' );

			list( $number, $time ) = $course_duration_arr;

			switch ( $time ) {
				case 'week':
					$course_duration_text = sprintf( _n( "%s week", "%s weeks", $number, 'course-builder' ), $number );
					break;
				case 'day':
					$course_duration_text = sprintf( _n( "%s day", "%s days", $number, 'course-builder' ), $number );
					break;
				case 'hour':
					$course_duration_text = sprintf( _n( "%s hour", "%s hours", $number, 'course-builder' ), $number );
					break;
				default:
					$course_duration_text = sprintf( _n( "%s minute", "%s minutes", $number, 'course-builder' ), $number );
			}

			return $course_duration_text;
		} else {
			$duration = get_post_meta( $id, '_lp_duration', true );

			if ( ! $duration ) {
				return '';
			}
			$duration = ( strtotime( $duration ) - time() ) / 60;
			$hour     = floor( $duration / 60 );

			if ( ! $duration ) {
				return '';
			}
			if ( $hour == 0 ) {
				$hour = '';
			} else {
				$hour = $hour . esc_html__( 'h', 'course-builder' ) . esc_html__( ':', 'course-builder' );
			}
			$minute = $duration % 60;
			$minute = $minute . esc_html__( 'm', 'course-builder' );

			return $hour . $minute;
		}
	}
}
// add format icon for item lession

add_action( 'learn-press/begin-section-loop-item', 'thim_add_format_icon' );
if ( ! function_exists( 'thim_add_format_icon' ) ) {
	function thim_add_format_icon( $item ) {
		$format = get_post_format( $item->get_id() );
		if ( get_post_type( $item->get_id() ) == 'lp_quiz' ) {
			echo '<span class="course-format-icon"><i class="fa fa-puzzle-piece"></i></span>';
		} elseif ( $format == 'video' ) {
			echo '<span class="course-format-icon"><i class="fa fa-play"></i></span>';
		} elseif ( $format == 'audio' ) {
			echo '<span class="course-format-icon"><i class="fa fa-music"></i></span>';
		} elseif ( $format == 'image' ) {
			echo '<span class="course-format-icon"><i class="fa fa-picture-o"></i></span>';
		} elseif ( $format == 'aside' ) {
			echo '<span class="course-format-icon"><i class="fa fa-file-archive"></i></span>';
		} elseif ( $format == 'quote' ) {
			echo '<span class="course-format-icon"><i class="fa fa-quote-left"></i></span>';
		} elseif ( $format == 'link' ) {
			echo '<span class="course-format-icon"><i class="fa fa-link"></i></span>';
		} else {
			echo '<span class="course-format-icon"><i class="fa fa-file-archive"></i></span>';
		}
	}
}

// Show Related Courses

function thim_get_related_courses( $limit ) {
	if ( ! $limit ) {
		$limit = 3;
	}
	$course_id = get_the_ID();

	$tag_ids = array();
	$tags    = get_the_terms( $course_id, 'course_tag' );

	if ( $tags ) {
		foreach ( $tags as $individual_tag ) {
			$tag_ids[] = $individual_tag->slug;
		}
	}

	$args = array(
		'posts_per_page'      => $limit,
		'paged'               => 1,
		'ignore_sticky_posts' => 1,
		'post__not_in'        => array( $course_id ),
		'post_type'           => 'lp_course'
	);

	if ( $tag_ids ) {
		$args['tax_query'] = array(
			array(
				'taxonomy' => 'course_tag',
				'field'    => 'slug',
				'terms'    => $tag_ids
			)
		);
	}
	$related = array();
	if ( $posts = new WP_Query( $args ) ) {
		global $post;
		while ( $posts->have_posts() ) {
			$posts->the_post();
			$related[] = $post;
		}
	}
	wp_reset_query();

	return $related;
}

if ( ! function_exists( 'thim_related_courses' ) ) {

	function thim_related_courses() {
		$related_courses = thim_get_related_courses( 6 );
		if ( $related_courses ) {
			?>
			<div class="thim-related-course">
				<h3 class="related-title"><?php esc_html_e( 'Related Courses', 'course-builder' ); ?></h3>

				<div class="courses-carousel archive-courses course-grid owl-carousel owl-theme" data-cols="3">
					<?php foreach ( $related_courses as $course_item ) : ?>
						<?php
						$classes     = "";
						$course      = LP_Course::get_course( $course_item->ID );
						$is_required = $course->is_required_enroll();
						$course_id   = $course_item->ID;
						if ( class_exists( 'LP_Addon_Course_Review' ) ) {
							$course_rate              = learn_press_get_course_rate( $course_id );
							$course_number_vote       = learn_press_get_course_rate_total( $course_id );
							$html_course_number_votes = $course_number_vote ? sprintf( _n( '(%1$s vote )', ' (%1$s votes)', $course_number_vote, 'course-builder' ), number_format_i18n( $course_number_vote ) ) : esc_html__( '(0 vote)', 'course-builder' );
						}

						$is_course_in_membership = (bool) get_post_meta( $course->get_id(), '_lp_pmpro_levels', false );

						if ( $is_course_in_membership ) {
							$classes = "in-membership";
						}
						$course_thumbnail_dimensions = get_option( 'learn_press_course_thumbnail_dimensions' );
						if ( isset( $course_thumbnail_dimensions['width'] ) && $course_thumbnail_dimensions['width'] ) {
							$width  = $course_thumbnail_dimensions['width'];
							$height = $course_thumbnail_dimensions['height'];
						} else {
							$width  = 320;
							$height = 355;
						}
						$thumbnail_size = $width . 'x' . $height;

						?>
						<div class="inner-course <?php echo esc_attr( $classes ) ?>">
							<?php do_action( 'learn_press_before_course_header' ); ?>

							<div class="wrapper-course-thumbnail">
								<?php if ( has_post_thumbnail( $course_id ) ) : ?>
									<a href="<?php the_permalink( $course_id ); ?>"
									   class="img_thumbnail"><?php thim_thumbnail( $course_id, $thumbnail_size, 'post', false ); ?></a>
								<?php endif; ?>
								<div class="course-price">
									<?php

									$origin_price = $course->get_origin_price_html();
									$sale_price   = $course->get_sale_price();
									$price        = $course->get_price();
									$price        = learn_press_format_price( $price, true );
									$sale_price   = isset( $sale_price ) ? $sale_price : '';
									?>
									<?php if ( $course->is_free() || ! $is_required ) { ?>
										<div class="value free-course" itemprop="price"
											 content="<?php esc_attr_e( 'Free', 'course-builder' ); ?>">
											<span class="free"><?php esc_html_e( 'Free', 'course-builder' ); ?></span>
										</div>
									<?php } else {

										if ( $sale_price != '' ) {
											echo '<span class="course-origin-price">' . learn_press_format_price( $sale_price, true ) . '</span>';
										}
										echo '<span class="price">' . esc_html( $price ) . '</span>';
									}
									?>
								</div>


							</div>
							<div class="item-list-center">
								<?php if ( isset( $course_rate ) ): ?>
									<div class="course-rating-list">
										<?php thimpress_html_course_item_average_rating( $course_id ); ?>
									</div>
								<?php endif; ?>
								<div class="course-title">
									<h2 class="title">
										<a href="<?php echo esc_url( get_the_permalink( $course_item->ID ) ); ?>"> <?php echo get_the_title( $course_item->ID ); ?></a>
									</h2>
								</div>
								<?php
								$count = $course->get_users_enrolled( 'append' ) ? $course->get_users_enrolled( 'append' ) : 0;
								?>
								<span class="date-comment">

									<span class="date"><?php echo get_the_date() . ' / '; ?></span>

									<span class="comment"><?php $comment = get_comments_number();
										if ( $comment == 0 ) {
											echo esc_html__( "No Comments", 'course-builder' );
										} else {
											echo sprintf( _n( '%d Comment', '%d Comments', $comment, 'course-builder' ), $comment );
										}
										?></span>
								</span>
								<?php
								$link = learn_press_user_profile_link( get_the_author_meta( 'ID' ) );
								echo sprintf(
									'<div class="group-author-btn"><div class="course-author">
											<span class="avatar"><a href="%s">%s</a></span>
											<span class="info">
												<span class="major">%s</span>
												<a href="%s" class="name">%s</a>
											</span>
										</div></div>',
									esc_url( $link ),
									get_avatar( get_the_author_meta( 'ID' ), 50 ),
									esc_html__( 'Teacher', 'course-builder' ),
									esc_url( $link ),
									get_the_author_meta( 'display_name', get_post_field( 'post_author', $course_id ) ),

								);
								?>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
			<?php
		}
	}
}

// add class in single course
function thim_learnpress_body_classes( $classes ) {

	if ( is_singular( 'lp_course' ) ) {
		$layouts = get_theme_mod( 'learnpress_single_course_style', 1 );
		$layouts = isset( $_GET['layout'] ) ? $_GET['layout'] : $layouts;

		$classes[] = 'thim-lp-layout-' . $layouts;
		$classes[] = 'lp-learning lp-landing';
	}

	if ( learn_press_is_profile() ) {
		$classes[] = 'lp-profile';
	}

	return $classes;
}

add_filter( 'body_class', 'thim_learnpress_body_classes' );


if ( ! function_exists( 'lp_course_price' ) ) {
	/**
	 * Display course price.
	 */
	function lp_course_price() {
		$user   = learn_press_get_current_user();
		$course = learn_press_get_course();

		if ( $user && $user->has_enrolled_course( $course->get_id() ) ) {
			return;
		}

		learn_press_get_template( 'single-course/price.php' );
	}
}
if ( ! function_exists( 'learn_press_course_button' ) ) {
	/**
	 * Display course retake button
	 */
	function learn_press_course_button() {
		learn_press_get_template( 'single-course/buttons.php' );
	}
}

// Check is landing page
if ( ! function_exists( 'thim_is_learning' ) ) {
	/**
	 * true if is learning page, false if is landing page.
	 * @return bool
	 */
	function thim_is_learning() {
		if ( learn_press_is_learning_course() ) {
			return true;
		} else {
			return false;
		}
	}
}

if ( ! function_exists( 'thim_course_tabs_content' ) ) {
	function thim_course_tabs_content( $defaults ) {
		$group_tab = get_theme_mod( 'group_tabs_course', array(
			'overview',
			'curriculum',
			'instructor',
			'announcements',
			'students-list',
			'package',
			'faqs',
			'review',
			'materials',
		) );
		foreach ( $defaults as $k => $v ) {
			$new_prioty = array_keys( $group_tab, $k );
			if ( $k == 'reviews' ) {
				$new_prioty = array_keys( $group_tab, 'review' );
				if ( $new_prioty ) {
					$defaults['reviews']['priority'] = $new_prioty[0];
				} else {
					unset( $defaults['reviews'] );
				}
			} else {
				if ( $new_prioty ) {
					$defaults[$k]['priority'] = $new_prioty[0];
				} else {
					unset( $defaults[$k] );
				}
			}
		}
		$tab = get_theme_mod( 'default_tab_course', 'curriculum' );
		$tab = str_replace( 'review', 'reviews', $tab );
		if ( isset( $defaults[$tab] ) ) {
			$defaults[$tab]['active'] = true;
		}

		return $defaults;
	}
}
add_filter( 'learn-press/course-tabs', 'thim_course_tabs_content', 9999 );
