<?php

/**
 * Template for displaying course content within the loop.
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$column_product = 4;

if ( get_query_var( 'post_type' ) == 'lp_collection' ) {
	$column_product = 12 / get_theme_mod( 'collection_single_columns', 3 );
}

if ( get_theme_mod( 'learnpress_cate_style', 'grid' ) == 'grid' ) {
	$column_product = 12 / get_theme_mod( 'learnpress_cate_grid_column', 3 );
}

if ( ! empty( $_REQUEST['cols'] ) ) {
	$column_product = 12 / $_REQUEST['cols'];
}
$classes[] = 'col-md-' . $column_product . ' col-12 col-sm-6 col-xs-6 lpr-course';


$course_thumbnail_dimensions = get_option( 'learn_press_course_thumbnail_dimensions' );
if ( isset( $course_thumbnail_dimensions['width'] ) ) {
	$width  = $course_thumbnail_dimensions['width'];
	$height = $course_thumbnail_dimensions['height'];
} else {
	$width  = 320;
	$height = 355;
}
$thumbnail_size = $width . 'x' . $height;

$course = learn_press_get_course();
if ( ! $course ) {
	return;
}

$course_id = $course->get_id();


$class_wishlist = '';

if ( class_exists( 'LP_Addon_Wishlist' ) ) {
	$class_wishlist = 'has-wishlist';
}

$is_course_in_membership = (bool) get_post_meta( $course->get_id(), '_lp_pmpro_levels', false );

if ( $is_course_in_membership ) {
	$classes[] = 'lp-membership';
}

$course_current = learn_press_get_course();
$user_current   = learn_press_get_current_user();

if ( $user_current->has_purchased_course( $course_current->get_id() ) ) {
	$classes[] = 'course-purchased';
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $classes ); ?>>

	<div class="content">

		<div class="thumbnail">
			<?php if ( $course->has_sale_price() ) { ?>
				<span class="sale">
					<span class="text-sale"><?php esc_html_e( 'Sale', 'course-builder' ); ?></span>
				</span>
			<?php } ?>

			<a href="<?php the_permalink(); ?>" class="img_thumbnail">
				<?php echo thim_get_thumbnail( $course_id, $thumbnail_size, 'post', false ); ?>
			</a>

			<?php

			if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) && learn_press_is_coming_soon( $course_id ) ) {
				echo '<span class="status price">' . esc_html__( 'Coming Soon', 'course-builder' ) . '</span>';
			} else {

				do_action( 'thim-lp-course-btn_add_to_cart' );

				echo '<span class="price">';
				learn_press_get_template( 'single-course/price.php' );
				echo '</span>';

				// thim_course_review_info( $course_id );

				thim_course_wishlist_button( $course_id );
			}
			?>

		</div>

		<div class="sub-content">
			<div class="course-rating-list">
				<?php thimpress_html_course_item_average_rating( $course_id ); ?>
			</div>
			<h3 class="title">
				<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			</h3>
			<?php
			if ( version_compare( LEARNPRESS_VERSION, '4.2.7.2', '>=' ) ) {
				$link = learn_press_user_profile_link( get_the_author_meta( 'ID' ) );
				echo sprintf(
					'<div class="group-author-btn"><div class="course-author">
					<span class="avatar"><a href="%s">%s</a></span>
					<span class="info">
						<span class="major">%s</span>
						<a href="%s" class="name">%s</a>
					</span>
				</div>',
					esc_url( $link ),
					get_avatar( get_the_author_meta( 'ID' ), 50 ),
					esc_html__( 'Teacher', 'course-builder' ),
					esc_url( $link ),
					get_the_author_meta( 'display_name', get_post_field( 'post_author', $course_id ) ),
				);
			} else {
				echo thim_course_comment_info( $course );
				?>
				<div class="content-list">
					<div class="course-description">
						<?php
						the_excerpt();
						?>
					</div>
					<?php thim_list_course_info( $course ); ?>
				</div>
				<?php
			}
			?>

		</div>
	</div>
</article>
