<?php
/**
 * Template for displaying course content within the loop.
 *
 * @author      ThimPress
 * @package     CourseBuilder/Templates
 * @version     4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

if ( post_password_required() ) {
	echo get_the_password_form();

	return;
}

$layouts = isset( $_GET['layout'] ) ? $_GET['layout'] : get_theme_mod( 'learnpress_single_course_style', 1 );
?>

<?php
/**
 * @since 4.0.0
 */

do_action( 'learn-press/before-single-course' );

?>

<div id="learn-press-course">
	<div class="course-summary">
		<?php
		learn_press_get_template( 'single-course/content-landing-' . $layouts . '.php' );
		?>
	</div>
</div>

<?php
/**
 * @since 3.0.0
 */

do_action( 'learn-press/after-single-course' );

?>
</div>

