<?php

/**
 * Template for displaying curriculum tab of single course.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/single-course/tabs/curriculum.php.
 *
 * @author  ThimPress
 * @package  Learnpress/Templates
 * @version  4.1.6
 */

use LearnPress\Helpers\Template;

defined('ABSPATH') || exit();

if (empty($args)) {
    return;
}

if (isset($args['sections']) && isset($args['filters'])) {
    $sections = $args['sections'];
    $filters = $args['filters'];
} else {
    return;
}

$curriculum_heading      = apply_filters('learn_press_curriculum_heading', esc_html__('Course Content', 'course-builder'));

?>
<?php
do_action('thim_learning_after_tabs_wrapper');
?>
<div class="course-curriculum" id="learn-press-course-curriculum">
    <div class="curriculum-heading">
        <?php if ($curriculum_heading) { ?>
            <div class="title">
                <h2 class="course-curriculum-title"><?php echo ($curriculum_heading); ?></h2>
            </div>
        <?php } ?>
        <div class="search">
            <form role="search" method="get" class="search-form" action="<?php echo home_url('/'); ?>">
                <input type="text" class="search-field"
                    placeholder="<?php echo esc_attr__('Search...', 'course-builder') ?>"
                    value="<?php echo get_search_query() ?>" name="s" />
                <input type="hidden" name="post_type" value="lp_lession">
                <button type="submit" class="search-submit"><span class="icon-ion-search1"></span></button>
            </form>
        </div>
    </div>

    <!-- Display Breadcrumb in sidebar course item popup -->
    <?php
    $course_id = $args['course_id'] ?? 0;
    $course = learn_press_get_course($course_id);

    if ($course) {
        $course_title = get_the_title($course_id);
        $course_permalink = get_permalink($course_id);
        $categories = get_the_terms($course_id, 'course_category');

        $breadcrumb_html = '<nav class="thim-font-heading learn-press-breadcrumb">';

        $all_course_page_id = LP_Settings::instance()->get_option('courses_page_id', false);
        if ($all_course_page_id) {
            $breadcrumb_html .= '<a href="' . esc_url(get_permalink($all_course_page_id)) . '">' . esc_html__('All Courses', 'course-builder') . '</a>';
        }

        if ($categories && ! is_wp_error($categories)) {
            $first_category = reset($categories);
            $breadcrumb_html .= ' <span class="delimiter">/</span> ';
            $breadcrumb_html .= '<a href="' . esc_url(get_term_link($first_category)) . '">' . esc_html($first_category->name) . '</a>';
        }

        $breadcrumb_html .= ' <span class="delimiter">/</span> ';
        $breadcrumb_html .= '<a href="' . esc_url($course_permalink) . '">' . esc_html($course_title) . '</a>';
        $breadcrumb_html .= '</nav>';

        echo $breadcrumb_html;
    }


    $course_id = $args['course_id'] ?? 0;
    $course = learn_press_get_course($course_id);
    if ($course) {
        Template::instance()->get_frontend_template('single-course/progress.php', compact('course'));
    }
    ?>

    <!-- End -->

    <div class="curriculum-scrollable">
        <?php
        /**
         * @deprecated
         */
        do_action('learn_press_before_single_course_curriculum');

        /**
         * @since 3.0.0
         */
        do_action('learn-press/before-single-course-curriculum');
        ?>
        <?php if ($sections['total'] > 0) : ?>
            <ul class="curriculum-sections">
                <?php
                foreach ($sections['results'] as $section) :
                    $args['section'] = $section;
                    learn_press_get_template('loop/single-course/loop-section', $args);
                endforeach;
                ?>
            </ul>
        <?php else : ?>
            <?php
            echo wp_kses_post(apply_filters('learnpress/course/curriculum/empty', '<p class="curriculum-scrollable-empty">' . esc_html__('The curriculum is empty', 'learnpress') . '</p>'));
            ?>
        <?php endif; ?>
    </div>
    <?php
    /**
     * @since 3.0.0
     */
    do_action('learn-press/after-single-course-curriculum');

    /**
     * @deprecated
     */
    do_action('learn_press_after_single_course_curriculum');

    ?>

    <?php if ($sections['pages'] > 1 && $sections['pages'] > $filters->page) : ?>
        <div class="curriculum-more">
            <button class="curriculum-more__button" data-page="<?php echo esc_attr($filters->page); ?>">
                <?php esc_html_e('Show more Sections', 'learnpress'); ?>
            </button>
        </div>
    <?php endif; ?>

</div>