<?php
/**
 * Template for displaying the instructor of a course
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$course = learn_press_get_course();
$author = $course->get_instructor();
if ( ! $author ) {
	return;
}
$author_meta = get_user_meta( $author->get_id() );
$author_meta = array_map( 'thim_get_user_meta', $author_meta );
?>
<?php if ( ! learn_press_is_learning_course() ) : ?>
<?php endif; ?>

<div class="course-author">

	<h3><?php esc_html_e( 'Instructor', 'course-builder' ); ?></h3>

	<?php do_action( 'learn-press/before-single-course-instructor' ); ?>

	<div class="thim-course-author teacher">
		<div class="author-avatar">
			<?php echo get_avatar( $author->get_id(), 150 ); ?>
			<?php thim_lp_social_user( $author->get_id() ); ?>
		</div>

		<div class="author-bio">
			<div class="name">
				<?php echo $course->get_instructor_html(); ?>
			</div>

			<?php if ( ! empty( $author_meta['lp_info_major'] ) ) : ?>
				<div class="major"><?php echo esc_html( $author_meta['lp_info_major'] ); ?></div>
			<?php endif; ?>

			<?php if ( ! empty( $author_meta['description'] ) ) : ?>
				<p class="description"><?php echo( $author_meta['description'] ); ?></p>
			<?php endif; ?>
		</div>
	</div>

	<?php do_action( 'learn-press/after-single-course-instructor' ); ?>

</div>

