<?php
/**
 * Template for displaying thumbnail of single course.
 *
 * @author   ThimPress
 * @package  CourseBuilder/Templates 
 * @version  4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $post;
$course = learn_press_get_course();
$user   = learn_press_get_current_user();


$video_intro      = get_post_meta( get_the_ID(), 'thim_course_media', true ); 
$thim_course_page = get_option( 'learn_press_single_course_image_size' );
$width            = ! empty ( $thim_course_page['width'] ) ? $thim_course_page['width'] : 1022;
$height           = ! empty ( $thim_course_page['height'] ) ? $thim_course_page['height'] : 608;

$thim_courses_thumbnail = true;
if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
	$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
	if ( $instance_addon->is_coming_soon( get_the_ID() ) ) {
		$thim_courses_thumbnail = false;
	}
}
if($thim_courses_thumbnail){
?>
<div class="course-thumbnail">
 	<?php
	$image         = '';
	$image_title   = get_the_title( get_post_thumbnail_id() ) ? esc_attr( get_the_title( get_post_thumbnail_id() ) ) : '';
	$image_caption = get_post( get_post_thumbnail_id() ) ? esc_attr( get_post( get_post_thumbnail_id() )->post_excerpt ) : '""';
	// $image_link    = wp_get_attachment_image_src( get_post_thumbnail_id(), array( $width, $height ) );
	$image_link    = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
	$layouts = get_theme_mod( 'learnpress_single_course_style', 1 );
	if ( $image_link ) {
		$image = '<img src="' . esc_url( $image_link[0] ) . '" alt="' . esc_attr( $image_title ) . '" title="' . esc_attr( $image_title ) . '" />';
	}else{
		$image = '<img src="' .get_template_directory_uri().'/assets/images/demo-image.jpg'. '" alt="' . esc_attr( $image_title ) . '" title="' . esc_attr( $image_title ) . '" />';
	}
	if ( learn_press_is_learning_course() &&  $layouts == '3') {
		thim_thumbnail( $course->get_id(), '647x399', 'post', false );
	} elseif($layouts == '1'){
		thim_thumbnail($course->get_id(), '1290x730', 'post', false);
	}else {
		echo( $image );
	}
	 ?>
	<?php
	$thim_learnpress_display_date = get_theme_mod('thim_learnpress_display_date', 1);
	if ( $video_intro ) {
		wp_enqueue_script( 'magnific-popup' );
		?>
		<a href="<?php echo esc_url( $video_intro ); ?>" class="play-button video-thumbnail <?php if(!$thim_learnpress_display_date){ echo 'sg-course-no-date';}; ?>">
			<span class="video-thumbnail hvr-push"></span>
		</a>
	<?php } ?> 
	<?php
	if($thim_learnpress_display_date):
 	?>
		<div class="time"> 
			<div class="date-start"><?php echo get_the_date( 'd' ); ?></div> 
			<div class="month-start"><?php echo get_the_date( 'M' ); ?></div> 
		</div>
	<?php endif;?> 
</div>
<?php }else{
echo '<div class="thim-coming-soon-course">';
	$image         = '';
	$image_title   = get_the_title( get_post_thumbnail_id() ) ? esc_attr( get_the_title( get_post_thumbnail_id() ) ) : '';
	$image_caption = get_post( get_post_thumbnail_id() ) ? esc_attr( get_post( get_post_thumbnail_id() )->post_excerpt ) : '""';
	$image_link    = wp_get_attachment_image_src( get_post_thumbnail_id(), array( $width, $height ) );
	if ( $image_link ) {
		$image = '<img src="' . esc_url( $image_link[0] ) . '" alt="' . esc_attr( $image_title ) . '" title="' . esc_attr( $image_title ) . '" />';
	}
	if ( learn_press_is_learning_course() ) {
		thim_thumbnail( $course->get_id(), '647x399', 'post', false );
	} else {
		echo( $image );
	}
	echo '<div class="wrap-countdown">';
		$instance_addon->coming_soon_countdown() ;
	echo '</div>';
echo '</div>';
}?>
